/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip;

import java.util.Date;
import kd.bos.dataentity.Tuple;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;

public enum SalarySlipQueryDateRangeEnum {
    UNLIMITED("0"),
    NEARLY_A_MONTH("1"),
    NEARLY_THREE_MONTH("2"),
    NEARLY_A_YEAR("3"),
    CUSTOM("4");

    private String code;

    private SalarySlipQueryDateRangeEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static SalarySlipQueryDateRangeEnum getEnum(String code) {
        SalarySlipQueryDateRangeEnum[] enums;
        if (code == null) {
            return UNLIMITED;
        }
        for (SalarySlipQueryDateRangeEnum rangeEnum : enums = SalarySlipQueryDateRangeEnum.values()) {
            if (!code.equals(rangeEnum.getCode())) continue;
            return rangeEnum;
        }
        return UNLIMITED;
    }

    public static Tuple<Date, Date> getQueryDateRange(String code, int queryNum, String queryDate) {
        SalarySlipQueryDateRangeEnum dateRangeEnum = SalarySlipQueryDateRangeEnum.getEnum(code);
        Tuple dates = new Tuple(null, null);
        Date date = new Date();
        switch (dateRangeEnum) {
            case UNLIMITED: {
                return dates;
            }
            case NEARLY_A_MONTH: {
                dates = new Tuple((Object)SalarySlipHelper.getDateFirst(date), (Object)SalarySlipHelper.getDateLast(date));
                break;
            }
            case NEARLY_THREE_MONTH: {
                Date dateFirst = SalarySlipHelper.getDateFirst(date);
                dates = new Tuple((Object)SWCDateTimeUtils.addMonth((Date)dateFirst, (int)-2), (Object)SalarySlipHelper.getDateLast(date));
                break;
            }
            case NEARLY_A_YEAR: {
                int year = SWCDateTimeUtils.getYear((Date)date);
                dates = new Tuple((Object)SalarySlipHelper.getYearFirst(year), (Object)SalarySlipHelper.getYearLast(year));
                break;
            }
            case CUSTOM: {
                CustomParam customParam = new CustomParam(queryNum, queryDate);
                dates = customParam.getQueryDateRange();
                break;
            }
        }
        return dates;
    }

    static class CustomParam {
        private int queryNum;
        private String queryDate;

        CustomParam(int queryNum, String queryDate) {
            this.queryNum = queryNum;
            this.queryDate = queryDate;
        }

        public int getQueryNum() {
            return this.queryNum;
        }

        public String getQueryDate() {
            return this.queryDate;
        }

        Tuple<Date, Date> getQueryDateRange() {
            Tuple dates = new Tuple(null, null);
            Date date = new Date();
            if ("Y".equals(this.queryDate)) {
                int year = SWCDateTimeUtils.getYear((Date)date);
                dates = new Tuple((Object)SalarySlipHelper.getYearFirst(year - this.queryNum + 1), (Object)SalarySlipHelper.getYearLast(year));
            }
            if ("M".equals(this.queryDate)) {
                Date dateFirst = SalarySlipHelper.getDateFirst(date);
                dates = new Tuple((Object)SWCDateTimeUtils.addMonth((Date)dateFirst, (int)(-this.queryNum + 1)), (Object)SalarySlipHelper.getDateLast(date));
            }
            return dates;
        }
    }
}

