/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.context;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.sdk.swc.hspp.business.extpoint.salaryslip.ISalarySlipQueryExtService;
import kd.sdk.swc.hspp.common.events.SalarySlipPersonVerifyEvent;
import kd.swc.hsbp.business.encrypt.MultiEncryptNewService;
import kd.swc.hsbp.business.encrypt.util.CompressUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.dto.salary.StructureSalaryDTO;
import kd.swc.hsbp.common.dto.salary.SummaryInfoDTO;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.enums.SalarySlipQueryParamEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.SalarySlipQueryDateRangeEnum;
import kd.swc.hspp.business.salaryslip.context.DefaultSalarySlipQueryService;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipEncryModel;
import kd.swc.hspp.common.model.SalarySlipModel;
import kd.swc.hspp.common.model.SalarySlipSumDetailModel;
import org.apache.commons.collections4.MapUtils;

public class ContextHolder {
    public static final Log logger = LogFactory.getLog(ContextHolder.class);
    private static final InheritableThreadLocal<Map<String, Object>> THREAD_LOCAL = new InheritableThreadLocal();
    private static final String SALARYSLIP = "salarySlip";
    private static final String QUERYDATE = "queryDate";
    private static final String STARTDATE = "startDate";
    private static final String ENDDATE = "endDate";
    private static final String CALENDAR_SET = "calendarSet";
    private static final String PERSONVERIFYEVENT = "personVerifyEvent";
    static SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hspp_secretrecord");

    public static void init(Date startDate, Date endDate) {
        HashMap<String, Object> map = (HashMap<String, Object>)THREAD_LOCAL.get();
        if (map == null) {
            map = new HashMap<String, Object>(16);
        }
        SalarySlipModel salarySlip = new SalarySlipModel();
        map.put(SALARYSLIP, salarySlip);
        map.put(STARTDATE, startDate);
        map.put(ENDDATE, endDate);
        map.put(PERSONVERIFYEVENT, new SalarySlipPersonVerifyEvent());
        map.put(CALENDAR_SET, null);
        THREAD_LOCAL.set(map);
    }

    public static void init() {
        HashMap<String, Object> map = (HashMap<String, Object>)THREAD_LOCAL.get();
        if (map == null) {
            map = new HashMap<String, Object>(16);
        }
        SalarySlipModel salarySlip = new SalarySlipModel();
        map.put(SALARYSLIP, salarySlip);
        map.put(PERSONVERIFYEVENT, new SalarySlipPersonVerifyEvent());
        map.put(CALENDAR_SET, null);
        THREAD_LOCAL.set(map);
    }

    public static void setCalendarSet(Set<Long> payrollGroupSet) {
        ContextHolder.set(CALENDAR_SET, payrollGroupSet);
    }

    public static void setQueryDate(String queryDate) {
        ContextHolder.set(QUERYDATE, queryDate);
    }

    public static void setStartEndDate(Date startDate, Date endDate) {
        ContextHolder.set(STARTDATE, startDate);
        ContextHolder.set(ENDDATE, endDate);
    }

    public static void destory() {
        THREAD_LOCAL.remove();
    }

    public static Map<String, Object> getSalaryParam() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Map salaryParam = salarySlipModel.getSalaryParam();
        if (Objects.nonNull(salaryParam)) {
            return salaryParam;
        }
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"salaryslipqueryparam");
        salarySlipModel.setSalaryParam(paramMap);
        return paramMap;
    }

    public static Tuple<Boolean, Map<String, Object>> getPersonTuple() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Tuple<Boolean, Map<String, Object>> tuple = salarySlipModel.getTuple();
        if (Objects.nonNull(tuple)) {
            return tuple;
        }
        tuple = IPersonService.getInstance().getPersonInfo();
        salarySlipModel.setTuple(tuple);
        return tuple;
    }

    public static void setPersonVerifyEvent(Long queriedPersonId) {
        if (queriedPersonId == null || queriedPersonId == 0L) {
            return;
        }
        SalarySlipPersonVerifyEvent verifyEvent = ContextHolder.getOrDefault(PERSONVERIFYEVENT, new SalarySlipPersonVerifyEvent());
        verifyEvent.setCurrentPersonId(ContextHolder.getPersonId());
        verifyEvent.setQueriedPersonId(queriedPersonId);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new DefaultSalarySlipQueryService(), ISalarySlipQueryExtService.class, (String)"kd.sdk.swc.hspp.business.extpoint.salaryslip.ISalarySlipQueryExtService#salarySlipQueryPersonVerify", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.salarySlipQueryPersonVerify(verifyEvent);
            return null;
        });
        Boolean havePerm = verifyEvent.getHavePerm();
        if (havePerm == null || !havePerm.booleanValue()) {
            return;
        }
        ContextHolder.setPersonId(queriedPersonId);
    }

    public static SalarySlipPersonVerifyEvent getPersonVerifyEvent() {
        return ContextHolder.getOrDefault(PERSONVERIFYEVENT, new SalarySlipPersonVerifyEvent());
    }

    public static void setPersonId(Long personId) {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        salarySlipModel.setPersonId(personId);
    }

    public static Long getPersonId() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Long personId = salarySlipModel.getPersonId();
        if (Objects.nonNull(personId)) {
            return personId;
        }
        Tuple<Boolean, Map<String, Object>> tuple = ContextHolder.getPersonTuple();
        personId = ((Map)tuple.item2).getOrDefault("person", 0L);
        salarySlipModel.setPersonId(personId);
        return personId;
    }

    public static Boolean salarySlipExist() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        DynamicObject salarySlipEnd = salarySlipModel.getSalarySlipEnd();
        if (Objects.nonNull(salarySlipEnd)) {
            return Boolean.TRUE;
        }
        ContextHolder.getSalarySlipEndDate();
        return salarySlipModel.getSalarySlipEnd() != null;
    }

    public static Date getSalarySlipEndDate() {
        QFilter filter;
        SWCDataServiceHelper helper;
        DynamicObject salarySlipData;
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Date salarySlipEndDate = salarySlipModel.getSalarySlipEndDate();
        if (Objects.nonNull(salarySlipEndDate)) {
            return salarySlipEndDate;
        }
        String queryDate = ContextHolder.getSalarySlipQueryParam();
        if (SWCStringUtils.isEmpty((String)queryDate)) {
            queryDate = "releasetime";
        }
        if ((salarySlipData = (helper = new SWCDataServiceHelper("hspp_salarycalendar")).queryOne(queryDate, (filter = new QFilter("person.id", "=", (Object)ContextHolder.getPersonId())).toArray(), queryDate + " desc")) != null) {
            salarySlipModel.setSalarySlipEndDate(salarySlipData.getDate(queryDate));
            salarySlipModel.setSalarySlipEnd(salarySlipData);
        } else {
            salarySlipModel.setSalarySlipEndDate(new Date());
        }
        return salarySlipModel.getSalarySlipEndDate();
    }

    public static DynamicObject[] getSalarySlipStatus() {
        QFilter filter;
        String orderBys;
        SalarySlipQueryParamEnum enumByCode;
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        DynamicObject[] salarySlipStatus = salarySlipModel.getSalarySlipStatus();
        if (Objects.nonNull(salarySlipStatus)) {
            return salarySlipStatus;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipstatus");
        Set calendarSet = (Set)ContextHolder.get(CALENDAR_SET);
        String queryDate = (String)ContextHolder.get(QUERYDATE);
        if (SWCStringUtils.isEmpty((String)queryDate)) {
            queryDate = "releasetime";
        }
        if ((enumByCode = SalarySlipQueryParamEnum.getEnumByCode((String)queryDate)) == null) {
            return new DynamicObject[0];
        }
        switch (enumByCode) {
            case RELEASETIME: {
                orderBys = "salarycalendar.releasetime desc";
                break;
            }
            case PAYROLLDATE: 
            case PAYDATE: 
            case STARTDATE: 
            case ENDDATE: {
                orderBys = "salarycalendar." + queryDate + " desc,salarycalendar.releasetime desc";
                break;
            }
            default: {
                orderBys = "";
            }
        }
        if (calendarSet != null) {
            filter = new QFilter("salarycalendar.id", "in", (Object)calendarSet);
        } else {
            filter = new QFilter("salarycalendar.person.id", "=", (Object)ContextHolder.getPersonId());
            filter.and(new QFilter("salarycalendar." + queryDate, ">=", ContextHolder.get(STARTDATE)));
            filter.and(new QFilter("salarycalendar." + queryDate, "<=", ContextHolder.get(ENDDATE)));
        }
        logger.info("filter is {}", (Object)filter.toString());
        DynamicObject[] dynamicObjects = helper.query("id,salarycalendar,isconfirm,isview,encryptlevel,encrypttype,iscompress", new QFilter[]{filter}, orderBys);
        salarySlipModel.setSalarySlipStatus(dynamicObjects);
        return dynamicObjects;
    }

    public static Map<Long, DynamicObject> getSalarySlipViewMap() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Map salarySlipViewMap = salarySlipModel.getSalarySlipViewMap();
        if (Objects.nonNull(salarySlipViewMap)) {
            return salarySlipViewMap;
        }
        DynamicObject[] salarySlipStatus = ContextHolder.getSalarySlipStatus();
        HashSet<Long> salaryViewIdSet = new HashSet<Long>(salarySlipStatus.length);
        for (DynamicObject salarySlip : salarySlipStatus) {
            Long salaryViewId = salarySlip.getLong("salarycalendar.salaryviewv.id");
            salaryViewIdSet.add(salaryViewId);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
        QFilter filter = new QFilter("id", "in", salaryViewIdSet);
        DynamicObject[] slipViews = helper.queryOriginalArray("id,isneedconfirm,isshowpayflow", new QFilter[]{filter});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(slipViews.length);
        for (DynamicObject slipView : slipViews) {
            map.put(slipView.getLong("id"), slipView);
        }
        salarySlipModel.setSalarySlipViewMap(map);
        return map;
    }

    private static Map<Long, Boolean> getEmpposorgrelMap() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Map<Long, Boolean> empposorgrelMap = salarySlipModel.getEmpposorgrelMap();
        if (Objects.nonNull(empposorgrelMap)) {
            return empposorgrelMap;
        }
        DynamicObject[] salarySlipStatus = ContextHolder.getSalarySlipStatus();
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(salarySlipStatus.length);
        for (DynamicObject salarySlip : salarySlipStatus) {
            Long salaryFileId = salarySlip.getLong("salarycalendar.salaryfilev.id");
            salaryFileIdSet.add(salaryFileId);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", salaryFileIdSet);
        DynamicObjectCollection col = helper.queryOriginalCollection("id,empposinfo.isprimary", new QFilter[]{filter});
        empposorgrelMap = col.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getBoolean("empposinfo.isprimary")));
        salarySlipModel.setEmpposorgrelMap(empposorgrelMap);
        return empposorgrelMap;
    }

    public static Map<Long, SalaryCalendarModel> getSalaryCalendarModelMap() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Map salaryCalendarModelMap = salarySlipModel.getSalaryCalendarModelMap();
        if (Objects.nonNull(salaryCalendarModelMap)) {
            return salaryCalendarModelMap;
        }
        DynamicObject[] salarySlipStatus = ContextHolder.getSalarySlipStatus();
        LinkedHashMap<Long, SalaryCalendarModel> map = new LinkedHashMap<Long, SalaryCalendarModel>(salarySlipStatus.length);
        String queryDate = (String)ContextHolder.get(QUERYDATE);
        if (SWCStringUtils.isEmpty((String)queryDate)) {
            queryDate = "releasetime";
        }
        MultiEncryptNewService service = new MultiEncryptNewService(EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL, EncryptLevelEnum.ENCRYPT_LEVEL_ORDINARY);
        for (DynamicObject dynamicObject : salarySlipStatus) {
            Date startDate = dynamicObject.getDate("salarycalendar.startdate");
            Date endDate = dynamicObject.getDate("salarycalendar.enddate");
            String dateRange = "";
            if (null != startDate && null != endDate) {
                dateRange = HRInteDateTimeUtil.formatDate((String)"hspp_salarycalendar", (String)"startdate", (Date)startDate) + "~" + HRInteDateTimeUtil.formatDate((String)"hspp_salarycalendar", (String)"enddate", (Date)endDate);
            }
            String caption = dynamicObject.getString("salarycalendar.caption");
            SalaryCalendarModel model2 = new SalaryCalendarModel();
            model2.setCaption(caption);
            model2.setDateRange(dateRange);
            model2.setView(dynamicObject.getBoolean("isview"));
            model2.setConfirm(dynamicObject.getBoolean("isconfirm"));
            model2.setId(Long.valueOf(dynamicObject.getLong("salarycalendar.id")));
            Date queryTime = dynamicObject.getDate("salarycalendar." + queryDate);
            int queryMonth = SWCDateTimeUtils.getMonth((Date)queryTime);
            model2.setMonth(String.valueOf(queryMonth));
            model2.setRemark(dynamicObject.getString("salarycalendar.remark"));
            model2.setPayrollDate(SWCDateTimeUtils.format((Date)dynamicObject.getDate("salarycalendar.payrolldate"), (String)"yyyy-MM-dd"));
            model2.setPayDate(SWCDateTimeUtils.format((Date)dynamicObject.getDate("salarycalendar.paydate"), (String)"yyyy-MM-dd"));
            model2.setReleaseTime(SWCDateTimeUtils.format((Date)dynamicObject.getDate("salarycalendar.releasetime"), (String)"yyyy-MM-dd HH:mm:ss"));
            ContextHolder.decode(model2, dynamicObject, service);
            model2.setSalaryFileId(Long.valueOf(dynamicObject.getLong("salarycalendar.salaryfilev.id")));
            model2.setPrimary(Boolean.TRUE);
            map.put(model2.getId(), model2);
        }
        long curSize = map.values().stream().map(SalaryCalendarModel::getCalCurrencyId).distinct().count();
        if (curSize > 1L) {
            Map<Long, Boolean> empposorgrelMap = ContextHolder.getEmpposorgrelMap();
            map.values().forEach(model -> {
                Long salaryFileId = model.getSalaryFileId();
                Boolean isPrimary = empposorgrelMap.getOrDefault(salaryFileId, Boolean.FALSE);
                model.setPrimary(isPrimary);
            });
        }
        salarySlipModel.setSalaryCalendarModelMap(map);
        return map;
    }

    public static Map<Long, DynamicObject> getCurrencyMap() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Map<Long, DynamicObject> currencyMap = salarySlipModel.getCurrencyMap();
        if (Objects.nonNull(currencyMap)) {
            return currencyMap;
        }
        Set currencyIdSet = ContextHolder.getSalaryCalendarModelMap().values().stream().map(SalaryCalendarModel::getCalCurrencyId).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_currency");
        QFilter filter = new QFilter("id", "in", currencyIdSet);
        DynamicObjectCollection currencyCol = helper.queryOriginalCollection("id,number,sign,amtprecision", new QFilter[]{filter});
        currencyMap = currencyCol.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data));
        salarySlipModel.setCurrencyMap(currencyMap);
        return currencyMap;
    }

    public static Map<Long, Set<Long>> getSumViewCalendarMap() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        Map sumViewPayrollGroupMap = salarySlipModel.getSumViewCalendarMap();
        if (Objects.nonNull(sumViewPayrollGroupMap)) {
            return sumViewPayrollGroupMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salarycalendar");
        QFilter filter = new QFilter("person.id", "=", (Object)ContextHolder.getPersonId());
        String queryDate = (String)ContextHolder.get(QUERYDATE);
        String salarySlipQueryParam = queryDate == null ? ContextHolder.getSalarySlipQueryParam() : queryDate;
        DynamicObject[] calendarDatas = helper.query("id,payrollgrp,salcalendarmulsum," + salarySlipQueryParam, new QFilter[]{filter}, salarySlipQueryParam + " desc");
        LinkedHashMap<Long, DynamicObject> map = new LinkedHashMap<Long, DynamicObject>(16);
        LinkedHashMap<Long, Set> payrollGroupCalendarMap = new LinkedHashMap<Long, Set>(16);
        Date startDate = (Date)ContextHolder.get(STARTDATE);
        Date endDate = (Date)ContextHolder.get(ENDDATE);
        for (DynamicObject calendarData2 : calendarDatas) {
            Long payrollGroupId2 = calendarData2.getLong("payrollgrp.id");
            Date salarySlipQueryTime = calendarData2.getDate(salarySlipQueryParam);
            DynamicObject calendarObj = (DynamicObject)map.get(payrollGroupId2);
            if (calendarObj == null || salarySlipQueryTime.after(calendarObj.getDate(salarySlipQueryParam))) {
                map.put(payrollGroupId2, calendarData2);
            }
            if (!SWCDateTimeUtils.isCover((Date)salarySlipQueryTime, (Date)startDate, (Date)endDate)) continue;
            Set salaryCalendarIds = payrollGroupCalendarMap.getOrDefault(payrollGroupId2, new HashSet());
            salaryCalendarIds.add(calendarData2.getLong("id"));
            payrollGroupCalendarMap.put(payrollGroupId2, salaryCalendarIds);
        }
        LinkedHashMap<Long, Set<Long>> viewCalendarMap = new LinkedHashMap<Long, Set<Long>>(16);
        map.forEach((payrollGroupId, calendarData) -> {
            List<Long> sumViewIds = calendarData.getDynamicObjectCollection("salcalendarmulsum").stream().filter(sumView -> "C".equalsIgnoreCase(sumView.getString("fbasedataid.status"))).map(sumView -> sumView.getLong("fbasedataid.id")).collect(Collectors.toList());
            sumViewIds.forEach(id -> {
                Set payrollGroupIdSet = viewCalendarMap.getOrDefault(id, new HashSet());
                Set calendarSet = (Set)payrollGroupCalendarMap.get(payrollGroupId);
                if (calendarSet != null) {
                    payrollGroupIdSet.addAll(calendarSet);
                }
                viewCalendarMap.put((Long)id, payrollGroupIdSet);
            });
        });
        salarySlipModel.setSumViewCalendarMap(viewCalendarMap);
        return viewCalendarMap;
    }

    public static List<SalarySlipSumDetailModel> getSalarySlipSumDetailModelList() {
        SalarySlipModel salarySlipModel = ContextHolder.getOrDefault(SALARYSLIP, new SalarySlipModel());
        ArrayList<SalarySlipSumDetailModel> salarySlipSumDetailModelList = salarySlipModel.getSalarySlipSumDetailModelList();
        if (Objects.nonNull(salarySlipSumDetailModelList)) {
            return salarySlipSumDetailModelList;
        }
        DynamicObject[] salarySlipStatus = ContextHolder.getSalarySlipStatus();
        HashMap<String, SalarySlipSumDetailModel> salarySlipSumDetailMap = new HashMap<String, SalarySlipSumDetailModel>(salarySlipStatus.length);
        HashMap<String, SalarySlipEncryModel> salarySlipEncryMap = new HashMap<String, SalarySlipEncryModel>(salarySlipStatus.length);
        String queryDate = (String)ContextHolder.get(QUERYDATE);
        if (SWCStringUtils.isEmpty((String)queryDate)) {
            queryDate = "releasetime";
        }
        salarySlipSumDetailModelList = new ArrayList<SalarySlipSumDetailModel>(salarySlipStatus.length);
        String encryptType = "0";
        String encryptLevel = "0";
        for (DynamicObject dynamicObject : salarySlipStatus) {
            encryptLevel = dynamicObject.getString("encryptlevel");
            encryptType = dynamicObject.getString("encrypttype");
            if (SWCStringUtils.isNotEmpty((String)encryptType) && SWCStringUtils.isNotEmpty((String)encryptLevel)) break;
        }
        MultiEncryptNewService encryptService = SalarySlipHelper.getEncryptService(encryptLevel, encryptType);
        for (DynamicObject dynamicObject : salarySlipStatus) {
            ArrayList<String> secretDetailKeyList = new ArrayList<String>(10);
            String salaryCalendarId = dynamicObject.getString("salarycalendar.id");
            secretDetailKeyList.add(salaryCalendarId);
            secretDetailKeyList.add(String.valueOf(dynamicObject.getLong("salarycalendar.person.id")));
            secretDetailKeyList.add(dynamicObject.getString("salarycalendar.releasetimestamp"));
            String encryptKey = encryptService.getEncryKey(secretDetailKeyList);
            SalarySlipEncryModel encryModel = new SalarySlipEncryModel();
            encryModel.setEncryptLevel(encryptLevel);
            encryModel.setEncryptType(encryptType);
            encryModel.setCompress(Boolean.valueOf(dynamicObject.getBoolean("iscompress")));
            ArrayList<String> secretKeyList = new ArrayList<String>(10);
            secretKeyList.add(String.valueOf(dynamicObject.getLong("salarycalendar.person.id")));
            secretKeyList.add(String.valueOf(dynamicObject.getLong("salarycalendar.salaryfile.id")));
            encryModel.setSecretKeyList(secretKeyList);
            salarySlipEncryMap.put(encryptKey, encryModel);
            Date releaseDate = null;
            try {
                releaseDate = SWCDateTimeUtils.formatDateToDate((Date)dynamicObject.getDate("salarycalendar." + queryDate), (String)"yyyy-MM");
            }
            catch (ParseException e) {
                logger.info("ParseException Error : {}", (Object)e.getMessage());
            }
            SalarySlipSumDetailModel sumDetailModel = new SalarySlipSumDetailModel(salaryCalendarId, releaseDate);
            salarySlipSumDetailMap.put(encryptKey, sumDetailModel);
            salarySlipSumDetailModelList.add(sumDetailModel);
        }
        Map<String, StructureSalaryDTO> structureSalaryMap = ContextHolder.getStructureSalaryData(encryptService, salarySlipEncryMap);
        for (Map.Entry<String, StructureSalaryDTO> entry : structureSalaryMap.entrySet()) {
            SalarySlipSumDetailModel sumDetailModel = (SalarySlipSumDetailModel)salarySlipSumDetailMap.get(entry.getKey());
            StructureSalaryDTO structureSalaryData = entry.getValue();
            sumDetailModel.setSalaryItemInfoList(structureSalaryData.getSalaryItemInfoDTOList());
            sumDetailModel.setIssueFlowInfoList(structureSalaryData.getIssueFlowInfoDTOList());
        }
        salarySlipModel.setSalarySlipSumDetailModelList(salarySlipSumDetailModelList);
        return salarySlipSumDetailModelList;
    }

    private static Map<String, StructureSalaryDTO> getStructureSalaryData(MultiEncryptNewService encryptService, Map<String, SalarySlipEncryModel> salarySlipEncryMap) {
        HashMap<String, StructureSalaryDTO> structureSalaryMap = new HashMap<String, StructureSalaryDTO>(salarySlipEncryMap.size());
        Set<String> keySet = salarySlipEncryMap.keySet();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_salaryslipdetail");
        QFilter qFilter = new QFilter("encrykey", "in", keySet);
        DynamicObjectCollection slipObjectCol = helper.queryOriginalCollection("encrykey,salaryslipdata", new QFilter[]{qFilter});
        for (DynamicObject slipObject : slipObjectCol) {
            String key = slipObject.getString("encrykey");
            String slipData = slipObject.getString("salaryslipdata");
            SalarySlipEncryModel salarySlipEncryModel = salarySlipEncryMap.get(key);
            Boolean isCompress = salarySlipEncryModel.getCompress();
            slipData = SalarySlipHelper.decode(encryptService, salarySlipEncryModel.getSecretKeyList(), slipData);
            slipData = isCompress != false ? CompressUtils.uncompress((String)slipData) : slipData;
            StructureSalaryDTO structureSalaryDTO = SWCStringUtils.isNotEmpty((String)slipData) ? (StructureSalaryDTO)JSON.parseObject((String)slipData, StructureSalaryDTO.class) : new StructureSalaryDTO();
            structureSalaryMap.put(key, structureSalaryDTO);
        }
        return structureSalaryMap;
    }

    private static void decode(SalaryCalendarModel model, DynamicObject dynamicObject, MultiEncryptNewService service) {
        String encryptLevel = dynamicObject.getString("encryptlevel");
        String encryptType = dynamicObject.getString("encrypttype");
        String decodeData = dynamicObject.getString("salarycalendar.salaryslipdata");
        ArrayList<String> secretDetailKeyList = new ArrayList<String>(10);
        secretDetailKeyList.add(String.valueOf(model.getId()));
        secretDetailKeyList.add(String.valueOf(dynamicObject.getLong("salarycalendar.person.id")));
        secretDetailKeyList.add(dynamicObject.getString("salarycalendar.releasetimestamp"));
        String encryptKey = service.getEncryKey(secretDetailKeyList);
        model.setEncryptKey(encryptKey);
        SalarySlipEncryModel encryModel = new SalarySlipEncryModel();
        encryModel.setEncryptLevel(encryptLevel);
        encryModel.setEncryptType(encryptType);
        encryModel.setCompress(Boolean.valueOf(dynamicObject.getBoolean("iscompress")));
        model.setSalarySlipEncryModel(encryModel);
        if (encryptLevel.equals("1")) {
            ArrayList<String> secretKeyList = new ArrayList<String>(10);
            secretKeyList.add(String.valueOf(dynamicObject.getLong("salarycalendar.person.id")));
            secretKeyList.add(String.valueOf(dynamicObject.getLong("salarycalendar.salaryfile.id")));
            encryModel.setSecretKeyList(secretKeyList);
        }
        model.setSalarySlipEncryModel(encryModel);
        if (StringUtils.isEmpty((CharSequence)decodeData)) {
            return;
        }
        SummaryInfoDTO summaryInfoDTO = SWCStringUtils.isNotEmpty((String)(decodeData = service.decode(decodeData))) ? (SummaryInfoDTO)JSON.parseObject((String)decodeData, SummaryInfoDTO.class) : new SummaryInfoDTO();
        model.setTotalSalary(summaryInfoDTO.getTotalSalary());
        model.setNetSalary(summaryInfoDTO.getNetSalary());
        model.setCalCurrencyId(summaryInfoDTO.getCalCurrencyId());
    }

    public static void set(String key, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)THREAD_LOCAL.get();
        if (map == null) {
            map = new HashMap<String, Object>(16);
        }
        map.put(key, value);
        THREAD_LOCAL.set(map);
    }

    public static <T> T get(String key) {
        return ContextHolder.getOrDefault(key, null);
    }

    public static <T> T getOrDefault(String key, T defValue) {
        Map map = (Map)THREAD_LOCAL.get();
        if (map == null) {
            return defValue;
        }
        Object data = map.get(key);
        return (T)(data == null ? defValue : data);
    }

    public static String getSalarySlipQueryParam() {
        String salarySlipQueryParam = SalarySlipQueryParamEnum.RELEASETIME.getCode();
        Map<String, Object> salaryParam = ContextHolder.getSalaryParam();
        if (salaryParam != null) {
            salarySlipQueryParam = (String)salaryParam.get("radiogroupfield");
        }
        return salarySlipQueryParam;
    }

    public static String getShowAmountType() {
        Map<String, Object> salaryParam = ContextHolder.getSalaryParam();
        Object netSalaryObj = salaryParam.get("showamounttype");
        return netSalaryObj.toString();
    }

    public static Tuple<Date, Date> getSalarySlipQueryDateParam() {
        Map<String, Object> salaryParam = ContextHolder.getSalaryParam();
        if (salaryParam != null) {
            String dateRange = MapUtils.getString(salaryParam, (Object)"querydaterange");
            int queryNum = MapUtils.getIntValue(salaryParam, (Object)"querynum", (int)0);
            String queryDate = MapUtils.getString(salaryParam, (Object)"querydate", (String)"");
            return SalarySlipQueryDateRangeEnum.getQueryDateRange(dateRange, queryNum, queryDate);
        }
        return new Tuple(null, null);
    }

    public static void updateSaveShowTips(int ShowTips) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject secretRecordDy = ContextHolder.getSecretrecord();
        if (null != secretRecordDy) {
            secretRecordDy.set("showtips", (Object)ShowTips);
            secretRecordDy.set("modifytime", (Object)new Date());
            serviceHelper.updateOne(secretRecordDy);
        } else {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hspp_secretrecord");
            DynamicObject object = helper.generateEmptyDynamicObject();
            object.set("user", (Object)userId);
            object.set("showtips", (Object)ShowTips);
            object.set("createtime", (Object)new Date());
            serviceHelper.saveOne(object);
        }
    }

    public static void updateSaveEncryptType(int encryptType) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject secretRecordDy = ContextHolder.getSecretrecord();
        if (null != secretRecordDy) {
            secretRecordDy.set("encrypttype", (Object)encryptType);
            secretRecordDy.set("modifytime", (Object)new Date());
            serviceHelper.updateOne(secretRecordDy);
        } else {
            DynamicObject object = serviceHelper.generateEmptyDynamicObject();
            object.set("user", (Object)userId);
            object.set("encrypttype", (Object)encryptType);
            object.set("createtime", (Object)new Date());
            serviceHelper.saveOne(object);
        }
    }

    public static int getShowTips() {
        DynamicObject secretRecordDy = ContextHolder.getSecretrecord();
        if (null != secretRecordDy && StringUtils.isNotEmpty((CharSequence)secretRecordDy.getString("showtips"))) {
            return secretRecordDy.getInt("showtips");
        }
        return 1;
    }

    public static boolean getEncryptType() {
        DynamicObject secretRecordDy = ContextHolder.getSecretrecord();
        if (null != secretRecordDy) {
            int encrypttype = secretRecordDy.getInt("encrypttype");
            if (encrypttype == 0) {
                return false;
            }
            if (encrypttype == 1) {
                return true;
            }
        }
        return false;
    }

    private static DynamicObject getSecretrecord() {
        long userId = RequestContext.get().getCurrUserId();
        return serviceHelper.queryOne("id,user,showtips,encrypttype,modifytime,createtime,user", new QFilter[]{new QFilter("user", "=", (Object)userId)});
    }
}

