/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.detaildata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.detaildata.BaseSalarySlipDataService;
import kd.swc.hspp.business.salaryslip.pojo.SalaryCardTypeEnum;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryCardDTO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryCardVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryDetailVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalarySumDetailVO;

public abstract class BaseEncryptDataDecorator
extends BaseSalarySlipDataService {
    private static final String CUSTOMER_CARD_DATA_LIST = "customerCardDataList";
    private static final String CUSTOMER_CARD_ENCRYPT_DATA_LIST = "customerCardEncryptDataList";
    private static final String CUSTOMER_DETAIL_DATA_LIST = "customerDetailDataList";
    private static final String CUSTOMER_DETAIL_SUM_DATA_LIST = "customerSumDataList";
    private BaseSalarySlipDataService dataService;
    private IFormView view;

    public BaseEncryptDataDecorator(IFormView view, BaseSalarySlipDataService dataService) {
        this.dataService = dataService;
        this.view = view;
    }

    @Override
    public List<SalarySumDetailVO> getSummaryDetailList() {
        String dataString = this.view.getPageCache().get(CUSTOMER_DETAIL_SUM_DATA_LIST);
        if (SWCStringUtils.isNotEmpty((String)dataString)) {
            return JSON.parseArray((String)dataString, SalarySumDetailVO.class);
        }
        if (this.dataService == null) {
            return new ArrayList<SalarySumDetailVO>(10);
        }
        List<SalarySumDetailVO> sumDataList = this.dataService.getSummaryDetailList();
        this.view.getPageCache().put(CUSTOMER_DETAIL_SUM_DATA_LIST, JSONObject.toJSONString(sumDataList));
        return sumDataList;
    }

    public List<SalarySumDetailVO> getSummaryDetailList(Boolean isEncrypt) {
        return this.getSummaryDetailList();
    }

    @Override
    public List<SalaryDetailVO> getDetailDataList() {
        String dataString = this.view.getPageCache().get(CUSTOMER_DETAIL_DATA_LIST);
        if (SWCStringUtils.isNotEmpty((String)dataString)) {
            return JSON.parseArray((String)dataString, SalaryDetailVO.class);
        }
        if (this.dataService == null) {
            return new ArrayList<SalaryDetailVO>(10);
        }
        List<SalaryDetailVO> detailDataList = this.dataService.getDetailDataList();
        this.view.getPageCache().put(CUSTOMER_DETAIL_DATA_LIST, JSONObject.toJSONString(detailDataList));
        return detailDataList;
    }

    public List<SalaryDetailVO> getDetailDataList(Boolean isEncrypt) {
        return this.getDetailDataList();
    }

    @Override
    public List<SalaryCardVO> getSalaryCardList() {
        String dataString = this.view.getPageCache().get(CUSTOMER_CARD_DATA_LIST);
        if (SWCStringUtils.isNotEmpty((String)dataString)) {
            return JSON.parseArray((String)dataString, SalaryCardVO.class);
        }
        if (this.dataService == null) {
            return new ArrayList<SalaryCardVO>(10);
        }
        List<SalaryCardVO> salaryCardList = this.dataService.getSalaryCardList();
        this.setSalaryCardImg(salaryCardList);
        this.view.getPageCache().put(CUSTOMER_CARD_DATA_LIST, JSONObject.toJSONString(salaryCardList));
        return salaryCardList;
    }

    public List<SalaryCardVO> getSalaryCardList(Boolean isEncrypt) {
        String dataString;
        if (isEncrypt.booleanValue() && SWCStringUtils.isNotEmpty((String)(dataString = this.view.getPageCache().get(CUSTOMER_CARD_ENCRYPT_DATA_LIST)))) {
            return JSON.parseArray((String)dataString, SalaryCardVO.class);
        }
        List<SalaryCardVO> salaryCardList = this.getSalaryCardList();
        if (!isEncrypt.booleanValue()) {
            return salaryCardList;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perbankcard");
        DynamicObject bankObj = BusinessDataServiceHelper.newDynamicObject((String)"hrpi_perbankcard");
        boolean isBankCardEncrypt = this.isEncrypt(mainEntityType, bankObj, "bankcardnum");
        boolean isUserNameEncrypt = this.isEncrypt(mainEntityType, bankObj, "username");
        boolean isBankNameEncrypt = this.isEncrypt(mainEntityType, bankObj, "bankdeposit");
        boolean isAccountRelEncrypt = this.isEncrypt(mainEntityType, bankObj, "accountrelation");
        if (isBankCardEncrypt || isUserNameEncrypt || isBankNameEncrypt || isAccountRelEncrypt) {
            salaryCardList.forEach(salaryCard -> {
                SalaryCardDTO card = salaryCard.getCard();
                String type = salaryCard.getType();
                Boolean openEye = Boolean.TRUE;
                if (SalaryCardTypeEnum.BANK_TYPE.getType().equals(type)) {
                    if (isBankCardEncrypt) {
                        Object bankCardNum = this.getEncrypt(mainEntityType, bankObj, "bankcardnum", card.getNumber());
                        card.setNumber(String.valueOf(bankCardNum));
                        openEye = Boolean.FALSE;
                    }
                    if (isBankNameEncrypt) {
                        Object bankName = this.getEncrypt(mainEntityType, bankObj, "bankdeposit", card.getName());
                        card.setName(String.valueOf(bankName));
                        openEye = Boolean.FALSE;
                    }
                }
                if (isUserNameEncrypt) {
                    Object accountName = this.getEncrypt(mainEntityType, bankObj, "username", card.getAccountName());
                    card.setAccountName(String.valueOf(accountName));
                    openEye = Boolean.FALSE;
                }
                if (isAccountRelEncrypt) {
                    Object relation = this.getEncrypt(mainEntityType, bankObj, "accountrelation", card.getRelation());
                    card.setRelation(String.valueOf(relation));
                    openEye = Boolean.FALSE;
                }
                card.setOpenEye(openEye);
                salaryCard.setShowEye(Boolean.FALSE);
            });
        }
        this.view.getPageCache().put(CUSTOMER_CARD_ENCRYPT_DATA_LIST, JSONObject.toJSONString(salaryCardList));
        return salaryCardList;
    }

    public void removeDataCache() {
        IPageCache pageCache = this.view.getPageCache();
        pageCache.remove(CUSTOMER_CARD_DATA_LIST);
        pageCache.remove(CUSTOMER_CARD_ENCRYPT_DATA_LIST);
        pageCache.remove(CUSTOMER_DETAIL_DATA_LIST);
        pageCache.remove(CUSTOMER_DETAIL_SUM_DATA_LIST);
    }

    private void setSalaryCardImg(List<SalaryCardVO> salaryCardList) {
        salaryCardList.forEach(salaryCard -> {
            String type = salaryCard.getType();
            boolean mustBankCard = SalaryCardTypeEnum.BANK_TYPE.getType().equals(type);
            JSONObject salaryCardCommonUrl = this.getSalaryCardCommonUrl(mustBankCard);
            String logoUrl = salaryCardCommonUrl.getString("logoUrl");
            String imgUrl = salaryCardCommonUrl.getString("imgUrl");
            SalaryCardDTO card = salaryCard.getCard();
            if (mustBankCard) {
                Map<String, String> bankLogoMapOfRelativePathMap = SalarySlipHelper.getBankLogoMapOfRelativePath();
                for (Map.Entry<String, String> entry : bankLogoMapOfRelativePathMap.entrySet()) {
                    if (!card.getName().contains(entry.getKey())) continue;
                    logoUrl = entry.getValue();
                    break;
                }
            }
            card.setImg(imgUrl);
            card.setLogo(logoUrl);
        });
    }

    private boolean isEncrypt(MainEntityType mainEntityType, DynamicObject bankObj, String propKey) {
        IDataEntityProperty bankCardNumProp = mainEntityType.findProperty(propKey);
        return PrivacyCenterServiceHelper.isDesensitizeFieldWithoutPerm((IDataEntityProperty)bankCardNumProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj);
    }

    private Object getEncrypt(MainEntityType mainEntityType, DynamicObject bankObj, String propKey, Object value) {
        IDataEntityProperty bankCardNumProp = mainEntityType.findProperty(propKey);
        return PrivacyCenterServiceHelper.getDesensitizeValueWithoutPerm((IDataEntityProperty)bankCardNumProp, (String)Lang.get().toString(), (String)"LIST", (DynamicObject)bankObj, (Object)value);
    }
}

