/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.detaildata;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.form.IFormView;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.salaryslip.detaildata.BaseEncryptDataDecorator;
import kd.swc.hspp.business.salaryslip.detaildata.BaseSalarySlipDataService;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryCardVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryDetailVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalarySumDetailVO;

public class PcSalaryDataService
extends BaseEncryptDataDecorator {
    private static final String CASH_LOGO_RELATIVE = "icons/mobile/other/hr_xj_42_42.png";
    private static final String COMMON_BANK_LOGO_RELATIVE = "kingdee/hr/images/pc/other/image_COMlogo.png";
    private static final String BANK_BG_RELATIVE = "kingdee/hr/images/pc/cardbackground/hspp_pc_bank_bg.png";
    private static final String CASH_BG_RELATIVE = "kingdee/hr/images/pc/cardbackground/hspp_pc_cash_bg.png";

    public PcSalaryDataService(IFormView view, BaseSalarySlipDataService dataService) {
        super(view, dataService);
    }

    @Override
    public JSONObject getSalaryCardCommonUrl(Boolean mustBankCard) {
        String imgUrl;
        String logoUrl;
        if (mustBankCard.booleanValue()) {
            logoUrl = COMMON_BANK_LOGO_RELATIVE;
            imgUrl = BANK_BG_RELATIVE;
        } else {
            logoUrl = CASH_LOGO_RELATIVE;
            imgUrl = CASH_BG_RELATIVE;
        }
        JSONObject json = new JSONObject();
        json.put("logoUrl", (Object)logoUrl);
        json.put("imgUrl", (Object)imgUrl);
        return json;
    }

    @Override
    public List<SalarySumDetailVO> getSummaryDetailList(Boolean isEncrypt) {
        List<SalarySumDetailVO> summaryDetailList = super.getSummaryDetailList(isEncrypt);
        if (isEncrypt.booleanValue()) {
            summaryDetailList.forEach(detail -> detail.setPay("******"));
        }
        return summaryDetailList;
    }

    @Override
    public List<SalaryCardVO> getSalaryCardList(Boolean isEncrypt) {
        List<SalaryCardVO> salaryCardList = super.getSalaryCardList(isEncrypt);
        if (isEncrypt.booleanValue()) {
            salaryCardList.forEach(salaryCard -> {
                salaryCard.setPay("******");
                salaryCard.setCurrencySign("");
            });
        }
        return salaryCardList;
    }

    @Override
    public List<SalaryDetailVO> getDetailDataList(Boolean isEncrypt) {
        List<SalaryDetailVO> detailDataList = super.getDetailDataList(isEncrypt);
        if (isEncrypt.booleanValue()) {
            detailDataList.forEach(detail -> {
                String pay = detail.getPay();
                if (SWCStringUtils.isNotEmpty((String)pay)) {
                    detail.setPay("******");
                }
                detail.getData().forEach(itemSum -> itemSum.setValue("******"));
            });
        }
        return detailDataList;
    }
}

