/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.detaildata;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.IssueFlowInfoDTO;
import kd.swc.hsbp.common.dto.salary.SalaryItemInfoDTO;
import kd.swc.hsbp.common.dto.salary.item.BaseItemInfoDTO;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.detaildata.BaseSalarySlipDataService;
import kd.swc.hspp.business.salaryslip.detaildata.builddata.BuildDataEnum;
import kd.swc.hspp.business.salaryslip.detaildata.builddata.BuildOtherItemDataEnum;
import kd.swc.hspp.business.salaryslip.pojo.SalaryCardTypeEnum;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryCardDTO;
import kd.swc.hspp.business.salaryslip.pojo.dto.SalaryDetailItemDTO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryCardVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalaryDetailVO;
import kd.swc.hspp.business.salaryslip.pojo.vo.SalarySumDetailVO;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipDataBaseModel;
import kd.swc.hspp.common.model.SalarySlipDataGroupModel;
import kd.swc.hspp.common.model.SalarySlipDataItemSumModel;
import kd.swc.hspp.common.model.SalarySlipDataModel;
import org.apache.curator.shaded.com.google.common.collect.HashBasedTable;

public class SalarySlipDataService
extends BaseSalarySlipDataService {
    private SalarySlipDataModel dataModel;

    private SalarySlipDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = this.analyzeSlipData();
        }
        return this.dataModel;
    }

    @Override
    public List<SalarySumDetailVO> getSummaryDetailList() {
        List groupModelList = this.getDataModel().getSalarySlipDataGroupModelList();
        ArrayList<SalarySumDetailVO> salarySumDetailList = new ArrayList<SalarySumDetailVO>(groupModelList.size() + 2);
        SalaryCalendarModel salaryCalendarModel = this.getSalaryCalendarModel();
        BigDecimal totalSalary = salaryCalendarModel.getTotalSalary();
        BigDecimal netSalary = salaryCalendarModel.getNetSalary();
        SalarySumDetailVO totalSumDetail = new SalarySumDetailVO("", this.getSalaryAmount(totalSalary, salaryCalendarModel));
        totalSumDetail.setShow(totalSalary != null);
        salarySumDetailList.add(totalSumDetail);
        SalarySumDetailVO netSumDetail = new SalarySumDetailVO("", this.getSalaryAmount(netSalary, salaryCalendarModel));
        netSumDetail.setShow(netSalary != null);
        salarySumDetailList.add(netSumDetail);
        groupModelList.forEach(groupModel -> {
            Boolean summary = groupModel.getSummary();
            Boolean topShow = groupModel.getTopShow();
            if (summary.booleanValue() && topShow.booleanValue() && groupModel.getSalarySlipDataItemSumModelList().size() > 0) {
                String pay = groupModel.getShowValueList().size() > 0 ? (String)groupModel.getShowValueList().get(0) : "-";
                SalarySumDetailVO sumDetail = new SalarySumDetailVO(groupModel.getCaption(), pay);
                sumDetail.setShow(Boolean.TRUE);
                salarySumDetailList.add(sumDetail);
            }
        });
        return salarySumDetailList;
    }

    @Override
    public List<SalaryDetailVO> getDetailDataList() {
        List groupModelList = this.getDataModel().getSalarySlipDataGroupModelList();
        ArrayList<SalaryDetailVO> salaryDetailVOList = new ArrayList<SalaryDetailVO>(groupModelList.size());
        groupModelList.forEach(group -> {
            SalaryDetailVO detailVO = new SalaryDetailVO();
            detailVO.setName(group.getCaption());
            List showValueList = group.getShowValueList();
            String pay = group.getSummary() != false && showValueList.size() > 0 ? (String)showValueList.get(0) : "";
            detailVO.setPay(pay);
            ArrayList<SalaryDetailItemDTO> salaryDetailItemList = new ArrayList<SalaryDetailItemDTO>(10);
            group.getSalarySlipDataItemSumModelList().forEach(itemSum -> {
                SalaryDetailItemDTO salaryDetailItemDTO = new SalaryDetailItemDTO();
                salaryDetailItemDTO.setName(itemSum.getCaption());
                salaryDetailItemDTO.setType(itemSum.getShowType());
                List slipDataValList = itemSum.getShowValueList();
                if (slipDataValList != null && !slipDataValList.isEmpty()) {
                    salaryDetailItemDTO.setValue((String)slipDataValList.get(0));
                }
                salaryDetailItemList.add(salaryDetailItemDTO);
            });
            detailVO.setData(salaryDetailItemList);
            salaryDetailVOList.add(detailVO);
        });
        return salaryDetailVOList;
    }

    @Override
    public JSONObject getSalaryCardCommonUrl(Boolean mustBankCard) {
        return null;
    }

    @Override
    public List<SalaryCardVO> getSalaryCardList() {
        if (!this.getSalaryCalendarModel().getShowPayFlow().booleanValue()) {
            return new ArrayList<SalaryCardVO>(10);
        }
        List issueFlowInfoDTOList = this.getStructureSalaryDTO().getIssueFlowInfoDTOList();
        Map<Long, String> beBankMap = this.getBaseDataPropMapById("bd_bebank", "name", issueFlowInfoDTOList.stream().map(IssueFlowInfoDTO::getBeBankId).collect(Collectors.toSet()));
        Map<Long, String> relationMap = this.getBaseDataPropMapById("hbss_payrollacrelation", "name", issueFlowInfoDTOList.stream().map(IssueFlowInfoDTO::getPayRollacrelId).collect(Collectors.toSet()));
        Map<Long, String> currencyMap = this.getBaseDataPropMapById("bd_currency", "sign", issueFlowInfoDTOList.stream().map(IssueFlowInfoDTO::getPayCurrencyId).collect(Collectors.toSet()));
        String userName = RequestContext.get().getUserName();
        ArrayList<SalaryCardVO> salaryCardList = new ArrayList<SalaryCardVO>(issueFlowInfoDTOList.size());
        issueFlowInfoDTOList.forEach(info -> {
            Boolean mustBankCard = info.getMustBankCard();
            SalaryCardVO salaryCardVO = new SalaryCardVO();
            salaryCardVO.setCurrencySign(currencyMap.getOrDefault(info.getPayCurrencyId(), ""));
            salaryCardVO.setPay(SalarySlipHelper.fmtMicrometer(info.getPayAmount()));
            salaryCardVO.setShowEye(Boolean.FALSE);
            SalaryCardDTO card = new SalaryCardDTO();
            String cardId = UUID.randomUUID().toString();
            card.setId(cardId);
            card.setOpenEye(Boolean.TRUE);
            if (mustBankCard.booleanValue()) {
                salaryCardVO.setType(SalaryCardTypeEnum.BANK_TYPE.getType());
                String bankName = beBankMap.getOrDefault(info.getBeBankId(), "");
                card.setRelation(relationMap.getOrDefault(info.getPayRollacrelId(), ""));
                String accountUserName = info.getReceiverName();
                card.setAccountName(accountUserName);
                String bankCardNum = info.getBankAccount();
                card.setNumber(bankCardNum);
                card.setName(bankName);
                salaryCardVO.setCard(card);
            } else {
                salaryCardVO.setType(SalaryCardTypeEnum.CASH_TYPE.getType());
                salaryCardVO.setCard(card);
                card.setRelation(ResManager.loadKDString((String)"\u672c\u4eba", (String)"SalarySlipDataService_0", (String)"swc-hspp-business", (Object[])new Object[0]));
                card.setAccountName(userName);
                card.setNumber("");
                card.setName(ResManager.loadKDString((String)"\u73b0\u91d1\u6536\u6b3e", (String)"SalarySlipDataService_1", (String)"swc-hspp-business", (Object[])new Object[0]));
            }
            salaryCardList.add(salaryCardVO);
        });
        return salaryCardList;
    }

    private Map<Long, SalaryItemInfoDTO> getSalaryItemMap() {
        List salaryItemInfoList = this.getStructureSalaryDTO().getSalaryItemInfoDTOList();
        Map<Long, SalaryItemInfoDTO> salaryItemInfoMap = salaryItemInfoList.stream().collect(Collectors.toMap(SalaryItemInfoDTO::getSalaryItemId, data -> data, (o1, o2) -> o1));
        QFilter itemFilter = new QFilter("id", "in", salaryItemInfoMap.keySet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        DynamicObject[] itemObjects = helper.queryOriginalArray("id,number,name,ispayoutitem,datatype.showtype", new QFilter[]{itemFilter});
        HashMap<Long, DynamicObject> itemMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject salaryItem : itemObjects) {
            itemMap.put(salaryItem.getLong("id"), salaryItem);
        }
        salaryItemInfoList.forEach(salaryItemInfo -> {
            DynamicObject salaryItemDy = (DynamicObject)itemMap.get(salaryItemInfo.getSalaryItemId());
            if (salaryItemDy != null) {
                salaryItemInfo.setShowType(salaryItemDy.getString("datatype.showtype"));
            }
        });
        return salaryItemInfoMap;
    }

    private HashBasedTable<String, Long, BaseItemInfoDTO> getItemTable() {
        List bizItemInfoList = this.getStructureSalaryDTO().getBizItemInfoDTOList();
        List fetchItemInfoList = this.getStructureSalaryDTO().getFetchItemInfoDTOList();
        List supportItemInfoList = this.getStructureSalaryDTO().getSupportItemInfoDTOList();
        HashBasedTable itemTable = HashBasedTable.create();
        if (bizItemInfoList != null) {
            bizItemInfoList.forEach(item -> {
                BaseItemInfoDTO cfr_ignored_0 = (BaseItemInfoDTO)itemTable.put((Object)"hsbs_bizitem", (Object)item.getItemId(), item);
            });
        }
        if (fetchItemInfoList != null) {
            fetchItemInfoList.forEach(item -> {
                BaseItemInfoDTO cfr_ignored_0 = (BaseItemInfoDTO)itemTable.put((Object)"hsbs_fetchitem", (Object)item.getItemId(), item);
            });
        }
        if (supportItemInfoList != null) {
            supportItemInfoList.forEach(item -> {
                BaseItemInfoDTO cfr_ignored_0 = (BaseItemInfoDTO)itemTable.put((Object)"hsbs_supportitem", (Object)item.getItemId(), item);
            });
        }
        return itemTable;
    }

    private SalarySlipDataModel analyzeSlipData() {
        SalaryCalendarModel salaryCalendarModel = this.getSalaryCalendarModel();
        String calSign = salaryCalendarModel.getCalSign();
        int scale = salaryCalendarModel.getScale();
        Long calCurrencyId = salaryCalendarModel.getCalCurrencyId();
        Map<Long, SalaryItemInfoDTO> salaryItemMap = this.getSalaryItemMap();
        HashBasedTable<String, Long, BaseItemInfoDTO> itemOtherTable = this.getItemTable();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryslipview");
        DynamicObject slipViewV = helper.queryOne((Object)salaryCalendarModel.getSalarySlipViewVersionId());
        DynamicObjectCollection entryEntitys = slipViewV.getDynamicObjectCollection("entryentity");
        ArrayList<SalarySlipDataGroupModel> groupModelList = new ArrayList<SalarySlipDataGroupModel>(entryEntitys.size());
        for (DynamicObject entryEntity : entryEntitys) {
            String displayName = entryEntity.getString("groupdisplayname");
            boolean summary = entryEntity.getBoolean("isautoendsummary");
            boolean topShow = entryEntity.getBoolean("isautoendtopshow");
            SalarySlipDataGroupModel groupModel = new SalarySlipDataGroupModel();
            groupModel.setKey(entryEntity.getString("id"));
            groupModel.setCaption(displayName);
            groupModel.setSummary(Boolean.valueOf(summary));
            groupModel.setTopShow(Boolean.valueOf(topShow));
            groupModel.setEncryptLab(Boolean.FALSE);
            DynamicObjectCollection subEntryEntitys = entryEntity.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntryEntity : subEntryEntitys) {
                String showType;
                boolean emptyDisplay = subEntryEntity.getBoolean("isemptydisplay");
                String itemDisplayName = subEntryEntity.getString("itemdisplayname");
                boolean zeroDisplay = subEntryEntity.getBoolean("iszerodisplay");
                String itemCategory = subEntryEntity.getString("itemcategory");
                Long itemKey = subEntryEntity.getLong("item.id");
                SalarySlipDataItemSumModel itemSumModel = new SalarySlipDataItemSumModel();
                itemSumModel.setKey(subEntryEntity.getString("id"));
                itemSumModel.setCaption(itemDisplayName);
                itemSumModel.setEmptyDisplay(Boolean.valueOf(emptyDisplay));
                itemSumModel.setZeroDisplay(Boolean.valueOf(zeroDisplay));
                itemSumModel.setEncryptLab(Boolean.FALSE);
                if ("hsbs_salaryitem".equals(itemCategory)) {
                    SalaryItemInfoDTO salaryItemInfoDTO = salaryItemMap.get(itemKey);
                    if (salaryItemInfoDTO == null) {
                        if (!emptyDisplay) continue;
                        itemSumModel.addShowValueList("-");
                        groupModel.addSalarySlipDataItemSumModelList(itemSumModel);
                        continue;
                    }
                    showType = salaryItemInfoDTO.getShowType();
                    itemSumModel.setShowType(showType);
                    BuildDataEnum buildDataEnum = BuildDataEnum.getBuildDataEnum(showType);
                    buildDataEnum.isShow(emptyDisplay, zeroDisplay, (SalarySlipDataBaseModel)itemSumModel, salaryItemInfoDTO);
                    if (!itemSumModel.getShow().booleanValue()) continue;
                    buildDataEnum.exec((SalarySlipDataBaseModel)groupModel, (SalarySlipDataBaseModel)itemSumModel, salaryItemInfoDTO, calSign, scale);
                    groupModel.addSalarySlipDataItemSumModelList(itemSumModel);
                    continue;
                }
                BaseItemInfoDTO itemInfo = (BaseItemInfoDTO)itemOtherTable.get((Object)itemCategory, (Object)itemKey);
                if (itemInfo == null) {
                    if (!emptyDisplay) continue;
                    itemSumModel.addShowValueList("-");
                    groupModel.addSalarySlipDataItemSumModelList(itemSumModel);
                    continue;
                }
                showType = itemInfo.getShowType();
                itemSumModel.setShowType(showType);
                BuildOtherItemDataEnum buildOtherItemDataEnum = BuildOtherItemDataEnum.getBuildDataEnum(showType);
                buildOtherItemDataEnum.isShow(emptyDisplay, zeroDisplay, (SalarySlipDataBaseModel)itemSumModel, itemInfo);
                if (!itemSumModel.getShow().booleanValue()) continue;
                buildOtherItemDataEnum.exec((SalarySlipDataBaseModel)groupModel, (SalarySlipDataBaseModel)itemSumModel, itemInfo, calSign, scale);
                groupModel.addSalarySlipDataItemSumModelList(itemSumModel);
            }
            BigDecimal sum = (BigDecimal)groupModel.getCurrencyAmountMap().get(calCurrencyId);
            if (sum != null) {
                sum = sum.setScale(scale, RoundingMode.HALF_UP);
                String sumAmount = calSign + SalarySlipHelper.fmtMicrometer(sum.toPlainString());
                groupModel.addShowValueList(sumAmount);
            }
            if (groupModel.getSalarySlipDataItemSumModelList().size() <= 0) continue;
            groupModelList.add(groupModel);
        }
        SalarySlipDataModel dataModel = new SalarySlipDataModel();
        dataModel.setSalarySlipDataGroupModelList(groupModelList);
        return dataModel;
    }

    private Map<Long, String> getBaseDataPropMapById(String baseDataName, String selectField, Set<Long> idSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(baseDataName);
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection collection = helper.queryOriginalCollection("id," + selectField, new QFilter[]{filter});
        return collection.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString(selectField)));
    }

    private String getSalaryAmount(BigDecimal salaryAmount, SalaryCalendarModel salaryCalendarModel) {
        String amount;
        if (salaryAmount == null) {
            amount = "-";
        } else {
            BigDecimal decimal = salaryAmount.setScale(salaryCalendarModel.getScale(), RoundingMode.HALF_UP);
            amount = salaryCalendarModel.getCalSign() + SalarySlipHelper.fmtMicrometer(decimal.toPlainString());
        }
        return amount;
    }
}

