/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.detaildata.builddata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.common.dto.salary.SalaryItemInfoDTO;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.common.model.SalarySlipDataBaseModel;

public enum BuildDataEnum {
    AMOUNT(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.AMOUNT.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo, String calSign, int scale) {
            boolean isNull = salaryItemInfo.isNull();
            String value = "-";
            BigDecimal amount = BigDecimal.ZERO;
            if (!isNull) {
                amount = new BigDecimal(salaryItemInfo.getCalAmount());
                amount = amount.setScale(scale, RoundingMode.HALF_UP);
                value = calSign + SalarySlipHelper.fmtMicrometer(amount.toPlainString());
            }
            itemModel.addShowValueList(value);
            itemModel.setCurrencyAmountShow(Long.valueOf(salaryItemInfo.getCalCurrencyId()), value);
            if (isNull) {
                return;
            }
            itemSumModel.addCurrencyAmount(Long.valueOf(salaryItemInfo.getCalCurrencyId()), amount);
            itemModel.setCurrencyAmount(Long.valueOf(salaryItemInfo.getCalCurrencyId()), amount);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo) {
            boolean isNull = salaryItemInfo.isNull();
            if (isNull) {
                itemModel.setShow(emptyDisplay);
                return;
            }
            if (BigDecimal.ZERO.compareTo(new BigDecimal(salaryItemInfo.getCalAmount())) == 0) {
                itemModel.setShow(zeroDisplay);
            }
        }

        @Override
        public void sum(SalaryItemInfoDTO salaryItemSum, SalaryItemInfoDTO salaryItemInfo) {
            boolean isNull = salaryItemSum.isNull();
            boolean infoNull = salaryItemInfo.isNull();
            salaryItemSum.setNull(isNull && infoNull);
            BigDecimal sum = new BigDecimal(salaryItemSum.getCalAmount()).add(new BigDecimal(salaryItemInfo.getCalAmount()));
            salaryItemSum.setCalAmount(sum.toPlainString());
        }
    }
    ,
    NUM(new HashSet(2){
        {
            super(x0);
            this.add(SWCShowType.NUM.getCode());
            this.add(SWCShowType.INT.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo, String calSign, int scale) {
            String value = salaryItemInfo.isNull() ? "-" : salaryItemInfo.getNumValue();
            itemModel.addShowValueList(value);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo) {
            boolean isNull = salaryItemInfo.isNull();
            if (isNull) {
                itemModel.setShow(emptyDisplay);
                return;
            }
            if (BigDecimal.ZERO.compareTo(new BigDecimal(salaryItemInfo.getNumValue())) == 0) {
                itemModel.setShow(zeroDisplay);
            }
        }

        @Override
        public void sum(SalaryItemInfoDTO salaryItemSum, SalaryItemInfoDTO salaryItemInfo) {
        }
    }
    ,
    BOOL(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.BOOL.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo, String calSign, int scale) {
            String value = salaryItemInfo.getBoolValue();
            value = "1".equals(value) ? ResManager.loadKDString((String)"\u662f", (String)"BuildDataEnum_0", (String)"swc-hspp-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BuildDataEnum_1", (String)"swc-hspp-business", (Object[])new Object[0]);
            itemModel.addShowValueList(value);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo) {
        }

        @Override
        public void sum(SalaryItemInfoDTO salaryItemSum, SalaryItemInfoDTO salaryItemInfo) {
        }
    }
    ,
    TEXT(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.TEXT.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo, String calSign, int scale) {
            String textValue = salaryItemInfo.getTextValue();
            textValue = SWCStringUtils.isEmpty((String)textValue) ? "-" : textValue;
            itemModel.addShowValueList(textValue);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo) {
            String value = salaryItemInfo.getTextValue();
            boolean isNull = SWCStringUtils.isEmpty((String)value);
            if (isNull) {
                itemModel.setShow(emptyDisplay);
            }
        }

        @Override
        public void sum(SalaryItemInfoDTO salaryItemSum, SalaryItemInfoDTO salaryItemInfo) {
        }
    }
    ,
    DATE(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.DATE.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo, String calSign, int scale) {
            itemModel.addShowValueList(salaryItemInfo.getDateValue());
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo) {
            String value = salaryItemInfo.getDateValue();
            boolean isNull = SWCStringUtils.isEmpty((String)value);
            if (isNull) {
                itemModel.setShow(emptyDisplay);
            }
        }

        @Override
        public void sum(SalaryItemInfoDTO salaryItemSum, SalaryItemInfoDTO salaryItemInfo) {
        }
    }
    ,
    OTHER(new HashSet(1){}){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo, String calSign, int scale) {
            itemModel.addShowValueList("");
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, SalaryItemInfoDTO salaryItemInfo) {
        }

        @Override
        public void sum(SalaryItemInfoDTO salaryItemSum, SalaryItemInfoDTO salaryItemInfo) {
        }
    };

    private Set<String> showTypeSet;

    private BuildDataEnum(HashSet<String> showTypeSet) {
        this.showTypeSet = showTypeSet;
    }

    public Set<String> getShowTypeSet() {
        return this.showTypeSet;
    }

    public static BuildDataEnum getBuildDataEnum(String showType) {
        for (BuildDataEnum data : BuildDataEnum.values()) {
            if (!data.getShowTypeSet().contains(showType)) continue;
            return data;
        }
        return OTHER;
    }

    public abstract void exec(SalarySlipDataBaseModel var1, SalarySlipDataBaseModel var2, SalaryItemInfoDTO var3, String var4, int var5);

    public abstract void isShow(Boolean var1, Boolean var2, SalarySlipDataBaseModel var3, SalaryItemInfoDTO var4);

    public abstract void sum(SalaryItemInfoDTO var1, SalaryItemInfoDTO var2);
}

