/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.detaildata.builddata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.common.dto.salary.item.BaseItemInfoDTO;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.common.model.SalarySlipDataBaseModel;

public enum BuildOtherItemDataEnum {
    AMOUNT(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.AMOUNT.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo, String calSign, int scale) {
            String infoValue = itemInfo.getValue();
            boolean isNull = SWCStringUtils.isEmpty((String)infoValue);
            String value = "-";
            BigDecimal amount = BigDecimal.ZERO;
            if (!isNull) {
                amount = new BigDecimal(infoValue);
                amount = amount.setScale(scale, RoundingMode.HALF_UP);
                value = calSign + SalarySlipHelper.fmtMicrometer(amount.toPlainString());
            }
            itemModel.addShowValueList(value);
            itemModel.setCurrencyAmountShow(itemInfo.getCalCurrencyId(), value);
            if (isNull) {
                return;
            }
            itemSumModel.addCurrencyAmount(itemInfo.getCalCurrencyId(), amount);
            itemModel.setCurrencyAmount(itemInfo.getCalCurrencyId(), amount);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo) {
            String value = itemInfo.getValue();
            boolean isNull = SWCStringUtils.isEmpty((String)value);
            if (isNull) {
                itemModel.setShow(emptyDisplay);
                return;
            }
            if (BigDecimal.ZERO.compareTo(new BigDecimal(value)) == 0) {
                itemModel.setShow(zeroDisplay);
            }
        }
    }
    ,
    NUM(new HashSet(2){
        {
            super(x0);
            this.add(SWCShowType.NUM.getCode());
            this.add(SWCShowType.INT.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo, String calSign, int scale) {
            String infoValue = itemInfo.getValue();
            String value = SWCStringUtils.isEmpty((String)infoValue) ? "-" : infoValue;
            itemModel.addShowValueList(value);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo) {
            String value = itemInfo.getValue();
            boolean isNull = SWCStringUtils.isEmpty((String)value);
            if (isNull) {
                itemModel.setShow(emptyDisplay);
                return;
            }
            if (BigDecimal.ZERO.compareTo(new BigDecimal(value)) == 0) {
                itemModel.setShow(zeroDisplay);
            }
        }
    }
    ,
    BOOL(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.BOOL.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo, String calSign, int scale) {
            String value = itemInfo.getValue();
            value = "1".equals(value) ? ResManager.loadKDString((String)"\u662f", (String)"BuildDataEnum_0", (String)"swc-hspp-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BuildDataEnum_1", (String)"swc-hspp-business", (Object[])new Object[0]);
            itemModel.addShowValueList(value);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo) {
        }
    }
    ,
    TEXT(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.TEXT.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo, String calSign, int scale) {
            String textValue = itemInfo.getValue();
            textValue = SWCStringUtils.isEmpty((String)textValue) ? "-" : textValue;
            itemModel.addShowValueList(textValue);
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo) {
            String value = itemInfo.getValue();
            boolean isNull = SWCStringUtils.isEmpty((String)value);
            if (isNull) {
                itemModel.setShow(emptyDisplay);
            }
        }
    }
    ,
    DATE(new HashSet(1){
        {
            super(x0);
            this.add(SWCShowType.DATE.getCode());
        }
    }){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo, String calSign, int scale) {
            itemModel.addShowValueList(itemInfo.getValue());
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo) {
            String value = itemInfo.getValue();
            boolean isNull = SWCStringUtils.isEmpty((String)value);
            if (isNull) {
                itemModel.setShow(emptyDisplay);
            }
        }
    }
    ,
    OTHER(new HashSet(1){}){

        @Override
        public void exec(SalarySlipDataBaseModel itemSumModel, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo, String calSign, int scale) {
            itemModel.addShowValueList("");
        }

        @Override
        public void isShow(Boolean emptyDisplay, Boolean zeroDisplay, SalarySlipDataBaseModel itemModel, BaseItemInfoDTO itemInfo) {
        }
    };

    private Set<String> showTypeSet;

    private BuildOtherItemDataEnum(HashSet<String> showTypeSet) {
        this.showTypeSet = showTypeSet;
    }

    public Set<String> getShowTypeSet() {
        return this.showTypeSet;
    }

    public static BuildOtherItemDataEnum getBuildDataEnum(String showType) {
        for (BuildOtherItemDataEnum data : BuildOtherItemDataEnum.values()) {
            if (!data.getShowTypeSet().contains(showType)) continue;
            return data;
        }
        return OTHER;
    }

    public abstract void exec(SalarySlipDataBaseModel var1, SalarySlipDataBaseModel var2, BaseItemInfoDTO var3, String var4, int var5);

    public abstract void isShow(Boolean var1, Boolean var2, SalarySlipDataBaseModel var3, BaseItemInfoDTO var4);
}

