/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.detaildata.sum;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.dto.salary.SalaryItemInfoDTO;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.business.salaryslip.detaildata.builddata.BuildDataEnum;
import kd.swc.hspp.business.salaryslip.detaildata.sum.BaseSalarySlipSumDataService;
import kd.swc.hspp.common.model.SalaryCalendarModel;
import kd.swc.hspp.common.model.SalarySlipDataBaseModel;
import kd.swc.hspp.common.model.SalarySlipDataGroupModel;
import kd.swc.hspp.common.model.SalarySlipDataItemModel;
import kd.swc.hspp.common.model.SalarySlipDataItemSumModel;
import kd.swc.hspp.common.model.SalarySlipDataModel;
import kd.swc.hspp.common.model.SalarySlipSumDetailModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataBaseSdkModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataGroupSdkModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataItemSdkModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataItemSumSdkModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDataSdkModel;
import kd.swc.hspp.common.model.sdk.SalarySlipDetailDataSdkModel;

public class SalarySlipSumDataService
extends BaseSalarySlipSumDataService {
    public final Log logger = LogFactory.getLog(SalarySlipSumDataService.class);
    private SalarySlipDataModel dataModel;
    private Long slipSumViewId;

    public SalarySlipSumDataService(List<SalarySlipSumDetailModel> salarySlipSumDetailModelList, Map<Long, SalaryCalendarModel> salaryCalendarModelMap, Map<Long, DynamicObject> currencyMap, Long slipSumViewId) {
        super(salarySlipSumDetailModelList, salaryCalendarModelMap, currencyMap);
        this.slipSumViewId = slipSumViewId;
    }

    private SalarySlipDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = this.analyzeSlipSumData();
        }
        return this.dataModel;
    }

    public SalarySlipDataSdkModel getSalarySlipDataSdkModel() {
        SalarySlipDataModel dataModel = this.getDataModel();
        SalarySlipDataSdkModel dataSdkModel = new SalarySlipDataSdkModel();
        if (dataModel == null) {
            return dataSdkModel;
        }
        List groupModelList = dataModel.getSalarySlipDataGroupModelList();
        for (SalarySlipDataGroupModel groupModel : groupModelList) {
            SalarySlipDataGroupSdkModel groupSdkModel = new SalarySlipDataGroupSdkModel();
            this.packagingSdkData((SalarySlipDataBaseSdkModel)groupSdkModel, (SalarySlipDataBaseModel)groupModel);
            dataSdkModel.addSalarySlipDataGroupSdkModelList(groupSdkModel);
            List itemSumModelList = groupModel.getSalarySlipDataItemSumModelList();
            for (SalarySlipDataItemSumModel itemSumModel : itemSumModelList) {
                SalarySlipDataItemSumSdkModel itemSumSdkModel = new SalarySlipDataItemSumSdkModel();
                this.packagingSdkData((SalarySlipDataBaseSdkModel)itemSumSdkModel, (SalarySlipDataBaseModel)itemSumModel);
                itemSumSdkModel.setSalaryItemId(itemSumModel.getSalaryItemId());
                groupSdkModel.addItemDataList(itemSumSdkModel);
                List itemModelList = itemSumModel.getSalarySlipDataItemModelList();
                for (SalarySlipDataItemModel itemModel : itemModelList) {
                    SalarySlipDataItemSdkModel itemSdkModel = new SalarySlipDataItemSdkModel();
                    this.packagingSdkData((SalarySlipDataBaseSdkModel)itemSdkModel, (SalarySlipDataBaseModel)itemModel);
                    itemSumSdkModel.addItemDetailList(itemSdkModel);
                }
            }
        }
        return dataSdkModel;
    }

    private void packagingSdkData(SalarySlipDataBaseSdkModel sdkModel, SalarySlipDataBaseModel baseModel) {
        sdkModel.setCaption(baseModel.getCaption());
        Map currencyAmountMap = baseModel.getCurrencyAmountMap();
        Map currencyAmountShowMap = baseModel.getCurrencyAmountShowMap();
        ArrayList detailDataSdkModels = new ArrayList(currencyAmountShowMap.size());
        currencyAmountShowMap.forEach((id, showValue) -> {
            SalarySlipDetailDataSdkModel detailDataSdkModel = new SalarySlipDetailDataSdkModel();
            detailDataSdkModel.setCurrencyId(id);
            detailDataSdkModel.setShowValue(showValue);
            detailDataSdkModel.setItemAmount((BigDecimal)currencyAmountMap.get(id));
            detailDataSdkModels.add(detailDataSdkModel);
        });
        sdkModel.setDataDetailList(detailDataSdkModels);
    }

    private SalarySlipDataModel analyzeSlipSumData() {
        List<SalarySlipSumDetailModel> salarySlipSumDetailModelList = this.getSalarySlipSumDetailModelList();
        Map<Long, SalaryCalendarModel> salaryCalendarModelMap = this.getSalaryCalendarModelMap();
        Map<Long, DynamicObject> currencyMap = this.getCurrencyMap();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salslipsumview");
        DynamicObject slipSumView = helper.queryOne((Object)this.slipSumViewId);
        Map<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap = this.groupingSalaryItemBySumView(salarySlipSumDetailModelList, slipSumView);
        Set<Date> dateSet = salarySlipSumDetailModelList.stream().map(SalarySlipSumDetailModel::getReleaseTime).collect(Collectors.toSet());
        Map<Long, List<SalarySlipSumDetailModel>> salaryItemIdSumInfoSortMap = this.addItemByYear(salaryItemIdSumInfoMap, salaryCalendarModelMap, dateSet);
        List<Long> calCurrencySortList = salaryCalendarModelMap.values().stream().sorted().map(SalaryCalendarModel::getCalCurrencyId).distinct().collect(Collectors.toList());
        boolean isGroup = slipSumView.getBoolean("isgroup");
        DynamicObjectCollection entryEntity = slipSumView.getDynamicObjectCollection("entryentity");
        ArrayList<SalarySlipDataGroupModel> groupModelList = new ArrayList<SalarySlipDataGroupModel>(entryEntity.size());
        for (DynamicObject entity : entryEntity) {
            SalarySlipDataGroupModel groupModel = new SalarySlipDataGroupModel();
            groupModel.setKey(entity.getString("id"));
            groupModel.setCaption(isGroup ? entity.getString("groupdisplayname") : "");
            DynamicObjectCollection subEntryEntity = entity.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntity : subEntryEntity) {
                Long salaryItemId = subEntity.getLong("salaryitem.id");
                boolean emptyDisplay = subEntity.getBoolean("isemptydisplay");
                String itemDisplayName = subEntity.getString("subgroupdisplayname");
                boolean zeroDisplay = subEntity.getBoolean("iszerodisplay");
                SalarySlipDataItemSumModel itemSumModel = new SalarySlipDataItemSumModel();
                String subEntityId = subEntity.getString("id");
                itemSumModel.setKey(subEntityId);
                itemSumModel.setCaption(itemDisplayName);
                itemSumModel.setEmptyDisplay(Boolean.valueOf(emptyDisplay));
                itemSumModel.setZeroDisplay(Boolean.valueOf(zeroDisplay));
                itemSumModel.setSalaryItemId(salaryItemId);
                List<SalarySlipSumDetailModel> salaryItemSumInfoList = salaryItemIdSumInfoSortMap.get(salaryItemId);
                salaryItemSumInfoList.forEach(data -> {
                    String calendarId = data.getCalendarId();
                    Date releaseTime = data.getReleaseTime();
                    String caption = SWCDateTimeUtils.format((Date)releaseTime, (String)"yyyy.MM");
                    DynamicObject currency = (DynamicObject)currencyMap.get(data.getCalCurrencyId());
                    String calSign = currency == null ? "" : currency.getString("sign");
                    int scale = currency == null ? 2 : currency.getInt("amtprecision");
                    data.getSalaryItemInfoList().forEach(salaryItemInfo -> {
                        String showType = salaryItemInfo.getShowType();
                        SalarySlipDataItemModel itemModel = new SalarySlipDataItemModel();
                        itemModel.setKey(calendarId + subEntityId);
                        itemModel.setCaption(caption);
                        BuildDataEnum buildDataEnum = BuildDataEnum.getBuildDataEnum(showType);
                        buildDataEnum.isShow(emptyDisplay, zeroDisplay, (SalarySlipDataBaseModel)itemModel, (SalaryItemInfoDTO)salaryItemInfo);
                        if (itemModel.getShow().booleanValue()) {
                            buildDataEnum.exec((SalarySlipDataBaseModel)itemSumModel, (SalarySlipDataBaseModel)itemModel, (SalaryItemInfoDTO)salaryItemInfo, calSign, scale);
                            itemSumModel.addSalarySlipDataItemModelList(itemModel);
                        }
                    });
                });
                Map currencyAmountMap = itemSumModel.getCurrencyAmountMap();
                if (currencyAmountMap.isEmpty()) {
                    if (emptyDisplay) {
                        itemSumModel.addShowValueList("-");
                        itemSumModel.setCurrencyAmountShow(Long.valueOf(0L), null);
                    }
                } else {
                    calCurrencySortList.forEach(calCurrencyId -> {
                        BigDecimal sum = (BigDecimal)currencyAmountMap.get(calCurrencyId);
                        if (sum != null) {
                            DynamicObject currency = (DynamicObject)currencyMap.get(calCurrencyId);
                            String calSign = currency.getString("sign");
                            sum = sum.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                            currencyAmountMap.put(calCurrencyId, sum);
                            String sumAmount = calSign + SalarySlipHelper.fmtMicrometer(sum.toPlainString());
                            itemSumModel.addShowValueList(sumAmount);
                            itemSumModel.setCurrencyAmountShow(calCurrencyId, sumAmount);
                        }
                    });
                }
                itemSumModel.setShow(Boolean.valueOf(itemSumModel.getShowValueList().size() > 0));
                if (!itemSumModel.getShow().booleanValue()) continue;
                groupModel.addSalarySlipDataItemSumModelList(itemSumModel);
            }
            groupModel.setShow(Boolean.valueOf(groupModel.getSalarySlipDataItemSumModelList().size() > 0));
            if (!groupModel.getShow().booleanValue()) continue;
            groupModelList.add(groupModel);
        }
        SalarySlipDataModel dataModel = new SalarySlipDataModel();
        dataModel.setSalarySlipDataGroupModelList(groupModelList);
        return dataModel;
    }

    private Map<Long, Map<String, SalarySlipSumDetailModel>> groupingSalaryItemBySumView(List<SalarySlipSumDetailModel> salarySlipSumDetailModelList, DynamicObject slipSumView) {
        DynamicObjectCollection entryEntity = slipSumView.getDynamicObjectCollection("entryentity");
        HashMap<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap = new HashMap<Long, Map<String, SalarySlipSumDetailModel>>(16);
        for (DynamicObject entity : entryEntity) {
            DynamicObjectCollection subEntryEntity = entity.getDynamicObjectCollection("subentryentity");
            subEntryEntity.forEach(data -> {
                Long salaryItemId = data.getLong("salaryitem.id");
                salaryItemIdSumInfoMap.put(salaryItemId, new HashMap(16));
            });
        }
        QFilter itemFilter = new QFilter("id", "in", salaryItemIdSumInfoMap.keySet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        DynamicObject[] itemArrays = helper.query("id,number,name,ispayoutitem,datatype.showtype", new QFilter[]{itemFilter});
        HashMap<Long, DynamicObject> itemMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject item : itemArrays) {
            itemMap.put(item.getLong("id"), item);
        }
        salarySlipSumDetailModelList.forEach(detail -> {
            List salaryItemInfoList = detail.getSalaryItemInfoList();
            if (salaryItemInfoList != null) {
                for (SalaryItemInfoDTO salaryItemInfo : salaryItemInfoList) {
                    Long salaryItemId = salaryItemInfo.getSalaryItemId();
                    Map salaryItemSumInfoMap = (Map)salaryItemIdSumInfoMap.get(salaryItemId);
                    if (salaryItemSumInfoMap == null) continue;
                    String key = SWCDateTimeUtils.format((Date)detail.getReleaseTime(), (String)"yyyy.MM") + "_" + salaryItemInfo.getCalCurrencyId();
                    SalarySlipSumDetailModel detailModel = salaryItemSumInfoMap.getOrDefault(key, new SalarySlipSumDetailModel());
                    salaryItemInfo.setShowType(((DynamicObject)itemMap.get(salaryItemId)).getString("datatype.showtype"));
                    detailModel.setCalendarId(detail.getCalendarId());
                    detailModel.setReleaseTime(detail.getReleaseTime());
                    detailModel.setCalCurrencyId(Long.valueOf(salaryItemInfo.getCalCurrencyId()));
                    List salaryItemInfos = detailModel.getSalaryItemInfoList();
                    if (salaryItemInfos.size() == 1) {
                        SalaryItemInfoDTO salaryItemInfoSum = (SalaryItemInfoDTO)salaryItemInfos.get(0);
                        String showType = salaryItemInfoSum.getShowType();
                        BuildDataEnum buildDataEnum = BuildDataEnum.getBuildDataEnum(showType);
                        buildDataEnum.sum(salaryItemInfoSum, salaryItemInfo);
                    } else {
                        salaryItemInfos.add(salaryItemInfo);
                    }
                    salaryItemSumInfoMap.put(key, detailModel);
                }
            }
        });
        return salaryItemIdSumInfoMap;
    }

    private Map<Long, List<SalarySlipSumDetailModel>> addItemByYear(Map<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap, Map<Long, SalaryCalendarModel> salaryCalendarModelMap, Set<Date> dateSet) {
        List<Long> calCurrencySortList = salaryCalendarModelMap.values().stream().sorted().map(SalaryCalendarModel::getCalCurrencyId).distinct().collect(Collectors.toList());
        return this.buildSalaryItemMapSort(salaryItemIdSumInfoMap, dateSet, calCurrencySortList);
    }

    private Map<Long, List<SalarySlipSumDetailModel>> buildSalaryItemMapSort(Map<Long, Map<String, SalarySlipSumDetailModel>> salaryItemIdSumInfoMap, Set<Date> dateSet, List<Long> calCurrencySortList) {
        HashMap<Long, List<SalarySlipSumDetailModel>> salaryItemIdSumInfoSortMap = new HashMap<Long, List<SalarySlipSumDetailModel>>(salaryItemIdSumInfoMap.size());
        salaryItemIdSumInfoMap.forEach((salaryItemId, salaryItemSumInfoMap) -> {
            Map<String, Boolean> monthBetween = SalarySlipHelper.getMonthBetween(dateSet);
            ArrayList salaryItemSumInfoList = new ArrayList(salaryItemSumInfoMap.values());
            salaryItemSumInfoList.forEach(data -> {
                Date releaseTime = data.getReleaseTime();
                String dateKey = SWCDateTimeUtils.format((Date)releaseTime, (String)"yyyy.MM");
                if (monthBetween.containsKey(dateKey)) {
                    monthBetween.put(dateKey, Boolean.TRUE);
                }
            });
            monthBetween.forEach((monthString, isHave) -> {
                try {
                    if (!isHave.booleanValue()) {
                        Date date = SWCDateTimeUtils.parseDate((String)monthString, (String)"yyyy.MM");
                        salaryItemSumInfoList.add(SalarySlipSumDetailModel.newEmptyInstance((Date)date, (Long)salaryItemId));
                    }
                }
                catch (ParseException e) {
                    this.logger.error("parseDate error:", (Throwable)e);
                }
            });
            List sortList = salaryItemSumInfoList.stream().sorted(Comparator.comparing(SalarySlipSumDetailModel::getReleaseTime, Comparator.reverseOrder()).thenComparingInt(model -> calCurrencySortList.indexOf(model.getCalCurrencyId()))).collect(Collectors.toList());
            salaryItemIdSumInfoSortMap.put((Long)salaryItemId, sortList);
        });
        return salaryItemIdSumInfoSortMap;
    }
}

