/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.salaryslip.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hspp.business.mservice.person.IPersonService;
import kd.swc.hspp.business.salaryslip.SalarySlipHelper;
import kd.swc.hspp.common.constants.SalarySlipApiResultStatusEnum;
import kd.swc.hspp.common.model.openapi.PayDetailInfoModel;
import kd.swc.hspp.common.model.openapi.SalaryCalendarResponseModel;
import kd.swc.hspp.common.model.openapi.SalaryDetailResponseModel;
import kd.swc.hspp.common.model.openapi.SalarySlipDetailResponseModel;
import kd.swc.hspp.common.model.openapi.SalarySlipItemInfoModel;

public class SalarySlipOpenApiService {
    private Log log = LogFactory.getLog(SalarySlipOpenApiService.class);

    public CustomApiResult<SalarySlipDetailResponseModel> querySalarySlipDetail(String queryDate, String startDate, String endDate) {
        try {
            Long personId = 0L;
            Tuple<Boolean, Map<String, Object>> tuple = IPersonService.getInstance().getPersonInfo();
            if (((Boolean)tuple.item1).booleanValue()) {
                personId = ((Map)tuple.item2).getOrDefault("person", 0L);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("personId", personId);
            paramMap.put("startDate", startDate);
            paramMap.put("endDate", endDate);
            paramMap.put("queryDate", queryDate);
            ApiResult apiResult = SalarySlipHelper.querySalarySlipDetail(paramMap);
            if (apiResult.getSuccess()) {
                JSONObject data = (JSONObject)apiResult.getData();
                SalarySlipDetailResponseModel responseModel = (SalarySlipDetailResponseModel)JSON.toJavaObject((JSON)data, SalarySlipDetailResponseModel.class);
                this.setBaseDataProp(responseModel);
                return CustomApiResult.success((Object)responseModel);
            }
            return CustomApiResult.fail((String)apiResult.getErrorCode(), (String)apiResult.getMessage());
        }
        catch (Exception exception) {
            this.log.info("error %s", (Object)exception);
            return CustomApiResult.fail((String)String.valueOf(SalarySlipApiResultStatusEnum.ERROR.getCode()), (String)SalarySlipApiResultStatusEnum.ERROR.getI18nParamString());
        }
    }

    private void setBaseDataProp(SalarySlipDetailResponseModel responseModel) {
        HashSet<Long> currencyIdSet = new HashSet<Long>(16);
        HashSet<Long> salaryItemIdSet = new HashSet<Long>(16);
        HashSet<Long> payTypeIdSet = new HashSet<Long>(16);
        HashSet<Long> payRollacrelIdSet = new HashSet<Long>(16);
        HashSet<Long> beBankIdSet = new HashSet<Long>(16);
        List salarySlipList = responseModel.getSalarySlip();
        if (salarySlipList == null) {
            return;
        }
        currencyIdSet.addAll(salarySlipList.stream().map(data -> data.getCalendar().getCalCurrencyId()).collect(Collectors.toSet()));
        salarySlipList.forEach(data -> {
            List payDetailInfoList;
            List salaryItemInfoList = data.getDetail().getSalaryItemInfoList();
            if (salaryItemInfoList != null) {
                salaryItemIdSet.addAll(salaryItemInfoList.stream().map(SalarySlipItemInfoModel::getSalaryItemId).collect(Collectors.toSet()));
            }
            if ((payDetailInfoList = data.getDetail().getPayDetailInfoList()) != null) {
                payTypeIdSet.addAll(payDetailInfoList.stream().map(PayDetailInfoModel::getPayTypeId).collect(Collectors.toSet()));
                currencyIdSet.addAll(payDetailInfoList.stream().map(PayDetailInfoModel::getPayCurrencyId).collect(Collectors.toSet()));
                payRollacrelIdSet.addAll(payDetailInfoList.stream().map(PayDetailInfoModel::getPayRollacrelId).collect(Collectors.toSet()));
                beBankIdSet.addAll(payDetailInfoList.stream().map(PayDetailInfoModel::getBeBankId).collect(Collectors.toSet()));
            }
        });
        Map<Long, DynamicObject> currencyDataMap = this.queryBaseDataMap("bd_currency", "id,number,name,sign,amtprecision", currencyIdSet);
        Map<Long, DynamicObject> salaryItemDataMap = this.queryBaseDataMap("hsbs_salaryitem", "id,number,name", salaryItemIdSet);
        Map<Long, DynamicObject> payTypeDataMap = this.queryBaseDataMap("hsbs_paymethod", "id,number,name", payTypeIdSet);
        Map<Long, DynamicObject> payRollacrelIdMap = this.queryBaseDataMap("hbss_payrollacrelation", "id,number,name", payRollacrelIdSet);
        Map<Long, DynamicObject> beBankIdMap = this.queryBaseDataMap("bd_bebank", "id,number,name", beBankIdSet);
        salarySlipList.forEach(salarySlip -> {
            SalaryCalendarResponseModel calendar = salarySlip.getCalendar();
            DynamicObject currency = (DynamicObject)currencyDataMap.get(calendar.getCalCurrencyId());
            if (currency != null) {
                calendar.setCalCurrencyNum(currency.getString("number"));
                calendar.setCalCurrencyName(currency.getString("name"));
            }
            SalaryDetailResponseModel detail = salarySlip.getDetail();
            List salaryItemInfoList = detail.getSalaryItemInfoList();
            salaryItemInfoList.forEach(salaryItemInfo -> {
                DynamicObject salaryItem = (DynamicObject)salaryItemDataMap.get(salaryItemInfo.getSalaryItemId());
                if (salaryItem != null) {
                    salaryItemInfo.setSalaryItemNum(salaryItem.getString("number"));
                    salaryItemInfo.setSalaryItemName(salaryItem.getString("name"));
                }
            });
            List payDetailInfoList = detail.getPayDetailInfoList();
            payDetailInfoList.forEach(payDetail -> {
                DynamicObject currencyPay;
                DynamicObject bank;
                DynamicObject payRollacrel;
                DynamicObject payType = (DynamicObject)payTypeDataMap.get(payDetail.getPayTypeId());
                if (payType != null) {
                    payDetail.setPayTypeNum(payType.getString("number"));
                    payDetail.setPayTypeName(payType.getString("name"));
                }
                if ((payRollacrel = (DynamicObject)payRollacrelIdMap.get(payDetail.getPayRollacrelId())) != null) {
                    payDetail.setPayRollacrelNum(payRollacrel.getString("number"));
                    payDetail.setPayRollacrelName(payRollacrel.getString("name"));
                }
                if ((bank = (DynamicObject)beBankIdMap.get(payDetail.getBeBankId())) != null) {
                    payDetail.setBeBankNum(bank.getString("number"));
                    payDetail.setBeBankName(bank.getString("name"));
                }
                if ((currencyPay = (DynamicObject)currencyDataMap.get(payDetail.getPayCurrencyId())) != null) {
                    payDetail.setPayCurrencyNum(currencyPay.getString("number"));
                    payDetail.setPayCurrencyName(currencyPay.getString("name"));
                    payDetail.setPayCurSign(currencyPay.getString("sign"));
                    payDetail.setPayCurScale(Integer.valueOf(currencyPay.getInt("amtprecision")));
                }
            });
        });
    }

    private Map<Long, DynamicObject> queryBaseDataMap(String entityName, String selectProperties, Set<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] query = helper.query(selectProperties, new QFilter[]{filter});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject data : query) {
            map.put(data.getLong("id"), data);
        }
        return map;
    }
}

