/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hspp.business.viewhelper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;

public class EntryHelper {
    public static void deleteEntry(IDataModel model, String entryKey, int[] rows) {
        if (rows != null && rows.length > 0) {
            model.deleteEntryRows(entryKey, rows);
        } else {
            model.deleteEntryData(entryKey);
        }
    }

    public static void batchCreateNewEntryRow(IFormView view, String entryKey, List<Map<String, Object>> fieldMapList) {
        if (fieldMapList.isEmpty()) {
            return;
        }
        ArrayList<String> fieldKeyList = new ArrayList<String>(fieldMapList.get(0).keySet());
        TableValueSetter tableSetter = EntryHelper.createTableSetter(fieldKeyList);
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        fieldMapList.forEach(data -> {
            Object[] rowData = new Object[fieldKeyList.size()];
            for (int index = 0; index < fieldKeyList.size(); ++index) {
                rowData[index] = data.get(fieldKeyList.get(index));
            }
            tableSetter.addRow(rowData);
        });
        model.batchCreateNewEntryRow(entryKey, tableSetter);
        model.endInit();
        view.updateView(entryKey);
    }

    public static void setCardEntryChildVisible(CardEntry entry, boolean isVisible, int rowIndex, String ... ctlKeys) {
        entry.setChildVisible(isVisible, rowIndex, ctlKeys);
    }

    private static TableValueSetter createTableSetter(List<String> fieldKeyList) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        fieldKeyList.forEach(fieldKey -> setter.addField(fieldKey, new Object[0]));
        return setter;
    }
}

