/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.opplugin.validator.costcfg;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostCfgImportValidator
extends SWCDataBaseValidator {
    public void validate() {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String importType = (String)variables.get("isimport");
        if (!"1".equals(importType) && !"2".equals(importType)) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities.length == 0) {
            return;
        }
        DynamicObject dataEntity = extendedDataEntities[0].getDataEntity();
        String billFormId = dataEntity.getDataEntityType().getName();
        Long costBizObjId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billFormId);
        boolean isAllowedSplit = CostCfgImportHelper.queryIsAllowedSplitById((Long)costBizObjId);
        this.checkProportionAndMustInput(extendedDataEntities, isAllowedSplit);
    }

    private void checkProportionAndMustInput(ExtendedDataEntity[] extendedDataEntities, boolean isAllowedSplit) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection costCfgEntryColl = dataEntity.getDynamicObjectCollection("costcfgentryentity");
            String billName = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
            if (costCfgEntryColl == null) continue;
            if (isAllowedSplit) {
                this.validateEntryProportionInfo(costCfgEntryColl, extendedDataEntity);
            } else {
                this.checkIsNotAllowSplitProportion(costCfgEntryColl, billName, extendedDataEntity);
            }
            String billFromId = dataEntity.getDataEntityType().getName();
            if ("pcs_costitemcfg".equals(billFromId)) {
                this.validatorCostItem(extendedDataEntity, costCfgEntryColl);
                continue;
            }
            if (!"pcs_costdeptcfg".equals(billFromId)) continue;
            this.validatorCostDept(extendedDataEntity, costCfgEntryColl);
        }
    }

    private void validatorCostDept(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection costCfgEntryColl) {
        DynamicObject dynamicEntryObject;
        BigDecimal costCfgTotal;
        String errorMsg;
        DynamicObjectCollection costCfgTypeEntryColl = extendedDataEntity.getDataEntity().getDynamicObjectCollection("costcfgtypeentryentity");
        if (costCfgTypeEntryColl == null) {
            return;
        }
        if (costCfgEntryColl.isEmpty() && costCfgTypeEntryColl.isEmpty()) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u6216\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgImportValidator_0", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
        if (costCfgTypeEntryColl.size() > 1) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgImportValidator_1", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        } else if (costCfgTypeEntryColl.size() == 1 && new BigDecimal(100).compareTo(costCfgTotal = (dynamicEntryObject = (DynamicObject)costCfgTypeEntryColl.get(0)).getBigDecimal("costcfgtypeproportion")) != 0) {
            String errorMsg2 = ResManager.loadKDString((String)"\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d\u767e\u5206\u6bd4\u5fc5\u987b\u8bbe\u7f6e\u4e3a100%\u3002", (String)"CostCfgImportValidator_3", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
        }
    }

    private void validatorCostItem(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection costCfgEntryColl) {
        DynamicObject dynamicEntryObject;
        BigDecimal costCfgTotal;
        String errorMsg;
        DynamicObjectCollection costCfgTypeEntryColl = extendedDataEntity.getDataEntity().getDynamicObjectCollection("costcfgtypeentryentity");
        if (costCfgTypeEntryColl == null) {
            return;
        }
        if (costCfgEntryColl.isEmpty() && costCfgTypeEntryColl.isEmpty()) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u6216\u201c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgImportValidator_4", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
        if (costCfgTypeEntryColl.size() > 1) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgImportValidator_5", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        } else if (costCfgTypeEntryColl.size() == 1 && (costCfgTotal = (dynamicEntryObject = (DynamicObject)costCfgTypeEntryColl.get(0)).getBigDecimal("costcfgtypeproportion")).compareTo(new BigDecimal(100)) > 0) {
            String errorMsg2 = ResManager.loadKDString((String)"\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u8d85\u8fc7100%\u3002", (String)"CostCfgImportValidator_6", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg2);
        }
    }

    public void checkIsNotAllowSplitProportion(DynamicObjectCollection costCfgEntryColl, String costCfgTypeName, ExtendedDataEntity extendedDataEntity) {
        DynamicObject costCfgEntryDy;
        BigDecimal calCostProportion;
        if (costCfgEntryColl.size() > 1) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6,\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5fc5\u987b\u8bbe\u7f6e\u4e3a100\u3002", (String)"CostCfgImportValidator_7", (String)"swc-pcs-opplugin", (Object[])new Object[0]), costCfgTypeName);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        } else if (costCfgEntryColl.size() == 1 && new BigDecimal(100).compareTo(calCostProportion = (costCfgEntryDy = (DynamicObject)costCfgEntryColl.get(0)).getBigDecimal("calcostproportion")) != 0) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6,\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5fc5\u987b\u8bbe\u7f6e\u4e3a100\u3002", (String)"CostCfgImportValidator_7", (String)"swc-pcs-opplugin", (Object[])new Object[0]), costCfgTypeName);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    public void validateEntryProportionInfo(DynamicObjectCollection costCfgEntryColl, ExtendedDataEntity extendedDataEntity) {
        BigDecimal costCfgTotal = BigDecimal.ZERO;
        for (DynamicObject costCfgEntryDy : costCfgEntryColl) {
            BigDecimal calCostProportion = costCfgEntryDy.getBigDecimal("calcostproportion");
            if (BigDecimal.ZERO.compareTo(calCostProportion) == 0) continue;
            costCfgTotal = costCfgTotal.add(calCostProportion);
        }
        if (costCfgTotal.compareTo(new BigDecimal(100)) > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u4e0d\u5f97\u5927\u4e8e100%\u3002", (String)"CostCfgImportValidator_8", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }
}

