/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.opplugin.web.costcfg;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;

public class CostCfgSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("calcostproportion");
        fieldKeys.add("coststrucfgvalue");
        fieldKeys.add("costcfgtypeproportion");
        fieldKeys.add("coststrutypecfgvalue");
        fieldKeys.add("sourcetype.isallowedsplit");
        fieldKeys.add("costadapter.coststru.id");
        fieldKeys.add("costadapter");
        fieldKeys.add("qualitydim");
        fieldKeys.add("qualityname");
        fieldKeys.add("qualitynumber");
        fieldKeys.add("source");
        fieldKeys.add("createorg");
        fieldKeys.add("hidekeyandvalue");
        fieldKeys.add("hidetypekeyandvalue");
        fieldKeys.add("costsegstore");
        fieldKeys.add("costtypesegstore");
        fieldKeys.add("source");
        fieldKeys.add("creatorobj.person.name");
        fieldKeys.add("creatorobj.employee.empnumber");
        for (int i = 1; i <= 11; ++i) {
            String baseDataKey = "basedataid" + i;
            fieldKeys.add(baseDataKey);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String billList = (String)variables.get("bill_list");
        if ("true".equals(billList)) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        long costStruId = this.getCostStruId(dataEntities);
        this.setCostSegmentInfo(costStruId, dataEntities);
        this.setNameAndNumber(dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String importType = (String)variables.get("isimport");
        boolean isImport = "1".equals(importType);
        if (isImport) {
            return;
        }
        this.updateHistoryInfo(dataEntities);
    }

    private void updateHistoryInfo(DynamicObject[] dataEntities) {
        DynamicObject dynamicObject = dataEntities[0];
        String billName = dynamicObject.getDataEntityType().getName();
        for (DynamicObject data : dataEntities) {
            this.setCostSegStoreInfo(data, "costcfgentryentity", "costsegstore");
            if (!SWCStringUtils.equals((String)"pcs_costdeptcfg", (String)billName) && !SWCStringUtils.equals((String)"pcs_costitemcfg", (String)billName) && !"pcs_costgroupcfg".equals(billName)) continue;
            this.setCostSegStoreInfo(data, "costcfgtypeentryentity", "costtypesegstore");
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billName);
        helper.update(dataEntities);
    }

    private long getCostStruId(DynamicObject[] dataEntities) {
        DynamicObject costCfgDy;
        long costStruId = 0L;
        DynamicObject[] dynamicObjectArray = dataEntities;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n && (costStruId = (costCfgDy = dynamicObjectArray[i]).getLong("coststru.id")) == 0L; ++i) {
        }
        return costStruId;
    }

    private void setCostSegmentInfo(Long costStruId, DynamicObject[] dataEntities) {
        Map costStruDimensionIdMap = CostCfgHelper.getCostStruDimensionIdStorageNumberMap((Long)costStruId);
        this.saveCostCfgSegmentInfo(dataEntities, costStruDimensionIdMap);
        this.saveCostCfgTypeSegmentInfo(dataEntities, costStruDimensionIdMap);
    }

    private void setCostSegStoreInfo(DynamicObject costCfgDy, String entryEntityKey, String segStoreKey) {
        DynamicObjectCollection dynamicObjectCollection = costCfgDy.getDynamicObjectCollection(entryEntityKey);
        IAppCache appCache = AppCache.get((String)"pcs");
        long boId = costCfgDy.getLong("boid");
        if (boId == 0L) {
            return;
        }
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            String dimensionKey = boId + entryEntityKey + i;
            String dimensionValue = (String)appCache.get(dimensionKey, String.class);
            if (dimensionValue != null && !dimensionValue.isEmpty()) {
                ((DynamicObject)dynamicObjectCollection.get(i)).set(segStoreKey, (Object)dimensionValue);
            }
            appCache.remove(dimensionKey);
        }
    }

    private void saveCostCfgTypeSegmentInfo(DynamicObject[] dataEntities, Map<Long, String> costStruDimensionIdMap) {
        SWCDataServiceHelper costSegStoreHelper = new SWCDataServiceHelper("pcs_costsegstore");
        DynamicObjectCollection costSegTypeStoreDyList = new DynamicObjectCollection();
        for (DynamicObject costCfgDy : dataEntities) {
            String name = costCfgDy.getDataEntityType().getName();
            if (!SWCStringUtils.equals((String)"pcs_costdeptcfg", (String)name) && !SWCStringUtils.equals((String)"pcs_costitemcfg", (String)name) && !"pcs_costgroupcfg".equals(name)) continue;
            String costSourceType = CostCfgHelper.getCostType((String)name);
            CostCfgHelper.fillCostSegmentInfo((String)"costCfgType", (String)costSourceType, (SWCDataServiceHelper)costSegStoreHelper, (DynamicObject)costCfgDy, costStruDimensionIdMap, (DynamicObjectCollection)costSegTypeStoreDyList);
        }
        if (!CollectionUtils.isEmpty((Collection)costSegTypeStoreDyList)) {
            costSegStoreHelper.save(costSegTypeStoreDyList);
        }
    }

    private void saveCostCfgSegmentInfo(DynamicObject[] dataEntities, Map<Long, String> costStruDimensionIdMaps) {
        DynamicObjectCollection costSegStoreDyList = new DynamicObjectCollection();
        SWCDataServiceHelper costSegStoreHelper = new SWCDataServiceHelper("pcs_costsegstore");
        for (DynamicObject costCfgDy : dataEntities) {
            CostCfgHelper.fillCostSegmentInfo((String)"costCfg", (String)"1", (SWCDataServiceHelper)costSegStoreHelper, (DynamicObject)costCfgDy, costStruDimensionIdMaps, (DynamicObjectCollection)costSegStoreDyList);
        }
        if (!CollectionUtils.isEmpty((Collection)costSegStoreDyList)) {
            costSegStoreHelper.save(costSegStoreDyList);
        }
    }

    private void setNameAndNumber(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            String sourceNumber;
            String sourceName;
            String billName = dynamicObject.getDataEntityType().getName();
            if ("pcs_costempcfg".equals(billName)) {
                sourceName = dynamicObject.getString("source.person.name");
                sourceNumber = dynamicObject.getString("source.person.number");
            } else if ("pcs_costitemcfg".equals(billName)) {
                String qualityName = dynamicObject.getString("qualityname");
                String qualityNumber = dynamicObject.getString("qualitynumber");
                sourceName = SWCStringUtils.isEmpty((String)qualityName) ? dynamicObject.getString("source.name") : qualityName;
                sourceNumber = SWCStringUtils.isEmpty((String)qualityNumber) ? dynamicObject.getString("source.number") : qualityNumber;
            } else {
                sourceName = dynamicObject.getString("source.name");
                sourceNumber = dynamicObject.getString("source.number");
            }
            dynamicObject.set("name", (Object)sourceName);
            dynamicObject.set("number", (Object)sourceNumber);
        }
    }
}

