/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallocation;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costmap.service.CostItemMapService;

public class CostAllocationList
extends SWCDataBaseList {
    public void setFilter(SetFilterEvent args) {
        super.setFilter(args);
        args.setOrderBy("modifytime desc,createtime desc,caltask.number asc");
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "caltask.payrollgroup.id": 
            case "caltask.payrollgroup.name": 
            case "caltask.payrollscene.id": 
            case "caltask.payrollscene.name": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"47150e89000000ac");
                if (payRollCalSet == null) break;
                QFilter qFilter = new QFilter("org.id", "in", (Object)payRollCalSet);
                filters.add(qFilter);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "caltask.id": 
            case "caltask.name": 
            case "caltask.number": {
                QFilter taskFilter = CostAllocationHelper.getTaskFilter();
                filters.add(taskFilter);
                break;
            }
            case "costadapter.id": 
            case "costadapter.name": {
                CostItemMapService service = new CostItemMapService();
                service.addCostAdapterFilter(filters, "pcs_costallocation");
                break;
            }
            case "caltask.payrollgroup.id": 
            case "caltask.payrollgroup.name": 
            case "caltask.payrollscene.id": 
            case "caltask.payrollscene.name": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"47150e89000000ac");
                if (payRollCalSet == null) break;
                QFilter qFilter = new QFilter("org.id", "in", (Object)payRollCalSet);
                filters.add(qFilter);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (SWCStringUtils.equals((String)"caltask_name", (String)fieldName)) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Long costAllocationPkId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.clickNameHyperLink(costAllocationPkId);
            args.setCancel(true);
        } else if (SWCStringUtils.equals((String)"viewdetail", (String)fieldName)) {
            this.clickViewImageHyperLink();
            args.setCancel(true);
        }
    }

    private void clickNameHyperLink(Long costAllocationPkId) {
        IListView listView = (IListView)this.getView();
        DynamicObject calTaskObj = CostAllocationHelper.getCalTaskId((Long)costAllocationPkId);
        long calTaskId = calTaskObj.getLong("caltask.id");
        long hrOrgId = calTaskObj.getLong("hrorg.id");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u7ed3\u6784", (String)"CostAllocationList_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        showParameter.setBillFormId("pcs_costsetuprst");
        showParameter.setPageId(this.getView().getPageId() + costAllocationPkId);
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCustomParam("hrOrgId", (Object)hrOrgId);
        showParameter.setCustomParam("costAllocationPkId", (Object)costAllocationPkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clickViewImageHyperLink() {
        IListView listView = (IListView)this.getView();
        Long pkId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
        DynamicObject calTaskObj = CostAllocationHelper.getCalTaskId((Long)pkId);
        long calTaskId = calTaskObj.getLong("caltask.id");
        boolean checkIsDeleted = SWCShowFormServiceHelper.isExists((Object)calTaskId, (String)"hsas_calpayrolltask");
        if (!checkIsDeleted) {
            String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CostAllocationList_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorTips);
            return;
        }
        this.openCalPayRollTask(calTaskId);
    }

    private void openCalPayRollTask(long calTaskId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("hsas_calpayrolltask");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)calTaskId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
        if (!idConfirm) {
            switch (opKey) {
                case "generatecostallocation": {
                    long userId = RequestContext.get().getCurrUserId();
                    boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"1NG6ISYFC0SM");
                    if (!hasPerm) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostAllocationList_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    CostAllocationHelper.openCostGenerateScheme((IFormView)this.getView(), (String)((Object)((Object)this)).getClass().getName());
                    break;
                }
                case "generatecostrecord": {
                    this.openCostRecord("");
                    break;
                }
            }
        }
    }

    private void openCostRecord(String costAllocationRecordIds) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("pcs_costrecord");
        showParameter.setCustomParam("recordids", (Object)costAllocationRecordIds);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        QFilter qFilter = new QFilter("recordtype", "in", (Object)"0");
        listFilterParameter.setFilter(qFilter);
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actId) {
            case "pcs_costgeneratescheme": {
                if (returnData == null) {
                    return;
                }
                CostAllocationHelper.setCostInfoToCache((ClosedCallBackEvent)e, (IFormView)this.getView());
                this.dealGenerateScheme();
                break;
            }
            case "pcs_costallocationprog": {
                if (returnData instanceof Map) {
                    Map returnDataMap = (Map)returnData;
                    String operationKey = String.valueOf(returnDataMap.get("operationkey"));
                    if ("viewrecord".equals(operationKey)) {
                        String costAllocationRecordIds = String.valueOf(returnDataMap.get("costallocationrecordids"));
                        this.openCostRecord(costAllocationRecordIds);
                    } else if ("viewresult".equals(operationKey)) {
                        String costAllocationId = String.valueOf(returnDataMap.get("costallocationid"));
                        this.clickNameHyperLink(Long.valueOf(costAllocationId));
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void dealGenerateScheme() {
        IFormView view = this.getView();
        String calTaskFileRlsMapStr = view.getPageCache().get("calTaskFileRlsMap");
        Map calTaskFileRlsMap = (Map)JSON.parseObject((String)calTaskFileRlsMapStr, Map.class);
        HashMap<Long, Long> calTaskCostAdapterIdRlsMap = new HashMap<Long, Long>(16);
        Map calTaskAdaptionIdMap = CostCommonHelper.queryCostAdapterIdByCalTaskIds(calTaskFileRlsMap.keySet());
        for (Long calTaskId : calTaskFileRlsMap.keySet()) {
            Long costAdapterId = (Long)calTaskAdaptionIdMap.get(calTaskId);
            if (costAdapterId == null) {
                String message = ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u56e0\u4e3a\u201c\u6838\u7b97\u4efb\u52a1\u201d\u6240\u5c5e\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u6ca1\u6709\u5339\u914d\u7684\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3002", (String)"CostAllocationList_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return;
            }
            calTaskCostAdapterIdRlsMap.put(calTaskId, costAdapterId);
        }
        this.getView().getPageCache().put("calTaskCostAdapterIdRlsMap", JSON.toJSONString(calTaskCostAdapterIdRlsMap));
        CostAllocationHelper.preGenerateSetUp((IFormView)view, (String)((Object)((Object)this)).getClass().getName());
    }
}

