/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallocation;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;

public class CostAllocationRecordList
extends SWCDataBaseList {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("finishtime desc,createtime desc,recordnumber asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List fastFilterColumnsList = args.getFastFilterColumns();
        if (fastFilterColumnsList != null && !fastFilterColumnsList.isEmpty()) {
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            for (FilterColumn fastFilterColumn : fastFilterColumnsList) {
                String recordIdsStr;
                String fieldName = fastFilterColumn.getFieldName();
                if (!"recordnumber".equals(fieldName) || !SWCStringUtils.isNotEmpty((String)(recordIdsStr = (String)formShowParameter.getCustomParam("recordids")))) continue;
                Set recordIds = (Set)JSON.parseObject((String)recordIdsStr, Set.class);
                List<String> number = this.queryRecordNumberById(recordIds);
                fastFilterColumn.setDefaultValues(number.toArray());
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new CostAllocationRecordDataProviderImpl());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (SWCStringUtils.equals((String)"recordnumber", (String)fieldName)) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Long recordPkId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.clickNameHyperLink(recordPkId);
            args.setCancel(true);
        }
    }

    private void clickNameHyperLink(Long recordPkId) {
        IListView listView = (IListView)this.getView();
        Long pkId = Long.valueOf(String.valueOf(listView.getFocusRowPkId()));
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        DynamicObject costRecord = costRecordHelper.queryOne("id,recordtype", new QFilter[]{filter});
        if (SWCObjectUtils.isEmpty((Object)costRecord)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostAllocationRecordList_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("pcs_costrecord");
        if (costRecord.getString("recordtype").equals("1")) {
            parameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u8ba1\u7b97\u62a5\u544a", (String)"CostAllocationRecordList_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("page_from", (Object)"CostAllotTaskList");
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u5206\u644a\u7ed3\u6784\u8ba1\u7b97\u62a5\u544a", (String)"CostAllocationRecordList_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("page_from", (Object)"CostAllocationList");
        }
        parameter.setPkId((Object)costRecord.getLong("id"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private List<String> queryRecordNumberById(Set<Long> recordIds) {
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        QFilter filter = new QFilter("id", "in", recordIds);
        DynamicObject[] costRecordDy = costRecordHelper.query("id,recordnumber", new QFilter[]{filter});
        return costRecordDy == null ? new ArrayList<String>() : Arrays.stream(costRecordDy).map(dy -> dy.getString("recordnumber")).collect(Collectors.toList());
    }

    static class CostAllocationRecordDataProviderImpl
    extends ListDataProvider {
        CostAllocationRecordDataProviderImpl() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            DynamicSimpleProperty property = new DynamicSimpleProperty();
            property.setName("usetime");
            rows.getDynamicObjectType().addProperty((DynamicProperty)property);
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject object = (DynamicObject)rows.get(i);
                String useTime = CostAllocationHelper.getUseTime((Date)object.getDate("createtime"), (Date)object.getDate("finishtime"));
                object.set("usetime", (Object)useTime);
            }
            return rows;
        }
    }
}

