/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costallot.CostAllotDetailHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;

public class CostAdjustmentEdit
extends SWCDataBaseEdit
implements ClickListener {
    private static final Log LOGGER = LogFactory.getLog(CostAdjustmentEdit.class);
    private static final String KEY_ADJUSTMENTWAY = "adjustmentway";
    private static final String DONOTHING_SAVE = "donothing_save";
    private static final String DONOTHING_COSTEDIT = "donothing_costedit";
    private static final BigDecimal BIGDECIMAL_HUNDRED = new BigDecimal("100.00");
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_PERCENT = "percent";

    public void afterCreateNewData(EventObject e) {
        DynamicObject costAllotDetail = this.initData();
        this.setEntryVal(costAllotDetail);
        this.setAmountAndPercentDisplay();
        String allotBillStatus = costAllotDetail.getString("allotbillstatus");
        this.getView().setVisible(Boolean.valueOf("B".equals(allotBillStatus)), new String[]{"createallotbilll"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        BigDecimal assAmount = this.getModel().getDataEntity().getBigDecimal("assuamount");
        BigDecimal calAmount = this.getModel().getDataEntity().getBigDecimal("calamount");
        switch (propName) {
            case "adjustmentway": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u8c03\u6574\u65b9\u5f0f\uff0c\u8868\u683c\u4fe1\u606f\u5c06\u6062\u590d\u521d\u59cb\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\u3002", (String)"CostAdjustmentEdit_9", (String)"swc-pcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_ADJUSTMENTWAY));
                this.getView().getPageCache().put(propName, String.valueOf(changeData.getOldValue()));
                break;
            }
            case "amount": {
                BigDecimal amount = (BigDecimal)newValue;
                this.getModel().setValue("realassamount", (Object)amount);
                this.getModel().setValue("realcalamount", (Object)amount.divide(assAmount, 20, 4).multiply(calAmount));
                break;
            }
            case "percent": {
                int percentVal = (Integer)newValue;
                BigDecimal percentBigVal = new BigDecimal(percentVal);
                int amtPrecision = this.getView().getModel().getDataEntity().getInt("assucurrency.amtprecision");
                this.getModel().setValue("realassamount", (Object)assAmount.multiply(percentBigVal.divide(BIGDECIMAL_HUNDRED)).setScale(amtPrecision, 4));
                this.getModel().setValue("realcalamount", (Object)calAmount.multiply(percentBigVal.divide(BIGDECIMAL_HUNDRED)).setScale(amtPrecision, 4));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_save": {
                args.setCancel(this.validate());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_save": {
                this.save();
                break;
            }
            case "donothing_costedit": {
                this.edit();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "adjustmentway": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    DynamicObject costAllotDetail = this.getAllotDetail();
                    this.setEntryVal(costAllotDetail);
                    this.setAmountAndPercentDisplay();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(KEY_ADJUSTMENTWAY, (Object)this.getView().getPageCache().get(KEY_ADJUSTMENTWAY));
                this.getModel().endInit();
                this.getView().updateView(KEY_ADJUSTMENTWAY);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actId;
        switch (actId = closedCallBackEvent.getActionId()) {
            case "pcs_showdimension": {
                this.dealDimensionCallBack(closedCallBackEvent);
                break;
            }
        }
    }

    private DynamicObject initData() {
        DynamicObject costAllotDetail = this.getAllotDetail();
        Long salaryFileId = costAllotDetail.getLong("salaryfile.id");
        Long costAdapterId = costAllotDetail.getLong("costadapter.id");
        Long assCurrencyId = costAllotDetail.getLong("costadapter.currency.id");
        Long orgId = costAllotDetail.getLong("costadapter.org.id");
        Long createOrgId = costAllotDetail.getLong("costadapter.createorg.id");
        this.getModel().beginInit();
        this.getModel().setValue("allotdetail", this.getView().getFormShowParameter().getCustomParam("allotDetailId"));
        this.getModel().setValue("salaryfile", (Object)salaryFileId);
        this.getModel().setValue("costadapter", (Object)costAdapterId);
        this.getModel().setValue("assucurrency", (Object)assCurrencyId);
        this.getModel().setValue("org", (Object)(orgId == 0L ? createOrgId : orgId));
        this.getModel().endInit();
        this.getView().getPageCache().put("calcurrency", costAllotDetail.getString("calcur.id"));
        this.getView().getPageCache().put("assucurrency", String.valueOf(assCurrencyId));
        this.getView().getPageCache().put("costStructId", costAllotDetail.getString("costadapter.coststru.id"));
        this.getView().getPageCache().put("costAdapterId", costAdapterId.toString());
        this.getView().getPageCache().put("preAdjustmentTime", SWCDateTimeUtils.format((Date)new Date()));
        return costAllotDetail;
    }

    private boolean validate() {
        return this.checkPerm() || this.isAdjustment() || this.validateEntry();
    }

    private boolean checkPerm() {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"2C8K67=V=7H6");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostAdjustmentEdit_7", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"2C8K67=V=7H6");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            LOGGER.info("CostAdjustmentEdit checkPerm getPermOrgs :{}", (Object)hasPermOrgs);
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            if (!hasPermOrgs.contains(orgId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostAdjustmentEdit_7", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean validateEntry() {
        boolean isPercent;
        DynamicObjectCollection allotDetailPageEntry = this.getModel().getEntryEntity("allotdetailent");
        if (allotDetailPageEntry == null || allotDetailPageEntry.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6210\u672c\u8c03\u6574\u201d\u3002", (String)"CostAdjustmentEdit_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        BigDecimal sumPercent = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        String adjustmentWay = this.getModel().getDataEntity().getString(KEY_ADJUSTMENTWAY);
        boolean isShow = "1".equals(adjustmentWay);
        for (DynamicObject allotDetailEntObj : allotDetailPageEntry) {
            BigDecimal pageAmount = allotDetailEntObj.getBigDecimal(KEY_AMOUNT);
            BigDecimal pagePercent = allotDetailEntObj.getBigDecimal(KEY_PERCENT);
            sumAmount = sumAmount.add(pageAmount);
            sumPercent = sumPercent.add(pagePercent);
            String costSetUpConstVal = allotDetailEntObj.getString("costsetupconstval");
            if (SWCStringUtils.isEmpty((String)costSetUpConstVal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408\u503c\u201d\u3002", (String)"CostAdjustmentEdit_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!isShow && pageAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u91d1\u989d\u201d\u3002", (String)"CostAdjustmentEdit_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!isShow || sumPercent.compareTo(BigDecimal.ZERO) != 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u767e\u5206\u6bd4\u201d\u3002", (String)"CostAdjustmentEdit_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        BigDecimal assAmount = this.getModel().getDataEntity().getBigDecimal("assuamount");
        boolean flag = this.isNeedShowMessage(sumPercent, sumAmount, assAmount, isPercent = "1".equals(adjustmentWay));
        if (flag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u7684\u767e\u5206\u6bd4\u603b\u548c\u4e0d\u4e3a100%\uff0c\u6216\u91d1\u989d\u603b\u989d\u4e0d\u7b49\u4e8e\u539f\u59cb\u627f\u62c5\u91d1\u989d\u3002", (String)"CostAdjustmentEdit_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isNeedShowMessage(BigDecimal sumPercent, BigDecimal sumAmount, BigDecimal assAmount, boolean isPercent) {
        return isPercent && sumPercent.compareTo(BIGDECIMAL_HUNDRED) != 0 || !isPercent && sumAmount.compareTo(assAmount) != 0;
    }

    private boolean isAdjustment() {
        Long allotDetailId = (Long)this.getView().getFormShowParameter().getCustomParam("allotDetailId");
        DynamicObject allotDetail = CostAllotDetailHelper.queryCostAllotByPkId((Long)allotDetailId);
        boolean isAdjustment = allotDetail.getBoolean("isadjustment");
        Date modifyTime = allotDetail.getDate("modifytime");
        Date enterTime = null;
        try {
            enterTime = SWCDateTimeUtils.parseDate((String)this.getView().getPageCache().get("preAdjustmentTime"));
        }
        catch (ParseException e) {
            LOGGER.error("enterTime  exchange error...{}", (Object)e.getMessage());
        }
        if (isAdjustment && modifyTime != null && enterTime != null && modifyTime.after(enterTime)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u644a\u660e\u7ec6\u5df2\u88ab\u8c03\u6574\uff0c\u8bf7\u5173\u95ed\u8c03\u6574\u5f39\u7a97\u540e\u91cd\u8bd5\u3002", (String)"CostAdjustmentEdit_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void dealDimensionCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof Map) {
            Map map = (Map)returnData;
            JSONObject returnDataJson = new JSONObject(map);
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            String costSetUpConstVal = (String)pageCache.get("dimensionNameValCache", String.class);
            this.getModel().setValue("costsetupconstval", (Object)costSetUpConstVal);
            this.getModel().setValue("setupconstval", (Object)returnDataJson);
        }
    }

    private void save() {
        CostAllotDetailHelper.doSaveCostAdjustment((IFormView)this.getView());
        this.getView().getParentView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private void edit() {
        JSONObject paramJSONObject = new JSONObject();
        JSONObject setUpConstVal = JSONObject.parseObject((String)((String)this.getModel().getValue("setupconstval")));
        paramJSONObject.put("returnData", (Object)setUpConstVal);
        paramJSONObject.put("costStruId", (Object)Long.valueOf(this.getView().getPageCache().get("costStructId")));
        FormShowParameter parameter = CostCfgHelper.getDimensionFormShowParameter((JSONObject)paramJSONObject);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_showdimension"));
        this.getView().showForm(parameter);
    }

    private void setEntryVal(DynamicObject costAllotDetail) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("allotdetailent");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("costitem", new Object[0]);
        setter.addField("costsetupconstval", new Object[0]);
        setter.addField(KEY_AMOUNT, new Object[0]);
        setter.addField("realassamount", new Object[0]);
        setter.addField("realcalamount", new Object[0]);
        setter.addField("setupconstval", new Object[0]);
        DynamicObjectCollection allotDetailEnt = costAllotDetail.getDynamicObjectCollection("pcs_allotdetailentry");
        String costSetupConstVal = costAllotDetail.getString("costsetupconstval");
        BigDecimal totalAssAmount = BigDecimal.ZERO;
        BigDecimal totalCalAmount = BigDecimal.ZERO;
        Long costStructId = Long.valueOf(this.getView().getPageCache().get("costStructId"));
        Map costDimensionIdRefStorageSetNumberMap = CostAllotDetailHelper.getCostDimensionIdRefStorageSetNumberMap((long)costStructId);
        DynamicObject costSetUpConst = costAllotDetail.getDynamicObject("costsetupconst");
        if (costSetUpConst == null) {
            return;
        }
        JSONObject setUpConstJson = new JSONObject();
        costDimensionIdRefStorageSetNumberMap.forEach((costDimensionId, num) -> {
            String costSetUpConstVal = costSetUpConst.getString(String.join((CharSequence)"", "segment", num));
            setUpConstJson.put(costDimensionId.toString(), (Object)costSetUpConstVal);
        });
        for (DynamicObject allotDetailEntObj : allotDetailEnt) {
            Long costItemId = allotDetailEntObj.getLong("costitem.id");
            BigDecimal assAmount = allotDetailEntObj.getBigDecimal("assuamount");
            BigDecimal calAmount = allotDetailEntObj.getBigDecimal("calamount");
            BigDecimal realCalAmount = assAmount.divide(assAmount, 20, 4).multiply(calAmount);
            totalAssAmount = totalAssAmount.add(assAmount);
            totalCalAmount = totalCalAmount.add(calAmount);
            setter.addRow(new Object[]{costItemId, costSetupConstVal, assAmount, assAmount, realCalAmount, setUpConstJson.toString()});
        }
        model.batchCreateNewEntryRow("allotdetailent", setter);
        model.endInit();
        this.getView().updateView("allotdetailent");
        this.getModel().setValue("assuamount", (Object)totalAssAmount);
        this.getModel().setValue("calamount", (Object)totalCalAmount);
    }

    private DynamicObject getAllotDetail() {
        String queryProperties = "salaryfile,costadapter,costsetupconst,costsetupconstval,costitem,assuamount,calamount,allotbillstatus,calcur";
        Long allotDetailId = (Long)this.getView().getFormShowParameter().getCustomParam("allotDetailId");
        return CostAllotDetailHelper.queryCostAllotByPkId((String)queryProperties, (Long)allotDetailId);
    }

    private void setAmountAndPercentDisplay() {
        String adjustmentWay = this.getModel().getDataEntity().getString(KEY_ADJUSTMENTWAY);
        boolean isShow = "1".equals(adjustmentWay);
        this.getView().setVisible(Boolean.valueOf(!isShow), new String[]{KEY_AMOUNT});
        AmountEdit amountEdit = (AmountEdit)this.getControl(KEY_AMOUNT);
        amountEdit.setMustInput(!isShow);
        DecimalEdit percentEdit = (DecimalEdit)this.getControl(KEY_PERCENT);
        percentEdit.setMustInput(isShow);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{KEY_PERCENT});
    }
}

