/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostSplitHelper;
import kd.swc.pcs.business.costallot.service.CostBuildAllotBillService;
import kd.swc.pcs.business.costcfg.CostCfgHelper;

public class CostAllotBillCreatePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostAllotBillCreatePlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String CAL_TASK = "caltask";
    private static final String DATE_RANGE_FIELD = "daterangefield";
    private static final String CAL_TASK_ACCORD_ZERO = "0";
    private static final String CAL_TASK_ACCORD_ONE = "1";
    private static final String CAL_TASK_ACCORD_TWO = "2";
    private static final String CAL_TASK_ACCORD_THREE = "3";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String parentPageId = showParameter.getParentPageId();
        if (SWCStringUtils.isEmpty((String)parentPageId)) {
            e.setCancel(true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDateRangeFieldValue();
        this.getView().setVisible(Boolean.FALSE, new String[]{CAL_TASK, DATE_RANGE_FIELD});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit costAdaptionBaseEdit = (BasedataEdit)this.getView().getControl("costadaption");
        costAdaptionBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calTaskBaseEdit = (BasedataEdit)this.getView().getControl(CAL_TASK);
        calTaskBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (propertyName) {
            case "caltaskaccord": {
                this.isShowByCalTaskAccord(changeData[0]);
                break;
            }
            case "costadaption": {
                this.setSplitBillRuleByAdaption(changeData[0]);
                break;
            }
            case "org": {
                this.getView().getModel().setValue("costadaption", null);
                this.getView().getModel().setValue("splitbillrule", null);
                break;
            }
        }
    }

    private void setSplitBillRuleByAdaption(ChangeData changeData) {
        DynamicObject costAdaption = (DynamicObject)changeData.getNewValue();
        if (costAdaption == null) {
            return;
        }
        long costAdaptionId = costAdaption.getLong("id");
        DynamicObject splitBillRuleDy = CostSplitHelper.getSplitBillRuleByAdaptionId((long)costAdaptionId);
        if (splitBillRuleDy != null) {
            long splitBillRuleDyId = splitBillRuleDy.getLong("id");
            this.getView().getModel().setValue("splitbillrule", (Object)splitBillRuleDyId);
        } else {
            this.getView().getModel().setValue("splitbillrule", null);
        }
    }

    private void isShowByCalTaskAccord(ChangeData changeData) {
        String calTaskAccord;
        switch (calTaskAccord = (String)changeData.getNewValue()) {
            case "0": {
                this.getView().setVisible(Boolean.FALSE, new String[]{CAL_TASK});
                this.getView().setVisible(Boolean.FALSE, new String[]{DATE_RANGE_FIELD});
                break;
            }
            case "1": 
            case "2": {
                this.getView().setVisible(Boolean.FALSE, new String[]{CAL_TASK});
                this.getView().setVisible(Boolean.TRUE, new String[]{DATE_RANGE_FIELD});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.TRUE, new String[]{CAL_TASK});
                this.getView().setVisible(Boolean.FALSE, new String[]{DATE_RANGE_FIELD});
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clkKey;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (clkKey = control.getKey()) {
            case "btnok": {
                long userId = RequestContext.get().getCurrUserId();
                boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_allotbill", (String)"220CQT8O4HUV");
                if (!hasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostAllotBillCreatePlugin_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean ischanged = SWCPermissionServiceHelper.checkCancelDataRight((IFormView)this.getView());
                if (ischanged) {
                    return;
                }
                long hrOrgId = this.getView().getModel().getDataEntity().getLong("org.id");
                if (hrOrgId == 0L) {
                    String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostAllotBillCreatePlugin_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(errorMsg);
                    return;
                }
                long costAdaptionId = this.getView().getModel().getDataEntity().getLong("costadaption.id");
                if (costAdaptionId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3002", (String)"CostAllotBillCreatePlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                    return;
                }
                CostBuildAllotBillService costBuildAllotBillService = new CostBuildAllotBillService();
                Map<String, Object> result = this.packageValue(costAdaptionId);
                Map resultMap = costBuildAllotBillService.buildAllotBill(result);
                String errorMsg = (String)resultMap.get("errorMsg");
                if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                    this.getView().showErrorNotification(errorMsg);
                    break;
                }
                String message = ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"CostAllotBillCreatePlugin_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                this.getView().getParentView().showSuccessNotification(message);
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().close();
                break;
            }
        }
    }

    private Map<String, Object> packageValue(Long costAdaptionId) {
        String calTaskAccord = this.getView().getModel().getDataEntity().getString("caltaskaccord");
        Date startDate = null;
        Date endDate = null;
        if (!CAL_TASK_ACCORD_THREE.equals(calTaskAccord)) {
            DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl(DATE_RANGE_FIELD);
            String headDateStart = headFieldEdit.getStartDateFieldKey();
            String headDateEnd = headFieldEdit.getEndDateFieldKey();
            startDate = (Date)this.getView().getModel().getValue(headDateStart);
            endDate = (Date)this.getView().getModel().getValue(headDateEnd);
        }
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue(CAL_TASK);
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(rows.size());
        for (DynamicObject row : rows) {
            DynamicObject baseDataObj = row.getDynamicObject("fbasedataid");
            Long calTaskId = (Long)baseDataObj.getPkValue();
            calTaskIdList.add(calTaskId);
        }
        Long splitBillRuleId = this.getView().getModel().getDataEntity().getLong("splitbillrule.id");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("costadaptionid", costAdaptionId);
        map.put("splitbillruleid", splitBillRuleId);
        map.put("caltaskaccord", calTaskAccord);
        map.put("startdate", startDate);
        map.put("enddate", endDate);
        map.put("caltaskidlist", calTaskIdList);
        return map;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        long currUserId = RequestContext.get().getCurrUserId();
        switch (fieldKey = event.getProperty().getName()) {
            case "org": {
                HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)"pcs_allotbill", (String)"47150e89000000ac");
                if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
                    event.getFormShowParameter().setCustomParam("range", (Object)hasPermOrgResult.getHasPermOrgs());
                    logger.info("CostAllotBillCreatePlugin beforeF7Select :{}", (Object)hasPermOrgResult.getHasPermOrgs());
                }
                this.addBaseDataF7Filter(event, currUserId, "pcs_allotbill", "org");
                break;
            }
            case "caltask": {
                this.addFilter(event);
                break;
            }
            case "costadaption": {
                long hrOrgId = this.getView().getModel().getDataEntity().getLong("org.id");
                if (hrOrgId == 0L) {
                    String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostAllotBillCreatePlugin_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(errorMsg);
                    event.setCancel(true);
                    return;
                }
                CostCfgHelper.addCostAdaptionBaseDataBuFilter((BeforeF7SelectEvent)event, (String)"pcs_allotbill", (String)"costadapter", (long)hrOrgId);
                break;
            }
        }
        logger.info("CostAllotBillCreatePlugin beforeF7Select fieldKey:{},CustomFilters:{}", (Object)fieldKey, (Object)event.getCustomQFilters());
    }

    private void addBaseDataF7Filter(BeforeF7SelectEvent event, long currUserId, String pcsAllotbill, String key) {
        QFilter orgFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)pcsAllotbill, (String)key, (String)"47150e89000000ac");
        if (orgFilter != null) {
            event.addCustomQFilter(orgFilter);
        }
    }

    private void addFilter(BeforeF7SelectEvent event) {
        long costAdaptionId = this.getView().getModel().getDataEntity().getLong("costadaption.id");
        if (costAdaptionId == 0L) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3002", (String)"CostAllotBillCreatePlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        } else {
            long currUserId = RequestContext.get().getCurrUserId();
            this.addBaseDataF7Filter(event, currUserId, "pcs_allottask", CAL_TASK);
            long hrOrgId = this.getView().getModel().getDataEntity().getLong("org.id");
            List<Long> calTaskIdList = CostAllotBillCreatePlugin.queryCalTaskByAdapterAndOrgId(hrOrgId, costAdaptionId);
            event.addCustomQFilter(new QFilter("id", "in", calTaskIdList));
        }
    }

    private static List<Long> queryCalTaskByAdapterAndOrgId(long hrOrgId, long costAdaptionId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allottask");
        QFilter qFilter = new QFilter("hrorg.id", "=", (Object)hrOrgId);
        qFilter.and(new QFilter("costadapter.id", "=", (Object)costAdaptionId));
        DynamicObject[] allotTaskDys = serviceHelper.query("id,caltask", new QFilter[]{qFilter});
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(allotTaskDys.length);
        for (int i = 0; i < allotTaskDys.length; ++i) {
            calTaskIdList.add(allotTaskDys[i].getLong("caltask.id"));
        }
        return calTaskIdList;
    }

    private void initDateRangeFieldValue() {
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl(DATE_RANGE_FIELD);
        String headDateStart = headFieldEdit.getStartDateFieldKey();
        String headDateEnd = headFieldEdit.getEndDateFieldKey();
        Date minStartDate = this.getDate("1900-01-01");
        Date maxEndDate = this.getDate("2999-12-31");
        this.getModel().setValue(headDateStart, (Object)minStartDate);
        this.getModel().setValue(headDateEnd, (Object)maxEndDate);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("org", (Object)orgId);
    }

    private Date getDate(String dateStr) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            logger.error("SimpleDateFormat error");
        }
        return date;
    }
}

