/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.QRCode;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.util.SWCNumberGenerater;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costallotbill.helper.CostAllotBillHelper;
import kd.swc.pcs.business.costallotbill.service.CostAllotBillExportService;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostSetUpHelper;

public class CostAllotBillFieldControlEdit
extends SWCDataBaseEdit
implements HyperLinkClickListener {
    private static final String BAR_SAVE = "bar_save";
    private static final String FINANCING_STATUS = "financingstatus";
    private static final String FINANCING_IMG = "financingimg";
    private static final String FINANCING_LBL = "financinglbl";
    private static final String ACCOUNT_IMG = "accountimg";
    private static final String ACCOUNT_LBL = "accountlbl";
    private static final String DELETEVOUCHER = "deletevoucher";
    private static final String SUBMITVOUCHER = "submit";
    private static final String DESCRIPTION = "description";
    private static final String BAR_SUBMIT = "bar_submit";

    public void afterLoadData(EventObject e) {
        this.setDescriptionDisable();
        Date createTime = this.getModel().getDataEntity().getDate("createtime");
        if (createTime != null) {
            this.getModel().setValue("showcreatetime", (Object)createTime);
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeBindData(EventObject e) {
        boolean financeFlag = CostCfgHelper.isOpenFinance();
        if (financeFlag) {
            this.setStatusImgAndLabel();
            this.setVoucherStatus();
        }
        this.getView().setVisible(Boolean.valueOf(financeFlag), new String[]{"flexpanelap4", BAR_SUBMIT, "tracevoucher"});
        long currencyId = this.getView().getModel().getDataEntity().getLong("costadapter.currency.id");
        this.getView().getModel().setValue("assucurrency", (Object)currencyId);
        this.setBarCode();
        this.setAmtPrecision();
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"billno");
    }

    private void setAmtPrecision() {
        DynamicObject allotBillObj = this.getModel().getDataEntity();
        DynamicObjectCollection dynamicObjectColl = allotBillObj.getDynamicObjectCollection("entryentity");
        int assuCurPrecision = this.getModel().getDataEntity().getInt("costadapter.currency.amtprecision");
        BigDecimal amountSum = allotBillObj.getBigDecimal("amountsum");
        BigDecimal assuAmt = amountSum.setScale(assuCurPrecision, 4);
        allotBillObj.set("amountsum", (Object)assuAmt.toPlainString());
        for (DynamicObject dynamicObject : dynamicObjectColl) {
            BigDecimal assuAmount = dynamicObject.getBigDecimal("assuamount");
            BigDecimal assuAmountFormat = assuAmount.setScale(assuCurPrecision, 4);
            dynamicObject.set("assuamount", (Object)assuAmountFormat.toPlainString());
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("donothing_unsubmit".equals(opKey)) {
            String financingStatus = this.getView().getModel().getDataEntity().getString(FINANCING_STATUS);
            if ("A".equals(financingStatus)) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u914d\u5355\u672a\u63d0\u4ea4\u8d22\u52a1\uff0c\u65e0\u6cd5\u64a4\u9500\u3002", (String)"CostAllotBillFieldControlEdit_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                return;
            }
            int voucherCount = CostAllotBillHelper.queryVoucherCount((Long)this.getPkId());
            this.getView().invokeOperation("unaudit");
            if (voucherCount > 0) {
                args.setCancel(true);
                this.getView().invokeOperation(DELETEVOUCHER);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void openCostDimensionPage(long constId) {
        DynamicObject costSetUpConstObj = CostSetUpHelper.querySetUpConstObjById((Long)constId);
        if (costSetUpConstObj == null) {
            return;
        }
        Long costStruId = costSetUpConstObj.getLong("coststru.id");
        DynamicObject costStruObj = CostAllocationHelper.queryCostStruObjById((Long)costStruId);
        if (costStruObj == null) {
            return;
        }
        DynamicObjectCollection dimensionEntry = costStruObj.getDynamicObjectCollection("dimensionentry");
        HashMap dimensionRefSegmentIndexMap = new HashMap(dimensionEntry.size());
        dimensionEntry.forEach(entry -> dimensionRefSegmentIndexMap.put(entry.getString("costdimension.id"), entry.getString("storageset.number")));
        HashMap dimensionValMap = new HashMap(dimensionEntry.size());
        for (Map.Entry entry2 : dimensionRefSegmentIndexMap.entrySet()) {
            dimensionValMap.put(entry2.getKey(), CostSetUpHelper.getIdVal((String)costSetUpConstObj.getString("segment" + (String)entry2.getValue())));
        }
        JSONObject paramJSONObject = new JSONObject();
        paramJSONObject.put("returnData", dimensionValMap);
        paramJSONObject.put("costStruId", (Object)costStruId);
        paramJSONObject.put("isShow", (Object)Boolean.TRUE);
        FormShowParameter parameter = CostCfgHelper.getDimensionFormShowParameter((JSONObject)paramJSONObject);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_showdimension"));
        this.getView().showForm(parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currentRowIndex);
        switch (fieldName) {
            case "costsetupconstval": {
                long costSetUpConstId = dynamicObject.getLong("costsetupconst.id");
                this.openCostDimensionPage(costSetUpConstId);
                break;
            }
        }
    }

    private void setDescriptionDisable() {
        IDataModel dataModel = this.getModel();
        String financingStatus = (String)dataModel.getValue(FINANCING_STATUS);
        if ("A".equals(financingStatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{DESCRIPTION});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_SUBMIT});
            this.getView().setEnable(Boolean.FALSE, new String[]{DELETEVOUCHER});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_SAVE});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{DESCRIPTION});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SUBMIT});
            this.getView().setEnable(Boolean.TRUE, new String[]{DELETEVOUCHER});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE});
        }
    }

    private void setBarCode() {
        String barCode = (String)this.getModel().getValue("barcode");
        if (SWCStringUtils.isEmpty((String)barCode)) {
            barCode = SWCNumberGenerater.getInstance().generaterNextNumber(new Date(), "FTFP");
        }
        QRCode qrCode = (QRCode)this.getView().getControl("qrcodeap");
        qrCode.setUrl(barCode);
    }

    private void setStatusImgAndLabel() {
        IDataModel dataModel = this.getModel();
        String financingStatus = (String)dataModel.getValue(FINANCING_STATUS);
        this.setStatusImg(financingStatus);
    }

    private void setVoucherStatus() {
        Long fid = this.getPkId();
        ArrayList<Long> idList = new ArrayList<Long>(1);
        idList.add(fid);
        Map voucherStatusMap = CostAllotBillHelper.getVoucherStatus(idList);
        String voucherStatus = "";
        if (voucherStatusMap != null && !voucherStatusMap.isEmpty()) {
            voucherStatus = (String)voucherStatusMap.get(String.valueOf(fid));
        }
        this.setVoucherWithStatus(voucherStatus);
    }

    private void setVoucherWithStatus(String statusValue) {
        if (SWCStringUtils.isEmpty((String)statusValue)) {
            statusValue = "";
        }
        switch (statusValue) {
            case "E": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap2", "submitlabelap3", "submitlabelap4", "submitlabelap5", "submitlabelap6"});
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap1", "submitlabelap3", "submitlabelap4", "submitlabelap5", "submitlabelap6"});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap1", "submitlabelap2", "submitlabelap4", "submitlabelap5", "submitlabelap6"});
                break;
            }
            case "A": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap5"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap1", "submitlabelap2", "submitlabelap3", "submitlabelap4", "submitlabelap6"});
                break;
            }
            case "D": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap6"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap1", "submitlabelap2", "submitlabelap3", "submitlabelap4", "submitlabelap5"});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap4"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap1", "submitlabelap2", "submitlabelap3", "submitlabelap5", "submitlabelap6"});
            }
        }
    }

    private Long getPkId() {
        IDataModel model = this.getView().getModel();
        return (Long)model.getValue("id");
    }

    private String getBillNo() {
        IDataModel model = this.getView().getModel();
        return (String)model.getValue("billno");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        switch (opKey = formOperate.getOperateKey()) {
            case "deletevoucher": {
                List pkIds = operationResult.getSuccessPkIds();
                if (pkIds == null || pkIds.size() <= 0) break;
                this.getView().invokeOperation("unaudit");
                CostAllotBillHelper.updateFinancingStatus((Long)this.getPkId());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_unsubmit": {
                CostAllotBillHelper.updateFinancingStatus((Long)this.getPkId());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submit": {
                this.getView().invokeOperation("audit");
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_checkallotdetail": {
                String billNo = this.getBillNo();
                CostAllotBillHelper.showAllotDetailList(Collections.singletonList(billNo), (IFormView)this.getView());
                break;
            }
            case "donothing_export": {
                CostAllotBillExportService costAllotBillExportService = new CostAllotBillExportService();
                costAllotBillExportService.exportOneBill(this.getView());
                break;
            }
            case "audit": 
            case "unaudit": {
                OperationResult result = args.getOperationResult();
                result.setShowMessage(false);
                break;
            }
        }
    }

    private void setStatusImg(String statusValue) {
        if (null != statusValue) {
            switch (statusValue) {
                case "A": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"nosubmitlabelap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"submitlabelap"});
                    break;
                }
                case "B": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"submitlabelap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nosubmitlabelap"});
                    break;
                }
            }
        }
    }
}

