/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCAdminOrgPermList;
import kd.swc.pcs.business.costallot.CostAllotDetailHelper;
import kd.swc.pcs.business.costallotbill.helper.CostAllotBillHelper;
import kd.swc.pcs.business.costallotbill.service.CostAllotBillExportService;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costmap.service.CostItemMapService;
import kd.swc.pcs.formplugin.web.costallot.CostAllotBillProvider;

public class CostAllotBillList
extends SWCAdminOrgPermList {
    private static final Log LOGGER = LogFactory.getLog(CostAllotBillList.class);

    public void setFilter(SetFilterEvent args) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)"pcs_allotbill", (String)"47150e89000000ac");
        if (permOrgs != null) {
            if (permOrgs.hasAllOrgPerm()) {
                LOGGER.info("CostAllotBillList hava all org perm ");
                return;
            }
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            QFilter qFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            if (hasPermOrgs != null) {
                LOGGER.info("CostAllotBillList hava org perm:{}", (Object)SerializationUtils.toJsonString((Object)hasPermOrgs));
            }
            args.getQFilters().add(qFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        CostItemMapService service = new CostItemMapService();
        switch (fieldName) {
            case "costadapter.id": 
            case "costadapter.name": {
                service.addCostAdapterFilter(filters, "pcs_allotbill");
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CostAllotBillProvider());
    }

    public void beforeBindData(EventObject e) {
        boolean financeFlag = CostCfgHelper.isOpenFinance();
        this.getView().setVisible(Boolean.valueOf(financeFlag), new String[]{"submit"});
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        boolean financeFlag = CostCfgHelper.isOpenFinance();
        if (!financeFlag) {
            List cols = args.getListColumns();
            cols.removeIf(col -> SWCStringUtils.equals((String)"financingstatus", (String)col.getListFieldKey()) || SWCStringUtils.equals((String)"finaccountstatus", (String)col.getListFieldKey()));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DataEntityPropertyCollection properties = e.getRowData().getDataEntityType().getProperties();
        if (properties == null) {
            return;
        }
        int assuCurPrecision = 2;
        if (properties.containsKey((Object)"costadapter")) {
            assuCurPrecision = e.getRowData().getInt("costadapter.currency.amtprecision");
        }
        CostAllotDetailHelper.setGridScaleField((PackageDataEvent)e, (String)"amountsum", (String)"costadapter.currency", (int)assuCurPrecision);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "submit": {
                OperationResult opResult = args.getOperationResult();
                List successPkIds = opResult.getSuccessPkIds();
                OperationServiceHelper.executeOperate((String)"audit", (String)this.getEntityId(), (Object[])successPkIds.toArray(), null);
                break;
            }
            case "audit": 
            case "unaudit": {
                LOGGER.info("afterDoOperation GO IN UNAUDIT");
                OperationResult result = args.getOperationResult();
                result.setShowMessage(false);
                break;
            }
            case "donothing_checkallotdetail": {
                List<String> billNoList = this.getBillNoList();
                CostAllotBillHelper.showAllotDetailList(billNoList, (IFormView)this.getView());
                break;
            }
            case "deletevoucher": {
                LOGGER.info("afterDoOperation GO IN DELETEVOUCHER");
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("unaudit");
                this.delVoucher(args);
                break;
            }
            case "donothing_unsubmit": {
                LOGGER.info("afterDoOperation GO IN DONOTHING_UNSUBMIT");
                this.getView().invokeOperation("unaudit");
                this.unSubmitAllotBill(args);
                break;
            }
            case "donothing_export": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null) {
                    return;
                }
                CostAllotBillExportService costAllotBillExportService = new CostAllotBillExportService();
                costAllotBillExportService.doExport(this.getView());
                break;
            }
            case "refresh": {
                this.getView().updateView();
                break;
            }
        }
    }

    protected String getEntityId() {
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        return listParameter.getBillFormId();
    }

    private void unSubmitAllotBill(AfterDoOperationEventArgs args) {
        OperationResult unSubmitOperateResult = args.getOperationResult();
        List unSubmitSuccessPkIds = unSubmitOperateResult.getSuccessPkIds();
        CostAllotBillHelper.updateFinancingStatus((List)unSubmitSuccessPkIds);
        this.getView().invokeOperation("refresh");
    }

    private void delVoucher(AfterDoOperationEventArgs args) {
        List<Long> entryPkList = this.getEntrySelectRowIds();
        Map<String, String> billNoRelMap = this.getBillNoRel();
        Map voucherIdMap = CostAllotBillHelper.getVoucherIdRefAllotIdMap(entryPkList, (IFormView)this.getView());
        LOGGER.info("delVoucher voucherIdMap:{}", (Object)voucherIdMap);
        entryPkList.removeAll(voucherIdMap.values());
        LOGGER.info("delVoucher entryPkList1:{}", entryPkList);
        List unSubmitFinancePkIdList = CostAllotBillHelper.getUnSubmitFinancePkIds(entryPkList);
        entryPkList.removeAll(unSubmitFinancePkIdList);
        int errorMsgListSize = unSubmitFinancePkIdList.size() * 4 / 3;
        ArrayList errorMsgList = Lists.newArrayListWithExpectedSize((int)errorMsgListSize);
        for (Long unSubmitFinancePkId : unSubmitFinancePkIdList) {
            String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u5206\u914d\u5355\u672a\u63d0\u4ea4\u8d22\u52a1\uff0c\u4e0d\u80fd\u64a4\u9500\u3002", (String)"CostAllotBillList_7", (String)"swc-pcs-formplugin", (Object[])new Object[]{billNoRelMap.get(String.valueOf(unSubmitFinancePkId))});
            errorMsgList.add(errorMsg);
        }
        OperationResult delVoucherOperateResult = args.getOperationResult();
        List delVoucherSuccessPkIds = delVoucherOperateResult.getSuccessPkIds();
        LOGGER.info("delVoucher delVoucherOperateResult delVoucherSuccessPkIds:{}", (Object)delVoucherSuccessPkIds);
        if (delVoucherSuccessPkIds.size() > 0) {
            ArrayList<Long> allotBillPkIds = new ArrayList<Long>(delVoucherSuccessPkIds.size());
            for (Object obj : delVoucherSuccessPkIds) {
                allotBillPkIds.add(Long.valueOf(String.valueOf(obj)));
            }
            entryPkList.addAll(allotBillPkIds);
            LOGGER.info("delVoucher entryPkList2:{}", entryPkList);
        }
        this.packageErrorMsgList(billNoRelMap, voucherIdMap, errorMsgList, delVoucherOperateResult);
        delVoucherOperateResult.setShowMessage(false);
        CostAllotBillHelper.updateFinancingStatus(entryPkList);
        CostAllotBillHelper.clearVoucherIdMap((IFormView)this.getView());
        int errorSize = errorMsgList.size();
        int successSize = entryPkList.size();
        int total = successSize + errorSize;
        if (errorSize > 0) {
            if (total == 1) {
                this.getView().showErrorNotification((String)errorMsgList.get(0));
            } else {
                String message = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"CostAllotBillList_1", (String)"swc-pcs-formplugin", (Object[])new Object[]{total, successSize, errorSize});
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u64a4\u9500", (String)"CostAllotBillList_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]), (String)message, (List)errorMsgList);
                this.getView().showForm(parameters);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void packageErrorMsgList(Map<String, String> billNoRelMap, Map<String, Long> voucherIdMap, List<String> errorMsgList, OperationResult delVoucherOperateResult) {
        List validateErrors = delVoucherOperateResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List errorInfoList = validateResult.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : errorInfoList) {
                String errorMsg = errorInfo.getMessage();
                String voucherId = String.valueOf(errorInfo.getPkValue());
                Long allotBillId = voucherIdMap.get(voucherId);
                String allotBillNo = billNoRelMap.get(String.valueOf(allotBillId));
                if (StringUtils.isNotEmpty((String)allotBillNo)) {
                    errorMsgList.add(String.format(Locale.ROOT, "%s\uff1a", allotBillNo) + errorMsg);
                    continue;
                }
                errorMsgList.add(errorMsg);
            }
        }
    }

    private List<String> getBillNoList() {
        ArrayList<String> billNoList = new ArrayList<String>();
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            billNoList.add(selectedRow.getBillNo());
        }
        return billNoList;
    }

    private List<Long> getEntrySelectRowIds() {
        ArrayList<Long> entryPkList = new ArrayList<Long>();
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRowColl = view.getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRowColl) {
            entryPkList.add(Long.valueOf(String.valueOf(selectedRow.getPrimaryKeyValue())));
        }
        return entryPkList;
    }

    private Map<String, String> getBillNoRel() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRowColl = view.getSelectedRows();
        HashMap<String, String> billNoRelMap = new HashMap<String, String>(selectedRowColl.size());
        for (ListSelectedRow selectedRow : selectedRowColl) {
            billNoRelMap.put(String.valueOf(selectedRow.getPrimaryKeyValue()), String.valueOf(selectedRow.getBillNo()));
        }
        return billNoRelMap;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter formShowParameter;
        super.filterContainerInit(args);
        List commonFilterColumnsList = args.getCommonFilterColumns();
        boolean financeFlag = CostCfgHelper.isOpenFinance();
        if (!financeFlag) {
            commonFilterColumnsList.removeIf(col -> SWCStringUtils.equals((String)"financingstatus", (String)col.getFieldName()) || SWCStringUtils.equals((String)"finaccountstatus", (String)col.getFieldName()));
            List schemeFilterColumns = args.getSchemeFilterColumns();
            schemeFilterColumns.removeIf(col -> SWCStringUtils.equals((String)"financingstatus", (String)col.getFieldName()) || SWCStringUtils.equals((String)"finaccountstatus", (String)col.getFieldName()));
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String flag = (String)pageCache.get("flag", String.class);
        for (FilterColumn commonFilterColumn : commonFilterColumnsList) {
            String fieldName = commonFilterColumn.getFieldName();
            String value = (String)pageCache.get(fieldName, String.class);
            if (value != null && !value.isEmpty()) {
                commonFilterColumn.setDefaultValues(new Object[]{value});
            }
            if (!"org.name".equals(fieldName) || !StringUtils.isEmpty((String)value) || !StringUtils.isNotEmpty((String)flag)) continue;
            commonFilterColumn.setDefaultValues(new Object[]{""});
        }
        List fastFilterColumnsList = args.getFastFilterColumns();
        if (fastFilterColumnsList != null && !fastFilterColumnsList.isEmpty()) {
            formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            for (FilterColumn fastFilterColumn : fastFilterColumnsList) {
                List allotBillNoList;
                String fieldName = fastFilterColumn.getFieldName();
                if (!"billno".equals(fieldName) || (allotBillNoList = (List)formShowParameter.getCustomParam("allotBillNo")) == null || allotBillNoList.isEmpty()) continue;
                fastFilterColumn.setDefaultValues(allotBillNoList);
            }
        }
        formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        commonFilterColumnsList.forEach(filterColumn -> {
            List allotorgList;
            String fieldName = filterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"org.name") && (allotorgList = (List)formShowParameter.getCustomParam("orgidList")) != null && !allotorgList.isEmpty()) {
                filterColumn.setDefaultValues(allotorgList);
            }
        });
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (!CollectionUtils.isEmpty((Map)currentCommonFilter)) {
            String fieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
            if ("org.id".equals(fieldName)) {
                fieldName = "org.name";
            }
            if ("costadapter.id".equals(fieldName)) {
                fieldName = "costadapter.name";
            }
            String value = (String)((List)currentCommonFilter.get("Value")).get(0);
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(fieldName, (Object)value);
            pageCache.put("flag", (Object)"true");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "donothing_unsubmit": {
                List<Long> entryPkList = this.getEntrySelectRowIds();
                CostAllotBillHelper.clearVoucherIdMap((IFormView)this.getView());
                Map allotIdRefVoucherIdMap = CostAllotBillHelper.getVoucherIdRefAllotIdMap(entryPkList, (IFormView)this.getView());
                if (allotIdRefVoucherIdMap.isEmpty()) break;
                args.setCancel(true);
                this.getView().invokeOperation("deletevoucher");
                break;
            }
            case "donothing_createallotbill": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("pcs_allotbillcreate");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "pcs_allotbillcreate");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }
}

