/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostAllotDetailHelper;
import kd.swc.pcs.business.costcommon.CostProgressCommonHelper;
import org.apache.commons.lang3.StringUtils;

public class CostAllotDetailProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String COST_ALLOT_DETAIL_PROGRESS_FLEX = "costallocationprogress";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"btn_min", "btn_termination", "btn_viewresult", "btn_viewrecord"});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(COST_ALLOT_DETAIL_PROGRESS_FLEX);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject event) {
        ProgressBar progressBar = (ProgressBar)this.getControl(COST_ALLOT_DETAIL_PROGRESS_FLEX);
        progressBar.start();
        CostProgressCommonHelper.setShowProgressInfo((String)"cache_costallotdetail_key_%s", (String)COST_ALLOT_DETAIL_PROGRESS_FLEX, (IFormView)this.getView());
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)COST_ALLOT_DETAIL_PROGRESS_FLEX)) {
            String message = ResManager.loadKDString((String)"\u751f\u6210\u6210\u672c\u5206\u644a\u660e\u7ec6", (String)"CostAllotDetailProgressPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            CostProgressCommonHelper.setCostProgressDetail((String)"cache_costallotdetail_key_%s", (String)message, (ProgressEvent)progressEvent, (IFormView)this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_giveup": {
                this.terminationCostAllotDetail();
                break;
            }
            case "viewrecord": {
                this.viewCostAllotDetailRecord(operateKey);
                break;
            }
            case "viewresult": {
                this.viewCostAllotDetailResult(operateKey);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData;
        String calTaskIds = (String)this.getView().getFormShowParameter().getCustomParam("caltaskids");
        CostAllocationProgressInfo progress = CostProgressCommonHelper.getProgress((String)"cache_costallotdetail_key_%s", (IFormView)this.getView());
        if (progress != null) {
            this.openProgressBall(calTaskIds, progress);
        }
        if ((returnData = this.getView().getReturnData()) != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private void openProgressBall(String calTaskIds, CostAllocationProgressInfo progress) {
        int status;
        IFormView mainView = this.getView().getMainView();
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (SWCStringUtils.isNotEmpty((String)taskId)) {
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(mainView, taskId);
        }
        if ((status = progress.getStatus()) == 2) {
            CostProgressCommonHelper.refreshParentView((IFormView)this.getView());
        } else {
            String operaKey;
            Object schTaskIdObj = this.getView().getFormShowParameter().getCustomParam("sch_taskid");
            if (SWCObjectUtils.isEmpty((Object)schTaskIdObj) && SWCStringUtils.isEmpty((String)(operaKey = this.getView().getPageCache().get("btn_termination")))) {
                CostAllotDetailHelper.openProgressBallByCalTaskId((IFormView)this.getView(), (String)calTaskIds);
            }
        }
    }

    private void viewCostAllotDetailResult(String operateKey) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"47150e89000000ac");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6210\u672c\u5206\u644a\u660e\u7ec6\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostAllotDetailProgressPlugin_7", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map calTaskId = (Map)this.getView().getFormShowParameter().getCustomParam("taskOfRecordId");
        List taskIds = calTaskId.values().stream().map(ele -> (Long)ObjectConverter.convert((Object)ele, Long.class, (boolean)true)).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("caltask", "in", taskIds);
        SWCDataServiceHelper allotTaskHelper = new SWCDataServiceHelper("pcs_allottask");
        DynamicObject[] allotTasks = allotTaskHelper.query("id", new QFilter[]{taskFilter});
        List costAllotDetailIds = Arrays.stream(allotTasks).map(ele -> ele.getLong("id")).collect(Collectors.toList());
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        returnData.put("costAllotDetailId", costAllotDetailIds);
        returnData.put("operationkey", operateKey);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    private void viewCostAllotDetailRecord(String operateKey) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"220JN+6Q4R=I");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostAllotDetailProgressPlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map calTaskId = (Map)this.getView().getFormShowParameter().getCustomParam("taskOfRecordId");
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        if (CollectionUtils.isEmpty((Map)calTaskId)) {
            returnData.put("costallotdetailrecordids", Lists.newArrayList());
        } else {
            List costAllotDetailIds = calTaskId.keySet().stream().map(ele -> (Long)ObjectConverter.convert((Object)ele, Long.class, (boolean)true)).collect(Collectors.toList());
            returnData.put("costallotdetailrecordids", costAllotDetailIds);
        }
        returnData.put("operationkey", operateKey);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    private void terminationCostAllotDetail() {
        Map taskOfRecordId = (Map)this.getView().getFormShowParameter().getCustomParam("taskOfRecordId");
        for (Map.Entry entry : taskOfRecordId.entrySet()) {
            int failCount;
            int finishCount;
            String costAllotDetailRecordId = String.valueOf(entry.getKey());
            String calTaskId = String.valueOf(entry.getValue());
            CostAllocationProgressInfo progress = (CostAllocationProgressInfo)SWCAppCache.get((String)"pcs").get(String.format(Locale.ROOT, "cache_costallotdetail_key_%s", calTaskId), CostAllocationProgressInfo.class);
            if (progress == null) continue;
            int status = progress.getStatus();
            if (status == 2) {
                return;
            }
            int total = progress.getTotal();
            if (total == (finishCount = progress.getFinish()) + (failCount = progress.getFail())) {
                return;
            }
            this.terminationGenerateCostUp(Long.valueOf(calTaskId), Long.valueOf(costAllotDetailRecordId));
            String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
            if (SWCStringUtils.isNotEmpty((String)taskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(taskId, "ABORTED");
            }
            this.getView().getPageCache().put("btn_termination", "1");
            CostProgressCommonHelper.refreshParentView((IFormView)this.getView());
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_close"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_min", "btn_termination", "btn_viewresult", "btn_viewrecord"});
            ProgressBar progressBar = (ProgressBar)this.getControl(COST_ALLOT_DETAIL_PROGRESS_FLEX);
            progressBar.stop();
            CostProgressCommonHelper.updateTerminationContent((IFormView)this.getView());
            CostProgressCommonHelper.updateTerminationImage((IFormView)this.getView());
        }
    }

    private void terminationGenerateCostUp(Long calTaskId, Long costAllotDetailRecordId) {
        List<Long> pkIds = Collections.singletonList(calTaskId);
        CostAllotDetailHelper.deleteAllotTaskAndDetail(pkIds);
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        costRecordHelper.deleteOne((Object)costAllotDetailRecordId);
        IAppCache appCache = AppCache.get((String)"pcs");
        appCache.put(String.format(Locale.ROOT, "isdetailtermination_%s", calTaskId), (Object)"true");
    }
}

