/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costallot.CostSplitHelper;

public class CostSplitBillRuleEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_COST_DIMENSION_MUL = "costdimensionmul";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAdapterBaseEdit = (BasedataEdit)this.getView().getControl("costadapter");
        costAdapterBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costDimensionMulBaseEdit = (BasedataEdit)this.getView().getControl(KEY_COST_DIMENSION_MUL);
        costDimensionMulBaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "costadapter": {
                this.addAdapterFilter(event);
                break;
            }
            case "costdimensionmul": {
                this.addDimensionFilter(event);
                break;
            }
        }
    }

    private void addAdapterFilter(BeforeF7SelectEvent event) {
        CostSplitHelper costSplitHelper = new CostSplitHelper();
        List existCostAdapterList = costSplitHelper.getExistCostAdapterList();
        long costAdapterId = this.getModel().getDataEntity().getLong("costadapter.id");
        if (costAdapterId != 0L) {
            existCostAdapterList.add(costAdapterId);
        }
        QFilter orgFilter = new QFilter("id", "not in", (Object)existCostAdapterList);
        event.addCustomQFilter(orgFilter);
    }

    private void addDimensionFilter(BeforeF7SelectEvent event) {
        CostSplitHelper costSplitHelper = new CostSplitHelper();
        long costAdapterId = this.getModel().getDataEntity().getLong("costadapter.id");
        if (costAdapterId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3002", (String)"CostSplitBillRuleEdit_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        long costStruId = this.getModel().getDataEntity().getLong("costadapter.coststru.id");
        List costDimensionList = costSplitHelper.getCostDimensionByCostStruId(costStruId);
        QFilter orgFilter = new QFilter("id", "in", (Object)costDimensionList);
        event.addCustomQFilter(orgFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("costadapter".equals(propertyName)) {
            this.getView().getModel().setValue(KEY_COST_DIMENSION_MUL, null);
        } else if ("org".equals(propertyName)) {
            this.getView().getModel().setValue("costadapter", null);
            this.getView().getModel().setValue(KEY_COST_DIMENSION_MUL, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("org", (Object)orgId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("audit".equals(operateKey)) {
            this.getView().getModel().setValue("isaudit", (Object)1);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("unaudit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "costadapter"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isAudit = this.getView().getModel().getDataEntity().getBoolean("isaudit");
        if (isAudit) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "costadapter"});
        }
    }
}

