/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;

public class CostCfgAddPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostCfgAddPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final List<String> COST_CFG_ADD_MARK_LIST = Arrays.asList("org", "costadaption", "salaryitem", "salaryfile", "person", "adminorg", "position", "payrollgrp", "job");
    private static final Map<String, List<String>> COST_CFG_ADD_SHOWMAP = Maps.newHashMapWithExpectedSize((int)16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        for (String key : COST_CFG_ADD_MARK_LIST) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String parentBillFormId = this.getParentBillFormId();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)parentBillFormId, (String)"47150e89000000ac");
        long orgId = 0L;
        if (hasPermOrgResult != null) {
            if (hasPermOrgResult.hasAllOrgPerm()) {
                orgId = RequestContext.get().getOrgId();
            } else {
                List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
                if (!CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
                    orgId = (Long)hasPermOrgResult.getHasPermOrgs().get(0);
                }
            }
        }
        this.getModel().setValue("org", (Object)orgId);
    }

    public void initialize() {
        String parentBillFormId = this.getParentBillFormId();
        if ("pcs_costsalaryfilecfg".equals(parentBillFormId) || "pcs_costsalaryitemcfg".equals(parentBillFormId)) {
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)parentBillFormId);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().cacheFormShowParameter();
        } else if ("pcs_costdeptcfg".equals(parentBillFormId)) {
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)parentBillFormId);
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"source");
        }
    }

    public void beforeBindData(EventObject e) {
        String parentBillFormId = this.getParentBillFormId();
        List<String> costCfgShowList = COST_CFG_ADD_SHOWMAP.get(parentBillFormId);
        for (String key : COST_CFG_ADD_MARK_LIST) {
            BasedataEdit basedataEdit;
            if (!SWCListUtils.isEmpty(costCfgShowList) && costCfgShowList.contains(key)) {
                basedataEdit = (BasedataEdit)this.getView().getControl(key);
                this.getView().setVisible(Boolean.TRUE, new String[]{key});
                basedataEdit.setMustInput(true);
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            basedataEdit = (BasedataEdit)this.getView().getControl(key);
            basedataEdit.setMustInput(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        String parentBillFormId = this.getParentBillFormId();
        if (SWCStringUtils.isEmpty((String)parentBillFormId)) {
            return;
        }
        switch (fieldKey = event.getProperty().getName()) {
            case "org": {
                HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)parentBillFormId, (String)"47150e89000000ac");
                if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
                    event.getFormShowParameter().setCustomParam("range", (Object)hasPermOrgResult.getHasPermOrgs());
                    logger.info("CostCfgAddPlugin beforeF7Select :{}", (Object)hasPermOrgResult.getHasPermOrgs());
                }
                this.addBaseDataF7Filter(event, parentBillFormId, "createorg");
                break;
            }
            case "costadaption": {
                this.addCostAdaptionFilter(event, parentBillFormId);
                break;
            }
            case "adminorg": {
                this.setCustomFilter(event);
                this.addCountryFilter(event, "companyarea.id");
                this.addBaseDataF7Filter(event, parentBillFormId, "source");
                break;
            }
            case "position": {
                this.setCustomFilter(event);
                this.addCountryFilter(event, "countryregion.id");
                this.addBaseDataF7Filter(event, parentBillFormId, "source");
                break;
            }
            case "person": {
                this.setCustomFilter(event);
                this.addBaseDataF7Filter(event, parentBillFormId, "source");
                this.addBaseDataF7Filter(event, parentBillFormId, "employee");
                break;
            }
            case "job": {
                this.setCustomFilter(event);
                this.addBaseDataF7Filter(event, parentBillFormId, "source");
                break;
            }
            case "salaryitem": {
                this.setCustomFilter(event);
                this.addCountryFilter(event, "country.id");
                this.addExistSalaryFileItemQFilter(event, parentBillFormId);
                event.addCustomQFilter(new QFilter("datatype.id", "=", (Object)1020L));
                this.addSalaryItemBaseDataBuFilter(event, parentBillFormId, "source");
                break;
            }
            case "salaryfile": {
                this.setCustomFilter(event);
                this.addCountryFilter(event, "payrollregion.id");
                if ("pcs_costsalaryfilecfg".equals(parentBillFormId)) {
                    this.addBaseDataF7Filter(event, parentBillFormId, "source");
                    break;
                }
                this.addBaseDataF7Filter(event, parentBillFormId, "creatorobj");
                break;
            }
            case "payrollgrp": {
                this.setCustomFilter(event);
                this.addCountryFilter(event, "country.id");
                this.addBaseDataF7Filter(event, parentBillFormId, "source");
                break;
            }
        }
        logger.info("CostCfgAddPlugin beforeF7Select fieldKey:{},CustomFilters:{}", (Object)fieldKey, (Object)event.getCustomQFilters());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String billFormId = ((ListView)this.getView().getParentView()).getBillFormId();
        switch (key) {
            case "costadaption": {
                this.cleanValue(billFormId);
                break;
            }
            case "org": {
                this.getView().getModel().setValue("costadaption", null);
                if ("pcs_costitemcfg".equals(billFormId)) {
                    this.getView().getModel().setValue("salaryitem", null);
                    break;
                }
                if ("pcs_costsalaryfilecfg".equals(billFormId)) {
                    this.getView().getModel().setValue("salaryfile", null);
                    break;
                }
                if ("pcs_costgroupcfg".equals(billFormId)) {
                    this.getView().getModel().setValue("payrollgrp", null);
                    break;
                }
                if (!"pcs_costsalaryitemcfg".equals(billFormId)) break;
                this.getView().getModel().setValue("salaryfile", null);
                this.getView().getModel().setValue("salaryitem", null);
                break;
            }
            case "salaryfile": {
                if (!"pcs_costsalaryitemcfg".equals(billFormId)) break;
                this.getView().getModel().setValue("salaryitem", null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        if (BTN_OK.equals(clkKey)) {
            this.clickButton();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private void clickButton() {
        String billFormId = ((ListView)this.getView().getParentView()).getBillFormId();
        List<String> costCfgShowList = COST_CFG_ADD_SHOWMAP.get(billFormId);
        if (SWCListUtils.isEmpty(costCfgShowList)) {
            return;
        }
        HashMap returnData = Maps.newHashMapWithExpectedSize((int)costCfgShowList.size());
        for (String showKey : costCfgShowList) {
            long id = this.getView().getModel().getDataEntity().getLong(showKey + ".id");
            returnData.put(showKey, id);
        }
        long costStruId = this.getView().getModel().getDataEntity().getLong("costadaption.coststru.id");
        long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        returnData.put("coststruid", costStruId);
        returnData.put("orgid", orgId);
        this.getView().setReturnData((Object)returnData);
        this.getView().close();
    }

    private void addExistQFilter(BeforeF7SelectEvent event) {
        long costAdaptionId;
        String parentBillFormId = this.getParentBillFormId();
        List sourceIds = CostCfgHelper.getCostCfgTypeIds((String)parentBillFormId, (Long)(costAdaptionId = this.getModel().getDataEntity().getLong("costadaption.id")));
        if (!sourceIds.isEmpty()) {
            event.addCustomQFilter(new QFilter("id", "not in", (Object)sourceIds));
        }
    }

    private String getParentBillFormId() {
        IListView listView = (IListView)this.getView().getParentView();
        return listView.getBillFormId();
    }

    private void setCustomFilter(BeforeF7SelectEvent event) {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            event.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostCfgAddPlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        long costAdaptionId = this.getView().getModel().getDataEntity().getLong("costadaption.id");
        if (costAdaptionId == 0L) {
            event.setCancel(true);
            String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3002", (String)"CostCfgAddPlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        this.addExistQFilter(event);
        logger.info("CostCfgAddPlugin CustomFilters :{}", (Object)event.getCustomQFilters());
    }

    private void addCountryFilter(BeforeF7SelectEvent event, String propertyKey) {
        String type = this.getView().getModel().getDataEntity().getString("costadaption.areatype");
        if ("2".equals(type)) {
            long countryId = this.getView().getModel().getDataEntity().getLong("costadaption.country.id");
            event.addCustomQFilter(new QFilter(propertyKey, "=", (Object)countryId));
            logger.info("CostCfgAddPlugin addCountryFilter countryId:{}", (Object)countryId);
        }
    }

    private void cleanValue(String billFormId) {
        if ("pcs_costdeptcfg".equals(billFormId)) {
            this.getView().getModel().setValue("adminorg", null);
        } else if ("pcs_costpostcfg".equals(billFormId)) {
            this.getView().getModel().setValue("position", null);
        } else if ("pcs_costempcfg".equals(billFormId)) {
            this.getView().getModel().setValue("person", null);
        } else if ("pcs_costitemcfg".equals(billFormId)) {
            this.getView().getModel().setValue("salaryitem", null);
        } else if ("pcs_costsalaryfilecfg".equals(billFormId)) {
            this.getView().getModel().setValue("salaryfile", null);
        } else if ("pcs_costgroupcfg".equals(billFormId)) {
            this.getView().getModel().setValue("payrollgrp", null);
        } else if ("pcs_costjobcfg".equals(billFormId)) {
            this.getView().getModel().setValue("job", null);
        } else if ("pcs_costsalaryitemcfg".equals(billFormId)) {
            this.getView().getModel().setValue("salaryfile", null);
            this.getView().getModel().setValue("salaryitem", null);
        }
    }

    private void addExistSalaryFileItemQFilter(BeforeF7SelectEvent event, String parentBillFormId) {
        if ("pcs_costsalaryitemcfg".equals(parentBillFormId)) {
            boolean isCancel = event.isCancel();
            if (isCancel) {
                return;
            }
            long salaryFileId = this.getView().getModel().getDataEntity().getLong("salaryfile.id");
            if (salaryFileId == 0L) {
                event.setCancel(true);
                String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u5458\u85aa\u8d44\u6863\u6848\u201d\u3002", (String)"CostCfgAddPlugin_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            long costAdaptionId = this.getModel().getDataEntity().getLong("costadaption.id");
            SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costsalaryitemcfg");
            QFilter qFilter = new QFilter("sourcetype", "=", (Object)SWCCostConstants.COST_TYPE_SALARYFILEITEM);
            qFilter.and(new QFilter("costadapter", "=", (Object)costAdaptionId));
            qFilter.and(new QFilter("creatorobj", "=", (Object)salaryFileId));
            DynamicObject[] queryResults = helper.query("id,source", new QFilter[]{qFilter});
            HashSet<Long> existSalaryItemList = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : queryResults) {
                long sourceId = dynamicObject.getLong("source.id");
                existSalaryItemList.add(sourceId);
            }
            if (!existSalaryItemList.isEmpty()) {
                event.addCustomQFilter(new QFilter("id", "not in", existSalaryItemList));
            }
        }
    }

    private void addBaseDataF7Filter(BeforeF7SelectEvent event, String entityNumber, String key) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter baseDataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)entityNumber, (String)key, (String)"47156aff000000ac");
        if (baseDataFilter != null) {
            event.addCustomQFilter(baseDataFilter);
        }
    }

    private void addCostAdaptionFilter(BeforeF7SelectEvent event, String parentBillFormId) {
        long hrOrgId = this.getView().getModel().getDataEntity().getLong("org.id");
        if (hrOrgId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostCfgAddPlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            event.setCancel(true);
            return;
        }
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(hrOrgId);
        CostCfgHelper.addCostStruFilter((BeforeF7SelectEvent)event, (IFormView)this.getView(), orgIdList);
        CostCfgHelper.addCostAdaptionBaseDataBuFilter((BeforeF7SelectEvent)event, (String)parentBillFormId, (String)"costadapter", (long)hrOrgId);
    }

    private void addSalaryItemBaseDataBuFilter(BeforeF7SelectEvent event, String entityNumber, String key) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter baseDataRuleFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)entityNumber, (String)key, (String)"47156aff000000ac");
        logger.info("CostCfgAddPlugin beforeF7Select addSalaryItemBaseDataBuFilter baseDataRuleFilter:{}", (Object)baseDataRuleFilter);
        QFilter salaryItemBaseDataBuFilter = null;
        Set payrollCalSetByPermItem = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costitemcfgperm", (String)"47150e89000000ac");
        if (!CollectionUtils.isEmpty((Collection)payrollCalSetByPermItem)) {
            ArrayList payrollCalListByPermItem = new ArrayList(payrollCalSetByPermItem);
            salaryItemBaseDataBuFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", payrollCalListByPermItem, (boolean)true);
            logger.info("CostCfgAddPlugin beforeF7Select addSalaryItemBaseDataBuFilter salaryItemBaseDataBuFilter:{}", (Object)salaryItemBaseDataBuFilter);
        }
        CostCfgHelper.addBaseDataAndBuFilter((BeforeF7SelectEvent)event, (QFilter)baseDataRuleFilter, salaryItemBaseDataBuFilter);
    }

    static {
        COST_CFG_ADD_SHOWMAP.put("pcs_costdeptcfg", Arrays.asList("org", "costadaption", "adminorg"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costpostcfg", Arrays.asList("org", "costadaption", "position"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costempcfg", Arrays.asList("org", "costadaption", "person"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costitemcfg", Arrays.asList("org", "costadaption", "salaryitem"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costgroupcfg", Arrays.asList("org", "costadaption", "payrollgrp"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costjobcfg", Arrays.asList("org", "costadaption", "job"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costsalaryfilecfg", Arrays.asList("org", "costadaption", "salaryfile"));
        COST_CFG_ADD_SHOWMAP.put("pcs_costsalaryitemcfg", Arrays.asList("org", "costadaption", "salaryfile", "salaryitem"));
    }
}

