/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import kd.swc.pcs.business.costcfg.service.CostCfgExportService;
import kd.swc.pcs.business.costmap.service.CostItemMapService;

public class CostCfgList
extends SWCDataBaseList {
    private static final String OP_IMPORT_DATA = "donothing_import";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        IListView listView = (IListView)this.getView();
        String parentBillFormId = listView.getBillFormId();
        CostItemMapService service = new CostItemMapService();
        switch (fieldName) {
            case "costadapter.id": 
            case "costadapter.name": {
                service.addCostAdapterFilter(filters, parentBillFormId);
                break;
            }
            case "coststru.id": 
            case "coststru.name": 
            case "coststru.alldimensionname": {
                service.addCostStruFilter(filters, parentBillFormId);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
        if (this.isNeedCancel(opKey, idConfirm)) {
            args.setCancel(true);
            this.invokeSaveOperation(opKey);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_export_list": {
                CostCfgExportService costCfgExportService = new CostCfgExportService();
                costCfgExportService.doExport(this.getView());
                break;
            }
            case "donothing_import": {
                this.openImportWindow();
                break;
            }
        }
    }

    private void openImportWindow() {
        IListView listView = (IListView)this.getView();
        String costCfgName = listView.getFormShowParameter().getCaption();
        FormShowParameter importShowParameter = new FormShowParameter();
        importShowParameter.setCustomParam("entityid", (Object)((IListView)this.getView()).getBillFormId());
        importShowParameter.setFormId("pcs_costcfgimportstart");
        importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        importShowParameter.setCaption(ResManager.loadKDString((String)"{0}\u6210\u672c\u8bbe\u7f6e\u5bfc\u5165\u8d77\u59cb\u9875", (String)"CostCfgList_1", (String)"swc-pcs-formplugin", (Object[])new Object[]{costCfgName}));
        importShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_costcfgimportstart"));
        this.getView().showForm(importShowParameter);
    }

    private void invokeSaveOperation(String opKey) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("confirm", "true");
        option.setVariableValue("bill_list", "true");
        this.getView().invokeOperation(opKey, option);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        String isSuccess;
        String actId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnDataObj)) {
            return;
        }
        if ("pcs_costcfgimportstart".equals(actId) && "true".equals(isSuccess = (String)(returnData = (Map)returnDataObj).get("issuccess"))) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"CostCfgList_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isNeedCancel(String opKey, boolean idConfirm) {
        return !idConfirm && ("submit".equals(opKey) || "audit".equals(opKey));
    }
}

