/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.pcs.common.constants.CostCfgImportConstants;

public class CostCommonProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
        this.setShowProgressInfo();
    }

    public void onProgress(ProgressEvent progressEvent) {
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        Double progress = (Double)cache.get("progress", Double.class);
        if (Objects.nonNull(progress)) {
            this.setProgress(progressEvent, progress);
        } else {
            progressEvent.setProgress(0);
            progressEvent.setText(ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u59cb\uff0c\u8bf7\u7a0d\u5019...", (String)"CostCommonProgressPlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void setProgress(ProgressEvent progressEvent, Double progress) {
        String text = progress + "%";
        if (progress >= CostCfgImportConstants.DOUBLE_HUNDRED) {
            IPageCache pageCache = this.getView().getPageCache();
            String isClose = pageCache.get("isclose");
            if ("1".equals(isClose)) {
                SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
                String url = (String)cache.get("url", String.class);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    text = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostCommonProgressPlugin_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    clientViewProxy.addAction("download", (Object)url);
                    progress = CostCfgImportConstants.DOUBLE_HUNDRED;
                    progressEvent.setProgress(progress.intValue());
                    progressEvent.setText(text);
                }
                this.getView().close();
            } else {
                progressEvent.setProgress(CostCfgImportConstants.DOUBLE_NINETY_NINE.intValue());
                pageCache.put("isclose", "1");
            }
        } else {
            progressEvent.setProgress(progress.intValue());
            progressEvent.setText(text);
        }
        String content = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa({0}%)", (String)"CostCommonProgressPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[]{progress});
        Label contentLabel = (Label)this.getControl("contentlabel");
        contentLabel.setText(content);
    }

    private void setShowProgressInfo() {
        String title = (String)this.getView().getFormShowParameter().getCustomParam("title");
        Label titleLabel = (Label)this.getControl("titlelabel");
        titleLabel.setText(title);
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        Double progress = (Double)cache.get("progress", Double.class);
        if (progress == null) {
            progress = 0.0;
        }
        String content = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa({0}%)", (String)"CostCommonProgressPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[]{progress});
        Label contentLabel = (Label)this.getControl("contentlabel");
        contentLabel.setText(content);
    }
}

