/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostAllotDetailHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.strategy.CreateFieldApStrategy;
import kd.swc.pcs.business.costcfg.strategy.constants.StrategyConstants;

public class CostDimensionPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(CostDimensionPlugin.class);
    private static final String DONOTHING_CONFIRM = "donothing_confirm";
    private static final String DONOTHING_CLOSE = "donothing_close";
    private static final String PAGE_SHOWDIMENSION = "pcs_showdimension";
    private static final String KEY_PREFIXBASEDATA = "basedata";
    private static final String KEY_PREFIXTEXT = "text";

    public void afterCreateNewData(EventObject e) {
        this.initFieldDefaultData();
    }

    private void initFieldDefaultData() {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        JSONObject paramDataJSONObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("paramData");
        JSONObject returnData = paramDataJSONObject.getJSONObject("returnData");
        if (returnData == null || returnData.isEmpty()) {
            Long costBizObjId;
            Long costStruId = paramDataJSONObject.getLong("costStruId");
            Map costDimensionEntIdIdRefDefRuleMap = CostCfgHelper.getDimensionEntIdIdRefDefRuleMap((Long)costStruId, (Long)(costBizObjId = paramDataJSONObject.getLong("costBizObjId")));
            if (!costDimensionEntIdIdRefDefRuleMap.isEmpty()) {
                this.setDefaultValue(properties, costDimensionEntIdIdRefDefRuleMap, paramDataJSONObject);
            }
            return;
        }
        this.setReturnValue(properties, returnData);
        Boolean isShow = paramDataJSONObject.getBoolean("isShow");
        if (isShow != null && isShow.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
            HashMap ctrl = new HashMap(16);
            HashMap<String, String> name = new HashMap<String, String>(16);
            String langKey = RequestContext.get().getLang().name();
            name.put(langKey, ResManager.loadKDString((String)"\u5173\u95ed", (String)"CostDimensionPlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            ctrl.put(KEY_PREFIXTEXT, name);
            this.getView().updateControlMetadata("btncancel", ctrl);
        }
    }

    private void setDefaultValue(DataEntityPropertyCollection properties, Map<Long, JSONArray> costDimensionEntIdIdRefDefRuleMap, JSONObject paramDataJSONObject) {
        for (IDataEntityProperty property : properties) {
            String dataKey;
            JSONArray defaultValArr;
            String fieldName = property.getName();
            if (this.isSkipDefaultValue(fieldName) || (defaultValArr = costDimensionEntIdIdRefDefRuleMap.get(Long.valueOf(dataKey = this.getDataKeyByPropType(property)))) == null) continue;
            List<Map<String, Object>> propFilterMapList = this.getDefaultValRule(defaultValArr, paramDataJSONObject);
            String resultVal = this.getDefaultValue(propFilterMapList, paramDataJSONObject);
            if (property instanceof BasedataProp) {
                this.setBasedataPropValue(fieldName, dataKey, resultVal);
            } else {
                this.getModel().setValue(fieldName, (Object)resultVal);
            }
            this.getView().updateView(fieldName);
        }
    }

    private String getDefaultValue(List<Map<String, Object>> propFilterMapList, JSONObject paramDataJSONObject) {
        String resultVal = null;
        String entityName = paramDataJSONObject.getString("entityName");
        if (SWCStringUtils.isEmpty((String)entityName)) {
            LOGGER.error("entityName is empty...");
            return resultVal;
        }
        for (Map<String, Object> propFilterMap : propFilterMapList) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityName);
            String propName = (String)propFilterMap.get("propName");
            String fixedValue = (String)propFilterMap.get("fixedValue");
            QFilter qFilter = (QFilter)propFilterMap.get("qFilter");
            if (qFilter == null) {
                if (SWCStringUtils.isNotEmpty((String)fixedValue)) {
                    return fixedValue;
                }
                if (!SWCStringUtils.isNotEmpty((String)propName)) continue;
                DynamicObject sourceObj = serviceHelper.queryOriginalOne("id," + propName, (Object)this.getView().getParentView().getModel().getDataEntity().getLong("source.id"));
                return sourceObj == null ? "" : sourceObj.getString(propName);
            }
            String prop = SWCStringUtils.isEmpty((String)propName) ? "id" : "id," + propName;
            DynamicObject[] sourceObjArr = serviceHelper.queryOriginalArray(prop, new QFilter[]{qFilter});
            if (sourceObjArr.length == 0) continue;
            long sourceId = paramDataJSONObject.getLong("sourceId");
            for (DynamicObject sourceObj : sourceObjArr) {
                if (sourceId != sourceObj.getLong("id")) continue;
                if (SWCStringUtils.isNotEmpty((String)fixedValue)) {
                    return fixedValue;
                }
                if (!SWCStringUtils.isNotEmpty((String)propName)) continue;
                resultVal = sourceObj.getString(propName);
                break;
            }
            if (!SWCStringUtils.isNotEmpty(resultVal)) continue;
            break;
        }
        return resultVal;
    }

    private List<Map<String, Object>> getDefaultValRule(JSONArray defaultValArr, JSONObject paramDataJSONObject) {
        ArrayList<Map<String, Object>> propFiterMapList = new ArrayList<Map<String, Object>>(defaultValArr.size());
        String entitytName = paramDataJSONObject.getString("entityName");
        if (SWCStringUtils.isEmpty((String)entitytName)) {
            LOGGER.error("entityName is empty...");
            return propFiterMapList;
        }
        for (Object defaultValObj : defaultValArr) {
            if (!(defaultValObj instanceof JSONObject)) break;
            JSONObject defaultRuleObj = (JSONObject)defaultValObj;
            HashMap<String, String> propFiterMap = new HashMap<String, String>(3);
            propFiterMapList.add(propFiterMap);
            String fixedValue = defaultRuleObj.getString("fixedvalue");
            propFiterMap.put("fixedValue", fixedValue);
            propFiterMap.put("propName", defaultRuleObj.getString("objectproperties"));
            JSONObject defaultValRuleEntObj = defaultRuleObj.getJSONObject("defaultvalruleentval");
            if (defaultValRuleEntObj == null) continue;
            String filterCondition = defaultValRuleEntObj.getString("filterCondition");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entitytName);
            QFilter qFilter = PermCommonUtil.getQFilterFromFilterGridJsonStr((MainEntityType)entityType, (String)filterCondition);
            propFiterMap.put("qFilter", (String)qFilter);
        }
        return propFiterMapList;
    }

    private void setBasedataPropValue(String fieldName, String dataKey, String fixedValue) {
        DynamicObject dimensionObj = CostCfgHelper.queryDimensionById((String)dataKey);
        String displayProp = dimensionObj.getString("displayproperty");
        String entityNumber = CostCfgHelper.getFormNumber((DynamicObject)dimensionObj);
        QFilter qFilter = this.getqFilter(fixedValue, displayProp);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityNumber);
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("id", new QFilter[]{qFilter});
        this.getModel().setValue(fieldName, (Object)(dynamicObject == null ? 0L : dynamicObject.getLong("id")));
    }

    private QFilter getqFilter(String fixedValue, String displayProp) {
        QFilter qFilter = null;
        switch (displayProp) {
            case "2": {
                qFilter = new QFilter("name", "=", (Object)fixedValue);
                break;
            }
            case "3": {
                qFilter = new QFilter("number", "=", (Object)fixedValue);
                qFilter.or(new QFilter("name", "=", (Object)fixedValue));
                break;
            }
            default: {
                qFilter = new QFilter("number", "=", (Object)fixedValue);
            }
        }
        return qFilter;
    }

    private void setReturnValue(DataEntityPropertyCollection properties, JSONObject returnData) {
        for (IDataEntityProperty property : properties) {
            String fieldName = property.getName();
            if (fieldName.contains("_id")) continue;
            String dataKey = this.getDataKeyByPropType(property);
            String dataVal = (String)returnData.get((Object)dataKey);
            if (dataVal != null && dataVal.contains("||")) {
                dataVal = dataVal.substring(0, dataVal.indexOf("||"));
            }
            this.getModel().setValue(fieldName, (Object)dataVal);
            this.getView().updateView(fieldName);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)PAGE_SHOWDIMENSION, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("dimensionFlex");
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        JSONObject paramDataJSONObject = (JSONObject)parameter.getCustomParam("paramData");
        Long costStruId = paramDataJSONObject.getLong("costStruId");
        Long costBizObjId = paramDataJSONObject.getLong("costBizObjId");
        String costType = paramDataJSONObject.getString("costType");
        List<FieldAp> baseDataFieldApList = this.batchDynamicCreateFieldAp(entityMetadata, costStruId, costBizObjId, costType);
        if (baseDataFieldApList != null) {
            flexPanelAp.getItems().addAll(baseDataFieldApList);
        }
        HashMap<String, String> mapPanel = new HashMap<String, String>(16);
        mapPanel.put("id", "contentpanel");
        mapPanel.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(mapPanel);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            LOGGER.error("getEntityType error", (Object)exp.getMessage());
        }
        JSONObject paramDataJSONObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("paramData");
        Long costStruId = paramDataJSONObject.getLong("costStruId");
        Long costBizObjId = paramDataJSONObject.getLong("costBizObjId");
        String costType = paramDataJSONObject.getString("costType");
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStruId, (Long)costBizObjId, (String)costType);
        this.setEntityNameRefDisplayPropToPageCache(dimensionObjList);
        for (DynamicObject dimensionObj : dimensionObjList) {
            String valueType = dimensionObj.getString("valuetype");
            CreateFieldApStrategy createFieldApStrategy = (CreateFieldApStrategy)StrategyConstants.getCreateFieldApStrategyMap().get(valueType);
            createFieldApStrategy.createPro(dimensionObj, newMainType);
        }
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(KEY_PREFIXBASEDATA)) {
            BasedataEdit basedataEdit = new BasedataEdit();
            basedataEdit.setKey(key);
            basedataEdit.setView(this.getView());
            basedataEdit.setFieldKey(key);
            QFilter qFilter = this.getQFilter(key);
            basedataEdit.setQFilter(qFilter);
            e.setControl((Control)basedataEdit);
        } else if (key.startsWith(KEY_PREFIXTEXT)) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JSONObject paramDataJSONObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("paramData");
        String costType = paramDataJSONObject.getString("costType");
        if (!"COST".equals(costType)) {
            this.setMustInput();
        }
    }

    private void setMustInput() {
        JSONObject paramDataJSONObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("paramData");
        Long costStruId = paramDataJSONObject.getLong("costStruId");
        List dimensionIdList = CostAllotDetailHelper.queryIsRequiredDimensionIdList((Long)costStruId);
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty prop : properties) {
            String propName = prop.getName();
            if (this.isSkipMustInput(propName) || !dimensionIdList.contains(this.getDataKeyByPropType(prop))) continue;
            FieldEdit fieldEdit = (FieldEdit)this.getControl(propName);
            fieldEdit.setMustInput(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (DONOTHING_CLOSE.equals(operateKey)) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.showCloseConfirmDialog();
            } else {
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                this.getView().invokeOperation("close");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_confirm": {
                this.returnDataToParentPage();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        switch (e.getCallBackId()) {
            case "donothing_close": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.getModel().setDataChanged(false);
                this.getView().returnDataToParent((Object)Boolean.TRUE);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private void returnDataToParentPage() {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        JSONObject pageFieldValJSON = new JSONObject(true);
        StringBuilder builder = new StringBuilder();
        boolean isAllNull = true;
        for (IDataEntityProperty prop : properties) {
            String propName = prop.getName();
            if (this.isSkipMustInput(propName)) continue;
            Object value = this.getModel().getValue(propName);
            if (value != null) {
                String dataKey = this.getDataKeyByPropType(prop);
                if (value instanceof DynamicObject) {
                    isAllNull = false;
                    DynamicObject baseDataVal = (DynamicObject)value;
                    String baseDataId = propName.replace(KEY_PREFIXBASEDATA, "");
                    String disPalyProp = this.getView().getPageCache().get(baseDataId);
                    String baseDataName = "1".equals(disPalyProp) ? "number" : "name";
                    String displayVal = baseDataVal.getString(baseDataName);
                    String baseDataKeyVal = String.join((CharSequence)"||", baseDataVal.getString("id"), displayVal);
                    pageFieldValJSON.put(dataKey, (Object)baseDataKeyVal);
                    builder.append(displayVal).append('.');
                    continue;
                }
                if (!SWCStringUtils.isEmpty((String)((String)value))) {
                    isAllNull = false;
                    pageFieldValJSON.put(dataKey, value);
                    builder.append(value).append('.');
                    continue;
                }
                builder.append(' ').append('.');
                continue;
            }
            builder.append(' ').append('.');
        }
        if (isAllNull) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u503c\u3002", (String)"CostDimensionPlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        this.getView().returnDataToParent((Object)pageFieldValJSON);
        SWCPageCache parentViewPageCache = new SWCPageCache(this.getView().getParentView());
        parentViewPageCache.put("dimensionNameValCache", (Object)(builder.length() > 0 ? builder.substring(0, builder.lastIndexOf(".")) : ""));
        this.getView().close();
    }

    private void showCloseConfirmDialog() {
        String changeDesc = this.getModel().getChangeDesc();
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CostDimensionPlugin_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Default, new ConfirmCallBackListener(DONOTHING_CLOSE, (IFormPlugin)this));
    }

    private String getDataKeyByPropType(IDataEntityProperty property) {
        String fieldName = property.getName();
        if (property instanceof BasedataProp) {
            return fieldName.replace(KEY_PREFIXBASEDATA, "");
        }
        return fieldName.replace(KEY_PREFIXTEXT, "");
    }

    private List<FieldAp> batchDynamicCreateFieldAp(EntityMetadata entityMetadata, Long costStrutId, Long costBizObjId, String costType) {
        if (SWCObjectUtils.isEmpty((Object)costStrutId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u7ef4\u5ea6\u7ec4\u5408\u4fe1\u606f\u3002", (String)"CostDimensionPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<FieldAp> fieldApList = new ArrayList<FieldAp>(10);
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStrutId, (Long)costBizObjId, (String)costType);
        for (DynamicObject dimensionObj : dimensionObjList) {
            String valueType = dimensionObj.getString("valuetype");
            CreateFieldApStrategy createFieldApStrategy = (CreateFieldApStrategy)StrategyConstants.getCreateFieldApStrategyMap().get(valueType);
            FieldAp fieldAp = createFieldApStrategy.createField(entityMetadata, dimensionObj);
            if (fieldAp == null) continue;
            fieldApList.add(fieldAp);
        }
        return fieldApList;
    }

    private void setEntityNameRefDisplayPropToPageCache(List<DynamicObject> dimensionObjList) {
        HashMap<String, String> entityNameRefDisplayPropMap = new HashMap<String, String>(dimensionObjList.size());
        for (DynamicObject dimensionObj : dimensionObjList) {
            String valueType = dimensionObj.getString("valuetype");
            if (!"1".equals(valueType) && !"2".equals(valueType)) continue;
            String displayProp = dimensionObj.getString("displayproperty");
            String dimensionObjId = dimensionObj.getString("id");
            entityNameRefDisplayPropMap.put(dimensionObjId, displayProp);
        }
        if (entityNameRefDisplayPropMap.isEmpty()) {
            return;
        }
        this.getView().getPageCache().put(entityNameRefDisplayPropMap);
    }

    private QFilter getQFilter(String key) {
        DataEntityPropertyCollection properties;
        DynamicObject value = (DynamicObject)this.getModel().getValue(key);
        QFilter qFilter = new QFilter("id", "!=", (Object)0L);
        if (value == null) {
            String dimensionId = key.replace(KEY_PREFIXBASEDATA, "");
            DynamicObject dimensionObj = CostCfgHelper.queryDimensionById((String)dimensionId);
            String pageNumber = CostCfgHelper.getFormNumber((DynamicObject)dimensionObj);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pageNumber);
            properties = dataEntityType.getProperties();
        } else {
            properties = value.getDataEntityType().getProperties();
        }
        QFilter assistantQFilter = CostCfgHelper.setAssistantQFilter((String)key);
        if (qFilter != null) {
            qFilter.and(assistantQFilter);
        }
        if (properties.containsKey((Object)"name")) {
            qFilter.and(new QFilter("name", "!=", (Object)" "));
        }
        if (properties.containsKey((Object)"number")) {
            qFilter.and(new QFilter("number", "!=", (Object)" "));
        }
        if (properties.containsKey((Object)"status")) {
            qFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        if (properties.containsKey((Object)"enable")) {
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
        }
        return qFilter;
    }

    private boolean isSkipMustInput(String propName) {
        return propName.contains("_id") || !propName.startsWith(KEY_PREFIXBASEDATA) && !propName.startsWith(KEY_PREFIXTEXT);
    }

    private boolean isSkipDefaultValue(String fieldName) {
        return fieldName.contains("_id") || !fieldName.startsWith(KEY_PREFIXBASEDATA) && !fieldName.startsWith(KEY_PREFIXTEXT);
    }
}

