/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costcfg.CostItemCfgQualityHelper;
import kd.swc.pcs.business.costcfg.service.CostItemQualityService;

public class CostItemCfgQualityEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"leftadd"});
        this.addBeforeF7Listener();
    }

    public void beforeBindData(EventObject e) {
        String costCfgStatus;
        long id;
        super.beforeBindData(e);
        CostItemQualityService service = new CostItemQualityService(this.getView());
        service.setCostItemCfgInfo();
        String qualityName = this.getModel().getDataEntity().getString("qualityname");
        long parentId = this.getModel().getDataEntity().getLong("parentid");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (SWCStringUtils.isNotEmpty((String)qualityName) || parentId != 0L || !OperationStatus.ADDNEW.equals((Object)status)) {
            service.initParentId();
            service.initLeftCostCfgQualityInfo();
        }
        if ((id = this.getModel().getDataEntity().getLong("id")) != 0L) {
            this.getView().setStatus(OperationStatus.EDIT);
        }
        if ("A".equals(costCfgStatus = this.getModel().getDataEntity().getString("status"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String qualityName = this.getModel().getDataEntity().getString("qualityname");
        if (SWCStringUtils.isEmpty((String)qualityName)) {
            this.setCostItemEnableAndVisible();
        } else {
            this.setCostItemQualityEnableAndVisible();
        }
        CostItemQualityService service = new CostItemQualityService(this.getView());
        service.setLeftPanelVisible();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("leftadd".equals(key)) {
            this.openCostItemCfgQualityForm();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long parentId;
        DynamicObject[] costItemCfgDys;
        String qualityGroup = this.getView().getModel().getDataEntity().getString("qualitydim.index");
        if (SWCStringUtils.isEmpty((String)qualityGroup)) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8d44\u683c\u5206\u7ec4\u7ef4\u5ea6\u201d\u3002", (String)"CostItemCfgQualityEdit_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        }
        if ((costItemCfgDys = CostItemCfgQualityHelper.selectCostItemCfgList((long)(parentId = this.getView().getModel().getDataEntity().getLong("parentid")))).length == 0) {
            return;
        }
        CostItemQualityService service = new CostItemQualityService(this.getView());
        List costItemIdList = service.getCostItemIdList(costItemCfgDys);
        if (costItemIdList.isEmpty()) {
            return;
        }
        QFilter qfilter = new QFilter("id", "not in", (Object)costItemIdList);
        beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qfilter));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        CostItemQualityService service = new CostItemQualityService(this.getView());
        service.clickTreeNode(nodeId, evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"qualitydim", (CharSequence)key)) {
            DynamicObject newQualityDimDy;
            DynamicObject oldQualityDimDy = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldQualityDimDy != null) {
                long qualityId = oldQualityDimDy.getLong("id");
                int oldQualityGroup = CostItemCfgQualityHelper.getQualityGroupIndex((long)qualityId);
                this.getView().getModel().setValue("basedataid" + String.valueOf(oldQualityGroup), null);
            }
            if ((newQualityDimDy = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
                long qualityId = newQualityDimDy.getLong("id");
                int newQualityDimIndex = CostItemCfgQualityHelper.getQualityGroupIndex((long)qualityId);
                CostItemQualityService service = new CostItemQualityService(this.getView());
                service.setQualityBaseDataVisible(newQualityDimIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "confirmchange": {
                boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
                if (args.isCancel()) break;
                this.validateIsNeedCancel(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        CostItemQualityService service = new CostItemQualityService(this.getView());
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "audit": {
                boolean success = e.getOperationResult().isSuccess();
                if (!success) break;
                this.afterSaveOrSubmitSuccessDo();
                break;
            }
            case "donothing_delete": {
                service.clickTreeRoot();
                service.clearCacheAndRebuildLeftTree();
                service.focusRootTreeNode();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "clicktreenodecallback": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    this.confirmTreeNodeCallBackForYes();
                    break;
                }
                CostItemQualityService service = new CostItemQualityService(this.getView());
                service.focusTreeNode();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actId;
        switch (actId = closedCallBackEvent.getActionId()) {
            case "qualityaddcloseback": {
                this.qualityAddCloseBack(closedCallBackEvent);
                break;
            }
        }
    }

    private void qualityAddCloseBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("costAdapter", returnData.get("costAdapter"));
        swcPageCache.put("sourceType", returnData.get("sourceType"));
        swcPageCache.put("source", returnData.get("source"));
        swcPageCache.put("qualityName", returnData.get("qualityName"));
        swcPageCache.put("qualityNumber", returnData.get("qualityNumber"));
        swcPageCache.put("qualityBsed", returnData.get("qualityBsed"));
        swcPageCache.put("qualityDimId", returnData.get("qualityDimId"));
        swcPageCache.put("qualityDimIndex", returnData.get("qualityDimIndex"));
        swcPageCache.put("selectNodeId", (Object)"addnotsave");
        swcPageCache.put("costStru", returnData.get("costStru"));
        swcPageCache.put("createOrg", returnData.get("createOrg"));
        this.getView().invokeOperation("new");
    }

    private void confirmTreeNodeCallBackForYes() {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String nodeId = (String)swcPageCache.get("clickOtherTreeNode", String.class);
        CostItemQualityService service = new CostItemQualityService(this.getView());
        service.loadById(nodeId);
        service.clearCacheAndRebuildLeftTree();
    }

    private void afterSaveOrSubmitSuccessDo() {
        CostItemQualityService service = new CostItemQualityService(this.getView());
        service.cleanCache();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String treeNodeStr = (String)swcPageCache.get("treeNode", String.class);
        if (SWCStringUtils.isEmpty((String)treeNodeStr)) {
            DynamicObject costItemDy = this.getModel().getDataEntity();
            String costItemDyId = costItemDy.getString("id");
            swcPageCache.put("parentId", (Object)costItemDyId);
            swcPageCache.put("selectNodeId", (Object)costItemDyId);
            swcPageCache.put("keyRoot", (Object)costItemDyId);
            swcPageCache.put("qualityDimId", (Object)costItemDy.getLong("qualitydim.id"));
            service.clearCacheAndRebuildLeftTree();
        }
        service.setLeftPanelVisible();
    }

    private void openCostItemCfgQualityForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pcs_costitemcfgqualityadd");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "qualityaddcloseback"));
        this.getView().showForm(showParameter);
    }

    private void setCostItemEnableAndVisible() {
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L || BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"costitemcfgquality", "qualityname", "qualitynumber"});
        } else {
            this.setExistDbCostItemVisible();
        }
    }

    private void setExistDbCostItemVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"costitemcfgquality", "bar_deleteself", "qualityname", "qualitynumber"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"name", "number"});
        CostItemQualityService service = new CostItemQualityService(this.getView());
        service.focusTreeNode();
    }

    private void setCostItemQualityEnableAndVisible() {
        CostItemQualityService service = new CostItemQualityService(this.getView());
        int qualityDimIndex = service.fillCostCfgQualityInfo();
        service.setQualityBaseDataVisible(qualityDimIndex);
        service.focusTreeNode();
        service.setQualityGroupEnable(qualityDimIndex);
        long id = this.getView().getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_deleteself"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_deleteself"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"costitemcfgquality", "qualityname", "qualitynumber", "name", "number"});
    }

    private void validateIsNeedCancel(BeforeDoOperationEventArgs args) {
        DynamicObject costItemCfgQualityDy = this.getView().getModel().getDataEntity();
        String qualityName = costItemCfgQualityDy.getString("qualityname");
        if (SWCStringUtils.isEmpty((String)qualityName)) {
            return;
        }
        long qualityDimId = costItemCfgQualityDy.getLong("qualitydim.id");
        if (qualityDimId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u6210\u672c\u8d44\u683c\u201d\u3002", (String)"CostItemCfgQualityEdit_8", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (this.validatorGroupValueIsEmpty(args, costItemCfgQualityDy)) {
            return;
        }
        int qualityDimIndex = costItemCfgQualityDy.getInt("qualitydim.index");
        if (qualityDimIndex == 0) {
            return;
        }
        if (this.validatorDimAndCityValue(args)) {
            return;
        }
        this.fillGroupValue(qualityDimIndex);
    }

    private boolean validatorDimAndCityValue(BeforeDoOperationEventArgs args) {
        long parentId = this.getView().getModel().getDataEntity().getLong("parentid");
        if (parentId == 0L) {
            return true;
        }
        DynamicObject[] costItemCfgDys = CostItemCfgQualityHelper.selectCostItemCfgList((long)parentId);
        ArrayList<Long> qualityDimIdList = new ArrayList<Long>(16);
        for (DynamicObject costItemQualityDy : costItemCfgDys) {
            long queryQualityDimId = costItemQualityDy.getLong("qualitydim.id");
            qualityDimIdList.add(queryQualityDimId);
        }
        long viewQualityDimId = this.getView().getModel().getDataEntity().getLong("qualitydim.id");
        if (qualityDimIdList.size() > 1 && !qualityDimIdList.contains(viewQualityDimId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u683c\u5206\u7ec4\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"CostItemCfgQualityEdit_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private boolean validatorGroupValueIsEmpty(BeforeDoOperationEventArgs args, DynamicObject costItemCfgQualityDy) {
        DynamicObjectCollection rows;
        int qualityDimIndex = costItemCfgQualityDy.getInt("qualitydim.index");
        if (qualityDimIndex == 0) {
            return true;
        }
        String key = "basedataid" + qualityDimIndex;
        Object obj = costItemCfgQualityDy.get(key);
        if (obj instanceof DynamicObject) {
            DynamicObject rows2 = costItemCfgQualityDy.getDynamicObject(key);
            if (rows2 == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5206\u7ec4\u6761\u4ef6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostItemCfgQualityEdit_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
        } else if (obj instanceof DynamicObjectCollection && (rows = costItemCfgQualityDy.getDynamicObjectCollection(key)).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5206\u7ec4\u6761\u4ef6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostItemCfgQualityEdit_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private void fillGroupValue(int qualityDimIndex) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String key = "basedataid" + qualityDimIndex;
        if (6 == qualityDimIndex) {
            dynamicObject.set("groupvalue", (Object)String.valueOf(dynamicObject.getBoolean(key)));
        } else {
            String baseData = "basedataid" + qualityDimIndex;
            DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection(baseData);
            ArrayList<Long> idList = new ArrayList<Long>(rows.size());
            String collect = "";
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject baseDataObj = ((DynamicObject)rows.get(i)).getDynamicObject("fbasedataid");
                Long baseDataId = baseDataObj.getLong("id");
                idList.add(baseDataId);
                collect = idList.stream().map(String::valueOf).collect(Collectors.joining(","));
            }
            dynamicObject.set("groupvalue", (Object)collect);
        }
    }

    private void addBeforeF7Listener() {
        for (int i = 1; i <= 11; ++i) {
            if (i == 6) continue;
            String baseDataKey = "basedataid" + String.valueOf(i);
            BasedataEdit baseEdit = (BasedataEdit)this.getView().getControl(baseDataKey);
            baseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }
}

