/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg.dataimport;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcommon.CostProgressCommonHelper;
import kd.swc.pcs.common.constants.CostCfgImportConstants;

public class CostCfgImportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_BTNCLOSE = "btn_close";
    private static final String NUM_CONTENT_LABEL = "numcontentlabel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndetails"});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
        this.setShowProgressInfo();
    }

    public void onProgress(ProgressEvent progressEvent) {
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        Double progress = (Double)cache.get("progress", Double.class);
        if (Objects.nonNull(progress)) {
            this.setProgress(progressEvent, progress);
        } else {
            progressEvent.setProgress(0);
            progressEvent.setText(ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u59cb\uff0c\u8bf7\u7a0d\u5019...", (String)"CostCfgImportProgressPlugin_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String controlKey;
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btndetails": {
                this.clickErrorDetails();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        String url = (String)cache.get("url", String.class);
        String isSuccess = (String)cache.get("issuccess", String.class);
        HashMap<String, String> returnData = new HashMap<String, String>(1);
        if (SWCStringUtils.isNotEmpty((String)url) || "false".equals(isSuccess)) {
            returnData.put("issuccess", "false");
        } else {
            returnData.put("issuccess", "true");
        }
        this.getView().returnDataToParent(returnData);
    }

    private void clickErrorDetails() {
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        String url = (String)cache.get("url", String.class);
        if (SWCStringUtils.isNotEmpty((String)url)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)url);
            this.getView().close();
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CostCfgImportProgressPlugin_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void setProgress(ProgressEvent progressEvent, Double progress) {
        String text = progress + "%";
        if (progress >= CostCfgImportConstants.DOUBLE_HUNDRED) {
            IPageCache pageCache = this.getView().getPageCache();
            String isClose = pageCache.get("isclose");
            if ("1".equals(isClose)) {
                SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
                String url = (String)cache.get("url", String.class);
                String isSuccess = (String)cache.get("issuccess", String.class);
                if (SWCStringUtils.isNotEmpty((String)url) || "false".equals(isSuccess)) {
                    this.setImportResultNum();
                    CostProgressCommonHelper.updateImportFailImage((IFormView)this.getView());
                    this.getView().setVisible(Boolean.TRUE, new String[]{"errorinfopanel", KEY_BTNCLOSE, NUM_CONTENT_LABEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"contentlabel"});
                    text = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostCfgImportProgressPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                    progressEvent.setProgress(CostCfgImportConstants.DOUBLE_HUNDRED.intValue());
                    progressEvent.setText(text);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"CostCfgImportProgressPlugin_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().close();
                }
            } else {
                progressEvent.setProgress(CostCfgImportConstants.DOUBLE_NINETY_NINE.intValue());
                pageCache.put("isclose", "1");
            }
        } else {
            progressEvent.setProgress(progress.intValue());
            progressEvent.setText(text);
        }
        String content = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165({0}%)", (String)"CostCfgImportProgressPlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[]{progress});
        Label contentLabel = (Label)this.getControl("contentlabel");
        contentLabel.setText(content);
    }

    private void setImportResultNum() {
        SWCPageCache parentCache = new SWCPageCache(this.getView().getParentView());
        Integer total = (Integer)parentCache.get("importexceltotalrow", Integer.class);
        Integer saveExcelRows = (Integer)parentCache.get("importexcelsaverow", Integer.class);
        String message = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"CostCfgImportProgressPlugin_6", (String)"swc-pcs-formplugin", (Object[])new Object[]{total, saveExcelRows, total - saveExcelRows});
        Label label = (Label)this.getControl(NUM_CONTENT_LABEL);
        label.setText(message);
    }

    private void setShowProgressInfo() {
        String title = (String)this.getView().getFormShowParameter().getCustomParam("title");
        Label titleLabel = (Label)this.getControl("titlelabel");
        titleLabel.setText(title);
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        Double progress = (Double)cache.get("progress", Double.class);
        if (progress == null) {
            progress = 0.0;
        }
        String content = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165({0}%)", (String)"CostCfgImportProgressPlugin_5", (String)"swc-pcs-formplugin", (Object[])new Object[]{progress});
        Label contentLabel = (Label)this.getControl("contentlabel");
        contentLabel.setText(content);
        this.getView().setVisible(Boolean.FALSE, new String[]{"errorinfopanel", KEY_BTNCLOSE, NUM_CONTENT_LABEL});
    }
}

