/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costmap;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costmap.service.CostItemMapService;

public class CostPayRollCalMapEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostPayRollCalMapEdit.class);
    private CostItemMapService costItemMapService = new CostItemMapService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit hrOrgEdit = (BasedataEdit)this.getView().getControl("hrorg");
        hrOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollCalEdit = (BasedataEdit)this.getView().getControl("payrollcal");
        payRollCalEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryItemEdit = (BasedataEdit)this.getView().getControl("salaryitem");
        salaryItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costItemEdit = (BasedataEdit)this.getView().getControl("costitem");
        costItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long costMapObjId = this.costItemMapService.getCostMapObjId("hsbs_salaryitem");
        this.getView().getModel().setValue("mapobj", (Object)costMapObjId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String salaryItemName = this.getView().getModel().getDataEntity().getString("salaryitem.name");
        UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)salaryItemName);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        boolean isHisVersionFlag = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        if (isHisVersionFlag) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"salaryitem", "hrorg", "payrollcal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "payrollcal": {
                this.costItemMapService.orgChange(e, "salaryitem", this.getView());
                break;
            }
            case "hrorg": {
                this.costItemMapService.orgChange(e, "costitem", this.getView());
                break;
            }
            case "salaryitem": {
                this.getView().getModel().setValue("costitem", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String baseDataName;
        switch (baseDataName = beforeF7SelectEvent.getProperty().getName()) {
            case "payrollcal": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costpayrollcalmap", (String)"47150e89000000ac");
                if (payRollCalSet == null) break;
                QFilter payRollCalFilter = new QFilter("id", "in", (Object)payRollCalSet);
                beforeF7SelectEvent.addCustomQFilter(payRollCalFilter);
                break;
            }
            case "hrorg": {
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, baseDataName));
                break;
            }
            case "salaryitem": {
                this.addSalaryItemF7Filter(beforeF7SelectEvent);
                break;
            }
            case "costitem": {
                this.addCostItemF7Filter(beforeF7SelectEvent);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.costItemMapService.updateParentView(args, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String billName = this.getModel().getDataEntityType().getName();
        if ("pcs_costpayrollcalmap".equals(billName)) {
            this.costItemMapService.costMapCloseCallBack(closedCallBackEvent, this.getView(), CostPayRollCalMapEdit.class.getName());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if ("payrollcal".equals(callBackId)) {
                this.getView().getModel().setValue("salaryitem", null);
            } else if ("hrorg".equals(callBackId)) {
                this.getView().getModel().setValue("costitem", null);
            }
            SWCPageCache swcPageCache = new SWCPageCache(this.getView());
            Long newValue = (Long)swcPageCache.get("newValue", Long.class);
            this.getView().getModel().setValue(callBackId, (Object)newValue);
        }
    }

    private void addSalaryItemF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        long payRollCalOrgId = this.getView().getModel().getDataEntity().getLong("payrollcal.id");
        if (payRollCalOrgId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostPayRollCalMapEdit_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        long id = this.getView().getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            id = this.getView().getModel().getDataEntity().getLong("boid");
        }
        long hrOrgId = this.getView().getModel().getDataEntity().getLong("hrorg.id");
        Set calExistSalaryItemIdList = this.costItemMapService.getCalDBExistSalaryItemIdList(hrOrgId, payRollCalOrgId, id, "hsbs_salaryitem");
        QFilter qFilter = new QFilter("datatype", "=", (Object)1020L);
        if (!calExistSalaryItemIdList.isEmpty()) {
            qFilter.and(new QFilter("id", "not in", (Object)calExistSalaryItemIdList));
        }
        logger.info("CostPayRollCalMapEdit addSalaryItemF7Filter : {}", (Object)qFilter);
        beforeF7SelectEvent.addCustomQFilter(qFilter);
    }

    private void addCostItemF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        long salaryItemId = this.getView().getModel().getDataEntity().getLong("salaryitem.id");
        if (salaryItemId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u85aa\u916c\u9879\u76ee\u201d\u3002", (String)"CostPayRollCalMapEdit_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String areaType = this.getView().getModel().getDataEntity().getString("salaryitem.areatype");
        if ("1".equals(areaType)) {
            QFilter areaTypeQFilter = new QFilter("areatype", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(areaTypeQFilter);
        } else if ("2".equals(areaType)) {
            long countryId = this.getView().getModel().getDataEntity().getLong("salaryitem.country.id");
            QFilter qFilter = new QFilter("country", "=", (Object)countryId);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }
}

