/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costsetup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.rpc.holders.IntHolder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hscs.common.events.CostCfgTypeDeptArgs;
import kd.sdk.swc.hscs.service.api.ICostSetUpService;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostCustomCreateEntryHelper;
import kd.swc.pcs.business.costcfg.CostSetUpExtService;
import kd.swc.pcs.business.costcfg.CostSetUpHelper;

public class CalculateChainPlugin
extends AbstractFormPlugin {
    protected static final Log logger = LogFactory.getLog(CalculateChainPlugin.class);
    private static final String SWC_PCS_FORMPLUGIN = "swc-pcs-formplugin";
    private static final String CALRESULTENTITY = "calresultentity";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"pcs_calculatechain", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String costSetUpIdStr = (String)formShowParameter.getCustomParam("costsetupid");
        long costSetUpId = Long.parseLong(costSetUpIdStr);
        if (costSetUpId == 0L) {
            return;
        }
        DynamicObject setUpRstQueryResult = CostSetUpHelper.queryCostSetUpByPkId((Long)costSetUpId);
        long costStruId = setUpRstQueryResult.getLong("costadapter.coststru.id");
        if (costStruId == 0L) {
            return;
        }
        IAppCache appCache = AppCache.get((String)("cache_coststruid_key" + formShowParameter.getParentPageId()));
        appCache.put("cache_coststruid_key" + formShowParameter.getParentPageId(), (Object)costStruId);
        List<EntryFieldAp> pcsDataFieldApList = this.batchDynamicCreateFieldAp(entityMetadata, costStruId, "0");
        EntryAp entryAp = CostSetUpHelper.createDynamicEntryAp((String)"entryentity");
        entryAp.getItems().addAll(pcsDataFieldApList);
        List<EntryFieldAp> calResultDataFieldApList = this.batchDynamicCreateFieldAp(entityMetadata, costStruId, "1");
        EntryAp calResultEntityAp = CostSetUpHelper.createDynamicEntryAp((String)CALRESULTENTITY);
        calResultEntityAp.getItems().addAll(calResultDataFieldApList);
        e.getItems().add(this.getEntryMap(entryAp, "entryentity"));
        e.getItems().add(this.getEntryMap(calResultEntityAp, CALRESULTENTITY));
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        String parentPageId = this.getView().getParentView().getPageId();
        IAppCache appCache = AppCache.get((String)("cache_coststruid_key" + parentPageId));
        Long costStruId = (Long)appCache.get("cache_coststruid_key" + parentPageId, Long.class);
        if (costStruId == null || costStruId == 0L) {
            return;
        }
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStruId, null, (String)"");
        List pcsColumnList = CostSetUpHelper.addNewFixColumn((List)dimensionObjList, (String)"0");
        for (DynamicObject dimensionObj : pcsColumnList) {
            CostSetUpHelper.createPropByType((MainEntityType)newMainType, (DynamicObject)dimensionObj, (String)"entryentity");
        }
        List calResultColumnList = CostSetUpHelper.addNewFixColumn((List)dimensionObjList, (String)"1");
        for (DynamicObject dimensionObj : calResultColumnList) {
            CostSetUpHelper.createPropByType((MainEntityType)newMainType, (DynamicObject)dimensionObj, (String)CALRESULTENTITY);
        }
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        EntryAp dynamicEntryAp = CostCustomCreateEntryHelper.createDynamicEntryAp();
        EntryAp calDynamicEntryAp = CostCustomCreateEntryHelper.createCalDynamicEntryAp();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"pcs_calculatechain", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String costSetUpIdStr = (String)formShowParameter.getCustomParam("costsetupid");
        long costSetUpId = Long.parseLong(costSetUpIdStr);
        if (costSetUpId == 0L) {
            return;
        }
        DynamicObject setUpRstQueryResult = CostSetUpHelper.queryCostSetUpByPkId((Long)costSetUpId);
        long costStruId = setUpRstQueryResult.getLong("costadapter.coststru.id");
        if (costStruId == 0L) {
            return;
        }
        CostSetUpHelper.dynamicCreateEntryApItem((EntryAp)dynamicEntryAp, (EntityMetadata)entityMetadata, (Long)costStruId, (String)"0");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        CostSetUpHelper.dynamicCreateEntryApItem((EntryAp)calDynamicEntryAp, (EntityMetadata)entityMetadata, (Long)costStruId, (String)"1");
        EntryGrid calResultEntityGrid = (EntryGrid)this.getView().getControl(CALRESULTENTITY);
        List calResultFieldEdits = ((Container)calDynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : calResultFieldEdits) {
            fieldEdit.setView(this.getView());
            calResultEntityGrid.getItems().add(fieldEdit);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        List<Long> sourceIdList;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String costSetUpIdStr = (String)formShowParameter.getCustomParam("costsetupid");
        long costSetUpId = Long.parseLong(costSetUpIdStr);
        if (costSetUpId == 0L) {
            return;
        }
        DynamicObject costSetupRstObj = CostSetUpHelper.queryCostSetUpObjBykId((Long)costSetUpId);
        long salaryFileId = costSetupRstObj.getLong("salaryfile.id");
        long salaryItemId = costSetupRstObj.getLong("salaryitem.id");
        long costAdapterId = costSetupRstObj.getLong("costadapter.id");
        long costStruId = costSetupRstObj.getLong("costadapter.coststru.id");
        long payrollGroupId = costSetupRstObj.getLong("caltask.payrollgroup.id");
        Date calTaskEndDate = costSetupRstObj.getDate("caltask.ENDDATE");
        long calTaskId = costSetupRstObj.getLong("caltask.id");
        DynamicObject salaryFileObj = CostSetUpHelper.querySalaryFile((long)salaryFileId);
        long jobId = salaryFileObj.getLong("empposinfo.job.id");
        long empId = salaryFileObj.getLong("employee.id");
        DynamicObject calPersonDy = CostSetUpHelper.getCalPersonDyByTaskFileId((Long)calTaskId, (Long)salaryFileId);
        long deptId = calPersonDy.getLong("empposorgrelhrv.adminorg.id");
        long posId = calPersonDy.getLong("empposorgrelhrv.position.id");
        long queryAdminOrgId = this.queryParentAdminOrgId(deptId, costAdapterId, calTaskEndDate);
        logger.info("CalculateChainPlugin createNewData deptId={},queryAdminOrgId={}", (Object)deptId, (Object)queryAdminOrgId);
        if (queryAdminOrgId != 0L) {
            deptId = queryAdminOrgId;
        }
        if (CollectionUtils.isEmpty(sourceIdList = this.mergeResult(salaryFileId, salaryItemId, deptId, posId, jobId, payrollGroupId, empId))) {
            return;
        }
        Long[] sourceResultIdList = sourceIdList.toArray(new Long[0]);
        DynamicObject[] costCfgHisCurrentArray = CostSetUpHelper.queryCostCfgCurrent((Long)costAdapterId, (Long[])sourceResultIdList);
        List<Long> enableBoIdList = this.getEnableIdList(costCfgHisCurrentArray);
        calTaskEndDate = CostSetUpHelper.convertDate((Date)calTaskEndDate);
        DynamicObject[] costCfgHisArr = CostSetUpHelper.queryCostCfgHis((Long)costAdapterId, (Long[])sourceResultIdList, (Date)calTaskEndDate, enableBoIdList);
        ArrayList<Long> costBizObjIdList = new ArrayList<Long>(costCfgHisArr.length);
        ArrayList<Long> segmentIdList = new ArrayList<Long>(10);
        this.initSegmentIdList(enableBoIdList, costCfgHisArr, costBizObjIdList, segmentIdList);
        DynamicObject costStruObj = CostAllocationHelper.queryCostStruObjById((Long)costStruId);
        Map<String, String> dimensionRefSegmentIndexMap = this.getDimensionIdRefSegmentIndexMap(costStruObj);
        Map<String, DynamicObject> dimensionIdRefMap = this.getDimensionIdRefMap(costStruObj);
        Map<String, Map<String, List<Map<String, String>>>> costCfgInfoMap = this.packegeCostCfgInfo(costCfgHisArr, segmentIdList, dimensionRefSegmentIndexMap, salaryFileId);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        this.insertCostCfgInfoIntoEntity(costSetupRstObj, costBizObjIdList, costCfgInfoMap, rows);
        DynamicObjectCollection setUpEntity = costSetupRstObj.getDynamicObjectCollection("entryentity");
        ArrayList<Long> setupConstIdList = new ArrayList<Long>(setUpEntity.size());
        setUpEntity.forEach(entity -> setupConstIdList.add(entity.getLong("aotucostsetupconst.id")));
        DynamicObjectCollection calResultEntityRows = dataEntity.getDynamicObjectCollection(CALRESULTENTITY);
        this.insertCalResultIntoEntity(costSetupRstObj, dimensionRefSegmentIndexMap, calResultEntityRows, setUpEntity, setupConstIdList, dimensionIdRefMap);
        e.setDataEntity((Object)dataEntity);
    }

    private List<Long> getEnableIdList(DynamicObject[] costCfgHisCurrentArray) {
        ArrayList<Long> enableBoIdList = new ArrayList<Long>(10);
        for (DynamicObject costCfgHisCurrentDy : costCfgHisCurrentArray) {
            long boId = costCfgHisCurrentDy.getLong("boid");
            enableBoIdList.add(boId);
        }
        return enableBoIdList;
    }

    private void initSegmentIdList(List<Long> enableBoIdList, DynamicObject[] costCfgHisArr, List<Long> costBizObjIdList, List<Long> segmentIdList) {
        if (!CollectionUtils.isEmpty(enableBoIdList)) {
            for (DynamicObject costCfgHis : costCfgHisArr) {
                costBizObjIdList.add(costCfgHis.getLong("sourcetype.id"));
                DynamicObjectCollection costCfgEntry = costCfgHis.getDynamicObjectCollection("costcfgentryentity");
                costCfgEntry.forEach(costCfg -> segmentIdList.add(costCfg.getLong("costsegstore.id")));
                DynamicObjectCollection costCfgTypeEntry = costCfgHis.getDynamicObjectCollection("costcfgtypeentryentity");
                costCfgTypeEntry.forEach(costCfg -> segmentIdList.add(costCfg.getLong("costtypesegstore.id")));
            }
        }
    }

    private Map<String, DynamicObject> getDimensionIdRefMap(DynamicObject costStruObj) {
        DynamicObjectCollection dimensionEntry = costStruObj.getDynamicObjectCollection("dimensionentry");
        HashMap<String, DynamicObject> dimensionRefBaseDataNumberMap = new HashMap<String, DynamicObject>(dimensionEntry.size());
        dimensionEntry.forEach(entry -> dimensionRefBaseDataNumberMap.put(entry.getString("costdimension.id"), entry.getDynamicObject("costdimension")));
        return dimensionRefBaseDataNumberMap;
    }

    private long queryParentAdminOrgId(long deptId, long costAdapterId, Date calTaskEndDate) {
        long queryAdminOrgId = 0L;
        if (deptId == 0L) {
            return queryAdminOrgId;
        }
        DynamicObject[] adminOrgCostCfgHisArr = CostSetUpHelper.queryAdminOrgCostCfgHis((long)costAdapterId, (Date)calTaskEndDate);
        ArrayList<Long> adminOrgIdList = new ArrayList<Long>(10);
        if (adminOrgCostCfgHisArr.length == 0) {
            return queryAdminOrgId;
        }
        HashMap<Long, Long> costCfgDeptMap = new HashMap<Long, Long>(16);
        for (DynamicObject adminOrgCostCfgDy : adminOrgCostCfgHisArr) {
            adminOrgIdList.add(adminOrgCostCfgDy.getLong("source.id"));
            costCfgDeptMap.put(adminOrgCostCfgDy.getLong("source.id"), adminOrgCostCfgDy.getLong("id"));
        }
        if (adminOrgIdList.isEmpty()) {
            return queryAdminOrgId;
        }
        Map costCfgAdminOrgMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{adminOrgIdList, new Date(), Boolean.TRUE});
        logger.info("CalculateChainPlugin queryParentAdminOrgId costCfgAdminOrgMap={},adminOrgIdList={}", (Object)costCfgAdminOrgMap, adminOrgIdList);
        HashMap<String, String> adminOrgStructNumberMap = new HashMap<String, String>(16);
        if (costCfgAdminOrgMap != null && !costCfgAdminOrgMap.isEmpty()) {
            for (Map.Entry next : costCfgAdminOrgMap.entrySet()) {
                String key = (String)next.getKey();
                Map value = (Map)next.getValue();
                Object structNumber = value.get("structnumber");
                adminOrgStructNumberMap.put(String.valueOf(structNumber), key);
            }
        }
        Map adminOrgDataMap = AdminOrgHelper.getAdminOrgDataMap((Long)deptId);
        logger.info("CalculateChainPlugin queryParentAdminOrgId getAdminOrgDataMap adminOrgDataMap={}", (Object)adminOrgDataMap);
        if (adminOrgDataMap != null && !adminOrgDataMap.isEmpty()) {
            Object longNumberObj = adminOrgDataMap.get("longnumber");
            String longNumber = String.valueOf(longNumberObj);
            if (SWCStringUtils.isEmpty((String)longNumber)) {
                return queryAdminOrgId;
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costdeptcfg");
            QFilter filter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
            filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            filter.and(new QFilter("sourcetype.id", "=", (Object)SWCCostConstants.COST_TYPE_DEPT));
            filter.and(new QFilter("source.id", "=", (Object)deptId));
            DynamicObject query = helper.queryOne("enable", new QFilter[]{filter});
            String enable = SWCObjectUtils.isEmpty((Object)query) ? "0" : query.getString("enable");
            CostSetUpExtService extService = new CostSetUpExtService();
            CostCfgTypeDeptArgs costCfgTypeDeptArgs = new CostCfgTypeDeptArgs();
            costCfgTypeDeptArgs.setCostCfgIdList(costCfgDeptMap.values().stream().collect(Collectors.toList()));
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostSetUpService.class, (String)"kd.sdk.swc.hscs.service.api.ICostSetUpService#handleCostCfgDept", null);
            hrPluginProxy.callReplaceIfPresent(proxy -> {
                proxy.setCostTypeDeptInfo(costCfgTypeDeptArgs);
                return null;
            });
            String[] split = longNumber.split("!");
            List<String> splitList = Arrays.asList(split);
            for (int i = splitList.size() - 1; i >= 0; --i) {
                String splitSourceId = (String)adminOrgStructNumberMap.get(splitList.get(i));
                if (SWCStringUtils.isEmpty((String)splitSourceId) || (queryAdminOrgId = Long.parseLong(splitSourceId)) == deptId && "0".equals(enable)) continue;
                if (i >= splitList.size() - 1) break;
                costCfgTypeDeptArgs.setSelectedId((Long)costCfgDeptMap.get(queryAdminOrgId));
                costCfgTypeDeptArgs.setCheckPass(Boolean.TRUE);
                hrPluginProxy.callReplaceIfPresent(proxy -> {
                    proxy.checkCostTypeDept(costCfgTypeDeptArgs);
                    return null;
                });
                if (costCfgTypeDeptArgs.getCheckPass().booleanValue()) break;
                queryAdminOrgId = 0L;
            }
        }
        return queryAdminOrgId;
    }

    private List<Long> mergeResult(long salaryFileId, long salaryItemId, long deptId, long posId, long jobId, long payrollGroupId, long empId) {
        ArrayList<Long> sourceIdList = new ArrayList<Long>(10);
        this.addSourceId(salaryFileId, sourceIdList);
        this.addSourceId(salaryItemId, sourceIdList);
        this.addSourceId(deptId, sourceIdList);
        this.addSourceId(posId, sourceIdList);
        this.addSourceId(jobId, sourceIdList);
        this.addSourceId(payrollGroupId, sourceIdList);
        this.addSourceId(empId, sourceIdList);
        return sourceIdList;
    }

    private void addSourceId(long sourceId, List<Long> sourceIdList) {
        if (sourceId != 0L) {
            sourceIdList.add(sourceId);
        }
    }

    private void insertCalResultIntoEntity(DynamicObject costSetupRstObj, Map<String, String> dimensionRefSegmentIndexMap, DynamicObjectCollection rows, DynamicObjectCollection setUpEntity, List<Long> setupConstIdList, Map<String, DynamicObject> dimensionIdRefBaseDataNumberMap) {
        Map setUpConstObjMap = CostSetUpHelper.querySetUpConstObjByIdList(setupConstIdList);
        String salaryItemName = costSetupRstObj.getString("salaryitem.name");
        IntHolder intHolder = new IntHolder(0);
        setUpEntity.forEach(entity -> {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            ++intHolder.value;
            BigDecimal percentDecimal = entity.getBigDecimal("percentage");
            newRow.set("10002", (Object)percentDecimal.toString());
            Set dimensionSet = dimensionRefSegmentIndexMap.keySet();
            DataEntityPropertyCollection properties = newRow.getDataEntityType().getProperties();
            String constId = entity.getString("aotucostsetupconst.id");
            DynamicObject constSetUpObj = (DynamicObject)setUpConstObjMap.get(constId);
            if (constSetUpObj != null) {
                dimensionSet.forEach(dimension -> {
                    String field = (String)dimension;
                    if (properties.containsKey((Object)field)) {
                        DynamicObject dimensionDy = (DynamicObject)dimensionIdRefBaseDataNumberMap.get(dimension);
                        String valueType = dimensionDy.getString("valuetype");
                        String basedateNumber = "2".equals(valueType) ? "bos_assistantdata_detail" : dimensionDy.getString("valuesource.id");
                        String idValue = CostSetUpHelper.getNameVal((String)constSetUpObj.getString("segment" + (String)dimensionRefSegmentIndexMap.get(field)));
                        if (SWCStringUtils.isNotEmpty((String)basedateNumber)) {
                            QFilter qFilter;
                            SWCDataServiceHelper swcDataServiceHelper;
                            DynamicObject dynamicObject;
                            if (SWCStringUtils.isNotEmpty((String)idValue) && (dynamicObject = (swcDataServiceHelper = new SWCDataServiceHelper(basedateNumber)).queryOne("name,number", new QFilter[]{qFilter = new QFilter("id", "=", (Object)Long.valueOf(idValue))})) != null) {
                                String displayProperty = dimensionDy.getString("displayproperty");
                                if ("1".equals(displayProperty)) {
                                    String number = dynamicObject.getString("number");
                                    newRow.set(field, (Object)number);
                                } else {
                                    String name = dynamicObject.getString("name");
                                    newRow.set(field, (Object)name);
                                }
                            }
                        } else {
                            newRow.set(field, (Object)idValue);
                        }
                    }
                });
            }
            rows.add((Object)newRow);
        });
    }

    private void insertCostCfgInfoIntoEntity(DynamicObject costSetupRstObj, List<Long> costBizObjIdList, Map<String, Map<String, List<Map<String, String>>>> costCfgInfoMap, DynamicObjectCollection rows) {
        Map costBizObjIdRefNameMap = CostSetUpHelper.queryCostBizObjMap(costBizObjIdList);
        String salaryItemName = costSetupRstObj.getString("salaryitem.name");
        for (Map.Entry entry : costBizObjIdRefNameMap.entrySet()) {
            List<Map<String, String>> costTypeCfgList;
            String costBizObjId = (String)entry.getKey();
            Map<String, List<Map<String, String>>> sourceTypeInfoMap = costCfgInfoMap.get(costBizObjId);
            if (sourceTypeInfoMap == null) continue;
            int count = 0;
            List<Map<String, String>> costCfgList = sourceTypeInfoMap.get("COST");
            if (costCfgList != null && !costCfgList.isEmpty()) {
                for (Map<String, String> costCfg : costCfgList) {
                    DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
                    String costBizOBjName = (String)entry.getValue();
                    newRow.set("10001", (Object)(count == 0 ? costBizOBjName : ""));
                    ++count;
                    String costProportion = costCfg.get("costProportion");
                    BigDecimal costProportionDecimal = new BigDecimal(costProportion);
                    if (costProportionDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        newRow.set("10002", (Object)costProportion);
                    }
                    newRow.set("10004", (Object)ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e", (String)"CalculateChainPlugin_1", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
                    Set<String> dimensionSet = costCfg.keySet();
                    DataEntityPropertyCollection properties = newRow.getDataEntityType().getProperties();
                    dimensionSet.forEach(dimension -> {
                        String field = (String)dimension;
                        if (properties.containsKey((Object)field)) {
                            newRow.set(field, costCfg.get(field));
                        }
                    });
                    rows.add((Object)newRow);
                }
            }
            if ((costTypeCfgList = sourceTypeInfoMap.get("PRIORITY")) == null || costTypeCfgList.isEmpty()) continue;
            for (Map<String, String> costCfg : costTypeCfgList) {
                DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
                DataEntityPropertyCollection properties = newRow.getDataEntityType().getProperties();
                String costBizOBjName = (String)entry.getValue();
                newRow.set("10001", (Object)(count == 0 ? costBizOBjName : ""));
                ++count;
                String costProportion = costCfg.get("costProportion");
                BigDecimal costProportionDecimal = new BigDecimal(costProportion);
                if (costProportionDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    newRow.set("10002", (Object)costProportion);
                }
                if (SWCCostConstants.COST_TYPE_ITEM.toString().equals(costBizObjId)) {
                    newRow.set("10004", (Object)ResManager.loadKDString((String)"\u4f18\u5148", (String)"CalculateChainPlugin_2", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    newRow.set("10004", (Object)ResManager.loadKDString((String)"\u515c\u5e95", (String)"CalculateChainPlugin_3", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
                }
                Set<String> dimensionSet = costCfg.keySet();
                dimensionSet.forEach(dimension -> {
                    String field = (String)dimension;
                    if (properties.containsKey((Object)field)) {
                        newRow.set(field, costCfg.get(dimension));
                    }
                });
                rows.add((Object)newRow);
            }
        }
    }

    private Map<String, Map<String, List<Map<String, String>>>> packegeCostCfgInfo(DynamicObject[] costCfgHisArr, List<Long> segmentIdList, Map<String, String> dimensionRefSegmentIndexMap, long salaryfileId) {
        Map constObjMap = CostSetUpHelper.querySegmentObjByIdList(segmentIdList);
        HashMap<String, Map<String, List<Map<String, String>>>> costCfgInfoMap = new HashMap<String, Map<String, List<Map<String, String>>>>(16);
        HashMap<String, List<Map<String, String>>> costItemCfgEntryMap = new HashMap<String, List<Map<String, String>>>(16);
        String key = "";
        boolean flag = false;
        for (DynamicObject costCfgHis : costCfgHisArr) {
            long creatorObjId;
            String sourceType = costCfgHis.getString("sourcetype.id");
            if (SWCCostConstants.COST_TYPE_SALARYFILEITEM.toString().equals(sourceType) && salaryfileId != (creatorObjId = costCfgHis.getLong("creatorobj.id"))) continue;
            boolean isCostItemCfg = SWCCostConstants.COST_TYPE_ITEM.toString().equals(sourceType);
            if (isCostItemCfg) {
                long boId = costCfgHis.getLong("boid");
                DynamicObject costItemCfgDy = this.queryCostCfgById(boId);
                String qualityNumber = costItemCfgDy.getString("qualitynumber");
                Long sourceId = costItemCfgDy.getLong("source.id");
                if (SWCStringUtils.isNotEmpty((String)qualityNumber)) {
                    Long longVal;
                    String groupValue = costItemCfgDy.getString("groupvalue");
                    String salaryFileField = costItemCfgDy.getString("qualitydim.salaryfilefield");
                    DynamicObject salaryFileDy = CalculateChainPlugin.querySalaryFile(salaryfileId, salaryFileField);
                    Object costCfgQualityValue = salaryFileDy.get(salaryFileField);
                    if (costCfgQualityValue instanceof Long && SWCStringUtils.equals((String)groupValue, (String)String.valueOf(longVal = (Long)costCfgQualityValue))) {
                        flag = true;
                        key = String.join((CharSequence)"_", sourceId.toString(), salaryFileField, groupValue);
                    }
                } else {
                    key = sourceId.toString();
                }
            }
            DynamicObjectCollection costCfgEntryColl = costCfgHis.getDynamicObjectCollection("costcfgentryentity");
            HashMap<String, List<Map<String, String>>> costSourceTypeRefObjMap = new HashMap<String, List<Map<String, String>>>(costCfgEntryColl.size());
            List<Map<String, String>> costSegStoreList = this.getCostSegStoreList(dimensionRefSegmentIndexMap, constObjMap, costCfgEntryColl);
            if (isCostItemCfg) {
                if (flag) {
                    costItemCfgEntryMap.put("costqualitycfg" + key, costSegStoreList);
                } else {
                    costItemCfgEntryMap.put("costcfg" + key, costSegStoreList);
                }
            }
            costSourceTypeRefObjMap.put("COST", costSegStoreList);
            DynamicObjectCollection costPriorityCfgEntryColl = costCfgHis.getDynamicObjectCollection("costcfgtypeentryentity");
            List<Map<String, String>> costPrioritySegStoreList = this.getCostPrioritySegStoreList(dimensionRefSegmentIndexMap, constObjMap, costPriorityCfgEntryColl);
            if (isCostItemCfg) {
                if (flag) {
                    costItemCfgEntryMap.put("costqualitycfgtype" + key, costPrioritySegStoreList);
                } else {
                    costItemCfgEntryMap.put("costcfgtype" + key, costPrioritySegStoreList);
                }
            }
            costSourceTypeRefObjMap.put("PRIORITY", costPrioritySegStoreList);
            costCfgInfoMap.put(sourceType, costSourceTypeRefObjMap);
        }
        this.updateCostItemValue(key, flag, costCfgInfoMap, costItemCfgEntryMap);
        return costCfgInfoMap;
    }

    private DynamicObject queryCostCfgById(long boId) {
        SWCDataServiceHelper costItemCfgHelper = new SWCDataServiceHelper("pcs_costitemcfg");
        QFilter filter = new QFilter("id", "=", (Object)boId);
        return costItemCfgHelper.queryOne("id,source,qualitynumber,qualitydim,groupvalue", new QFilter[]{filter});
    }

    private List<Map<String, String>> getCostPrioritySegStoreList(Map<String, String> dimensionRefSegmentIndexMap, Map<String, DynamicObject> constObjMap, DynamicObjectCollection costPriorityCfgEntryColl) {
        ArrayList<Map<String, String>> costPrioritySegStoreList = new ArrayList<Map<String, String>>(10);
        for (DynamicObject costPriorityCfgEntry : costPriorityCfgEntryColl) {
            Long costSegStoreId = costPriorityCfgEntry.getLong("costtypesegstore.id");
            BigDecimal costProportion = costPriorityCfgEntry.getBigDecimal("costcfgtypeproportion");
            DynamicObject costSegStoreObj = constObjMap.get(costSegStoreId.toString());
            if (costSegStoreObj == null) continue;
            BigDecimal resultCostProportion = costProportion.setScale(2, 4);
            HashMap<String, String> salaryItemCfgMap = new HashMap<String, String>(16);
            salaryItemCfgMap.put("costProportion", resultCostProportion.toString());
            salaryItemCfgMap.put("costStruCfgValue", costPriorityCfgEntry.getString("coststrutypecfgvalue"));
            this.putNameValue(dimensionRefSegmentIndexMap, costSegStoreObj, salaryItemCfgMap);
            costPrioritySegStoreList.add(salaryItemCfgMap);
        }
        return costPrioritySegStoreList;
    }

    private List<Map<String, String>> getCostSegStoreList(Map<String, String> dimensionRefSegmentIndexMap, Map<String, DynamicObject> constObjMap, DynamicObjectCollection costCfgEntryColl) {
        ArrayList<Map<String, String>> costSegStoreList = new ArrayList<Map<String, String>>(10);
        for (DynamicObject costCfgEntry : costCfgEntryColl) {
            Long costSegStoreId = costCfgEntry.getLong("costsegstore.id");
            BigDecimal costProportion = costCfgEntry.getBigDecimal("calcostproportion");
            DynamicObject costSegStoreObj = constObjMap.get(costSegStoreId.toString());
            if (costSegStoreObj == null) continue;
            BigDecimal resultCostProportion = costProportion.setScale(2, 4);
            HashMap<String, String> salaryItemCfgMap = new HashMap<String, String>(16);
            salaryItemCfgMap.put("costProportion", resultCostProportion.toString());
            salaryItemCfgMap.put("costStruCfgValue", costCfgEntry.getString("coststrucfgvalue"));
            this.putNameValue(dimensionRefSegmentIndexMap, costSegStoreObj, salaryItemCfgMap);
            costSegStoreList.add(salaryItemCfgMap);
        }
        return costSegStoreList;
    }

    private void updateCostItemValue(String key, boolean flag, Map<String, Map<String, List<Map<String, String>>>> costCfgInfoMap, Map<String, List<Map<String, String>>> costItemCfgEntryMap) {
        HashMap<String, List<Map<String, String>>> costSourceTypeRefObjMap = new HashMap<String, List<Map<String, String>>>(16);
        if (flag) {
            costSourceTypeRefObjMap.put("COST", costItemCfgEntryMap.get("costqualitycfg" + key));
            costSourceTypeRefObjMap.put("PRIORITY", costItemCfgEntryMap.get("costqualitycfgtype" + key));
        } else {
            costSourceTypeRefObjMap.put("COST", costItemCfgEntryMap.get("costcfg" + key));
            costSourceTypeRefObjMap.put("PRIORITY", costItemCfgEntryMap.get("costcfgtype" + key));
        }
        costCfgInfoMap.put(SWCCostConstants.COST_TYPE_ITEM.toString(), costSourceTypeRefObjMap);
    }

    public static DynamicObject querySalaryFile(Long salaryFileId, String salaryFileField) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter numberFilter = new QFilter("id", "=", (Object)salaryFileId);
        return serviceHelper.queryOne(salaryFileField, new QFilter[]{numberFilter});
    }

    private void putNameValue(Map<String, String> dimensionRefSegmentIndexMap, DynamicObject costSegStoreObj, Map<String, String> salaryItemCfgMap) {
        for (Map.Entry<String, String> entry : dimensionRefSegmentIndexMap.entrySet()) {
            salaryItemCfgMap.put(entry.getKey(), CostSetUpHelper.getNameVal((String)costSegStoreObj.getString("segment" + entry.getValue())));
        }
    }

    private Map<String, String> getDimensionIdRefSegmentIndexMap(DynamicObject costStruObj) {
        DynamicObjectCollection dimensionEntry = costStruObj.getDynamicObjectCollection("dimensionentry");
        HashMap<String, String> dimensionRefSegmentIndexMap = new HashMap<String, String>(dimensionEntry.size());
        dimensionEntry.forEach(entry -> dimensionRefSegmentIndexMap.put(entry.getString("costdimension.id"), entry.getString("storageset.number")));
        return dimensionRefSegmentIndexMap;
    }

    private List<EntryFieldAp> batchDynamicCreateFieldAp(EntityMetadata entityMetadata, Long costStrutId, String type) {
        ArrayList<EntryFieldAp> fieldApList = new ArrayList<EntryFieldAp>(10);
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStrutId, null, (String)"");
        List newColumnList = CostSetUpHelper.addNewFixColumn((List)dimensionObjList, (String)type);
        for (DynamicObject dimensionObj : newColumnList) {
            EntryFieldAp fieldAp = CostSetUpHelper.createEntryFieldByType((EntityMetadata)entityMetadata, (DynamicObject)dimensionObj);
            if (fieldAp == null) continue;
            fieldApList.add(fieldAp);
        }
        return fieldApList;
    }

    private Map<String, Object> getEntryMap(EntryAp entryAp, String entryKey) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>(2);
        entryMap.put("id", entryKey);
        entryMap.put("columns", entryAp.createControl().get("columns"));
        return entryMap;
    }
}

