/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costsetup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostSetUpHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costcustomize.service.CostSetUpExportService;
import kd.swc.pcs.business.costmap.service.CostItemMapService;

public class CostSetUpList
extends SWCDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(CostSetUpList.class);
    public static final String SWC_PCS_FORMPLUGIN = "swc-pcs-formplugin";

    public void setFilter(SetFilterEvent args) {
        super.setFilter(args);
        args.setOrderBy("salaryfile.id asc,salaryitem.id asc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "costitem.id": 
            case "costitem.name": {
                CostItemMapService costItemMapService = new CostItemMapService();
                costItemMapService.addCostItemFilter(filters, "pcs_costsetuprst");
                break;
            }
            case "salaryitem.id": 
            case "salaryitem.name": {
                CostItemMapService service = new CostItemMapService();
                service.addSalaryItemFilter(filters, "pcs_costsetuprst");
                break;
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        this.checkExclusion();
    }

    private void checkExclusion() {
        Long costAllocationPkId = (Long)this.getView().getFormShowParameter().getCustomParam("costAllocationPkId");
        try (DataMutex dataMutex = DataMutex.create();){
            String groupId = MutexHelper.getMutexGroupId((String)"pcs_costallocation", (String)"donothing");
            Map mutex = dataMutex.getLockInfo(costAllocationPkId.toString(), groupId, "pcs_costallocation");
            if (null != mutex && !mutex.isEmpty()) {
                String usetId = (String)mutex.get("userid");
                String userName = CostSetUpHelper.getUserNameById((String)usetId);
                String errorMsg = SWCStringUtils.isEmpty((String)userName) ? ResManager.loadKDString((String)"\u6709\u7528\u6237\u6b63\u5728\u7f16\u8f91\u6b64\u6210\u672c\u5206\u644a\u7ed3\u6784\uff0c\u4ec5\u5141\u8bb8\u67e5\u770b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CostSetUpList_11", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"{0}\u6b63\u5728\u7f16\u8f91\u6b64\u6210\u672c\u5206\u644a\u7ed3\u6784\uff0c\u4ec5\u5141\u8bb8\u67e5\u770b\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CostSetUpList_12", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[]{userName});
                this.getPageCache().put("isLock", "1");
                this.getView().showErrorNotification(errorMsg);
                this.getView().setEnable(Boolean.FALSE, new String[]{"generatecostsetup", "delete", "listoperationcolumnap3"});
            } else {
                MutexHelper.require((String)"pcs_costallocation", (Object)costAllocationPkId, (String)"donothing", (StringBuilder)new StringBuilder());
            }
        }
        catch (IOException e) {
            return;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        args.setCancel(true);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = clickEvent.getCurrentRow();
        Long costSetUpId = (Long)currentRow.getPrimaryKeyValue();
        boolean isExist = CostSetUpHelper.isExistSetUp((Long)costSetUpId);
        if (!isExist) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostSetUpList_1", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Long entryPrimaryKeyValue = (Long)currentRow.getEntryPrimaryKeyValue();
        switch (fieldName = args.getFieldName()) {
            case "caltask_name": {
                Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
                ListShowParameter calTaskShowParameter = CostSetUpHelper.getCalTableListForm((String)this.getView().getPageId(), (long)calTaskId);
                this.getView().showForm((FormShowParameter)calTaskShowParameter);
                break;
            }
            case "aotucostsetupconstval": {
                this.openCostDimensionPage(entryPrimaryKeyValue, costSetUpId);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_generatecostsetup": {
                IFormView view = this.getView();
                Long calTaskId = (Long)view.getFormShowParameter().getCustomParam("calTaskId");
                Long costAdapterId = CostCommonHelper.queryCostAdapterIdByCalTaskId((Long)calTaskId);
                LOGGER.info("costAdapterId is {}", (Object)costAdapterId);
                if (costAdapterId == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5206\u644a\u7ed3\u6784\uff0c\u56e0\u4e3a\u201c\u6838\u7b97\u4efb\u52a1\u201d\u6240\u5c5e\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u6ca1\u6709\u5339\u914d\u7684\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3002", (String)"CostSetUpList_13", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.getView().getPageCache().put("costAdapterId", costAdapterId.toString());
                HashMap<Long, Long> calTaskCostAdapterIdRlsMap = new HashMap<Long, Long>(16);
                calTaskCostAdapterIdRlsMap.put(calTaskId, costAdapterId);
                this.getView().getPageCache().put("calTaskCostAdapterIdRlsMap", JSON.toJSONString(calTaskCostAdapterIdRlsMap));
                CostAllocationHelper.openCostGenerateScheme((IFormView)this.getView(), (String)((Object)((Object)this)).getClass().getName());
                break;
            }
            case "costsetupcustomize": {
                this.openViewByFormId(this.getView(), "pcs_costcustomizescheme");
                break;
            }
            case "costsetupmodify": {
                this.openCostSetUpHistory();
                break;
            }
            case "donothing_calculatechain": {
                this.openViewByFormId(this.getView(), "pcs_calculatechain");
                break;
            }
            case "donothing_viewreport": {
                this.openCostRecord("");
                break;
            }
            case "donothing_export": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null) {
                    return;
                }
                CostSetUpExportService costSetUpExportService = new CostSetUpExportService();
                costSetUpExportService.doExport(this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actId) {
            case "pcs_costcustomizescheme": {
                CostSetUpHelper.saveCostUpCustomizeInfo((ClosedCallBackEvent)event, (IFormView)this.getView());
                break;
            }
            case "pcs_costgeneratescheme": {
                CostAllocationHelper.setCostInfoToCache((ClosedCallBackEvent)event, (IFormView)this.getView());
                CostAllocationHelper.preGenerateSetUp((IFormView)this.getView(), (String)((Object)((Object)this)).getClass().getName());
                break;
            }
            case "pcs_costallocationprog": {
                Map returnDataMap;
                String operationkey;
                if (returnData instanceof Map && "viewrecord".equals(operationkey = String.valueOf((returnDataMap = (Map)returnData).get("operationkey")))) {
                    String costAllocationRecordId = String.valueOf(returnDataMap.get("costallocationrecordid"));
                    this.openCostRecord(costAllocationRecordId);
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        try (DataMutex dataMutex = DataMutex.create();){
            Long currentUserId;
            String usetId;
            Long costAllocationPkId = (Long)this.getView().getFormShowParameter().getCustomParam("costAllocationPkId");
            String groupId = MutexHelper.getMutexGroupId((String)"pcs_costallocation", (String)"donothing");
            Map mutex = dataMutex.getLockInfo(costAllocationPkId.toString(), groupId, "pcs_costallocation");
            if (null != mutex && !mutex.isEmpty() && SWCStringUtils.equals((String)(usetId = (String)mutex.get("userid")), (String)String.valueOf(currentUserId = Long.valueOf(RequestContext.get().getCurrUserId())))) {
                MutexHelper.release((String)"pcs_costallocation", (String)"donothing", (String)costAllocationPkId.toString());
            }
        }
        catch (IOException exception) {
            return;
        }
    }

    private void openCostDimensionPage(Long entryPrimaryKeyValue, Long costSetUpId) {
        Long constId = CostSetUpHelper.getEntryInfoByEntryPkId((Long)entryPrimaryKeyValue, (Long)costSetUpId);
        DynamicObject costSetUpConstObj = CostSetUpHelper.querySetUpConstObjById((Long)constId);
        if (costSetUpConstObj == null) {
            return;
        }
        Long costStruId = costSetUpConstObj.getLong("coststru.id");
        DynamicObject costStruObj = CostAllocationHelper.queryCostStruObjById((Long)costStruId);
        if (costStruObj == null) {
            return;
        }
        DynamicObjectCollection dimensionEntry = costStruObj.getDynamicObjectCollection("dimensionentry");
        HashMap dimensionRefSegmentIndexMap = new HashMap(dimensionEntry.size());
        dimensionEntry.forEach(entry -> dimensionRefSegmentIndexMap.put(entry.getString("costdimension.id"), entry.getString("storageset.number")));
        HashMap dimensionValMap = new HashMap(dimensionEntry.size());
        for (Map.Entry entry2 : dimensionRefSegmentIndexMap.entrySet()) {
            dimensionValMap.put(entry2.getKey(), CostSetUpHelper.getIdVal((String)costSetUpConstObj.getString("segment" + (String)entry2.getValue())));
        }
        JSONObject paramJSONObject = new JSONObject();
        paramJSONObject.put("returnData", dimensionValMap);
        paramJSONObject.put("costStruId", (Object)costStruId);
        paramJSONObject.put("isShow", (Object)Boolean.TRUE);
        FormShowParameter parameter = CostCfgHelper.getDimensionFormShowParameter((JSONObject)paramJSONObject);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_showdimension"));
        this.getView().showForm(parameter);
    }

    private void openCostRecord(String costAllocationRecordId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("pcs_costrecord");
        showParameter.setCustomParam("recordid", (Object)costAllocationRecordId);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        QFilter qFilter = new QFilter("recordtype", "in", (Object)"0");
        filter.and(qFilter);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openViewByFormId(IFormView view, String formId) {
        IListView listView = (IListView)view;
        ListSelectedRow currentSelectedRowInfo = listView.getCurrentSelectedRowInfo();
        Object costSetUpIdObj = currentSelectedRowInfo.getPrimaryKeyValue();
        if (null == costSetUpIdObj) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostSetUpList_7", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean isExist = CostSetUpHelper.isExistSetUp((Long)Long.valueOf(String.valueOf(costSetUpIdObj)));
        if (!isExist) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostSetUpList_8", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter show = new FormShowParameter();
        show.setFormId(formId);
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setCustomParam("costsetupid", (Object)String.valueOf(costSetUpIdObj));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        show.setCloseCallBack(closeCallBack);
        this.getView().showForm(show);
    }

    private void openCostSetUpHistory() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow currentSelectedRowInfo = listView.getCurrentSelectedRowInfo();
        Object costSetUpIdObj = currentSelectedRowInfo.getPrimaryKeyValue();
        if (null == costSetUpIdObj) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CostSetUpList_7", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean isExist = CostSetUpHelper.isExistSetUp((Long)Long.valueOf(String.valueOf(costSetUpIdObj)));
        if (!isExist) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostSetUpList_8", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        SWCDataServiceHelper costSetupRstHisHelper = new SWCDataServiceHelper("pcs_costsetuprsthis");
        QFilter filter = new QFilter("costsetuprst", "=", (Object)Long.valueOf(String.valueOf(costSetUpIdObj)));
        DynamicObject[] ids = costSetupRstHisHelper.query("id", new QFilter[]{filter});
        if (ids == null || ids.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u5206\u644a\u7ed3\u6784\u6682\u65e0\u4fee\u6539\u5386\u53f2\u8bb0\u5f55\u3002", (String)"CostSetUpList_10", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("pcs_costsetuprsthisshow");
        listShowParameter.setBillFormId("pcs_costsetuprsthis");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u8bb0\u5f55", (String)"CostSetUpList_9", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
        listShowParameter.setLookUp(false);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setShowTitle(false);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)e.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                String isLock;
                if ("costsetupmodify".equalsIgnoreCase(operationColItem.getOperationKey()) && !e.getRowData().getBoolean("isdefined")) {
                    operationColItem.setVisible(false);
                    continue;
                }
                if (!"costsetupcustomize".equalsIgnoreCase(operationColItem.getOperationKey()) || !"1".equals(isLock = this.getPageCache().get("isLock"))) continue;
                operationColItem.setLocked(true);
            }
        }
        super.packageData(e);
    }
}

