/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.commons.collections.MapUtils;

public class CostBuildAllotBillHelper {
    public static List<Long> getSplitDimensionIds(Long splitBillRuleId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_splitbillrule");
        DynamicObject splitBillRule = serviceHelper.queryOne((Object)splitBillRuleId);
        DynamicObjectCollection mulBaseDataColl = splitBillRule.getDynamicObjectCollection("costdimensionmul");
        ArrayList<Long> dimensionIdList = new ArrayList<Long>(mulBaseDataColl.size());
        for (DynamicObject mulBaseDataDy : mulBaseDataColl) {
            dimensionIdList.add(mulBaseDataDy.getLong("fbasedataid_id"));
        }
        return dimensionIdList;
    }

    public static int getCostAllotDetailSize(Map<String, Object> filterMap) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotdetail");
        return serviceHelper.count(CostBuildAllotBillHelper.getQFilter(filterMap));
    }

    public static DynamicObject[] getCostAllotDetailArr(Map<String, Object> filterMap, int pageIndex) {
        String selectProperties = "costadapter,startdate,enddate,paydate,allotbillstatus,salaryfile,allotbill,allotbillno,costitem,costsetupconst,costsetupconstval,assuamount,assucurrency,calamount,calcurrency,oriamount,oricurrency";
        DynamicObject[] allotDetailArr = BusinessDataServiceHelper.load((String)"pcs_allotdetail", (String)selectProperties, (QFilter[])CostBuildAllotBillHelper.getQFilter(filterMap), (String)"modifytime", (int)pageIndex, (int)1000);
        return allotDetailArr;
    }

    public static DynamicObject[] getCostAllotDetailArrByIds(List<Long> allotDetailIds) {
        String selectProperties = "costadapter,startdate,enddate,paydate,allotbillstatus,salaryfile,allotbill,allotbillno,costitem,costsetupconst,costsetupconstval,assuamount,assucurrency,calamount,calcurrency,oriamount,oricurrency";
        QFilter filter = new QFilter("id", "in", allotDetailIds);
        DynamicObject[] allotDetailArr = BusinessDataServiceHelper.load((String)"pcs_allotdetail", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        return allotDetailArr;
    }

    public static Map<Long, String> queryDimensionIdRefStoragesetMap(Long coststruId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "=", (Object)coststruId);
        DynamicObject queryResult = costStruHelper.queryOne("costdimension,storageset", new QFilter[]{filter});
        DynamicObjectCollection dimensionEntrys = queryResult.getDynamicObjectCollection("dimensionentry");
        HashMap<Long, String> dimensionIdRefStorageMap = new HashMap<Long, String>(16);
        for (DynamicObject dimensionDy : dimensionEntrys) {
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String storageSetNumber = dimensionDy.getString("storageset.number");
            dimensionIdRefStorageMap.put(costDimensionId, storageSetNumber);
        }
        return dimensionIdRefStorageMap;
    }

    public static QFilter[] getQFilter(Map<String, Object> filterMap) {
        List allotDetailIdList;
        QFilter authorizedFilter = new QFilter("1", "=", (Object)1);
        String checkPerm = MapUtils.getString(filterMap, (Object)"checkperm");
        if ("1".equals(checkPerm)) {
            List<QFilter> authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter == null) {
                authorizedDataRuleQFilter = Collections.singletonList(new QFilter("1", "!=", (Object)1));
            }
            authorizedDataRuleQFilter.stream().filter(Objects::nonNull).forEach(arg_0 -> ((QFilter)authorizedFilter).and(arg_0));
        }
        if ((allotDetailIdList = (List)filterMap.get("allotDetailIdList")) != null) {
            QFilter filter = new QFilter("id", "in", (Object)allotDetailIdList);
            return new QFilter[]{filter, authorizedFilter};
        }
        Long costAdaptionId = (Long)filterMap.get("costadaption");
        QFilter filter = new QFilter("costadapter", "=", (Object)costAdaptionId);
        String calTaskAccord = (String)filterMap.get("caltaskaccord");
        filter.and(new QFilter("allotbillstatus", "=", (Object)"A"));
        if ("0".equals(calTaskAccord)) {
            return new QFilter[]{filter, authorizedFilter};
        }
        List caltaskIdList = (List)filterMap.get("caltasks");
        if (!CollectionUtils.isEmpty((Collection)caltaskIdList) && "3".equals(calTaskAccord)) {
            filter.and(new QFilter("caltask", "in", (Object)caltaskIdList));
            return new QFilter[]{filter, authorizedFilter};
        }
        Date startDate = (Date)filterMap.get("startdate");
        Date endDate = (Date)filterMap.get("enddate");
        if ("1".equals(calTaskAccord)) {
            if (null != startDate) {
                filter.and(new QFilter("startdate", ">=", (Object)startDate));
            }
            if (null != endDate) {
                filter.and(new QFilter("enddate", "<=", (Object)endDate));
            }
            return new QFilter[]{filter, authorizedFilter};
        }
        if ("2".equals(calTaskAccord)) {
            if (null != startDate) {
                filter.and(new QFilter("paydate", ">=", (Object)startDate));
            }
            if (null != endDate) {
                filter.and(new QFilter("paydate", "<=", (Object)endDate));
            }
            return new QFilter[]{filter, authorizedFilter};
        }
        return new QFilter[]{filter, authorizedFilter};
    }
}

