/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallot.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.helper.CostAllotHelper;
import kd.swc.pcs.business.costallot.service.PCSAllotExrateService;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateBatchResult;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateResult;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;

public class AllotDetailHelper {
    private static final Log LOGGER = LogFactory.getLog(AllotDetailHelper.class);

    public void validateCostAllotDetails(CostAllotValidateBatchResult batchResult) {
        this.validateCert(batchResult);
        if (batchResult.isFlag()) {
            return;
        }
        this.validateCalculating(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateCalTaskStatus(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateAdapter(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateSalaryItemIsAllot(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateStructExists(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateExistRate(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateCalTaskCostSetup(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        this.validateIsLatest(batchResult);
        if (batchResult.isAnyFlag()) {
            return;
        }
        Map<Long, CostAllotValidateResult> resultMap = batchResult.getResultMap();
        for (Map.Entry<Long, CostAllotValidateResult> entry : resultMap.entrySet()) {
            if (entry.getValue().isFlag()) continue;
            entry.getValue().setAllotMap(new HashMap<String, Object>(1));
        }
    }

    private void validateCert(CostAllotValidateBatchResult batchResult) {
        String groupIdByBizObjID = HRCertCommonHelper.getGroupIdByBizObjID((String)"1ANC8T4UC434", (String)"pcs_allotdetail");
        if (SWCStringUtils.isEmpty((String)groupIdByBizObjID)) {
            batchResult.allFail(null, null);
        }
    }

    private void validateCalculating(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        Map<Long, DynamicObject> costAllotObjs = CostAllotHelper.queryCostAllotByCalTaskIds(taskMap.keySet());
        if (!CollectionUtils.isEmpty(costAllotObjs)) {
            String split = MultiLangHelper.getMultiLangSlightDelimiter();
            StringBuilder calTaskName = new StringBuilder();
            for (Map.Entry<Long, DynamicObject> entry : costAllotObjs.entrySet()) {
                if (!"2".equals(entry.getValue().getString("costtaskstatus"))) continue;
                Long taskId = entry.getKey();
                calTaskName.append(taskMap.get(taskId).getString("name")).append(split);
                CostAllotValidateResult result = batchResult.resultOf(taskId);
                result.setFlag(true);
            }
            if (calTaskName.length() > 0) {
                calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
                batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u6b63\u5728\u8ba1\u7b97\u4e2d\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"AllotDetailHelper_52", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName}));
            }
        }
    }

    private void validateCalTaskStatus(CostAllotValidateBatchResult batchResult) {
        StringBuilder calTaskName = new StringBuilder();
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            DynamicObject calTaskInfo = entry.getValue();
            if (this.checkCalTaskStatus(calTaskInfo.getString("taskstatus"))) continue;
            calTaskName.append(entry.getValue().getString("name")).append(split);
            CostAllotValidateResult result = batchResult.resultOf(entry.getKey());
            result.setFlag(true);
        }
        if (calTaskName.length() > 0) {
            calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"AllotDetailHelper_38", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName}));
        }
    }

    private boolean checkCalTaskStatus(String payRollTaskStatus) {
        return SWCStringUtils.equals((String)CalPayrollTaskStateEnum.AUDIT.getCode(), (String)payRollTaskStatus) || SWCStringUtils.equals((String)CalPayrollTaskStateEnum.APPROVALEDING.getCode(), (String)payRollTaskStatus) || SWCStringUtils.equals((String)CalPayrollTaskStateEnum.APPROVALED.getCode(), (String)payRollTaskStatus) || SWCStringUtils.equals((String)CalPayrollTaskStateEnum.APPROVALED_NOT_PASS.getCode(), (String)payRollTaskStatus);
    }

    private void validateAdapter(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        Map<Long, DynamicObject> costAdapterObjs = CostAllotHelper.queryCostAdapterIdByCalTaskIds(taskMap);
        StringBuilder calTaskName = new StringBuilder();
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            DynamicObject costAdapter = costAdapterObjs.get(entry.getKey());
            CostAllotValidateResult taskResult = batchResult.resultOf(entry.getKey());
            if (costAdapter == null) {
                calTaskName.append(entry.getValue().getString("name")).append(split);
                taskResult.setFlag(true);
                continue;
            }
            taskResult.setDynamicObject(costAdapter);
        }
        if (calTaskName.length() > 0) {
            calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u6ca1\u6709\u5bf9\u5e94\u7684\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u3002", (String)"AllotDetailHelper_31", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName}));
        }
    }

    private void validateSalaryItemIsAllot(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        Map<Long, Map<Long, DynamicObject>> salaryItemIdListByCalTaskId = CostAllotHelper.getSalaryItemIdListByCalTasks(taskMap);
        StringBuilder calTaskName = new StringBuilder();
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            Map<Long, DynamicObject> itemMap = salaryItemIdListByCalTaskId.get(entry.getKey());
            if (!CollectionUtils.isEmpty(itemMap)) continue;
            calTaskName.append(entry.getValue().getString("name")).append(split);
            CostAllotValidateResult taskRes = batchResult.resultOf(entry.getKey());
            taskRes.setFlag(true);
        }
        if (calTaskName.length() > 0) {
            calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u8ba1\u7b97\u89c4\u5219\u4e2d\u65e0\u53c2\u4e0e\u6210\u672c\u5206\u644a\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"AllotDetailHelper_35", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName}));
        }
    }

    private void validateStructExists(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        Map<Long, DynamicObject> costAllocationObjs = CostAllocationHelper.queryCostAllocationByCalTaskIds(taskMap.keySet());
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        StringBuilder calTaskName = new StringBuilder();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            DynamicObject costAllocationObj = costAllocationObjs.get(entry.getKey());
            if (costAllocationObj != null && SWCStringUtils.equals((String)"1", (String)costAllocationObj.getString("costtaskstatus"))) continue;
            calTaskName.append(entry.getValue().getString("name")).append(split);
            CostAllotValidateResult result = batchResult.resultOf(entry.getKey());
            result.setFlag(true);
        }
        if (calTaskName.length() > 0) {
            calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u6ca1\u6709\u751f\u6210\u5206\u644a\u7ed3\u6784\u3002", (String)"AllotDetailHelper_53", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName}));
        }
    }

    private void validateIsLatest(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        StringBuilder calTaskName = new StringBuilder();
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            Long taskId = entry.getKey();
            CostAllotValidateResult taskRes = batchResult.resultOf(taskId);
            this.validateIsLatest(taskId, taskRes);
            if (!taskRes.isFlag()) continue;
            calTaskName.append(entry.getValue().getString("name")).append(split);
            taskRes.setMessage(null);
        }
        if (calTaskName.length() > 0) {
            calTaskName.delete(calTaskName.length() - split.length(), calTaskName.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u6210\u672c\u8bbe\u7f6e\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6210\u672c\u5206\u644a\u7ed3\u6784\u3002", (String)"AllotDetailHelper_36", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName}));
        }
    }

    private void validateExistRate(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        String format = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a{1}", (String)"AllotDetailHelper_51", (String)"swc-pcs-business", (Object[])new Object[0]);
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            CostAllotValidateResult result = batchResult.resultOf(entry.getKey());
            this.validateExistRate(entry.getKey(), result);
            if (!result.isFlag()) continue;
            batchResult.computeMessagesIfAbsent().add(MessageFormat.format(format, entry.getValue().getString("name"), result.getMessage()));
            result.setMessage(null);
            result.setCode("2");
        }
    }

    private CostAllotValidateResult validateExistRate(DynamicObject calTaskInfo, CostAllotValidateResult costAllotValidateResult) {
        ExchangeRateInfo costCurrency2CalCurrencyRate;
        DynamicObject dynamicObject = costAllotValidateResult.getDynamicObject();
        String currencyId = dynamicObject.getString("currency.id");
        String currencyName = dynamicObject.getString("currency.name");
        long exrateTableId = calTaskInfo.getLong("payrollgroupv.exratetable.id");
        String exrateTableName = calTaskInfo.getString("payrollgroupv.exratetable.name");
        long calCurrencyId = calTaskInfo.getLong("payrollgroupv.currency.id");
        String calCurrencyName = calTaskInfo.getString("payrollgroupv.currency.name");
        Date exrateDate = calTaskInfo.getDate("exratedate");
        String exrateDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"exratedate", (Date)exrateDate);
        PCSAllotExrateService allotExrateService = new PCSAllotExrateService();
        ExchangeRateInfo calCurrency2CostCurrencyRate = allotExrateService.getExrate(calCurrencyId, Long.valueOf(currencyId), exrateDate, exrateTableId);
        if (calCurrency2CostCurrencyRate == null) {
            String message = ResManager.loadKDString((String)"\u5728\u201c{0}\u201d\u6c47\u7387\u8868\u4e2d\uff0c\u672a\u627e\u5230\u65e5\u671f\u4e3a{1}\u201c{2}\u201d\u5151\u201c{3}\u201d\u7684\u6c47\u7387\u3002", (String)"AllotDetailHelper_3", (String)"swc-pcs-business", (Object[])new Object[]{exrateTableName, exrateDateStr, calCurrencyName, currencyName});
            costAllotValidateResult.setFlag(true);
            costAllotValidateResult.setMessage(message);
        }
        if ((costCurrency2CalCurrencyRate = allotExrateService.getExrate(Long.valueOf(currencyId), calCurrencyId, exrateDate, exrateTableId)) == null) {
            String message = ResManager.loadKDString((String)"\u5728\u201c{0}\u201d\u6c47\u7387\u8868\u4e2d\uff0c\u672a\u627e\u5230\u65e5\u671f\u4e3a{1}\u201c{2}\u201d\u5151\u201c{3}\u201d\u7684\u6c47\u7387\u3002", (String)"AllotDetailHelper_3", (String)"swc-pcs-business", (Object[])new Object[]{exrateTableName, exrateDateStr, currencyName, calCurrencyName});
            costAllotValidateResult.setFlag(true);
            costAllotValidateResult.setMessage(message);
        }
        return costAllotValidateResult;
    }

    public static void validateCalPersonStatus(Long calTaskId, CostAllotValidateResult costAllotValidateResult, boolean multi) {
        int permCount;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calTaskId);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"salaryfile", (String)"47150e89000000ac");
        if (salaryFileFilter != null) {
            calPersonFilter.and(salaryFileFilter);
        }
        if ((permCount = helper.count(new QFilter[]{calPersonFilter})) == 0) {
            costAllotValidateResult.setFlag(true);
            costAllotValidateResult.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e0b\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"AllotDetailHelper_40", (String)"swc-pcs-business", (Object[])new Object[0]));
            return;
        }
        calPersonFilter.and(new QFilter("allotstatus", "!=", (Object)"B"));
        int count = helper.count(new QFilter[]{calPersonFilter});
        if (count == 0) {
            costAllotValidateResult.setFlag(true);
            if (multi) {
                costAllotValidateResult.setMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u6ca1\u6709\u5df2\u5ba1\u6838\u4e14\u5206\u644a\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6210\u7684\u6838\u7b97\u8bb0\u5f55\u3002", (String)"AllotDetailHelper_42", (String)"swc-pcs-business", (Object[])new Object[0]));
            } else {
                costAllotValidateResult.setMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u56e0\u4e3a\u6240\u9009\u6838\u7b97\u4efb\u52a1\u4e0b\u6ca1\u6709\u5df2\u5ba1\u6838\u4e14\u5206\u644a\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6210\u7684\u6838\u7b97\u8bb0\u5f55\u3002", (String)"AllotDetailHelper_41", (String)"swc-pcs-business", (Object[])new Object[0]));
            }
        }
    }

    public void dealCostAllotDeatail(IFormView view, String className, String strategy, String salaryFile) {
        ArrayList calTaskIdsLong;
        LOGGER.info("costallotconfirmCallBack begin 2-1");
        IPageCache pageCache = view.getPageCache();
        String calTaskIds = pageCache.get("caltaskids");
        if (!StringUtils.isEmpty((CharSequence)calTaskIds)) {
            List calTaskIdList = SerializationUtils.fromJsonStringToList((String)calTaskIds, Long.class);
            calTaskIdsLong = Lists.newArrayListWithExpectedSize((int)calTaskIdList.size());
            calTaskIdList.forEach(ele -> calTaskIdsLong.add(ObjectConverter.convert((Object)ele, Long.class, (boolean)false)));
        } else {
            String calTaskId = pageCache.get("caltaskid");
            if (!StringUtils.isEmpty((CharSequence)calTaskId)) {
                calTaskIdsLong = Lists.newArrayList((Object[])new Long[]{(Long)ObjectConverter.convert((Object)calTaskId, Long.class, (boolean)true)});
            } else {
                return;
            }
        }
        List<Long> salaryFileList = new ArrayList<Long>(10);
        if (SWCStringUtils.isNotEmpty((String)salaryFile)) {
            String[] salaryFileListArr = salaryFile.substring(1, salaryFile.length() - 1).split(", ");
            salaryFileList = Arrays.stream(salaryFileListArr).map(Long::valueOf).collect(Collectors.toList());
        }
        HashMap taskOfRecordId = Maps.newHashMapWithExpectedSize((int)calTaskIdsLong.size());
        for (Long calTaskId : calTaskIdsLong) {
            DynamicObject[] calPersonArr = AllotDetailHelper.queryCalPersonIdsByCalTaskId(Collections.singletonList(calTaskId), salaryFileList, strategy);
            List calPersonIdList = Arrays.stream(calPersonArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            int costFileNumber = calPersonIdList.size();
            LOGGER.info("costallotconfirmCallBack begin 2-2 size{}", (Object)costFileNumber);
            String calTaskIdStr = calTaskId + "";
            long costAllotDetailRecordId = CostAllocationHelper.saveCostRecordInfo(costFileNumber, calTaskIdStr, "1");
            taskOfRecordId.put(costAllotDetailRecordId, calTaskId);
            this.setCostAllotDetailProgressInfo(calTaskIdStr, costFileNumber);
            SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSCostAllotDetailService", (String)"generateAllotDetail", (Object[])new Object[]{calTaskId, costAllotDetailRecordId, calPersonIdList, strategy, salaryFileList, ""});
        }
        this.openCostAllotDetailProgress(view, className, taskOfRecordId);
        try {
            Thread.sleep(1000L);
            view.invokeOperation("refresh");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static DynamicObject[] queryCalPersonIdsByCalTaskId(Collection<Long> calTaskIds, List<Long> salaryFileList, String strategy) {
        long currUserId;
        QFilter salaryFileFilter;
        QFilter calPersonFilter = calTaskIds.size() == 1 ? new QFilter("caltask", "=", (Object)calTaskIds.iterator().next()) : new QFilter("caltask", "in", calTaskIds);
        if (!CollectionUtils.isEmpty(salaryFileList)) {
            calPersonFilter.and(new QFilter("salaryfile.id", "in", salaryFileList));
        }
        if (SWCStringUtils.equals((String)"3", (String)strategy)) {
            calPersonFilter.and(new QFilter("allotstatus", "!=", (Object)"B"));
        }
        if ((salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)(currUserId = RequestContext.get().getCurrUserId()), (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"salaryfile", (String)"47150e89000000ac")) != null) {
            calPersonFilter.and(salaryFileFilter);
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        return calPersonHelper.query("id,caltask.id,salaryfile.id", new QFilter[]{calPersonFilter});
    }

    private void openCostAllotDetailProgress(IFormView view, String className, Map<Long, Long> taskOfRecordId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pcs_costallotdetailprog");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("parentPageId", (Object)view.getPageId());
        showParameter.setCustomParam("caltaskids", (Object)SerializationUtils.toJsonString(taskOfRecordId.values()));
        showParameter.setCustomParam("costallocationrecordids", (Object)SerializationUtils.toJsonString(taskOfRecordId.keySet()));
        showParameter.setCustomParam("taskOfRecordId", taskOfRecordId);
        CloseCallBack closeCallBack = new CloseCallBack(className, "pcs_costallotdetailprog");
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    private void setCostAllotDetailProgressInfo(String calTaskId, int costFileNumber) {
        CostAllocationProgressInfo progress = new CostAllocationProgressInfo();
        progress.setTotal(costFileNumber);
        progress.setStartDate(new Date());
        progress.setStatus(0);
        String key = String.format(Locale.ROOT, "cache_costallotdetail_key_%s", calTaskId);
        SWCAppCache.get((String)"pcs").put(key, (Object)progress);
        AppCache.get((String)"pcs").remove(String.format(Locale.ROOT, "isdetailtermination_%s", calTaskId));
    }

    private CostAllotValidateResult validateExistRate(Long calTaskId, CostAllotValidateResult costAllotValidateResult) {
        return this.validateExistRate(this.getCalTaskInfo(calTaskId, "payrollgroupv,exratedate"), costAllotValidateResult);
    }

    private void validateCalTaskCostSetup(CostAllotValidateBatchResult batchResult) {
        Map<Long, DynamicObject> taskMap = batchResult.successTaskMap();
        Map<Long, Set<String>> statusOfTask = CostAllotHelper.countCostSetUpEnable(taskMap, batchResult);
        StringBuilder calTaskName1 = new StringBuilder();
        StringBuilder calTaskName2 = new StringBuilder();
        String split = MultiLangHelper.getMultiLangSlightDelimiter();
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            Set<String> enableMap = statusOfTask.get(entry.getKey());
            CostAllotValidateResult taskRes = batchResult.resultOf(entry.getKey());
            if (enableMap == null) {
                taskRes.setFlag(true);
                taskRes.setCode("2");
                calTaskName1.append(entry.getValue().getString("name")).append(split);
                continue;
            }
            if (!enableMap.contains("0")) continue;
            taskRes.setFlag(true);
            taskRes.setCode("2");
            calTaskName2.append(entry.getValue().getString("name")).append(split);
        }
        if (calTaskName1.length() > 0) {
            calTaskName1.delete(calTaskName1.length() - split.length(), calTaskName1.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u65e0\u5bf9\u5e94\u7684\u6210\u672c\u5206\u644a\u7ed3\u6784\uff0c\u8bf7\u751f\u6210\u6210\u672c\u5206\u644a\u7ed3\u6784\u540e\u91cd\u8bd5\u3002", (String)"AllotDetailHelper_37", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName1}));
        }
        if (calTaskName2.length() > 0) {
            calTaskName2.delete(calTaskName2.length() - split.length(), calTaskName2.length());
            batchResult.computeMessagesIfAbsent().add(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1 {0}\uff1a\u5bf9\u5e94\u7684\u6210\u672c\u5206\u644a\u7ed3\u6784\u4efb\u52a1\u5b58\u5728\u65e0\u6548\u6210\u672c\u5206\u644a\u7ed3\u6784\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AllotDetailHelper_34", (String)"swc-pcs-business", (Object[])new Object[]{calTaskName2}));
        }
    }

    private CostAllotValidateResult validateIsLatest(Long calTaskId, CostAllotValidateResult costAllotValidateResult) {
        Date costAllocationModifyDate = CostAllotHelper.queryCostAllocationModifyDate(calTaskId);
        Long costAdapterId = costAllotValidateResult.getDynamicObject().getLong("id");
        boolean isLaterThanCostAllocationModifyDate = CostAllotHelper.costCfgModifyTimeIsLaterThanCostAllocationModifyDate(costAdapterId, costAllocationModifyDate);
        if (isLaterThanCostAllocationModifyDate && !CostAllotHelper.existCreatedAllotDetailByTaskId(calTaskId)) {
            costAllotValidateResult.setFlag(true);
            costAllotValidateResult.setMessage(ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6210\u672c\u5206\u644a\u7ed3\u6784\u3002", (String)"AllotDetailHelper_6", (String)"swc-pcs-business", (Object[])new Object[0]));
            costAllotValidateResult.setCode("1");
        }
        return costAllotValidateResult;
    }

    protected DynamicObject getCalTaskInfo(long taskId, String selectProperties) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return helper.queryOne(selectProperties, (Object)taskId);
    }

    public static List<Long> getExistSalaryFileNumber(long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter taskQFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        DynamicObject[] queryResult = helper.query("salaryfile.id", new QFilter[]{taskQFilter});
        ArrayList<Long> salaryFileList = new ArrayList<Long>(queryResult.length);
        for (DynamicObject dynamicObject : queryResult) {
            long salaryFileId = dynamicObject.getLong("salaryfile.id");
            salaryFileList.add(salaryFileId);
        }
        return salaryFileList;
    }
}

