/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallot.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.pcs.common.events.CostAllotBillArgs;
import kd.sdk.swc.pcs.service.api.ICostAllotBillService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCNumberGenerater;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostBuildAllotBillHelper;
import kd.swc.pcs.business.costallot.helper.CostAllotBillExtService;
import kd.swc.pcs.business.costallotbill.helper.CostAllotBillHelper;
import org.apache.commons.collections.CollectionUtils;

public class CostBuildAllotBillService {
    private static final Log LOGGER = LogFactory.getLog(CostBuildAllotBillService.class);
    private Map<String, DynamicObject> dimensionsRefAllotBillMap = new HashMap<String, DynamicObject>(16);
    private Map<String, Map<String, Object>> mergeAllotDetailDataMap = new HashMap<String, Map<String, Object>>(16);
    private Map<String, DynamicObject> billNoRefCostBillObjMap = new HashMap<String, DynamicObject>(16);
    private DynamicObject notSplitCostAllotBillObj;
    private Long orgId;

    private int getCostAllotDetailSize(Map<String, Object> filterMap, List<Long> allotDetailIds) {
        return CollectionUtils.isNotEmpty(allotDetailIds) ? allotDetailIds.size() : CostBuildAllotBillHelper.getCostAllotDetailSize(filterMap);
    }

    private void batchProcessAllotDetails(Map<String, Object> filterMap, List<Long> allotDetailIds, int costAllotDetailSize, List<DynamicObject[]> queryResults) {
        Long costAdaptionId = (Long)filterMap.get("costadaption");
        Long splitBillRuleId = (Long)filterMap.get("splitbillrule");
        boolean isSplit = true;
        List<Object> splitDimensionIdList = new ArrayList(10);
        if (splitBillRuleId != null && splitBillRuleId > 0L) {
            splitDimensionIdList = CostBuildAllotBillHelper.getSplitDimensionIds(splitBillRuleId);
        }
        DynamicObject costAdapterObj = CostAllotBillHelper.queryAdapterObj(costAdaptionId);
        Long costStruId = costAdapterObj.getLong("coststru.id");
        this.orgId = costAdapterObj.getLong("createorg.id");
        if (splitDimensionIdList.isEmpty()) {
            isSplit = false;
            this.notSplitCostAllotBillObj = this.createCostAllotBillObj(costAdaptionId);
        }
        Map<Long, String> dimensionIdRefStoragesetMap = CostBuildAllotBillHelper.queryDimensionIdRefStoragesetMap(costStruId);
        if (CollectionUtils.isNotEmpty(allotDetailIds)) {
            List splitIds = Lists.partition(allotDetailIds, (int)1000);
            for (List subIds : splitIds) {
                DynamicObject[] costAllotDetailArr = CostBuildAllotBillHelper.getCostAllotDetailArrByIds(subIds);
                queryResults.add(costAllotDetailArr);
                this.doBuildAllotBill(costAllotDetailArr, dimensionIdRefStoragesetMap, splitDimensionIdList, costAdaptionId, isSplit);
            }
        } else {
            int pageSize = costAllotDetailSize / 1000 + 1;
            for (int i = 0; i < pageSize; ++i) {
                DynamicObject[] costAllotDetailArr = CostBuildAllotBillHelper.getCostAllotDetailArr(filterMap, i);
                queryResults.add(costAllotDetailArr);
                this.doBuildAllotBill(costAllotDetailArr, dimensionIdRefStoragesetMap, splitDimensionIdList, costAdaptionId, isSplit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> buildAllotBillNew(Map<String, Object> filterMap, List<Long> allotDetailIds) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        int costAllotDetailSize = this.getCostAllotDetailSize(filterMap, allotDetailIds);
        LOGGER.info("create allotbill start ,total size:{}", (Object)costAllotDetailSize);
        long startTime = System.currentTimeMillis();
        resultMap.put("totalCount", costAllotDetailSize);
        if (costAllotDetailSize < 1) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u4e0b\u6ca1\u6709\u53ef\u751f\u6210\u5206\u914d\u5355\u7684\u5206\u644a\u660e\u7ec6\uff0c\u8bf7\u4fee\u6539\u6761\u4ef6\u540e\u91cd\u8bd5\u3002", (String)"CostBuildAllotBillService_0", (String)"swc-pcs-business", (Object[])new Object[0]);
            resultMap.put("errorMsg", message);
            return resultMap;
        }
        ArrayList<DynamicObject[]> queryResults = new ArrayList<DynamicObject[]>(costAllotDetailSize);
        this.batchProcessAllotDetails(filterMap, allotDetailIds, costAllotDetailSize, queryResults);
        try (TXHandle txHandle = TX.requiresNew();){
            Object[] allotBillObjArr = this.saveAllotDetail();
            ArrayList<Long> allotBillIds = new ArrayList<Long>(allotBillObjArr.length);
            for (Object allotBill : allotBillObjArr) {
                if (!(allotBill instanceof DynamicObject)) continue;
                allotBillIds.add(((DynamicObject)allotBill).getLong("id"));
            }
            resultMap.put("allotbillids", allotBillIds);
            for (DynamicObject[] costAllotDetailArr : queryResults) {
                this.doSave(costAllotDetailArr, allotBillObjArr);
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("create allotbill end,total time:{}ms", (Object)(endTime - startTime));
        return resultMap;
    }

    public Map<String, Object> buildAllotBill(Map<String, Object> filterMap) {
        HashMap<String, Object> filterMapNew = new HashMap<String, Object>(16);
        filterMapNew.put("costadaption", filterMap.get("costadaptionid"));
        filterMapNew.put("splitbillrule", filterMap.get("splitbillruleid"));
        filterMapNew.put("caltaskaccord", filterMap.get("caltaskaccord"));
        filterMapNew.put("startdate", filterMap.get("startdate"));
        filterMapNew.put("enddate", filterMap.get("enddate"));
        filterMapNew.put("caltasks", filterMap.get("caltaskidlist"));
        filterMapNew.put("allotDetailIdList", filterMap.get("allotDetailIdList"));
        filterMapNew.put("checkperm", "1");
        return this.buildAllotBillNew(filterMapNew, null);
    }

    public void doBuildAllotBill(DynamicObject[] costAllotDetailArr, Map<Long, String> dimensionIdRefStoragesetMap, List<Long> splitDimensionIdList, Long costAdaptionId, boolean isSplit) {
        for (DynamicObject costAllot : costAllotDetailArr) {
            String payDateStr;
            String endDateStr;
            String startDateStr;
            DynamicObject costAllotBillObj;
            if (isSplit) {
                String splitKey = this.getSplitKey(costAllot, dimensionIdRefStoragesetMap, splitDimensionIdList);
                costAllotBillObj = this.dimensionsRefAllotBillMap.get(splitKey);
                if (costAllotBillObj == null) {
                    costAllotBillObj = this.createCostAllotBillObj(costAdaptionId);
                    this.dimensionsRefAllotBillMap.put(splitKey, costAllotBillObj);
                }
            } else {
                costAllotBillObj = this.notSplitCostAllotBillObj;
            }
            String billNo = costAllotBillObj.getString("billno");
            String costSetupConstId = costAllot.getString("costsetupconst.id");
            String segmentValMd5 = costAllot.getString("costsetupconst.segmentvalmd5");
            String costSetupConstVal = costAllot.getString("costsetupconstval");
            Date startDate = costAllot.getDate("startdate");
            Date endDate = costAllot.getDate("enddate");
            Date payDate = costAllot.getDate("paydate");
            try {
                startDateStr = SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
                endDateStr = SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                payDateStr = SWCDateTimeUtils.format((Date)payDate, (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                LOGGER.error("data convert to String error:{}", (Object)e.getMessage());
                startDateStr = "";
                endDateStr = "";
                payDateStr = "";
            }
            DynamicObjectCollection costAllotDetailEntryColl = costAllot.getDynamicObjectCollection("pcs_allotdetailentry");
            for (DynamicObject costAllotDetailEntry : costAllotDetailEntryColl) {
                String costItemId = costAllotDetailEntry.getString("costitem.id");
                BigDecimal assuAmount = costAllotDetailEntry.getBigDecimal("assuamount");
                String mergeKey = String.join((CharSequence)"_", costItemId, segmentValMd5, startDateStr, endDateStr, payDateStr);
                LOGGER.info("CostBuildAllotBillService doBuildAllotBill mergeKey", (Object)mergeKey);
                Map<String, Object> mergedAllotDetaiInfoMap = this.mergeAllotDetailDataMap.get(mergeKey);
                if (mergedAllotDetaiInfoMap == null) {
                    mergedAllotDetaiInfoMap = new HashMap<String, Object>(16);
                    this.mergeAllotDetailDataMap.put(mergeKey, mergedAllotDetaiInfoMap);
                    mergedAllotDetaiInfoMap.put("assuAmount", BigDecimal.ZERO);
                }
                mergedAllotDetaiInfoMap.put("allotBillObj", costAllotBillObj);
                mergedAllotDetaiInfoMap.put("costItemId", Long.valueOf(costItemId));
                mergedAllotDetaiInfoMap.put("costSetupConstId", Long.valueOf(costSetupConstId == null ? "0" : costSetupConstId));
                mergedAllotDetaiInfoMap.put("costSetupConstVal", costSetupConstVal);
                mergedAllotDetaiInfoMap.put("assuAmount", assuAmount.add((BigDecimal)mergedAllotDetaiInfoMap.get("assuAmount")));
                mergedAllotDetaiInfoMap.put("startDate", startDate);
                mergedAllotDetaiInfoMap.put("endDate", endDate);
                mergedAllotDetaiInfoMap.put("payDate", payDate);
            }
            costAllot.set("allotbillstatus", (Object)"B");
            costAllot.set("allotbillno", (Object)costAllotBillObj.getString("billno"));
        }
    }

    private Object[] saveAllotDetail() {
        for (Map.Entry<String, Map<String, Object>> mergeAllotDetailDataEntry : this.mergeAllotDetailDataMap.entrySet()) {
            Map<String, Object> mergedAllotDetaiInfoMap = mergeAllotDetailDataEntry.getValue();
            DynamicObject allotBillObj = (DynamicObject)mergedAllotDetaiInfoMap.get("allotBillObj");
            String billNo = allotBillObj.getString("billno");
            DynamicObject costAllotBillEntryObj = this.generateCostAllotBillEntryObj(mergedAllotDetaiInfoMap);
            DynamicObject repeatAllotBillObj = this.billNoRefCostBillObjMap.get(billNo);
            if (repeatAllotBillObj == null) {
                this.billNoRefCostBillObjMap.put(billNo, allotBillObj);
                allotBillObj.set("amountsum", mergedAllotDetaiInfoMap.get("assuAmount"));
                allotBillObj.getDynamicObjectCollection("entryentity").add((Object)costAllotBillEntryObj);
                continue;
            }
            BigDecimal amountSum = repeatAllotBillObj.getBigDecimal("amountsum");
            repeatAllotBillObj.set("amountsum", (Object)amountSum.add((BigDecimal)mergedAllotDetaiInfoMap.get("assuAmount")));
            repeatAllotBillObj.getDynamicObjectCollection("entryentity").add((Object)costAllotBillEntryObj);
        }
        Collection<DynamicObject> costAllotBillColl = this.billNoRefCostBillObjMap.values();
        this.sortAllotBillColl(costAllotBillColl);
        CostAllotBillExtService extService = new CostAllotBillExtService();
        CostAllotBillArgs args = new CostAllotBillArgs(costAllotBillColl.stream().collect(Collectors.toList()));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostAllotBillService.class, (String)"kd.sdk.swc.pcs.service.api.ICostAllotBillService#setCostAllotBillFields", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.setCostAllotBillFields(args);
            return null;
        });
        SWCDataServiceHelper allotBillService = new SWCDataServiceHelper("pcs_allotbill");
        Object[] allotbillObjArr = allotBillService.save(costAllotBillColl.toArray(new DynamicObject[0]));
        return allotbillObjArr;
    }

    private void doSave(DynamicObject[] costAllotDetailArr, Object[] allotbillObjArr) {
        SWCDataServiceHelper allotDetailService = new SWCDataServiceHelper("pcs_allotdetail");
        this.setAllotBillId(costAllotDetailArr, allotbillObjArr);
        allotDetailService.save(costAllotDetailArr);
    }

    private void sortAllotBillColl(Collection<DynamicObject> costAllotBillColl) {
        for (DynamicObject costAllotBill : costAllotBillColl) {
            this.sortItemName(costAllotBill.getDynamicObjectCollection("entryentity"));
        }
    }

    private void sortItemName(DynamicObjectCollection allotBillEntry) {
        Collections.sort(allotBillEntry, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                LOGGER.info("CostBuildAllotBillService sortItemName costitem1={},costitem2={}", (Object)o1.getLong("costitem"), (Object)o2.getLong("costitem"));
                return Long.compare(o1.getLong("costitem"), o2.getLong("costitem"));
            }
        });
    }

    private void setAllotBillId(DynamicObject[] costAllotDetailArr, Object[] allotbillObjArr) {
        HashMap<String, Long> billNoRefbillIdMap = new HashMap<String, Long>(allotbillObjArr.length);
        for (Object obj : allotbillObjArr) {
            if (!(obj instanceof DynamicObject)) continue;
            DynamicObject allotbillObj = (DynamicObject)obj;
            String billNo = allotbillObj.getString("billno");
            Long billId = allotbillObj.getLong("id");
            billNoRefbillIdMap.put(billNo, billId);
        }
        for (DynamicObject costAllotDetail : costAllotDetailArr) {
            String allotbillNo = costAllotDetail.getString("allotbillno");
            Long allotBillId = (Long)billNoRefbillIdMap.get(allotbillNo);
            costAllotDetail.set("allotbill", (Object)allotBillId);
        }
    }

    private DynamicObject generateCostAllotBillEntryObj(Map<String, Object> mergedAllotDetaiInfoMap) {
        SWCDataServiceHelper allotBillService = new SWCDataServiceHelper("pcs_allotbill");
        DynamicObject costAllotBillEntryObj = allotBillService.generateEmptyEntryDynamicObject("entryentity");
        costAllotBillEntryObj.set("costitem", mergedAllotDetaiInfoMap.get("costItemId"));
        costAllotBillEntryObj.set("costsetupconst", mergedAllotDetaiInfoMap.get("costSetupConstId"));
        costAllotBillEntryObj.set("costSetupConstVal", mergedAllotDetaiInfoMap.get("costSetupConstVal"));
        costAllotBillEntryObj.set("assuamount", mergedAllotDetaiInfoMap.get("assuAmount"));
        costAllotBillEntryObj.set("startdate", mergedAllotDetaiInfoMap.get("startDate"));
        costAllotBillEntryObj.set("enddate", mergedAllotDetaiInfoMap.get("endDate"));
        costAllotBillEntryObj.set("paydate", mergedAllotDetaiInfoMap.get("payDate"));
        return costAllotBillEntryObj;
    }

    public DynamicObject createCostAllotBillObj(Long costAdaptionId) {
        SWCDataServiceHelper allotBillService = new SWCDataServiceHelper("pcs_allotbill");
        DynamicObject allotBillDyobj = allotBillService.generateEmptyDynamicObject();
        DynamicObject costAdapterObj = CostAllotBillHelper.queryAdapterObj(costAdaptionId);
        long currencyId = costAdapterObj.getLong("currency.id");
        allotBillDyobj.set("createtime", (Object)new Date());
        allotBillDyobj.set("creator", (Object)RequestContext.get().getCurrUserId());
        allotBillDyobj.set("billstatus", (Object)"A");
        allotBillDyobj.set("finaccountstatus", (Object)"F");
        allotBillDyobj.set("financingstatus", (Object)"A");
        allotBillDyobj.set("costadapter", (Object)costAdaptionId);
        allotBillDyobj.set("assucurrency", (Object)currencyId);
        allotBillDyobj.set("org", (Object)this.orgId);
        allotBillDyobj.set("barcode", (Object)SWCNumberGenerater.getInstance().generaterNextNumber(new Date(), "FTFP"));
        String billNo = CodeRuleServiceHelper.getNumber((String)"pcs_allotbill", (DynamicObject)allotBillDyobj, null);
        allotBillDyobj.set("billno", (Object)billNo);
        return allotBillDyobj;
    }

    public String getSplitKey(DynamicObject costAllot, Map<Long, String> dimensionIdRefStoragesetMap, List<Long> splitDimensionIdList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Long splitDimensionId : splitDimensionIdList) {
            String storagesetNumber = dimensionIdRefStoragesetMap.get(splitDimensionId);
            if (!SWCStringUtils.isNotEmpty((String)storagesetNumber)) continue;
            String dimensionVal = costAllot.getString("costsetupconst.segment" + storagesetNumber);
            stringBuilder.append(dimensionVal).append('_');
        }
        return stringBuilder.toString();
    }
}

