/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallot.vo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateResult;

public class CostAllotValidateBatchResult {
    private String operateKey;
    private boolean flag;
    private String code;
    private List<String> messages;
    private Map<Long, CostAllotValidateResult> resultMap;
    private Map<Long, DynamicObject> taskMap;

    public CostAllotValidateBatchResult() {
        this.taskMap = Maps.newHashMapWithExpectedSize((int)16);
        this.resultMap = Maps.newHashMapWithExpectedSize((int)16);
    }

    public CostAllotValidateBatchResult(Map<Long, DynamicObject> taskMap) {
        this.taskMap = taskMap;
        this.resultMap = Maps.newHashMapWithExpectedSize((int)taskMap.size());
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            this.resultMap.put(entry.getKey(), new CostAllotValidateResult(false, ""));
        }
    }

    public CostAllotValidateResult resultOf(Long taskId) {
        return this.computeResultMapIfAbsent().computeIfAbsent(taskId, ky -> new CostAllotValidateResult(false, ""));
    }

    public DynamicObject taskOf(Long taskId) {
        this.computeResultMapIfAbsent();
        return this.taskMap.get(taskId);
    }

    public Map<Long, DynamicObject> successTaskMap() {
        this.computeTaskMapIfAbsent();
        HashMap result = Maps.newHashMapWithExpectedSize((int)this.taskMap.size());
        for (Map.Entry<Long, DynamicObject> entry : this.taskMap.entrySet()) {
            CostAllotValidateResult res = this.resultOf(entry.getKey());
            if (!res.isSuccess()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void fail(long taskId, String message, String code) {
        CostAllotValidateResult result = this.resultOf(taskId);
        result.setFlag(true);
        result.setMessage(message);
        result.setCode(code);
    }

    public void allFail(String message, String code) {
        this.flag = true;
        this.code = code;
        for (Map.Entry<Long, CostAllotValidateResult> entry : this.computeResultMapIfAbsent().entrySet()) {
            CostAllotValidateResult result = entry.getValue();
            result.setFlag(false);
            result.setMessage(message);
            result.setCode(code);
        }
        this.computeMessagesIfAbsent().add(message);
    }

    public boolean isAllFail() {
        if (this.flag) {
            return true;
        }
        Map<Long, CostAllotValidateResult> results = this.computeResultMapIfAbsent();
        for (Map.Entry<Long, CostAllotValidateResult> entry : results.entrySet()) {
            if (!entry.getValue().isSuccess()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyFail() {
        if (this.flag) {
            return true;
        }
        Map<Long, CostAllotValidateResult> results = this.computeResultMapIfAbsent();
        for (Map.Entry<Long, CostAllotValidateResult> entry : results.entrySet()) {
            if (entry.getValue().isSuccess()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyFlag() {
        if (this.flag) {
            return true;
        }
        Map<Long, CostAllotValidateResult> results = this.computeResultMapIfAbsent();
        for (Map.Entry<Long, CostAllotValidateResult> entry : results.entrySet()) {
            if (!entry.getValue().isFlag()) continue;
            return true;
        }
        return false;
    }

    public int failSize() {
        int result = 0;
        Map<Long, CostAllotValidateResult> results = this.computeResultMapIfAbsent();
        for (Map.Entry<Long, CostAllotValidateResult> entry : results.entrySet()) {
            if (entry.getValue().isSuccess()) continue;
            ++result;
        }
        return result;
    }

    public List<String> allMessagesWithDetails() {
        List<String> result = this.computeMessagesIfAbsent();
        this.computeResultMapIfAbsent().forEach((ky, val) -> {
            if (!StringUtils.isEmpty((CharSequence)val.getMessage())) {
                result.add(val.getMessage());
            }
        });
        return result;
    }

    public Map<Long, CostAllotValidateResult> computeResultMapIfAbsent() {
        if (this.resultMap == null) {
            this.resultMap = Maps.newHashMapWithExpectedSize((int)16);
            this.computeTaskMapIfAbsent();
        }
        return this.resultMap;
    }

    public Map<Long, DynamicObject> computeTaskMapIfAbsent() {
        if (this.taskMap == null) {
            this.taskMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        return this.taskMap;
    }

    public List<String> computeMessagesIfAbsent() {
        if (this.messages == null) {
            this.messages = Lists.newArrayListWithExpectedSize((int)this.computeTaskMapIfAbsent().size());
        }
        return this.messages;
    }

    public String getOperateKey() {
        return this.operateKey;
    }

    public void setOperateKey(String operateKey) {
        this.operateKey = operateKey;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public Map<Long, CostAllotValidateResult> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<Long, CostAllotValidateResult> resultMap) {
        this.resultMap = resultMap;
    }

    public Map<Long, DynamicObject> getTaskMap() {
        return this.taskMap;
    }

    public void setTaskMap(Map<Long, DynamicObject> taskMap) {
        this.taskMap = taskMap;
    }
}

