/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallotbill.helper;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostAllotBillExportHelper {
    private static Log logger = LogFactory.getLog(CostAllotBillExportHelper.class);

    public static Map<Long, Long> queryAdapterIdByAllotBills(List<Long> selectIdList, Map<Long, String> allotBillNumberMap) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotbill");
        QFilter idFilter = new QFilter("id", "in", selectIdList);
        DynamicObject[] allotBillArr = serviceHelper.query("id,billno,costadapter", new QFilter[]{idFilter});
        HashMap<Long, Long> allotBillAndAdapterMap = new HashMap<Long, Long>(allotBillArr.length);
        for (int i = 0; i < allotBillArr.length; ++i) {
            DynamicObject allotBillDy = allotBillArr[i];
            long costAdapterId = allotBillDy.getLong("costadapter.id");
            long allotBillId = allotBillDy.getLong("id");
            allotBillAndAdapterMap.put(allotBillId, costAdapterId);
            String billNo = allotBillDy.getString("billno");
            allotBillNumberMap.put(allotBillId, billNo);
        }
        return allotBillAndAdapterMap;
    }

    public static Map<Long, Long> queryCostStruByAdapter(List<Long> selectIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter idFilter = new QFilter("id", "in", selectIdList);
        DynamicObject[] costAdaptionArr = serviceHelper.query("id,coststru", new QFilter[]{idFilter});
        HashMap<Long, Long> costAdaptionAndStruMap = new HashMap<Long, Long>(costAdaptionArr.length);
        for (int i = 0; i < costAdaptionArr.length; ++i) {
            long costStruId = costAdaptionArr[i].getLong("coststru.id");
            long costAdaptionId = costAdaptionArr[i].getLong("id");
            costAdaptionAndStruMap.put(costAdaptionId, costStruId);
        }
        return costAdaptionAndStruMap;
    }

    public static Map<Long, Map<String, String>> getDynamicColumnMap(List<Long> costStruIds) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter idFilter = new QFilter("id", "in", costStruIds);
        DynamicObject[] costStruDyArr = serviceHelper.query("dimensionentry,costdimension,storageset,costdimension.valuetype", new QFilter[]{idFilter});
        for (int i = 0; i < costStruDyArr.length; ++i) {
            LinkedHashMap<String, String> dynamicColumnMap = new LinkedHashMap<String, String>(16);
            DynamicObject costStruDy = costStruDyArr[i];
            DynamicObjectCollection entryEntity = costStruDy.getDynamicObjectCollection("dimensionentry");
            CostCommonHelper.getDynamicColumnMap(dynamicColumnMap, entryEntity);
            resultMap.put(costStruDy.getLong("id"), dynamicColumnMap);
        }
        return resultMap;
    }

    public static Map<Long, Map<String, String>> queryCostStruMap(List<Long> costStruIdList) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "in", costStruIdList);
        DynamicObject[] queryResultArr = costStruHelper.query("id,dimensionentry,costdimension,storageset,costdimension.valuetype", new QFilter[]{filter});
        HashMap<Long, Map<String, String>> costStruAndDimValueMap = new HashMap<Long, Map<String, String>>(costStruIdList.size());
        for (int i = 0; i < queryResultArr.length; ++i) {
            DynamicObject costStruDy = queryResultArr[i];
            DynamicObjectCollection dimensionEntryColl = costStruDy.getDynamicObjectCollection("dimensionentry");
            Map<String, String> baseDataPropMap = CostCommonHelper.getBaseDataPropMap(dimensionEntryColl);
            costStruAndDimValueMap.put(costStruDy.getLong("id"), baseDataPropMap);
        }
        return costStruAndDimValueMap;
    }

    public static List<Long> getAllotBillList(List<QFilter> filters) {
        QFilter[] qFilters = filters.toArray(new QFilter[0]);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotbill");
        DynamicObject[] allotBillDyArr = serviceHelper.query("id", qFilters, "billno desc");
        ArrayList<Long> selectIdList = new ArrayList<Long>(allotBillDyArr.length);
        for (DynamicObject allotBillDy : allotBillDyArr) {
            long allotBillId = allotBillDy.getLong("id");
            selectIdList.add(allotBillId);
        }
        return selectIdList;
    }

    public static List<Map<String, Object>> setAllotBillInfo(DynamicObject dynamicObject, int assuCurPrecision) {
        ArrayList<Map<String, Object>> subList = new ArrayList<Map<String, Object>>(10);
        LinkedHashMap<String, Object> valueMapOne = new LinkedHashMap<String, Object>(1);
        valueMapOne.put("allotbillkey", "");
        valueMapOne.put("allotbillvalue", dynamicObject.getLong("id"));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7", (String)"CostAllotBillExportHelper_9", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getString("org.name"));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u5206\u914d\u5355\u7f16\u53f7", (String)"CostAllotBillExportHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getString("billno"));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848", (String)"CostAllotBillExportHelper_4", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getString("costadapter.name"));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u8d39\u7528\u603b\u989d", (String)"CostAllotBillExportHelper_5", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getBigDecimal("amountsum").setScale(assuCurPrecision, RoundingMode.HALF_UP));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u627f\u62c5\u5e01\u79cd", (String)"CostAllotBillExportHelper_10", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getString("costadapter.currency.name"));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"CostAllotBillExportHelper_6", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getString("creator.name"));
        subList.add(valueMapOne);
        Date createTime = dynamicObject.getDate("createtime");
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"CostAllotBillExportHelper_7", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", createTime == null ? null : SWCDateTimeUtils.format((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss"));
        subList.add(valueMapOne);
        valueMapOne = new LinkedHashMap(1);
        valueMapOne.put("allotbillkey", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"CostAllotBillExportHelper_8", (String)"swc-pcs-business", (Object[])new Object[0]));
        valueMapOne.put("allotbillvalue", dynamicObject.getString("description"));
        subList.add(valueMapOne);
        return subList;
    }

    private static Map<String, Object> setFixColumnValue(int rowSeq, DynamicObject allotBillDetailEntryDy, int assuCurPrecision) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(16);
        valueMap.put("rowSeq", rowSeq);
        valueMap.put("costitem", allotBillDetailEntryDy.getString("costitem.name"));
        valueMap.put("assuamount", allotBillDetailEntryDy.getBigDecimal("assuamount").setScale(assuCurPrecision, RoundingMode.HALF_UP));
        Date startDate = allotBillDetailEntryDy.getDate("startdate");
        Date endDate = allotBillDetailEntryDy.getDate("enddate");
        Date payDate = allotBillDetailEntryDy.getDate("paydate");
        valueMap.put("startdate", startDate == null ? null : SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
        valueMap.put("enddate", endDate == null ? null : SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
        valueMap.put("paydate", payDate == null ? null : SWCDateTimeUtils.format((Date)payDate, (String)"yyyy-MM-dd"));
        return valueMap;
    }

    public static void setAllotBillEntryInfo(Map<Long, DynamicObject> constEntryIdMap, Map<String, DynamicObject> allDimensionMap, int rowSeq, DynamicObject costAllotBillDy, List<Map<String, Object>> allotBillInfoList, Map<String, HashMap<String, DynamicObject>> baseDataValueMap, Map<String, String> queryCostStruMap) {
        DynamicObjectCollection allotBillDetailEntryDys = costAllotBillDy.getDynamicObjectCollection("entryentity");
        if (allotBillDetailEntryDys.isEmpty()) {
            return;
        }
        int assuCurPrecision = costAllotBillDy.getInt("costadapter.currency.amtprecision");
        for (DynamicObject allotBillDetailEntryDy : allotBillDetailEntryDys) {
            Map<String, Object> valueMap = CostAllotBillExportHelper.setFixColumnValue(rowSeq, allotBillDetailEntryDy, assuCurPrecision);
            CostAllotBillExportHelper.setDynamicColumnValueByEntryInfo(constEntryIdMap, allDimensionMap, valueMap, allotBillDetailEntryDy, baseDataValueMap, queryCostStruMap);
            allotBillInfoList.add(valueMap);
            ++rowSeq;
        }
    }

    private static void setDynamicColumnValueByEntryInfo(Map<Long, DynamicObject> constEntryIdMap, Map<String, DynamicObject> allDimensionMap, Map<String, Object> valueMap, DynamicObject allotBillEntryDy, Map<String, HashMap<String, DynamicObject>> baseDataValueMap, Map<String, String> queryCostStruMap) {
        long costSetUpConstId = allotBillEntryDy.getLong("costsetupconst.id");
        DynamicObject constResult = constEntryIdMap.get(costSetUpConstId);
        if (constResult == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> iterator = queryCostStruMap.entrySet().iterator();
        CostCommonHelper.setDynamicColumnValue(valueMap, constResult, allDimensionMap, iterator, baseDataValueMap);
    }
}

