/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallotbill.helper;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostSplitHelper;
import kd.swc.pcs.business.costallot.service.CostBuildAllotBillService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CostAllotBillItfHelper {
    private static final Log LOGGER = LogFactory.getLog(CostAllotBillItfHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MESSAGE = "message";
    private static Set<String> MUST_INPUT_FIELDS = new HashSet<String>(Arrays.asList("costadaption", "org"));
    private static Set<String> CAL_TASK_ACCORD = new HashSet<String>(Arrays.asList("0", "1", "2", "3"));

    public Map<String, Object> generateAllotBills(Map<String, Object> param) {
        if (null == param) {
            return null;
        }
        param.put(KEY_SUCCESS, Boolean.TRUE);
        List data = (List)param.get("data");
        if (CollectionUtils.isEmpty((Collection)data)) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "Input param is Empty!");
            return param;
        }
        if (data.size() > 1000) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MESSAGE, "Data size over 1000!");
            return param;
        }
        for (Map rec : data) {
            this.doVerifyAndSave(rec);
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVerifyAndSave(Map<String, Object> record) {
        if (MapUtils.isEmpty(record)) {
            return;
        }
        LOGGER.info("CostAllotBillItfHelper.doVerifyAndSave record is\uff1a {}", record);
        try {
            record.put(KEY_SUCCESS, Boolean.TRUE);
            if (this.checkMustInput(record) && this.checkValue(record)) {
                List<Long> allotDetails;
                CostBuildAllotBillService service;
                Map<String, Object> resultMap;
                String errorMsg;
                Long costAdaptionId = MapUtils.getLong(record, (Object)"costadaption");
                DynamicObject splitBillRuleDy = CostSplitHelper.getSplitBillRuleByAdaptionId(costAdaptionId);
                if (splitBillRuleDy != null) {
                    Long splitBillRuleDyId = splitBillRuleDy.getLong("id");
                    record.put("splitbillrule", splitBillRuleDyId);
                }
                if (SWCStringUtils.isNotEmpty((String)(errorMsg = (String)(resultMap = (service = new CostBuildAllotBillService()).buildAllotBillNew(record, allotDetails = this.getLongList((List)record.get("allotdetails")))).get("errorMsg")))) {
                    record.put(KEY_SUCCESS, Boolean.FALSE);
                    record.put(KEY_MESSAGE, errorMsg);
                } else {
                    record.put("allotbills", resultMap.get("allotbillids"));
                }
            }
        }
        catch (Exception exp) {
            LOGGER.error("Execution Failure.", (Throwable)exp);
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, "Execution failure!");
        }
        finally {
            record.remove("splitbillrule");
        }
    }

    private boolean checkMustInput(Map<String, Object> record) {
        boolean isPass = true;
        ArrayList<String> notPassFields = new ArrayList<String>(2);
        for (String field : MUST_INPUT_FIELDS) {
            if (!SWCObjectUtils.isEmpty((Object)record.get(field))) continue;
            isPass = false;
            notPassFields.add(field);
        }
        if (!isPass) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u5fc5\u586b\u3002", (String)"CostAllotBillItfHelper_0", (String)"swc-pcs-business", (Object[])new Object[0]), notPassFields.stream().collect(Collectors.joining("\u3001"))));
            return false;
        }
        String caltaskAccord = MapUtils.getString(record, (Object)"caltaskaccord");
        if (!this.isAssignDetails(record) && SWCStringUtils.isEmpty((String)caltaskAccord)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u4e3a\u7a7a\u65f6\uff0c\u6570\u636e\u8303\u56f4\u5fc5\u586b\u3002", (String)"CostAllotBillItfHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkValue(Map<String, Object> record) {
        return this.checkCostAdaption(record) && this.checkOrgExists(record) && this.checkAllotDetails(record) && this.checkCalTaskAccord(record) && this.checkDateRange(record) && this.checkCalTasks(record);
    }

    private boolean checkCostAdaption(Map<String, Object> record) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("lcs_costadaption");
        Long costAdaptionId = MapUtils.getLong(record, (Object)"costadaption");
        DynamicObject costAdaption = helper.queryOne((Object)costAdaptionId);
        if (SWCObjectUtils.isEmpty((Object)costAdaption)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"CostAllotBillItfHelper_2", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        if (!"C".equals(costAdaption.getString("status"))) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u3002", (String)"CostAllotBillItfHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkAllotDetails(Map<String, Object> record) {
        Object allotDetailsObj = record.get("allotdetails");
        if (null == allotDetailsObj) {
            return true;
        }
        List<Long> allotDetails = this.getLongList((List)allotDetailsObj);
        if (null == allotDetails || CollectionUtils.isEmpty(allotDetails)) {
            return true;
        }
        QFilter filter = new QFilter("id", "in", allotDetails);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        DynamicObject[] allotDetailArr = helper.query("id, allotbillstatus", new QFilter[]{filter});
        HashSet<Long> existsIds = new HashSet<Long>(16);
        HashSet<Long> unGenerateIds = new HashSet<Long>(16);
        for (DynamicObject allotDetail : allotDetailArr) {
            existsIds.add(allotDetail.getLong("id"));
            if (!"A".equals(allotDetail.getString("allotbillstatus"))) continue;
            unGenerateIds.add(allotDetail.getLong("id"));
        }
        List notExistsIds = allotDetails.stream().filter(id -> !existsIds.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notExistsIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u4e0d\u5b58\u5728\uff1a\u201c{0}\u201d\u3002", (String)"CostAllotBillItfHelper_4", (String)"swc-pcs-business", (Object[])new Object[0]), notExistsIds.stream().map(id -> String.valueOf(id)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        List errorIds = allotDetails.stream().filter(id -> !unGenerateIds.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u5df2\u751f\u6210\u5206\u914d\u5355\uff1a\u201c{0}\u201d\u3002", (String)"CostAllotBillItfHelper_5", (String)"swc-pcs-business", (Object[])new Object[0]), errorIds.stream().map(id -> String.valueOf(id)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        return true;
    }

    private boolean checkCalTaskAccord(Map<String, Object> record) {
        if (this.isAssignDetails(record)) {
            return true;
        }
        String caltaskAccord = MapUtils.getString(record, (Object)"caltaskaccord");
        if (SWCStringUtils.isNotEmpty((String)caltaskAccord) && !CAL_TASK_ACCORD.contains(caltaskAccord)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u4e0d\u5b58\u5728\u3002", (String)"CostAllotBillItfHelper_6", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkDateRange(Map<String, Object> record) {
        String caltaskAccord = MapUtils.getString(record, (Object)"caltaskaccord");
        if (this.isAssignDetails(record) || !"1".equals(caltaskAccord) && !"2".equals(caltaskAccord)) {
            return true;
        }
        Object startDateObj = record.get("startdate");
        Object endDateObj = record.get("enddate");
        if (null != startDateObj && !(startDateObj instanceof Date)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, "startdate format error!");
            return false;
        }
        if (null != endDateObj && !(endDateObj instanceof Date)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, "enddate format error!");
            return false;
        }
        Date startDate = (Date)startDateObj;
        Date endDate = (Date)endDateObj;
        if (null != startDate && null != endDate && startDate.after(endDate)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u9700\u65e9\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"CostAllotBillItfHelper_7", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCalTasks(Map<String, Object> record) {
        String caltaskAccord = MapUtils.getString(record, (Object)"caltaskaccord");
        if (this.isAssignDetails(record) || !"3".equals(caltaskAccord)) {
            return true;
        }
        Object calTasksObj = record.get("caltasks");
        if (null == calTasksObj) {
            return true;
        }
        List<Long> calTaskIds = this.getLongList((List)calTasksObj);
        if (null == calTaskIds || CollectionUtils.isEmpty(calTaskIds)) {
            return true;
        }
        QFilter calTaskFilter = new QFilter("id", "in", calTaskIds);
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject[] calTasks = calTaskHelper.query("id", new QFilter[]{calTaskFilter});
        Set calTaskIdInDB = Arrays.stream(calTasks).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        List notExistsIds = calTaskIds.stream().filter(id -> !calTaskIdInDB.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notExistsIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u4e0d\u5b58\u5728\uff1a\u201c{0}\u201d\u3002", (String)"CostAllotBillItfHelper_10", (String)"swc-pcs-business", (Object[])new Object[0]), notExistsIds.stream().map(id -> String.valueOf(id)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        Long orgId = MapUtils.getLong(record, (Object)"org");
        Long costAdaptionId = MapUtils.getLong(record, (Object)"costadaption");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allottask");
        QFilter qFilter = new QFilter("hrorg.id", "=", (Object)orgId);
        qFilter.and(new QFilter("costadapter.id", "=", (Object)costAdaptionId));
        DynamicObject[] allotTaskDys = serviceHelper.query("id,caltask", new QFilter[]{qFilter});
        Set calTaskIdSet = Arrays.stream(allotTaskDys).map(dy -> dy.getLong("caltask.id")).collect(Collectors.toSet());
        List diffIds = calTaskIds.stream().filter(id -> !calTaskIdSet.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(diffIds)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, MessageFormat.format(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5173\u8054\u7684\u6210\u672c\u5206\u644a\u4efb\u52a1\u7684\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u548c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0e\u4f20\u5165\u7684\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u548c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0d\u4e00\u81f4\uff1a\u201c{0}\u201d\u3002", (String)"CostAllotBillItfHelper_11", (String)"swc-pcs-business", (Object[])new Object[0]), diffIds.stream().map(id -> String.valueOf(id)).collect(Collectors.joining("\u3001"))));
            return false;
        }
        return true;
    }

    private boolean checkOrgExists(Map<String, Object> record) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_org");
        Long orgId = MapUtils.getLong(record, (Object)"org");
        DynamicObject org = helper.queryOne((Object)orgId);
        if (SWCObjectUtils.isEmpty((Object)org)) {
            record.put(KEY_SUCCESS, Boolean.FALSE);
            record.put(KEY_MESSAGE, ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CostAllotBillItfHelper_9", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isAssignDetails(Map<String, Object> record) {
        List<Long> allotDetails = this.getLongList((List)record.get("allotdetails"));
        return CollectionUtils.isNotEmpty(allotDetails);
    }

    private List<Long> getLongList(List<Object> objects) {
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        ArrayList<Long> longList = new ArrayList<Long>(objects.size());
        for (Object obj : objects) {
            Number answer = CostAllotBillItfHelper.getNumber(obj);
            Long value = answer == null ? null : (answer instanceof Long ? (Long)answer : Long.valueOf(answer.longValue()));
            longList.add(value);
        }
        return longList;
    }

    public static Number getNumber(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                try {
                    String text = (String)value;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

