/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;

public class CostAllocationHelper {
    private static Map<String, String> costSetUpFixPropertiesMap = new HashMap<String, String>();

    public static Map<String, String> getCostSetUpFixPropertiesMap() {
        return costSetUpFixPropertiesMap;
    }

    public static String getUseTime(Date createTime, Date finishTime) {
        String secondDes = ResManager.loadKDString((String)"\u79d2", (String)"CostAllocationHelper_0", (String)"swc-pcs-business", (Object[])new Object[0]);
        String minuteDes = ResManager.loadKDString((String)"\u5206\u949f", (String)"CostAllocationHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]);
        String hourDes = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"CostAllocationHelper_2", (String)"swc-pcs-business", (Object[])new Object[0]);
        String useTime = '1' + secondDes;
        if (null != createTime && null != finishTime) {
            long between = (finishTime.getTime() - createTime.getTime()) / 1000L;
            if (between != 0L) {
                StringBuilder sb = new StringBuilder();
                long hour = between / 3600L;
                long minute = between % 3600L / 60L;
                long second = between % 60L;
                if (hour != 0L) {
                    sb.append(hour).append(hourDes);
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else if (minute != 0L) {
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else {
                    sb.append(second).append(secondDes);
                }
                useTime = sb.toString();
            }
        } else {
            useTime = "";
        }
        return useTime;
    }

    private static long saveCostAllocationInfo(IPageCache pageCache, String calTaskId, String costAdapterId, int fileNumber) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_costallocation");
        DynamicObject costAllocationDy = CostAllocationHelper.queryCostAllocationByCalTaskId(Long.valueOf(calTaskId));
        if (costAllocationDy == null) {
            costAllocationDy = costAllocationHelper.generateEmptyDynamicObject();
            costAllocationDy.set("createtime", (Object)new Date());
        }
        costAllocationDy.set("caltask", (Object)calTaskId);
        costAllocationDy.set("costtaskstatus", (Object)"2");
        long userId = RequestContext.get().getCurrUserId();
        costAllocationDy.set("status", (Object)"A");
        costAllocationDy.set("enable", (Object)"1");
        costAllocationDy.set("viewdetail", (Object)"0");
        costAllocationDy.set("creator", (Object)userId);
        costAllocationDy.set("modifier", (Object)userId);
        costAllocationDy.set("modifytime", (Object)new Date());
        costAllocationDy.set("costfilenum", (Object)fileNumber);
        costAllocationDy.set("caltaskpersonnum", (Object)fileNumber);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(calTaskId));
        DynamicObject calTaskDy = helper.queryOne("id,period", new QFilter[]{qFilter});
        long periodId = calTaskDy.getLong("period.id");
        Date date = calTaskDy.getDate("period.perioddate");
        if (date != null) {
            String format = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM");
            costAllocationDy.set("payrolldatestr", (Object)format);
        }
        long adaptionOrgId = CostCfgHelper.getAdaptionOrgId(Long.valueOf(costAdapterId));
        costAllocationDy.set("hrorg", (Object)adaptionOrgId);
        costAllocationDy.set("costadapter", (Object)costAdapterId);
        costAllocationDy.set("period", (Object)periodId);
        costAllocationHelper.saveOne(costAllocationDy);
        return costAllocationDy.getLong("id");
    }

    private static DynamicObject saveCostAllocationRecordInfo(int costFileNum, String calTaskId, String recordtype) {
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        DynamicObject costAllocationRecordDy = costRecordHelper.generateEmptyDynamicObject();
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(calTaskId));
        DynamicObject calTaskDy = calTaskHelper.queryOne("id,number,period.number,periodtype.number,", new QFilter[]{filter});
        String calTaskNumber = calTaskDy.getString("number");
        String periodNumber = calTaskDy.getString("period.number");
        String periodTypeNumber = calTaskDy.getString("periodtype.number");
        if (periodNumber == null) {
            costAllocationRecordDy.set("calperiodnumber", (Object)"");
        } else {
            String calPeriodAndTypeNumber = periodTypeNumber + '-' + periodNumber;
            costAllocationRecordDy.set("calperiodnumber", (Object)calPeriodAndTypeNumber);
        }
        costAllocationRecordDy.set("caltask", (Object)calTaskId);
        String recordNumber = CostAllocationHelper.getRecordNumber();
        costAllocationRecordDy.set("recordnumber", (Object)(calTaskNumber + '-' + recordNumber));
        costAllocationRecordDy.set("costtaskstatus", (Object)"2");
        costAllocationRecordDy.set("createtime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        costAllocationRecordDy.set("creator", (Object)userId);
        costAllocationRecordDy.set("modifier", (Object)userId);
        costAllocationRecordDy.set("modifytime", (Object)new Date());
        costAllocationRecordDy.set("totalcount", (Object)costFileNum);
        costAllocationRecordDy.set("failcount", (Object)0);
        costAllocationRecordDy.set("recordtype", (Object)recordtype);
        costRecordHelper.saveOne(costAllocationRecordDy);
        return costAllocationRecordDy;
    }

    private static String getRecordNumber() {
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        DynamicObject costRecordDy = costRecordHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.getNumber((String)"pcs_costrecord", (DynamicObject)costRecordDy, null);
    }

    public static Map<String, String> queryCostStruMustInputField(long costStruId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "=", (Object)costStruId);
        DynamicObject queryResult = costStruHelper.queryOne("id,dimensionentry,costdimension,storageset,costdimension.valuetype,costdimension.name,isrequired", new QFilter[]{filter});
        DynamicObjectCollection dimensionEntryColl = queryResult.getDynamicObjectCollection("dimensionentry");
        HashMap<String, String> mustInputFieldMap = new HashMap<String, String>(16);
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String costDimensionName = dimensionDy.getString("costdimension.name");
            String costDimensionIdKey = "1".equals(valueType) || "2".equals(valueType) ? "basedata" + costDimensionId : "text" + costDimensionId;
            boolean isRequired = dimensionDy.getBoolean("isrequired");
            if (!isRequired) continue;
            mustInputFieldMap.put(costDimensionIdKey, costDimensionName);
        }
        return mustInputFieldMap;
    }

    public static Map<String, String> queryCostStruShowDisPropMap(long costStruId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "=", (Object)costStruId);
        DynamicObject queryResult = costStruHelper.queryOne("id,dimensionentry,costdimension,storageset,costdimension.valuetype,costdimension.displayproperty", new QFilter[]{filter});
        DynamicObjectCollection dimensionEntryColl = queryResult.getDynamicObjectCollection("dimensionentry");
        HashMap<String, String> baseDataPropMap = new HashMap<String, String>(16);
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String costDimensionIdKey = "1".equals(valueType) || "2".equals(valueType) ? "basedata" + String.valueOf(costDimensionId) : "text" + String.valueOf(costDimensionId);
            String displayProperty = dimensionDy.getString("costdimension.displayproperty");
            baseDataPropMap.put(costDimensionIdKey, displayProperty);
        }
        return baseDataPropMap;
    }

    public static DynamicObject queryCostStruObjById(Long costStruId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        return serviceHelper.queryOne("id,costdimension,storageset", new QFilter[]{new QFilter("id", "=", (Object)costStruId)});
    }

    public static DynamicObject queryCostAllocationByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_costallocation");
        return costAllocationHelper.queryOne("costtaskstatus,id,costfilenum,caltaskpersonnum,caltask,status,enable,viewdetail,creator,modifier,createtime,modifytime,costfilenum,caltaskpersonnum,payrolldatestr,hrorg,costadapter,period", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
    }

    public static Map<Long, DynamicObject> queryCostAllocationByCalTaskIds(Collection<Long> calTaskIds) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_costallocation");
        DynamicObject[] query = costAllocationHelper.query("costtaskstatus,id,costfilenum,caltaskpersonnum,caltask,status,enable,viewdetail,creator,modifier,createtime,modifytime,costfilenum,caltaskpersonnum,payrolldatestr,hrorg,costadapter,period", new QFilter[]{new QFilter("caltask.id", "in", calTaskIds)});
        return Arrays.stream(query).collect(Collectors.toMap(ele -> ele.getLong("caltask.id"), ele -> ele, (k1, k2) -> k1));
    }

    public static void setCostInfoToCache(ClosedCallBackEvent e, IFormView view) {
        Map returnDataMap = (Map)e.getReturnData();
        Map calTaskFileRlsMap = (Map)returnDataMap.get("calTaskFileRlsMap");
        String generateStrategy = (String)returnDataMap.get("generatesStrategy");
        IPageCache pageCache = view.getPageCache();
        pageCache.put("calTaskFileRlsMap", JSON.toJSONString((Object)calTaskFileRlsMap));
        pageCache.put("generatestrategy", generateStrategy);
    }

    public static long saveCostRecordInfo(int costFileNumber, String calTaskId, String recordtype) {
        DynamicObject costAllocationRecordDy = CostAllocationHelper.saveCostAllocationRecordInfo(costFileNumber, calTaskId, recordtype);
        long costAllocationRecordId = costAllocationRecordDy.getLong("id");
        String fileName = costAllocationRecordDy.getString("recordnumber");
        String fileNameKey = String.format(Locale.ROOT, "cache_costallocationrecord_id_key_%s", costAllocationRecordId);
        IAppCache appCache = AppCache.get((String)"pcs");
        appCache.put(fileNameKey, (Object)fileName);
        SWCDataServiceHelper costRecordHelper = new SWCDataServiceHelper("pcs_costrecord");
        costAllocationRecordDy.set("filename", (Object)fileName);
        costRecordHelper.saveOne(costAllocationRecordDy);
        return costAllocationRecordDy.getLong("id");
    }

    private static void openCostAllocationProgress(IFormView view, String className, Map<Long, Long> costAllocationDyIdMap, Map<Long, Long> costAllocationRecordDyIdMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pcs_costallocationprog");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("caltaskids", (Object)JSON.toJSONString(costAllocationDyIdMap.keySet()));
        showParameter.setCustomParam("parentPageId", (Object)view.getPageId());
        showParameter.setCustomParam("costallocationid", (Object)String.valueOf(costAllocationDyIdMap.values().iterator().next()));
        showParameter.setCustomParam("costallocationids", (Object)JSON.toJSONString(costAllocationDyIdMap.values()));
        showParameter.setCustomParam("costallocationrecordids", (Object)JSON.toJSONString(costAllocationRecordDyIdMap.values()));
        CloseCallBack closeCallBack = new CloseCallBack(className, "pcs_costallocationprog");
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public static void preGenerateSetUp(IFormView view, String className) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"1NG6ISYFC0SM");
        if (!hasPerm) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostAllocationHelper_5", (String)"swc-pcs-business", (Object[])new Object[0]));
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String generateStrategy = pageCache.get("generatestrategy");
        String calTaskFileRlsMapStr = view.getPageCache().get("calTaskFileRlsMap");
        Map calTaskFileRlsMap = (Map)JSON.parseObject((String)calTaskFileRlsMapStr, Map.class);
        String calTaskCostAdapterIdRlsMapStr = pageCache.get("calTaskCostAdapterIdRlsMap");
        Map calTaskCostAdapterIdRlsMap = (Map)JSON.parseObject((String)calTaskCostAdapterIdRlsMapStr, Map.class);
        HashMap<Long, Long> costAllocationDyIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> costAllocationRecordDyIdMap = new HashMap<Long, Long>(16);
        for (Map.Entry entry : calTaskFileRlsMap.entrySet()) {
            String calTaskId = String.valueOf(entry.getKey());
            List salaryFileIdList = (List)entry.getValue();
            int costFileNumber = salaryFileIdList.size();
            CostAllocationHelper.setCostAllocationProgressInfo(calTaskId, costFileNumber);
            long costAllocationDyId = CostAllocationHelper.saveCostAllocationInfo(pageCache, calTaskId, String.valueOf(calTaskCostAdapterIdRlsMap.get(Long.valueOf(calTaskId))), costFileNumber);
            long costAllocationRecordDyId = CostAllocationHelper.saveCostRecordInfo(costFileNumber, calTaskId, "0");
            costAllocationDyIdMap.put(Long.valueOf(calTaskId), costAllocationDyId);
            costAllocationRecordDyIdMap.put(Long.valueOf(calTaskId), costAllocationRecordDyId);
        }
        CostAllocationHelper.openCostAllocationProgress(view, className, costAllocationDyIdMap, costAllocationRecordDyIdMap);
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnce((String)"COSTALLOCATIONHELPER_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            long begin = 0L;
            long end = 0L;
            block2: for (Map.Entry entry : calTaskFileRlsMap.entrySet()) {
                String calTaskId = String.valueOf(entry.getKey());
                List salaryFileIdList = (List)entry.getValue();
                SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSCostService", (String)"generateCostSetUp", (Object[])new Object[]{costAllocationDyIdMap.get(Long.valueOf(calTaskId)), costAllocationRecordDyIdMap.get(Long.valueOf(calTaskId)), calTaskCostAdapterIdRlsMap.get(Long.valueOf(calTaskId)), Long.valueOf(calTaskId), salaryFileIdList, generateStrategy});
                begin = System.currentTimeMillis();
                while ((end = System.currentTimeMillis()) - begin <= 3600000L) {
                    int status;
                    CostAllocationProgressInfo progressInfo;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((progressInfo = (CostAllocationProgressInfo)SWCAppCache.get((String)"pcs").get(String.format(Locale.ROOT, "cache_costallocation_key_%s", calTaskId), CostAllocationProgressInfo.class)) != null && (status = progressInfo.getStatus()) != 2) continue;
                    continue block2;
                }
            }
        });
        try {
            Thread.sleep(1000L);
            view.invokeOperation("refresh");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void setCostAllocationProgressInfo(String calTaskId, int total) {
        CostAllocationProgressInfo progress = new CostAllocationProgressInfo();
        progress.setTotal(total);
        progress.setStartDate(new Date());
        progress.setStatus(0);
        String key = String.format(Locale.ROOT, "cache_costallocation_key_%s", calTaskId);
        SWCAppCache.get((String)"pcs").put(key, (Object)progress);
        AppCache.get((String)"pcs").remove(String.format(Locale.ROOT, "istermination_%s", calTaskId));
    }

    public static void openCostGenerateScheme(IFormView view, String className) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("calTaskId", view.getFormShowParameter().getCustomParam("calTaskId"));
        showParameter.setFormId("pcs_costgeneratescheme");
        CloseCallBack closeCallBack = new CloseCallBack(className, "pcs_costgeneratescheme");
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public static DynamicObject getCalTaskId(Long costAllocationId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costallocation");
        QFilter filter = new QFilter("id", "=", (Object)costAllocationId);
        return helper.queryOne("id,caltask,hrorg", new QFilter[]{filter});
    }

    public static boolean isExistsCostSetUp(Long calTaskId) {
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        return serviceHelper.isExists(new QFilter[]{qFilter});
    }

    public static void getCreateFields(DataEntityPropertyCollection properties, List<String> myselfCreateFields, Map<String, BasedataProp> baseDataMap) {
        for (IDataEntityProperty dy : properties) {
            String propertieName = dy.getName();
            if ("id".equals(propertieName) || "seq".equals(propertieName) || propertieName.endsWith("_id")) continue;
            if (propertieName.contains("basedata")) {
                BasedataProp basedataProp = (BasedataProp)dy;
                baseDataMap.put(propertieName, basedataProp);
            }
            myselfCreateFields.add(propertieName);
        }
    }

    public static void setEntryFixColumnInfo(Map<Long, DynamicObject> salaryItemEntryIdMap, Map<String, String> costSetUpFixPropertiesMap, DynamicObject salaryItemDy, DynamicObject setUpSalaryItemDy, DynamicObject newRow, String field, DynamicObject bdCurrencyDy) {
        Long defCostSetupConstId = setUpSalaryItemDy.getLong("id");
        DynamicObject costSetUpSalaryItemDy = salaryItemEntryIdMap.get(defCostSetupConstId);
        if (costSetUpSalaryItemDy == null) {
            newRow.set(field, null);
        } else {
            String resultField = costSetUpFixPropertiesMap.get(field);
            if ("basedata10001".equals(field)) {
                newRow.set(field, (Object)salaryItemDy);
            } else if ("basedata10008".equals(field)) {
                newRow.set(field, (Object)bdCurrencyDy);
            } else {
                newRow.set(field, costSetUpSalaryItemDy.get(resultField));
            }
        }
    }

    public static void setEntryDynamicColumnInfo(Map<Long, DynamicObject> constEntryIdMap, Map<String, String> queryCostStruMap, Map<String, BasedataProp> baseDataMap, DynamicObject setUpSalaryItemDy, DynamicObject newRow, String field) {
        String segmentNumber = queryCostStruMap.get(field);
        Long defCostSetUpConstId = setUpSalaryItemDy.getLong("defcostsetupconst.id");
        DynamicObject constDy = constEntryIdMap.get(defCostSetUpConstId);
        if (constDy == null) {
            newRow.set(field, null);
        } else if (field.contains("basedata")) {
            String baseDataStr = constDy.getString("segment" + segmentNumber);
            if (!baseDataStr.isEmpty()) {
                BasedataProp basedataProp = baseDataMap.get(field);
                String baseEntityId = basedataProp.getBaseEntityId();
                DynamicObject loadSingleFromCache = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(baseDataStr), (String)baseEntityId);
                newRow.set(field, (Object)loadSingleFromCache);
            }
        } else {
            newRow.set(field, constDy.get("segment" + segmentNumber));
        }
    }

    public static QFilter getTaskFilter() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costadaptionmap");
        QFilter filter = new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP).and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] ad = helper.query("source", new QFilter[]{filter});
        List payrollGroupVid = Arrays.stream(ad).map(o -> o.getLong("source")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("payrollgroupv.id", "in", payrollGroupVid);
        taskFilter.and(new QFilter("calpersoncount", ">", (Object)0));
        taskFilter.and(new QFilter("tasktype", "!=", (Object)"2"));
        Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costallocation", (String)"47150e89000000ac");
        if (payRollCalSet != null) {
            QFilter payRollCalFilter = new QFilter("org.id", "in", (Object)payRollCalSet);
            taskFilter.and(payRollCalFilter);
        }
        helper = new SWCDataServiceHelper("hsas_payrollscene");
        filter = new QFilter("schemeaftercal.costallot", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection sceneObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (!SWCListUtils.isEmpty((List)sceneObjs)) {
            List sceneIdList = sceneObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
            taskFilter.and("payrollscenev.id", "in", sceneIdList);
        }
        return taskFilter;
    }

    public static void openProgressBallByCalTaskId(IFormView view, String calTaskIds) {
        IFormView parentView;
        String parentPageId = (String)view.getFormShowParameter().getCustomParam("parentPageId");
        String costAllocationId = (String)view.getFormShowParameter().getCustomParam("costallocationid");
        String costAllocationIds = (String)view.getFormShowParameter().getCustomParam("costallocationids");
        String costAllocationRecordDyIds = (String)view.getFormShowParameter().getCustomParam("costallocationrecordids");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("caltaskids", String.valueOf(calTaskIds));
        params.put("parentPageId", String.valueOf(parentPageId));
        params.put("costallocationid", costAllocationId);
        params.put("costAllocationIds", costAllocationIds);
        params.put("costallocationrecordids", costAllocationRecordDyIds);
        String mainViewId = "";
        IFormView mainView = view.getMainView();
        if (mainView != null) {
            mainViewId = mainView.getPageId();
        }
        String parentViewId = (parentView = view.getParentView()) == null ? "" : parentView.getPageId();
        String name = ResManager.loadKDString((String)"\u751f\u6210\u6210\u672c\u5206\u644a\u7ed3\u6784\u60ac\u6d6e\u7403\u4efb\u52a1", (String)"CostAllocationHelper_7", (String)"swc-pcs-business", (Object[])new Object[0]);
        String taskId = (String)view.getFormShowParameter().getCustomParam("taskId");
        if (SWCStringUtils.isEmpty((String)taskId)) {
            taskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_pcs_costallocation", name, false, mainViewId, parentViewId, params);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        HRBackgroundTaskHelper.getInstance().showBaskgroundTask(taskId);
    }

    static {
        costSetUpFixPropertiesMap.put("basedata10001", "salaryitem");
        costSetUpFixPropertiesMap.put("checkbox10006", "isrevealdetail");
        costSetUpFixPropertiesMap.put("decimal10007", "percentage");
        costSetUpFixPropertiesMap.put("basedata10008", "calcurrencyid");
    }
}

