/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostCfgExportHelper {
    public static final String SWC_PCS_BUSINESS = "swc-pcs-business";

    public static Map<String, String> getExportColumnMap(String billFormId, Long costAdapterId) {
        LinkedHashMap<String, String> entryHeadMap = new LinkedHashMap<String, String>(16);
        entryHeadMap.put("orgNumber", ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7.\u7f16\u7801", (String)"CostCfgExportHelper_36", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        CostCfgExportHelper.addFixExportColumnByBillName(billFormId, entryHeadMap);
        CostCfgExportHelper.addFixExportColumn(entryHeadMap, billFormId);
        CostCfgExportHelper.addDynamicsExportColumn(costAdapterId, entryHeadMap, billFormId);
        return entryHeadMap;
    }

    private static void addFixExportColumn(LinkedHashMap<String, String> entryHeadMap, String billFormId) {
        entryHeadMap.put("bsed", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"CostCfgExportHelper_38", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        if ("pcs_costdeptcfg".equals(billFormId) || "pcs_costitemcfg".equals(billFormId)) {
            entryHeadMap.put("costCfgType", ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u7c7b\u578b", (String)"CostCfgExportHelper_37", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        }
        entryHeadMap.put("proportion", ResManager.loadKDString((String)"\u767e\u5206\u6bd4(%)", (String)"CostCfgExportHelper_26", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
    }

    private static void addDynamicsExportColumn(Long costAdapterId, LinkedHashMap<String, String> entryHeadMap, String billFormId) {
        if (costAdapterId == null || costAdapterId == 0L) {
            return;
        }
        Long costStruId = CostCfgExportHelper.queryCostStruByAdapter(costAdapterId);
        Map<String, String> segmentAndDimNameMap = CostCommonHelper.queryCostStruSegmentAndDimNameMap(costStruId, billFormId);
        for (Map.Entry<String, String> next : segmentAndDimNameMap.entrySet()) {
            String key = next.getKey();
            String value = next.getValue();
            entryHeadMap.put("segment" + key, value);
        }
    }

    public static void addFixExportColumnByBillName(String billFormId, LinkedHashMap<String, String> map) {
        switch (billFormId) {
            case "pcs_costdeptcfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u7ec4\u7ec7.\u7f16\u7801", (String)"CostCfgExportHelper_27", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u7ec4\u7ec7.\u540d\u79f0", (String)"CostCfgExportHelper_39", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costitemcfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee.\u7f16\u7801", (String)"CostCfgExportHelper_28", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee.\u540d\u79f0", (String)"CostCfgExportHelper_29", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costempcfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CostCfgExportHelper_25", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CostCfgExportHelper_10", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costpostcfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u5c97\u4f4d.\u7f16\u7801", (String)"CostCfgExportHelper_31", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u5c97\u4f4d.\u540d\u79f0", (String)"CostCfgExportHelper_30", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costsalaryfilecfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7", (String)"CostCfgExportHelper_18", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CostCfgExportHelper_10", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costsalaryitemcfg": {
                map.put("salaryFileNumber", ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7", (String)"CostCfgExportHelper_18", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("personName", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CostCfgExportHelper_10", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee.\u7f16\u7801", (String)"CostCfgExportHelper_28", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee.\u540d\u79f0", (String)"CostCfgExportHelper_29", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costgroupcfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4.\u7f16\u7801", (String)"CostCfgExportHelper_32", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4.\u540d\u79f0", (String)"CostCfgExportHelper_33", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
            case "pcs_costjobcfg": {
                map.put("costCfgNumber", ResManager.loadKDString((String)"\u804c\u4f4d.\u7f16\u7801", (String)"CostCfgExportHelper_34", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                map.put("costCfgName", ResManager.loadKDString((String)"\u804c\u4f4d.\u540d\u79f0", (String)"CostCfgExportHelper_35", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
                break;
            }
        }
    }

    public static Map<Long, DynamicObject> getCostSegmentMap(List<Long> costSegmentIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costsegstore");
        DynamicObject[] costSegmentQueryResult = helper.query(costSegmentIds.toArray());
        HashMap<Long, DynamicObject> costSegmentIdMap = new HashMap<Long, DynamicObject>(costSegmentQueryResult.length);
        for (DynamicObject costSegmentDy : costSegmentQueryResult) {
            long costSegmentId = costSegmentDy.getLong("id");
            costSegmentIdMap.put(costSegmentId, costSegmentDy);
        }
        return costSegmentIdMap;
    }

    public static int getExportTotalSize(String billFormId, Long sourceTypeId, List<QFilter> filters) {
        QFilter sourceIdQFilter = new QFilter("sourcetype.id", "=", (Object)sourceTypeId);
        if (!CollectionUtils.isEmpty(filters)) {
            for (QFilter filter : filters) {
                sourceIdQFilter.and(filter);
            }
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(billFormId);
        return serviceHelper.count(new QFilter[]{sourceIdQFilter});
    }

    public static Long queryCostStruByAdapter(Long costAdapterId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter idFilter = new QFilter("id", "=", (Object)costAdapterId);
        DynamicObject costAdaptionDy = serviceHelper.queryOne("id,coststru", new QFilter[]{idFilter});
        return costAdaptionDy == null ? 0L : costAdaptionDy.getLong("coststru.id");
    }

    public static Map<Long, Long> getEmpAndPosOrgRelMap(List<Long> sourceIdList, Long costCfgTypeId) {
        HashMap<Long, Long> empIdAndRelMap = new HashMap<Long, Long>(16);
        if (SWCCostConstants.COST_TYPE_EMP.longValue() == costCfgTypeId.longValue()) {
            DynamicObject[] queryResultArray;
            SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hrpi_empposorgrel");
            QFilter empFilter = new QFilter("employee.id", "in", sourceIdList);
            empFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
            for (DynamicObject queryResult : queryResultArray = empHelper.query("id,employee", new QFilter[]{empFilter})) {
                long empPosOrgRelId = queryResult.getLong("id");
                long employeeId = queryResult.getLong("employee.id");
                empIdAndRelMap.put(employeeId, empPosOrgRelId);
            }
        }
        return empIdAndRelMap;
    }
}

