/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostCfgHelper {
    private static final String HSBS_FINANCE_PARAM = "hsbs_finance_param";
    private static final String FINANCE_SWC = "finance_swc";

    private static Map<Long, Integer> getDimensionIdRefSeqMap(Long costStruId, Long costBizObjId, String costType) {
        String properties = "dimensionentry.costdimension,dimensionentry.seq,subentryentity.costbizobj";
        DynamicObject costStru = CostCfgHelper.getCostStruObj(properties, costStruId);
        HashMap<Long, Integer> dimensionIdRefSeqMap = new HashMap<Long, Integer>(16);
        if (costStru == null) {
            return dimensionIdRefSeqMap;
        }
        DynamicObjectCollection entryEntity = costStru.getDynamicObjectCollection("dimensionentry");
        block0: for (DynamicObject dimensionObj : entryEntity) {
            DynamicObjectCollection subEntryEntity = dimensionObj.getDynamicObjectCollection("subentryentity");
            Long dimensionalityId = dimensionObj.getLong("costdimension.id");
            int seq = dimensionObj.getInt("seq");
            if ("COST".equals(costType)) {
                for (DynamicObject subEntity : subEntryEntity) {
                    long subCostBizObjId = subEntity.getLong("costbizobj.id");
                    if (costBizObjId != subCostBizObjId) continue;
                    dimensionIdRefSeqMap.put(dimensionalityId, seq);
                    continue block0;
                }
                continue;
            }
            dimensionIdRefSeqMap.put(dimensionalityId, seq);
        }
        return dimensionIdRefSeqMap;
    }

    private static DynamicObject getCostStruObj(String properties, Long costStruId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter idFilter = new QFilter("id", "=", (Object)costStruId);
        return serviceHelper.queryOne(properties, new QFilter[]{idFilter});
    }

    public static Map<Long, JSONArray> getDimensionEntIdIdRefDefRuleMap(Long costStruId, Long costBizObjId) {
        String properties = "dimensionentry.costdimension,defsubentryentity.defcostbizobj,defsubentryentity.defaultrule";
        DynamicObject costStru = CostCfgHelper.getCostStruObj(properties, costStruId);
        DynamicObjectCollection costStruEnt = costStru.getDynamicObjectCollection("dimensionentry");
        HashMap<Long, JSONArray> costDimensionEntIdIdRefDefRuleMap = new HashMap<Long, JSONArray>(16);
        costStruEnt.forEach(costStruEntObj -> {
            Long costStruEntObjId = costStruEntObj.getLong("costdimension.id");
            DynamicObjectCollection subEntryEntity = costStruEntObj.getDynamicObjectCollection("defsubentryentity");
            for (DynamicObject subEntryEntityObj : subEntryEntity) {
                long subCostBizObjId = subEntryEntityObj.getLong("defcostbizobj.id");
                String defaultRule = subEntryEntityObj.getString("defaultrule");
                if (costBizObjId == null || costBizObjId != subCostBizObjId || !SWCStringUtils.isNotEmpty((String)defaultRule)) continue;
                JSONArray defaultRuleArr = JSONObject.parseArray((String)defaultRule);
                costDimensionEntIdIdRefDefRuleMap.put(costStruEntObjId, defaultRuleArr);
                break;
            }
        });
        return costDimensionEntIdIdRefDefRuleMap;
    }

    private static List<DynamicObject> getDimensionListByIds(Object dimensionIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costdimension");
        QFilter idFilter = new QFilter("id", "in", dimensionIds);
        DynamicObject[] dimensionObjArr = serviceHelper.query("name,valuetype,valuesource,dentityid,displayproperty", new QFilter[]{idFilter});
        ArrayList<DynamicObject> dimensionList = new ArrayList<DynamicObject>(dimensionObjArr.length);
        Collections.addAll(dimensionList, dimensionObjArr);
        return dimensionList;
    }

    public static List<DynamicObject> getSortedDimensionList(Long costStruId, Long costBizObjId, String costType) {
        final Map<Long, Integer> dimensionIdRefSeqMap = CostCfgHelper.getDimensionIdRefSeqMap(costStruId, costBizObjId, costType);
        if (dimensionIdRefSeqMap == null || dimensionIdRefSeqMap.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> dimensionList = CostCfgHelper.getDimensionListByIds(dimensionIdRefSeqMap.keySet());
        dimensionList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return ((Integer)dimensionIdRefSeqMap.get(o1.getLong("id"))).compareTo((Integer)dimensionIdRefSeqMap.get(o2.getLong("id")));
            }
        });
        return dimensionList;
    }

    public static FieldAp createFieldAp(String name, String key) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setKey(key);
        fieldAp.setBackColor("");
        fieldAp.setLock("");
        fieldAp.setHidden(false);
        fieldAp.setHyperlink(false);
        fieldAp.setFireUpdEvt(true);
        fieldAp.setWidth(new LocaleString("100"));
        fieldAp.setTextAlign("left");
        fieldAp.setQuickAddNew(false);
        fieldAp.setFieldForeColor("#000000");
        return fieldAp;
    }

    public static void setCostCfgInfo(IFormView view, long sourceTypeId) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object sourceId = formShowParameter.getCustomParam("sourceid");
        Object costAdapterId = formShowParameter.getCustomParam("costadapterid");
        Object costStruId = formShowParameter.getCustomParam("coststruid");
        Object orgId = formShowParameter.getCustomParam("orgid");
        view.getModel().setValue("costadapter", costAdapterId);
        view.getModel().setValue("coststru", costStruId);
        view.getModel().setValue("sourcetype", (Object)sourceTypeId);
        view.getModel().setValue("source", sourceId);
        view.getModel().setValue("createorg", orgId);
        SWCPageCache pageCache = new SWCPageCache(view.getParentView());
        Date date = (Date)pageCache.get("defaultbsed", Date.class);
        if (date == null) {
            view.getModel().setValue("bsed", (Object)SWCDateTimeUtils.getTodayDateWithoutTime());
        } else {
            view.getModel().setValue("bsed", (Object)date);
        }
    }

    public static long getEmpPosOrgRelId(Long sourceId) {
        long empPosOrgRelId = 0L;
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter empFilter = new QFilter("employee.id", "=", (Object)sourceId);
        empFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        DynamicObject empPosRelDy = empHelper.queryOne("id", new QFilter[]{empFilter});
        if (empPosRelDy != null) {
            empPosOrgRelId = empPosRelDy.getLong("id");
        }
        return empPosOrgRelId;
    }

    public static void clickCostCfgAdd(IFormView view, String className) {
        CostCfgHelper.openCostCfgAddForm(view, className);
    }

    private static void openCostCfgAddForm(IFormView view, String className) {
        String billFormId = ((ListView)view).getBillFormId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("pcs_costcfgadd");
        showParameter.setCloseCallBack(new CloseCallBack(className, billFormId));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        if (mainEntityType != null) {
            String displayName = mainEntityType.getDisplayName().getLocaleValue();
            showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65b0\u589e%s", (String)"CostCfgHelper_6", (String)"swc-pcs-business", (Object[])new Object[0]), displayName));
        }
        view.showForm(showParameter);
    }

    public static List<Long> getCostCfgTypeIds(String billFormId, Long costAdapterId) {
        SWCDataServiceHelper costCfgHelper = new SWCDataServiceHelper(billFormId);
        Map<String, Long> costCfgTypeMap = CostCommonHelper.getCostCfgTypeMap();
        Long costCfgTypeId = costCfgTypeMap.get(billFormId);
        QFilter qFilter = new QFilter("sourcetype", "=", (Object)costCfgTypeId);
        qFilter.and(new QFilter("costadapter", "=", (Object)costAdapterId));
        String queryField = CostCfgHelper.getQueryField(billFormId);
        DynamicObject[] dynamicObjects = costCfgHelper.query(queryField, new QFilter[]{qFilter});
        ArrayList<Long> sourceIds = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long sourceId;
            if ("pcs_costitemcfg".equals(billFormId)) {
                long sourceId2;
                String qualityName = dynamicObject.getString("qualityname");
                if (!SWCStringUtils.isEmpty((String)qualityName) || sourceIds.contains(sourceId2 = dynamicObject.getLong("source.id"))) continue;
                sourceIds.add(sourceId2);
                continue;
            }
            if ("pcs_costsalaryitemcfg".equals(billFormId) || sourceIds.contains(sourceId = dynamicObject.getLong("source.id"))) continue;
            sourceIds.add(sourceId);
        }
        return sourceIds;
    }

    private static String getQueryField(String billFormId) {
        String filed = "pcs_costitemcfg".equals(billFormId) ? "id,source.id,qualityname" : ("pcs_costsalaryitemcfg".equals(billFormId) ? "id,source.id,creatorobj.id" : "id,source.id");
        return filed;
    }

    public static long getAdaptionOrgId(Long adaptionId) {
        SWCDataServiceHelper costCfgHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter qFilter = new QFilter("id", "=", (Object)adaptionId);
        DynamicObject adaptionDy = costCfgHelper.queryOne("id,createorg", new QFilter[]{qFilter});
        return adaptionDy == null ? 0L : adaptionDy.getLong("createorg.id");
    }

    public static void openCostCfgByType(Object returnData, String costCfgType, String costCfgName, IFormView view, String key) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            Map returnDataMap = (Map)returnData;
            Object primaryKeyValue = returnDataMap.get(key);
            Object costAdapterId = returnDataMap.get("costadaption");
            Object costStruId = returnDataMap.get("coststruid");
            Object orgId = returnDataMap.get("orgid");
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setCustomParam("sourceid", primaryKeyValue);
            showParameter.setCustomParam("costadapterid", costAdapterId);
            showParameter.setCustomParam("coststruid", costStruId);
            showParameter.setCustomParam("orgid", orgId);
            if ("pcs_costsalaryitemcfg".equals(costCfgType)) {
                Object salaryFileId = returnDataMap.get("salaryfile");
                showParameter.setCustomParam("salaryfile", salaryFileId);
            }
            showParameter.setFormId(costCfgType);
            showParameter.setCaption(costCfgName);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public static DynamicObject queryDimensionById(String dimensionId) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("lcs_costdimension");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(dimensionId));
        return salaryFileHelper.queryOne("displayproperty,valuesource,valuetype,assistant", new QFilter[]{qFilter});
    }

    public static FormShowParameter getDimensionFormShowParameter(JSONObject paramJSONObject) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pcs_showdimension");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(true);
        parameter.setCustomParam("paramData", (Object)paramJSONObject);
        return parameter;
    }

    public static boolean isOpenFinance() {
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_FINANCE_PARAM);
        Map paramMap = (Map)appCache.get(HSBS_FINANCE_PARAM, Map.class);
        if (paramMap == null) {
            paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)FINANCE_SWC);
        }
        return paramMap != null && (Boolean)paramMap.get("enablefinance") != false;
    }

    public static Map<Long, String> getCostStruDimensionIdStorageNumberMap(Long costStruId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter costStruIdsFilter = new QFilter("id", "=", (Object)costStruId);
        DynamicObject costStruQueryDbResult = costStruHelper.queryOne("dimensionentry,costdimension,storageset", new QFilter[]{costStruIdsFilter});
        HashMap<Long, String> costStruDimensionIdMap = new HashMap<Long, String>(16);
        DynamicObjectCollection dimensionEntryCol = costStruQueryDbResult.getDynamicObjectCollection("dimensionentry");
        for (DynamicObject dimensionEntry : dimensionEntryCol) {
            long dimensionId = dimensionEntry.getLong("costdimension.id");
            String storageSetNumber = dimensionEntry.getString("storageset.number");
            costStruDimensionIdMap.put(dimensionId, storageSetNumber);
        }
        return costStruDimensionIdMap;
    }

    public static String getDentityId(DynamicObject dimensionObj) {
        String valueType = dimensionObj.getString("valuetype");
        return "1".equals(valueType) ? dimensionObj.getString("valuesource.dentityid") : "b649c83f00000aac";
    }

    public static String getFormNumber(DynamicObject dimensionObj) {
        String valueType = dimensionObj.getString("valuetype");
        return "1".equals(valueType) ? dimensionObj.getString("valuesource.number") : "bos_assistantdata_detail";
    }

    public static QFilter setAssistantQFilter(String key) {
        String valueType;
        String dimensionId = key.replace("basedata", "");
        DynamicObject dimensionObj = CostCfgHelper.queryDimensionById(dimensionId);
        if (dimensionObj != null && "2".equals(valueType = dimensionObj.getString("valuetype"))) {
            Long assistantId = dimensionObj.getLong("assistant.id");
            QFilter qFilter = new QFilter("group.id", "=", (Object)assistantId);
            return qFilter;
        }
        return null;
    }

    public static void addCostAdaptionBaseDataBuFilter(BeforeF7SelectEvent event, String entityNumber, String key, long hrOrgId) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter baseDataRuleFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)entityNumber, (String)key, (String)"47156aff000000ac");
        QFilter adaptionBaseDataBuFilter = BaseDataServiceHelper.getBaseDataFilter((String)"lcs_costadaption", (Long)hrOrgId);
        CostCfgHelper.addBaseDataAndBuFilter(event, baseDataRuleFilter, adaptionBaseDataBuFilter);
    }

    public static void addBaseDataAndBuFilter(BeforeF7SelectEvent event, QFilter baseDataRuleFilter, QFilter baseDataBuFilter) {
        if (baseDataRuleFilter != null && baseDataBuFilter != null) {
            baseDataRuleFilter.or(baseDataBuFilter);
            event.addCustomQFilter(baseDataRuleFilter);
        } else {
            if (baseDataRuleFilter != null) {
                event.addCustomQFilter(baseDataRuleFilter);
            }
            if (baseDataBuFilter != null) {
                event.addCustomQFilter(baseDataBuFilter);
            }
        }
    }

    public static DynamicObjectCollection getNeedShowDimensionColl(Long costTypeId, String costType, DynamicObjectCollection dimensionEntryColl) {
        DynamicObjectCollection needShowDimensionEntryColl = new DynamicObjectCollection();
        if (dimensionEntryColl == null) {
            return needShowDimensionEntryColl;
        }
        block0: for (DynamicObject dimensionObj : dimensionEntryColl) {
            DynamicObjectCollection subEntryEntity = dimensionObj.getDynamicObjectCollection("subentryentity");
            if ("COST".equals(costType)) {
                for (DynamicObject subEntity : subEntryEntity) {
                    long subCostBizObjId = subEntity.getLong("costbizobj.id");
                    if (subCostBizObjId != costTypeId) continue;
                    needShowDimensionEntryColl.add((Object)dimensionObj);
                    continue block0;
                }
                continue;
            }
            needShowDimensionEntryColl.add((Object)dimensionObj);
        }
        return needShowDimensionEntryColl;
    }

    public static List<Long> getSegmentStoreIds(String entityKey, IFormView view) {
        String segmentIdKey = "costcfgentryentity".equals(entityKey) ? "costsegstore.id" : "costtypesegstore.id";
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entityKey);
        ArrayList<Long> segmentStoreIds = new ArrayList<Long>(10);
        for (DynamicObject costCfgEntry : entryEntity) {
            long segmentStoreId = costCfgEntry.getLong(segmentIdKey);
            segmentStoreIds.add(segmentStoreId);
        }
        return segmentStoreIds;
    }

    public static void setCostCfgValue(DynamicObjectCollection needShowDimensionEntryColl, Map<String, HashMap<String, DynamicObject>> baseDataValueMap, DynamicObject costCfgEntry, DynamicObject costSegStoreDy, String costCfgKey) {
        StringBuilder builder = new StringBuilder();
        for (DynamicObject dimensionEntryDy : needShowDimensionEntryColl) {
            DynamicObject dynamicObject;
            String storageSetNumber = dimensionEntryDy.getString("storageset.number");
            String valueType = dimensionEntryDy.getString("costdimension.valuetype");
            String baseDataNumber = dimensionEntryDy.getString("costdimension.valuesource.id");
            String displayProperty = dimensionEntryDy.getString("costdimension.displayproperty");
            String baseDataStr = costSegStoreDy.getString("segment" + storageSetNumber);
            if ("3".equals(valueType)) {
                if (SWCStringUtils.isEmpty((String)baseDataStr)) {
                    builder.append(' ').append('.');
                    continue;
                }
                builder.append(baseDataStr).append('.');
                continue;
            }
            if ("2".equals(valueType)) {
                baseDataNumber = "bos_assistantdata_detail";
            }
            HashMap<String, DynamicObject> baseDataResult = baseDataValueMap.get(baseDataNumber);
            if (SWCStringUtils.isEmpty((String)baseDataStr) || CollectionUtils.isEmpty(baseDataResult)) {
                builder.append(' ').append('.');
                continue;
            }
            if (baseDataStr.contains("||")) {
                baseDataStr = baseDataStr.substring(0, baseDataStr.indexOf("||"));
            }
            if ((dynamicObject = baseDataResult.get(baseDataStr)) == null) {
                builder.append(' ').append('.');
                continue;
            }
            String value = "1".equals(displayProperty) ? dynamicObject.getString("number") : dynamicObject.getString("name");
            if (SWCStringUtils.isEmpty((String)value)) {
                builder.append(' ').append('.');
                continue;
            }
            builder.append(value).append('.');
        }
        costCfgEntry.set(costCfgKey, (Object)(builder.length() > 0 ? builder.substring(0, builder.lastIndexOf(".")) : ""));
    }

    public static void fillCostSegmentInfo(String costCfg, String costCfgType, SWCDataServiceHelper costSegStoreHelper, DynamicObject costCfgDy, Map<Long, String> costStruDimensionIdMap, DynamicObjectCollection costSegStoreDyList) {
        if (CollectionUtils.isEmpty(costStruDimensionIdMap)) {
            return;
        }
        boolean isCostCfg = "costCfg".equals(costCfg);
        String entryEntityKey = isCostCfg ? "costcfgentryentity" : "costcfgtypeentryentity";
        String hideKey = isCostCfg ? "hidekeyandvalue" : "hidetypekeyandvalue";
        String costSegStoreKey = isCostCfg ? "costsegstore" : "costtypesegstore";
        long boId = costCfgDy.getLong("boid");
        DynamicObjectCollection dynamicObjectCollection = costCfgDy.getDynamicObjectCollection(entryEntityKey);
        long[] genLongIds = ORM.create().genLongIds("pcs_costsegstore", dynamicObjectCollection.size());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject costEntryDy = (DynamicObject)dynamicObjectCollection.get(i);
            String hideKeyAndValueStr = costEntryDy.getString(hideKey);
            if (SWCStringUtils.isEmpty((String)hideKeyAndValueStr)) continue;
            DynamicObject costSegStoreDy = costSegStoreHelper.generateEmptyDynamicObject();
            Map hideKeyAndValueMap = (Map)JSON.parseObject((String)hideKeyAndValueStr, Map.class);
            for (Map.Entry<Long, String> next : costStruDimensionIdMap.entrySet()) {
                Long dimensionId = next.getKey();
                String storageSetNumber = next.getValue();
                Object dimensionValue = hideKeyAndValueMap.get(String.valueOf(dimensionId));
                if (dimensionValue == null) continue;
                String propertyName = "segment" + storageSetNumber;
                costSegStoreDy.set(propertyName, dimensionValue);
            }
            costSegStoreDy.set("id", (Object)genLongIds[i]);
            costSegStoreDy.set("costsourcetype", (Object)costCfgType);
            costSegStoreDyList.add((Object)costSegStoreDy);
            costEntryDy.set(costSegStoreKey, (Object)genLongIds[i]);
            if (boId == 0L) continue;
            String dimensionKey = boId + entryEntityKey + i;
            AppCache.get((String)"pcs").put(dimensionKey, (Object)String.valueOf(genLongIds[i]));
        }
    }

    public static String getCostType(String name) {
        String costType = SWCStringUtils.equals((String)"pcs_costdeptcfg", (String)name) || "pcs_costgroupcfg".equals(name) ? "3" : (SWCStringUtils.equals((String)"pcs_costitemcfg", (String)name) ? "2" : "1");
        return costType;
    }

    public static Map<String, Long> getBaseDatapropMap(long costStruId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "=", (Object)costStruId);
        DynamicObject queryResult = costStruHelper.queryOne("id,dimensionentry,costdimension,storageset", new QFilter[]{filter});
        DynamicObjectCollection dimensionEntrys = queryResult.getDynamicObjectCollection("dimensionentry");
        HashMap<String, Long> baseDataPropMap = new HashMap<String, Long>(16);
        for (DynamicObject dimensionDy : dimensionEntrys) {
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String storageSetNumber = dimensionDy.getString("storageset.number");
            baseDataPropMap.put(storageSetNumber, costDimensionId);
        }
        return baseDataPropMap;
    }

    public static void addCostStruFilter(BeforeF7SelectEvent event, IFormView view, List<Long> list) {
        String parentBillFormId = CostCfgHelper.getParentBillFormId(view);
        if ("pcs_costitemcfg".equals(parentBillFormId) || "pcs_costdeptcfg".equals(parentBillFormId)) {
            return;
        }
        SWCDataServiceHelper adaptionHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"lcs_costadaption", list, (boolean)true);
        DynamicObject[] costAdaptionQueryResults = adaptionHelper.query("id,coststru", new QFilter[]{baseDataFilter});
        if (costAdaptionQueryResults == null) {
            return;
        }
        HashSet<Long> costStruSet = new HashSet<Long>(16);
        for (DynamicObject costAdaptionDy : costAdaptionQueryResults) {
            long costStruId = costAdaptionDy.getLong("coststru.id");
            costStruSet.add(costStruId);
        }
        SWCDataServiceHelper struHelper = new SWCDataServiceHelper("lcs_coststru");
        String properties = "dimensionentry.costdimension,dimensionentry.seq,subentryentity.costbizobj";
        QFilter idFilter = new QFilter("id", "in", costStruSet);
        DynamicObject[] struQueryResults = struHelper.query(properties, new QFilter[]{idFilter});
        if (struQueryResults == null) {
            return;
        }
        Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId(parentBillFormId);
        HashSet<Long> costStruMatchSet = new HashSet<Long>(16);
        for (DynamicObject struDy : struQueryResults) {
            CostCfgHelper.addCostStruMatchSet(costTypeId, costStruMatchSet, struDy);
        }
        if (!costStruMatchSet.isEmpty()) {
            QFilter costStruFilter = new QFilter("coststru.id", "in", costStruMatchSet);
            event.addCustomQFilter(costStruFilter);
        } else {
            QFilter notFindFilter = new QFilter("1", "!=", (Object)1);
            event.addCustomQFilter(notFindFilter);
        }
    }

    public static void addCostStruMatchSet(Long costTypeId, Set<Long> costStruMatchSet, DynamicObject struDy) {
        DynamicObjectCollection entryEntity = struDy.getDynamicObjectCollection("dimensionentry");
        block0: for (DynamicObject dimensionObj : entryEntity) {
            DynamicObjectCollection subEntryEntity = dimensionObj.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntity : subEntryEntity) {
                long subCostBizObjId = subEntity.getLong("costbizobj.id");
                if (costTypeId != subCostBizObjId) continue;
                costStruMatchSet.add(struDy.getLong("id"));
                break block0;
            }
        }
    }

    public static String getParentBillFormId(IFormView view) {
        IListView listView = (IListView)view.getParentView();
        return listView.getBillFormId();
    }

    public static void isNeedAddPersonF7Filter(List<QFilter> filters, QFilter empBaseDataFilter) {
        if (empBaseDataFilter != null) {
            SWCDataServiceHelper employeeQueryHelper = new SWCDataServiceHelper("hrpi_employeef7query");
            DynamicObject[] queryResults = employeeQueryHelper.query("id,name,number", new QFilter[]{empBaseDataFilter});
            ArrayList<Long> empIds = new ArrayList<Long>(10);
            if (queryResults != null) {
                for (DynamicObject queryResult : queryResults) {
                    long id = queryResult.getLong("id");
                    empIds.add(id);
                }
            }
            QFilter qFilter = new QFilter("id", "in", empIds);
            CostCfgHelper.addPersonF7IdFilter(filters, qFilter);
        }
    }

    public static void addPersonF7IdFilter(List<QFilter> filters, QFilter sourceBaseDataFilter) {
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        SWCDataServiceHelper employeeHelper = new SWCDataServiceHelper("hrpi_employee");
        DynamicObject[] employeeQueryResults = employeeHelper.query("id,person", new QFilter[]{sourceBaseDataFilter});
        if (employeeQueryResults != null) {
            for (DynamicObject employeeQueryResult : employeeQueryResults) {
                long personId = employeeQueryResult.getLong("person.id");
                personIds.add(personId);
            }
        }
        QFilter personIdQFilter = new QFilter("id", "in", personIds);
        filters.add(personIdQFilter);
    }
}

