/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.dataimport.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportConfig;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportParamEntity;
import kd.swc.pcs.business.costcfg.dataimport.ImportRowEntity;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportLoggerHelper;

public class CostCfgImportDataOperate {
    private static final Log LOGGER = LogFactory.getLog(CostCfgImportDataOperate.class);

    public void baseDataColumnConvertToDy(String billFormId, List<ImportRowEntity> costCfgDealResultList, Map<String, String> colKeyAndColNameMap, Map<String, Map<String, String>> columnKeyAndQueryMap, Map<Integer, List<String>> logCache) {
        Map<String, Map<String, List<DynamicObject>>> columnKeyAndBaseDataMap = this.loadBaseDataByValue(costCfgDealResultList, colKeyAndColNameMap, columnKeyAndQueryMap);
        LOGGER.info("CostCfgImportDataOperate baseDataColumnConvertToDy end 1-1");
        this.convertToDyByQueryDbResult(billFormId, costCfgDealResultList, colKeyAndColNameMap, columnKeyAndQueryMap, columnKeyAndBaseDataMap, logCache);
        LOGGER.info("CostCfgImportDataOperate convertToDyByQueryDbResult end 1-2");
    }

    private Map<String, Map<String, List<DynamicObject>>> loadBaseDataByValue(List<ImportRowEntity> costCfgDealResultList, Map<String, String> colKeyAndColNameMap, Map<String, Map<String, String>> columnKeyAndQueryMap) {
        HashMap<String, Map<String, List<DynamicObject>>> columnKeyAndBaseDataMap = new HashMap<String, Map<String, List<DynamicObject>>>(colKeyAndColNameMap.size());
        for (Map.Entry<String, String> entry : colKeyAndColNameMap.entrySet()) {
            String displayPropKey;
            String columnKey = entry.getKey();
            Map<String, String> queryBillNameAndTypeMap = columnKeyAndQueryMap.get(columnKey);
            if (CollectionUtils.isEmpty(queryBillNameAndTypeMap)) continue;
            String billName = "";
            String queryType = "";
            for (Map.Entry<String, String> next : queryBillNameAndTypeMap.entrySet()) {
                billName = next.getKey();
                queryType = next.getValue();
            }
            Set<String> values = this.getColumnValues(costCfgDealResultList, columnKey);
            if (StringUtils.isEmpty((CharSequence)billName) || values.isEmpty()) {
                columnKeyAndBaseDataMap.put(columnKey, new HashMap(1));
                continue;
            }
            String string = displayPropKey = "1".equals(queryType) ? "number" : "name";
            if ("hrpi_employee".equals(billName)) {
                displayPropKey = "1".equals(queryType) ? "empnumber" : "person.name";
            }
            Object[] allFilter = new QFilter[]{new QFilter(displayPropKey, "in", values)};
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billName);
            if (dataEntityType.getProperty("iscurrentversion") != null) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE)});
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(billName);
            String props = SWCHisBaseDataHelper.getSelectProperties((String)billName);
            if (props.contains(",enable,") || props.startsWith("enable,") || props.startsWith(",enable")) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            }
            if (props.contains(",status,") || props.startsWith("status,") || props.startsWith(",status")) {
                allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("status", "=", (Object)"C")});
            }
            DynamicObject[] queryResults = serviceHelper.query(props, (QFilter[])allFilter);
            HashMap<String, ArrayList<DynamicObject>> colValueAndQueryDbResultMap = new HashMap<String, ArrayList<DynamicObject>>(16);
            for (DynamicObject queryResultDy : queryResults) {
                String propKey = queryResultDy.getString(displayPropKey);
                ArrayList<DynamicObject> queryDataList = (ArrayList<DynamicObject>)colValueAndQueryDbResultMap.get(propKey);
                if (CollectionUtils.isEmpty((Collection)queryDataList)) {
                    queryDataList = new ArrayList<DynamicObject>(10);
                }
                queryDataList.add(queryResultDy);
                colValueAndQueryDbResultMap.put(propKey, queryDataList);
            }
            columnKeyAndBaseDataMap.putIfAbsent(columnKey, colValueAndQueryDbResultMap);
        }
        return columnKeyAndBaseDataMap;
    }

    private Set<String> getColumnValues(List<ImportRowEntity> costCfgDealResultList, String columnKey) {
        HashSet<String> values = new HashSet<String>(16);
        for (ImportRowEntity importRowEntity : costCfgDealResultList) {
            List<JSONObject> jsonObjectDataList = importRowEntity.getJsonObjectDataList();
            if (jsonObjectDataList == null) continue;
            for (JSONObject jSONObject : jsonObjectDataList) {
                String columnValue = jSONObject.getString(columnKey);
                if (!SWCStringUtils.isNotEmpty((String)columnValue)) continue;
                values.add(columnValue);
            }
        }
        return values;
    }

    private void convertToDyByQueryDbResult(String billFormId, List<ImportRowEntity> costCfgBatchList, Map<String, String> colKeyAndColNameMap, Map<String, Map<String, String>> columnKeyAndQueryMap, Map<String, Map<String, List<DynamicObject>>> columnKeyAndBaseDataMap, Map<Integer, List<String>> logCache) {
        String msgNotUnique = ResManager.loadKDString((String)"\u201c{0}\u201d\u201c{1}\u201d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\u3002", (String)"CostCfgImportDataOperate_8", (String)"swc-pcs-business", (Object[])new Object[0]);
        String msgNumberNotMatch = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0})\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a\u7f16\u7801\u201c{1}\u201d;", (String)"CostCfgImportDataOperate_9", (String)"swc-pcs-business", (Object[])new Object[0]);
        String msgNameNotMatch = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0})\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a\u540d\u79f0\u201c{1}\u201d;", (String)"CostCfgImportDataOperate_15", (String)"swc-pcs-business", (Object[])new Object[0]);
        for (ImportRowEntity cellRowEntity : costCfgBatchList) {
            List<JSONObject> jsonObjectDataList = cellRowEntity.getJsonObjectDataList();
            for (JSONObject jsonData : jsonObjectDataList) {
                int rowIndex = cellRowEntity.getRowIndex();
                this.convertToDy(billFormId, msgNotUnique, msgNumberNotMatch, msgNameNotMatch, rowIndex, jsonData, colKeyAndColNameMap, columnKeyAndQueryMap, columnKeyAndBaseDataMap, logCache);
            }
        }
    }

    private void convertToDy(String billFormId, String msgNotUnique, String msgNumberNotMatch, String msgNameNotMatch, int rowIndex, JSONObject jsonData, Map<String, String> colKeyAndColNameMap, Map<String, Map<String, String>> columnKeyAndQueryMap, Map<String, Map<String, List<DynamicObject>>> columnKeyAndBaseDataMap, Map<Integer, List<String>> logCache) {
        for (Map.Entry<String, String> keyIndexEntry : colKeyAndColNameMap.entrySet()) {
            int rowEntryIndex;
            String errorMessage;
            String columnKey = keyIndexEntry.getKey();
            Object cellValue = jsonData.get((Object)columnKey);
            if (cellValue == null) continue;
            String columnName = colKeyAndColNameMap.get(columnKey);
            if (!columnKeyAndQueryMap.containsKey(columnKey)) continue;
            Map<String, List<DynamicObject>> queryDbResultMap = columnKeyAndBaseDataMap.get(columnKey);
            List<DynamicObject> dynamicObjects = queryDbResultMap.get(String.valueOf(cellValue));
            if (CollectionUtils.isEmpty(dynamicObjects)) {
                errorMessage = this.getErrorMessage(msgNumberNotMatch, msgNameNotMatch, columnKeyAndQueryMap, columnKey, cellValue, columnName);
                rowEntryIndex = jsonData.getIntValue("rowIndex");
                CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
                continue;
            }
            if (dynamicObjects.size() == 1) {
                DynamicObject cellObject = dynamicObjects.get(0);
                jsonData.put(columnKey, (Object)cellObject);
                continue;
            }
            if ("pcs_costempcfg".equals(billFormId) && "costCfgNumber".equals(columnKey)) {
                this.setEmpValue(rowIndex, jsonData, logCache, dynamicObjects);
                continue;
            }
            errorMessage = MessageFormat.format(msgNotUnique, columnName, cellValue);
            rowEntryIndex = jsonData.getIntValue("rowIndex");
            CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
        }
    }

    private void setEmpValue(int rowIndex, JSONObject jsonData, Map<Integer, List<String>> logCache, List<DynamicObject> dynamicObjects) {
        boolean isMatch = false;
        Date date = jsonData.getDate("bsed");
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date endDate;
            Date startDate = dynamicObject.getDate("startdate");
            if (!this.checkBsedDate(date, startDate, endDate = dynamicObject.getDate("enddate"))) continue;
            jsonData.put("costCfgNumber", (Object)dynamicObject);
            isMatch = true;
            break;
        }
        if (!isMatch) {
            String empNumber = jsonData.getString("costCfgNumber");
            String empBsedNotMatch = ResManager.loadKDString((String)"\u5de5\u53f7{0}\u5728\u751f\u6548\u65e5\u671f{1}\u5185\uff0c\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u4eba\u5458\u4fe1\u606f\u3002", (String)"CostCfgImportDataOperate_17", (String)"swc-pcs-business", (Object[])new Object[0]);
            String formatDate = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            String errorMessage = MessageFormat.format(empBsedNotMatch, empNumber, formatDate);
            int rowEntryIndex = jsonData.getIntValue("rowIndex");
            CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
        }
    }

    private boolean checkBsedDate(Date date, Date startDate, Date endDate) {
        return !(startDate == null || endDate == null || date == null || !SWCDateUtils.isEqual((Date)date, (Date)endDate) && date.getTime() > endDate.getTime() || !SWCDateUtils.isEqual((Date)date, (Date)startDate) && date.getTime() < startDate.getTime());
    }

    private String getErrorMessage(String msgNumberNotMatch, String msgNameNotMatch, Map<String, Map<String, String>> columnKeyAndQueryMap, String columnKey, Object cellValue, String columnName) {
        Collection<String> queryTypes;
        ArrayList<String> queryTypeList;
        String errorMessage = "";
        Map<String, String> queryMap = columnKeyAndQueryMap.get(columnKey);
        if (!CollectionUtils.isEmpty(queryMap) && !CollectionUtils.isEmpty(queryTypeList = new ArrayList<String>(queryTypes = queryMap.values()))) {
            String queryType = (String)queryTypeList.get(0);
            errorMessage = "1".equals(queryType) ? MessageFormat.format(msgNumberNotMatch, columnName, cellValue) : MessageFormat.format(msgNameNotMatch, columnName, cellValue);
        }
        return errorMessage;
    }

    public Map<String, ImportRowEntity> mergeCostCfgImportEntity(CostCfgImportConfig conf, List<ImportRowEntity> costCfgDealResultList) {
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        String billFormId = costCfgImportParamEntity.getBillFormId();
        String costAdaptionName = costCfgImportParamEntity.getCostAdaptionName();
        Long costAdaptionId = costCfgImportParamEntity.getCostAdaptionId();
        Long costCfgTypeId = costCfgImportParamEntity.getCostCfgTypeId();
        Map<Integer, List<String>> logCache = conf.getLogCache();
        LinkedHashMap<String, ImportRowEntity> mergerResultMap = new LinkedHashMap<String, ImportRowEntity>(16);
        for (ImportRowEntity importRowEntity : costCfgDealResultList) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonData = importRowEntity.getJsonObjectData();
            String costCfgNumber = jsonData.getString("costCfgNumber");
            if ("pcs_costsalaryitemcfg".equals(billFormId)) {
                String salaryFileNumber = jsonData.getString("salaryFileNumber");
                sb.append(costCfgTypeId).append('_').append(costAdaptionId).append('_').append(salaryFileNumber).append('_').append(costCfgNumber);
            } else {
                sb.append(costCfgTypeId).append('_').append(costAdaptionId).append('_').append(costCfgNumber);
            }
            String rowKey = sb.toString();
            importRowEntity.setRowKey(rowKey);
            ImportRowEntity importRowEntityExist = (ImportRowEntity)mergerResultMap.get(rowKey);
            if (importRowEntityExist == null) {
                ArrayList<JSONObject> jsonObjectDataList = new ArrayList<JSONObject>(1);
                jsonObjectDataList.add(importRowEntity.getJsonObjectData());
                importRowEntity.setJsonObjectDataList(jsonObjectDataList);
            } else {
                importRowEntity = this.getMergeImportDate(costAdaptionName, logCache, importRowEntity, importRowEntityExist);
            }
            if (importRowEntity == null) continue;
            mergerResultMap.put(rowKey, importRowEntity);
        }
        return mergerResultMap;
    }

    private ImportRowEntity getMergeImportDate(String costAdaptionName, Map<Integer, List<String>> logCache, ImportRowEntity importRowEntity, ImportRowEntity importRowEntityExist) {
        String org;
        String bsed;
        String bsedExist = importRowEntityExist.getJsonObjectData().getString("bsed");
        if (this.isNotEmptyAndIsNotEquals(bsedExist, bsed = importRowEntity.getJsonObjectData().getString("bsed"))) {
            String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848[%s]\u4e0b\u5df2\u6709\u6210\u672c\u8bbe\u7f6e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"CostCfgImportDataOperate_6", (String)"swc-pcs-business", (Object[])new Object[0]), costAdaptionName);
            CostCfgImportLoggerHelper.putRowError(importRowEntity.getRowIndex(), errorMessage, logCache);
            return null;
        }
        String orgNumberExist = importRowEntityExist.getJsonObjectData().getString("orgNumber");
        if (this.isNotEmptyAndIsNotEquals(orgNumberExist, org = importRowEntity.getJsonObjectData().getString("orgNumber"))) {
            String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848[%s]\u4e0b\u5df2\u6709\u6210\u672c\u8bbe\u7f6e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"CostCfgImportDataOperate_6", (String)"swc-pcs-business", (Object[])new Object[0]), costAdaptionName);
            CostCfgImportLoggerHelper.putRowError(importRowEntity.getRowIndex(), errorMessage, logCache);
            return null;
        }
        List<JSONObject> jsonObjectDataList = importRowEntityExist.getJsonObjectDataList();
        if (CollectionUtils.isEmpty(jsonObjectDataList)) {
            jsonObjectDataList = new ArrayList<JSONObject>(1);
        }
        jsonObjectDataList.add(importRowEntity.getJsonObjectData());
        importRowEntityExist.setJsonObjectDataList(jsonObjectDataList);
        return importRowEntityExist;
    }

    private boolean isNotEmptyAndIsNotEquals(String bsedExist, String bsed) {
        return SWCStringUtils.isNotEmpty((String)bsedExist) && SWCStringUtils.isNotEmpty((String)bsed) && !SWCStringUtils.equals((String)bsedExist, (String)bsed);
    }

    public List<ImportRowEntity> importEntityConvertToCostCfgDy(List<Long> sourceIdList, List<ImportRowEntity> costCfgDealResultList, Map<String, DynamicObject> keyAndCostCfgDyMap, CostCfgImportConfig conf) {
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        Long costAdaptionId = costCfgImportParamEntity.getCostAdaptionId();
        Long costCfgTypeId = costCfgImportParamEntity.getCostCfgTypeId();
        Long costStruId = costCfgImportParamEntity.getCostStruId();
        String billFormId = costCfgImportParamEntity.getBillFormId();
        Map<Long, Long> empIdAndRelMap = CostCfgExportHelper.getEmpAndPosOrgRelMap(sourceIdList, costCfgTypeId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billFormId);
        long[] genLongIds = ORM.create().genLongIds(billFormId, costCfgDealResultList.size());
        ArrayList<ImportRowEntity> convertImportRowList = new ArrayList<ImportRowEntity>(10);
        DynamicObject costAdapterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costAdaptionId, (String)"lcs_costadaption");
        DynamicObject costStruDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costStruId, (String)"lcs_coststru");
        Map<String, String> costCfgHeaders = CostCfgExportHelper.getExportColumnMap(billFormId, costAdaptionId);
        Map<String, String> newCostCfgHeaders = costCfgImportParamEntity.getColumnKeyAndColumnNameMap();
        List<String> newAddKeyList = this.getAddKeyList(costCfgHeaders, newCostCfgHeaders);
        for (int i = 0; i < costCfgDealResultList.size(); ++i) {
            ImportRowEntity importRowEntity = costCfgDealResultList.get(i);
            String rowKey = this.getRowKey(costCfgTypeId, costAdaptionId, importRowEntity);
            Object orgDyObj = importRowEntity.getJsonObjectData().get((Object)"orgNumber");
            DynamicObject dynamicObject = CostCfgImportDataOperate.fillCostCfgDyId(billFormId, rowKey, helper, i, genLongIds, keyAndCostCfgDyMap, orgDyObj);
            CostCfgImportDataOperate.fillCostCfgMainInfo(costCfgTypeId, dynamicObject, costAdapterDy, costStruDy, importRowEntity, empIdAndRelMap);
            CostCfgImportDataOperate.addNewKeyValue(importRowEntity.getJsonObjectData(), newAddKeyList, dynamicObject);
            CostCfgImportDataOperate.fillCostCfgEntryInfo(importRowEntity, helper, dynamicObject, conf, keyAndCostCfgDyMap, newAddKeyList);
            importRowEntity.setDyObj(dynamicObject);
            convertImportRowList.add(importRowEntity);
        }
        return convertImportRowList;
    }

    private List<String> getAddKeyList(Map<String, String> costCfgHeaders, Map<String, String> newCostCfgHeaders) {
        ArrayList<String> newAddKeyList = new ArrayList<String>(10);
        if (!CollectionUtils.isEmpty(newCostCfgHeaders)) {
            for (Map.Entry<String, String> next : newCostCfgHeaders.entrySet()) {
                String key = next.getKey();
                if (costCfgHeaders.containsKey(key)) continue;
                newAddKeyList.add(key);
            }
        }
        return newAddKeyList;
    }

    private String getRowKey(Long costCfgTypeId, Long costAdapterId, ImportRowEntity importRowEntity) {
        StringBuilder sb = new StringBuilder();
        JSONObject jsonData = importRowEntity.getJsonObjectData();
        DynamicObject costCfgDy = (DynamicObject)jsonData.get((Object)"costCfgNumber");
        long costCfgId = costCfgDy.getLong("id");
        if (SWCCostConstants.COST_TYPE_SALARYFILEITEM.equals(costCfgTypeId)) {
            DynamicObject salaryFileDy = (DynamicObject)jsonData.get((Object)"salaryFileNumber");
            long salaryFileId = salaryFileDy.getLong("id");
            sb.append(costCfgTypeId).append('_').append(costAdapterId).append('_').append(salaryFileId).append('_').append(costCfgId);
        } else {
            sb.append(costCfgTypeId).append('_').append(costAdapterId).append('_').append(costCfgId);
        }
        importRowEntity.setRowKey(sb.toString());
        return sb.toString();
    }

    private static void fillCostCfgEntryInfo(ImportRowEntity importRowEntity, SWCDataServiceHelper helper, DynamicObject dynamicObject, CostCfgImportConfig conf, Map<String, DynamicObject> keyAndCostCfgDyMap, List<String> newAddKeyList) {
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        String billFormId = costCfgImportParamEntity.getBillFormId();
        DynamicObjectCollection entryTypeEntityColl = null;
        if ("pcs_costdeptcfg".equals(billFormId) || "pcs_costitemcfg".equals(billFormId)) {
            entryTypeEntityColl = dynamicObject.getDynamicObjectCollection("costcfgtypeentryentity");
        }
        int rowIndex = importRowEntity.getRowIndex();
        String rowKey = importRowEntity.getRowKey();
        Map<Integer, List<String>> logCache = conf.getLogCache();
        Map<String, String> costTypeNameMap = costCfgImportParamEntity.getCostTypeNameMap();
        DynamicObjectCollection entryEntityColl = dynamicObject.getDynamicObjectCollection("costcfgentryentity");
        List<JSONObject> jsonObjectDataList = importRowEntity.getJsonObjectDataList();
        for (int i = 0; i < jsonObjectDataList.size(); ++i) {
            JSONObject jsonObject = jsonObjectDataList.get(i);
            CostCfgImportDataOperate.validateCreateOrg(logCache, keyAndCostCfgDyMap, rowIndex, rowKey, jsonObject);
            StringBuilder sb = new StringBuilder();
            HashMap<String, Object> hideKeyAndValueMap = new HashMap<String, Object>(16);
            CostCfgImportDataOperate.getFillCostCfgEntryValue(rowIndex, sb, jsonObject, hideKeyAndValueMap, costTypeNameMap, conf);
            String costTypeName = jsonObject.getString("costCfgType");
            String costType = costTypeNameMap.get(costTypeName);
            if ("1".equals(costType)) {
                CostCfgImportDataOperate.setEntryValue(i + 1, sb, "costcfgentryentity", helper, hideKeyAndValueMap, jsonObject, entryEntityColl, newAddKeyList, dynamicObject);
                continue;
            }
            CostCfgImportDataOperate.setEntryValue(i + 1, sb, "costcfgtypeentryentity", helper, hideKeyAndValueMap, jsonObject, entryTypeEntityColl, newAddKeyList, dynamicObject);
        }
    }

    private static void validateCreateOrg(Map<Integer, List<String>> logCache, Map<String, DynamicObject> keyAndCostCfgDyMap, int rowIndex, String rowKey, JSONObject jsonObject) {
        DynamicObject orgDyObj = (DynamicObject)jsonObject.get((Object)"orgNumber");
        long importCreateOrgId = orgDyObj.getLong("id");
        DynamicObject dbDynamicObject = keyAndCostCfgDyMap.get(rowKey);
        if (dbDynamicObject == null) {
            return;
        }
        long dbExistCreateOrgId = dbDynamicObject.getLong("createorg.id");
        if (importCreateOrgId != dbExistCreateOrgId) {
            int rowEntryIndex = jsonObject.getIntValue("rowIndex");
            String errorMessage = ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u8bf7\u786e\u8ba4\u5bfc\u5165\u66f4\u65b0\u7684\u5df2\u6709\u6570\u636e\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u7cfb\u7edf\u6570\u636e\u662f\u5426\u4e00\u81f4\u3002", (String)"CostCfgImportDataOperate_11", (String)"swc-pcs-business", (Object[])new Object[0]);
            CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
        }
    }

    private static void setEntryValue(int seq, StringBuilder sb, String entryEntityKey, SWCDataServiceHelper helper, Map<String, Object> hideKeyAndValueMap, JSONObject jsonObject, DynamicObjectCollection entryEntityColl, List<String> newAddKeyList, DynamicObject dynamicObject) {
        String costStruCfgValue;
        if (entryEntityColl == null) {
            return;
        }
        boolean isCostCfg = "costcfgentryentity".equals(entryEntityKey);
        String proportionKey = isCostCfg ? "calcostproportion" : "costcfgtypeproportion";
        String costStruCfgValueKey = isCostCfg ? "coststrucfgvalue" : "coststrutypecfgvalue";
        String hideKey = isCostCfg ? "hidekeyandvalue" : "hidetypekeyandvalue";
        DynamicObject costCfgEntryEntity = helper.generateEmptyEntryDynamicObject(dynamicObject, entryEntityKey);
        CostCfgImportDataOperate.addNewKeyValue(jsonObject, newAddKeyList, costCfgEntryEntity);
        String proportionStr = jsonObject.getString("proportion");
        if (SWCStringUtils.isNotEmpty((String)proportionStr)) {
            BigDecimal proportion = new BigDecimal(proportionStr);
            costCfgEntryEntity.set(proportionKey, (Object)proportion);
        }
        if (SWCStringUtils.isNotEmpty((String)(costStruCfgValue = sb.toString()))) {
            costCfgEntryEntity.set(costStruCfgValueKey, (Object)costStruCfgValue.substring(0, sb.toString().length() - 1));
        }
        if (!CollectionUtils.isEmpty(hideKeyAndValueMap)) {
            costCfgEntryEntity.set(hideKey, (Object)new JSONObject(hideKeyAndValueMap));
        }
        costCfgEntryEntity.set("seq", (Object)seq);
        entryEntityColl.add((Object)costCfgEntryEntity);
    }

    private static void addNewKeyValue(JSONObject jsonObject, List<String> newAddKeyList, DynamicObject costCfgEntryEntity) {
        if (!CollectionUtils.isEmpty(newAddKeyList)) {
            DataEntityPropertyCollection properties = costCfgEntryEntity.getDataEntityType().getProperties();
            for (String key : newAddKeyList) {
                if (!properties.containsKey((Object)key)) continue;
                Object value = jsonObject.get((Object)key);
                costCfgEntryEntity.set(key, value);
            }
        }
    }

    private static void getFillCostCfgEntryValue(int rowIndex, StringBuilder sb, JSONObject jsonObject, Map<String, Object> hideKeyAndValueMap, Map<String, String> costTypeNameMap, CostCfgImportConfig conf) {
        Map<Integer, List<String>> logCache = conf.getLogCache();
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        Map<String, DynamicObject> needShowColumnKeyAndDimDyMap = costCfgImportParamEntity.getNeedShowColumnKeyAndDimensionDyMap();
        String billFormId = costCfgImportParamEntity.getBillFormId();
        String costAdaptionName = costCfgImportParamEntity.getCostAdaptionName();
        String costTypeName = jsonObject.getString("costCfgType");
        String costType = costTypeNameMap.get(costTypeName);
        if ("1".equals(costType) && CollectionUtils.isEmpty(needShowColumnKeyAndDimDyMap)) {
            int rowEntryIndex = jsonObject.getIntValue("rowIndex");
            if ("pcs_costitemcfg".equals(billFormId)) {
                String errorMessage = ResManager.loadKDString((String)"{0}\uff1a\u672a\u542f\u7528\u85aa\u916c\u9879\u76ee\u6210\u672c\u8bbe\u7f6e\uff0c\u4ec5\u53ef\u8fdb\u884c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u8c03\u6574\u3002", (String)"CostCfgImportDataOperate_12", (String)"swc-pcs-business", (Object[])new Object[]{costAdaptionName});
                CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
            } else if ("pcs_costdeptcfg".equals(billFormId)) {
                String errorMessage = ResManager.loadKDString((String)"{0}\uff1a\u672a\u542f\u7528\u7ec4\u7ec7\u85aa\u916c\u6210\u672c\u8bbe\u7f6e\uff0c\u4ec5\u53ef\u8fdb\u884c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\uff0c\u8bf7\u786e\u8ba4\u8c03\u6574\u3002", (String)"CostCfgImportDataOperate_13", (String)"swc-pcs-business", (Object[])new Object[]{costAdaptionName});
                CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
            }
            return;
        }
        CostCfgImportDataOperate.initHideKeyAndValueMap(rowIndex, costType, sb, jsonObject, hideKeyAndValueMap, logCache, needShowColumnKeyAndDimDyMap, costCfgImportParamEntity);
    }

    private static void initHideKeyAndValueMap(int rowIndex, String costType, StringBuilder sb, JSONObject jsonObject, Map<String, Object> hideKeyAndValueMap, Map<Integer, List<String>> logCache, Map<String, DynamicObject> needShowColumnKeyAndDimDyMap, CostCfgImportParamEntity costCfgImportParamEntity) {
        String showDimName = costCfgImportParamEntity.getShowDimName();
        Map<String, DynamicObject> columnKeyAndDimensionDy = costCfgImportParamEntity.getColumnKeyAndDimensionDyMap();
        Map<String, String> colKeyNameMap = costCfgImportParamEntity.getColKeyNameMap();
        Iterator<Map.Entry<String, String>> iterator = colKeyNameMap.entrySet().iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            DynamicObject dimensionDy;
            Map.Entry<String, String> next = iterator.next();
            String key = next.getKey();
            if (!key.contains("segment") || (dimensionDy = columnKeyAndDimensionDy.get(key)) == null) continue;
            if ("1".equals(costType) && !needShowColumnKeyAndDimDyMap.containsKey(key) && SWCStringUtils.isNotEmpty((String)jsonObject.getString(key))) {
                int rowEntryIndex = jsonObject.getIntValue("rowIndex");
                String errorMessage = ResManager.loadKDString((String)"\u5f53\u201c\u6210\u672c\u8bbe\u7f6e\u7c7b\u578b\u201d\u4e3a\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u65f6\uff0c\u4ec5\u53ef\u7ef4\u62a4{0}\u3002", (String)"CostCfgImportDataOperate_14", (String)"swc-pcs-business", (Object[])new Object[]{showDimName});
                CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
                return;
            }
            String valueType = dimensionDy.getString("costdimension.valuetype");
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String costDimensionStr = String.valueOf(costDimensionId);
            if ("1".equals(valueType) || "2".equals(valueType)) {
                DynamicObject dy = (DynamicObject)jsonObject.get((Object)key);
                if (dy == null) {
                    sb.append(' ').append('.');
                    continue;
                }
                String displayProperty = dimensionDy.getString("costdimension.displayproperty");
                String value = "1".equals(displayProperty) ? dy.getString("number") : dy.getString("name");
                sb.append(value).append('.');
                String id = dy.getString("id");
                if (!SWCStringUtils.isNotEmpty((String)value)) continue;
                flag = true;
                hideKeyAndValueMap.put(costDimensionStr, id + "||" + value);
                continue;
            }
            String columnValue = jsonObject.getString(key);
            if (SWCStringUtils.isEmpty((String)columnValue)) {
                sb.append(' ').append('.');
            } else {
                sb.append(columnValue).append('.');
            }
            if (!SWCStringUtils.isNotEmpty((String)columnValue)) continue;
            flag = true;
            hideKeyAndValueMap.put(costDimensionStr, columnValue);
        }
        if (!flag) {
            int rowEntryIndex = jsonObject.getIntValue("rowIndex");
            String errorMessage = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u503c\u3002", (String)"CostCfgImportDataOperate_16", (String)"swc-pcs-business", (Object[])new Object[0]);
            CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, errorMessage, logCache);
        }
    }

    private static void fillCostCfgMainInfo(Long costCfgTypeId, DynamicObject dynamicObject, DynamicObject costAdapterDy, DynamicObject costStruDy, ImportRowEntity importRowEntity, Map<Long, Long> empIdAndRelMap) {
        Object sourceDyObj = importRowEntity.getJsonObjectData().get((Object)"costCfgNumber");
        Date bsed = importRowEntity.getJsonObjectData().getDate("bsed");
        long userId = RequestContext.get().getCurrUserId();
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("sourcetype", (Object)costCfgTypeId);
        dynamicObject.set("source", sourceDyObj);
        dynamicObject.set("costadapter", (Object)costAdapterDy);
        dynamicObject.set("bsed", (Object)bsed);
        dynamicObject.set("coststru", (Object)costStruDy);
        if (SWCCostConstants.COST_TYPE_EMP.longValue() == costCfgTypeId.longValue()) {
            DynamicObject sourceDy = (DynamicObject)sourceDyObj;
            Long empPosOrgRelId = empIdAndRelMap.get(sourceDy.getLong("id"));
            dynamicObject.set("empposorgrel", (Object)empPosOrgRelId);
        }
        if (SWCCostConstants.COST_TYPE_SALARYFILEITEM.longValue() == costCfgTypeId.longValue()) {
            dynamicObject.set("creatorobj", importRowEntity.getJsonObjectData().get((Object)"salaryFileNumber"));
        }
    }

    private static DynamicObject fillCostCfgDyId(String billFormId, String rowKey, SWCDataServiceHelper helper, int i, long[] genLongIds, Map<String, DynamicObject> keyAndCostCfgDyMap, Object orgDyObj) {
        DynamicObject dynamicObject = keyAndCostCfgDyMap.get(rowKey);
        if (dynamicObject == null) {
            dynamicObject = helper.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)genLongIds[i]);
            dynamicObject.set("createorg", orgDyObj);
        } else {
            DynamicObjectCollection costCfgEntryList = dynamicObject.getDynamicObjectCollection("costcfgentryentity");
            costCfgEntryList.clear();
            if ("pcs_costdeptcfg".equals(billFormId) || "pcs_costitemcfg".equals(billFormId)) {
                DynamicObjectCollection costCfgTypeEntryList = dynamicObject.getDynamicObjectCollection("costcfgtypeentryentity");
                costCfgTypeEntryList.clear();
            }
        }
        return dynamicObject;
    }
}

