/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.dataimport.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.dataimport.ImportRowEntity;

public class CostCfgImportLoggerHelper {
    public static void putRowError(Integer rowIndex, String msg, Map<Integer, List<String>> logCache) {
        if (SWCStringUtils.isEmpty((String)msg)) {
            return;
        }
        List<String> errors = logCache.get(rowIndex);
        if (errors == null) {
            errors = new ArrayList<String>(1);
        }
        errors.add(msg);
        logCache.put(rowIndex, errors);
    }

    public static void putRowEntryError(int rowIndex, int rowEntryIndex, String msg, Map<Integer, List<String>> logCache) {
        List<String> entryErrors = logCache.get(rowEntryIndex);
        if (entryErrors == null) {
            entryErrors = new ArrayList<String>(1);
        }
        entryErrors.add(msg);
        logCache.put(rowEntryIndex, entryErrors);
        List<String> errors = logCache.get(rowIndex);
        if (errors == null) {
            errors = new ArrayList<String>(1);
        }
        errors.add("");
        logCache.put(rowIndex, errors);
    }

    public static void putRowErrors(String msg, ImportRowEntity importRowEntity, Map<Integer, List<String>> logCache) {
        if (SWCStringUtils.isEmpty((String)msg)) {
            return;
        }
        List<JSONObject> jsonObjectDataList = importRowEntity.getJsonObjectDataList();
        if (jsonObjectDataList == null) {
            return;
        }
        for (JSONObject jsonData : jsonObjectDataList) {
            int rowIndex = jsonData.getIntValue("rowIndex");
            List<String> errors = logCache.get(rowIndex);
            if (errors == null) {
                errors = new ArrayList<String>(1);
            }
            errors.add(msg);
            logCache.put(rowIndex, errors);
        }
    }
}

