/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.pcs.business.extpoint.costcfg.ICostCfgImportExtService;
import kd.sdk.swc.pcs.common.events.CostCfgEvent;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.url.SWCURLHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostCfgImportExtService;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportConfig;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportParamEntity;
import kd.swc.pcs.business.costcfg.dataimport.ImportRowEntity;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportDataOperate;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportHelper;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportLoggerHelper;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportSheetHandler;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costcommon.CostExportCommonHelper;
import kd.swc.pcs.common.constants.CostCfgImportConstants;
import kd.swc.pcs.common.constants.CostExportConstants;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CostCfgImportService {
    protected static final Log logger = LogFactory.getLog(CostCfgImportService.class);
    private static final String SWC_PCS_BUSINESS = "swc-pcs-business";

    public void downLoadTemplate(IFormView view) {
        logger.info("manageSelected begin");
        long costAdaptionId = view.getModel().getDataEntity().getLong("costadaption.id");
        if (costAdaptionId == 0L) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\uff0c\u518d\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"CostCfgImportService_19", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            return;
        }
        try (SXSSFWorkbook wb = new SXSSFWorkbook(CostExportConstants.ROW_ACCESS_WINDOWS_SIZE);){
            String billFormId = this.getBillFormId(view.getParentView());
            String billName = view.getParentView().getFormShowParameter().getCaption();
            String costaAdaptionName = view.getModel().getDataEntity().getString("costadaption.name");
            String exportFileName = ResManager.loadKDString((String)"{0}\u5bfc\u5165\u6a21\u677f_{1}", (String)"CostCfgImportService_33", (String)SWC_PCS_BUSINESS, (Object[])new Object[]{billName, costaAdaptionName});
            Map<String, String> costCfgHeaders = CostCfgExportHelper.getExportColumnMap(billFormId, costAdaptionId);
            String costCfgSheetName = ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e", (String)"CostCfgImportService_34", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
            SXSSFSheet costCfgTypeSheet = this.createCostCfgSheet(wb, costCfgHeaders, costCfgSheetName, billFormId, costAdaptionId);
            List<Map<String, String>> headList = CostExportCommonHelper.headMapToListMap(costCfgHeaders);
            CostExportCommonHelper.createValidation(costCfgTypeSheet, 1, headList, billFormId);
            this.flushAllAndDownload(wb, exportFileName, view);
        }
        catch (Exception e) {
            logger.error("CostCfgImportService downLoadTemplate  error : {}", (Object)e.getMessage());
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6a21\u677f\u5931\u8d25\u3002", (String)"CostCfgImportService_32", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void flushAllAndDownload(SXSSFWorkbook wb, String fileName, IFormView view) throws IOException {
        logger.info("export data 8-1");
        String url = CostExportCommonHelper.writeFile(wb, fileName);
        String billFormId = this.getBillFormId(view.getParentView());
        String safeUrl = SWCURLHelper.getSafeUrl((String)"pcs", (String)billFormId, (String)url);
        this.updateUrl(view, safeUrl);
        logger.info("export data 8-2");
        if (SWCStringUtils.isNotEmpty((String)safeUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)safeUrl);
        }
    }

    public void flushAll(SXSSFWorkbook wb, String fileName, IFormView view) throws IOException {
        logger.info("CostCfgImportService flushAll writeFile begin 1-1");
        String url = CostExportCommonHelper.writeFile(wb, fileName);
        String billFormId = this.getBillFormId(view.getParentView());
        String safeUrl = SWCURLHelper.getSafeUrl((String)"pcs", (String)billFormId, (String)url);
        this.updateUrl(view, safeUrl);
        logger.info("CostCfgImportService flushAll updateUrl end 1-2");
    }

    private void updateUrl(IFormView view, String url) {
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.put("url", (Object)url);
        pageCache.put("progress", (Object)CostCfgImportConstants.DOUBLE_HUNDRED);
        pageCache.put("issuccess", (Object)"false");
        pageCache.saveChanges();
    }

    private String getBillFormId(IFormView view) {
        ListView listView = (ListView)view;
        return listView.getBillFormId();
    }

    private SXSSFSheet createCostCfgSheet(SXSSFWorkbook wb, Map<String, String> costCfgHeaders, String sheetName, String billFormId, long costAdaptionId) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        CostExportCommonHelper.write2ExportCostCfgHead(sheet, costCfgHeaders, billFormId, costAdaptionId);
        return sheet;
    }

    public static void importCostCfgData(CostCfgImportConfig conf, List<Map<Integer, String>> rowDataList) {
        logger.info("CostCfgImportService importCostCfgData rowDataList size:{}", (Object)rowDataList.size());
        List<ImportRowEntity> dataRowEntityList = CostCfgImportService.transformDataToRowEntity(conf, rowDataList);
        List<ImportRowEntity> importRowEntityList = CostCfgImportService.getImportRowMergeList(conf, dataRowEntityList);
        List subList = Lists.partition(importRowEntityList, (int)CostCfgImportConstants.IMPORT_BATCH_SIZE);
        for (int i = 0; i < subList.size(); ++i) {
            List costCfgBatchList = (List)subList.get(i);
            CostCfgImportService.dataImportOneBatch(conf, costCfgBatchList);
        }
        CostCfgImportService.setProgressInfo(conf, dataRowEntityList);
        CostCfgImportService.setErrorList(conf, dataRowEntityList);
    }

    private static void setErrorList(CostCfgImportConfig conf, List<ImportRowEntity> dataRowEntityList) {
        Map<Integer, List<String>> logCache = conf.getLogCache();
        if (!CollectionUtils.isEmpty(logCache)) {
            Map<Integer, Map<Integer, String>> indexAndDataMap = CostCfgImportService.getIndexAndDataMap(dataRowEntityList);
            List<Map<String, Object>> errorList = CostCfgImportService.getErrorList(conf, logCache, indexAndDataMap);
            List<Map<String, Object>> existErrorList = conf.getErrorList();
            if (errorList != null) {
                existErrorList.addAll(errorList);
            }
            conf.setErrorList(existErrorList);
            logCache.clear();
        }
    }

    private static List<Map<String, Object>> getErrorList(CostCfgImportConfig conf, Map<Integer, List<String>> logCache, Map<Integer, Map<Integer, String>> indexAndDataMap) {
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(10);
        Map<Integer, String> colIndexKeyMap = conf.getCostCfgImportParamEntity().getColIndexKeyMap();
        for (Map.Entry<Integer, List<String>> next : logCache.entrySet()) {
            Integer index = next.getKey();
            Map<Integer, String> dataMap = indexAndDataMap.get(index);
            HashMap<String, Object> costCfgErrorDataMap = new HashMap<String, Object>(16);
            if (dataMap != null) {
                for (Map.Entry<Integer, String> dataNext : dataMap.entrySet()) {
                    Integer columnIndex = dataNext.getKey();
                    String columnKey = colIndexKeyMap.get(columnIndex);
                    String columnValue = dataNext.getValue();
                    costCfgErrorDataMap.put(columnKey, columnValue);
                }
            }
            CostCfgImportService.addErrorColumn(logCache, index, costCfgErrorDataMap);
            errorList.add(costCfgErrorDataMap);
        }
        return errorList;
    }

    private static void addErrorColumn(Map<Integer, List<String>> logCache, Integer index, Map<String, Object> costCfgErrorDataMap) {
        if (logCache == null) {
            return;
        }
        List<String> errors = logCache.get(index);
        if (errors != null && !CollectionUtils.isEmpty(errors = errors.stream().filter(error -> error != null && !error.isEmpty()).collect(Collectors.toList()))) {
            String allErrorMessage = String.join((CharSequence)"", errors);
            if (allErrorMessage.indexOf(12290) != -1) {
                allErrorMessage = allErrorMessage.replace('\u3002', ';');
            }
            costCfgErrorDataMap.put("errorMessage", allErrorMessage);
        }
    }

    private static Map<Integer, Map<Integer, String>> getIndexAndDataMap(List<ImportRowEntity> dataRowEntityList) {
        HashMap<Integer, Map<Integer, String>> indexAndDataMap = new HashMap<Integer, Map<Integer, String>>(16);
        for (ImportRowEntity importRowEntity : dataRowEntityList) {
            Map<Integer, String> data = importRowEntity.getData();
            JSONObject jsonObjectData = importRowEntity.getJsonObjectData();
            int index = jsonObjectData.getIntValue("rowIndex");
            indexAndDataMap.put(index, data);
        }
        return indexAndDataMap;
    }

    private static List<ImportRowEntity> getImportRowMergeList(CostCfgImportConfig conf, List<ImportRowEntity> dataRowEntityList) {
        CostCfgImportDataOperate costCfgImportDataOperate = new CostCfgImportDataOperate();
        Map<String, ImportRowEntity> mergerResultMap = costCfgImportDataOperate.mergeCostCfgImportEntity(conf, dataRowEntityList);
        List<ImportRowEntity> importRowEntityList = CostCfgImportService.getMergeResultList(mergerResultMap, conf.getLogCache());
        logger.info("CostCfgImportService importRowEntityList:{}", (Object)importRowEntityList.size());
        return importRowEntityList;
    }

    private static void setProgressInfo(CostCfgImportConfig conf, List<ImportRowEntity> dataRowEntityList) {
        Map<Integer, List<String>> logCache = conf.getLogCache();
        int failed = logCache.size();
        conf.setFailRows(failed);
        conf.setDealRows(conf.getDealRows() + dataRowEntityList.size());
    }

    private static List<ImportRowEntity> getMergeResultList(Map<String, ImportRowEntity> mergerResultMap, Map<Integer, List<String>> logCache) {
        List<ImportRowEntity> costCfgMergerResultList = new ArrayList<ImportRowEntity>(10);
        for (Map.Entry<String, ImportRowEntity> next : mergerResultMap.entrySet()) {
            ImportRowEntity importRowEntity = next.getValue();
            costCfgMergerResultList.add(importRowEntity);
        }
        costCfgMergerResultList = CostCfgImportService.filterRightRows(costCfgMergerResultList, logCache);
        return costCfgMergerResultList;
    }

    private static List<ImportRowEntity> transformDataToRowEntity(CostCfgImportConfig conf, List<Map<Integer, String>> rowDataList) {
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        Map<String, String> colKeyAndColumnNameMap = costCfgImportParamEntity.getColumnKeyAndColumnNameMap();
        HashMap<String, String> columnNameAndColKeyMap = new HashMap<String, String>(colKeyAndColumnNameMap.size());
        colKeyAndColumnNameMap.forEach((key, value) -> columnNameAndColKeyMap.put((String)value, (String)key));
        Map<Integer, String> colIndexAndColumnNameMap = conf.getDataHead().get(0);
        Map<Integer, String> columnIndexAndColKeyMap = CostCfgImportService.getColumnIndexAndColKeyMap(colIndexAndColumnNameMap, columnNameAndColKeyMap);
        costCfgImportParamEntity.setColIndexNameMap(colIndexAndColumnNameMap);
        costCfgImportParamEntity.setColKeyNameMap(colKeyAndColumnNameMap);
        costCfgImportParamEntity.setColIndexKeyMap(columnIndexAndColKeyMap);
        return CostCfgImportService.getImportRowEntities(conf, rowDataList, columnNameAndColKeyMap);
    }

    private static List<ImportRowEntity> getImportRowEntities(CostCfgImportConfig conf, List<Map<Integer, String>> rowDataList, Map<String, String> columnNameAndColKeyMap) {
        int dealRowNum = conf.getDealRows();
        String costCfgType = CostExportCommonHelper.getCostCfgTypeName();
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        String billFormId = costCfgImportParamEntity.getBillFormId();
        Map<Integer, String> colIndexKeyMap = costCfgImportParamEntity.getColIndexKeyMap();
        Map<Integer, String> colIndexAndColumnNameMap = costCfgImportParamEntity.getColIndexNameMap();
        ArrayList<ImportRowEntity> dataRowEntityList = new ArrayList<ImportRowEntity>(10);
        for (int i = 0; i < rowDataList.size(); ++i) {
            Map<Integer, String> rowDataMap = rowDataList.get(i);
            HashMap<String, Object> columnKeyAndValueMap = new HashMap<String, Object>(colIndexKeyMap.size());
            for (Map.Entry<Integer, String> next : colIndexKeyMap.entrySet()) {
                Integer colIndex = next.getKey();
                String value = rowDataMap.get(colIndex);
                String columnName = colIndexAndColumnNameMap.get(colIndex);
                if (columnName.contains("* ")) {
                    columnName = columnName.replace("* ", "");
                }
                String columnKey = columnNameAndColKeyMap.get(columnName);
                columnKeyAndValueMap.put(columnKey, value);
            }
            if ("pcs_costsalaryitemcfg".equals(billFormId) || "pcs_costsalaryfilecfg".equals(billFormId) || "pcs_costpostcfg".equals(billFormId) || "pcs_costempcfg".equals(billFormId)) {
                columnKeyAndValueMap.put("costCfgType", costCfgType);
            }
            int rowIndex = dealRowNum + i + 1;
            columnKeyAndValueMap.put("rowIndex", rowIndex);
            ImportRowEntity importRowEntity = new ImportRowEntity(rowIndex, rowDataMap);
            importRowEntity.setJsonObjectData(new JSONObject(columnKeyAndValueMap));
            dataRowEntityList.add(importRowEntity);
        }
        return dataRowEntityList;
    }

    private static Map<Integer, String> getColumnIndexAndColKeyMap(Map<Integer, String> colIndexAndColumnNameMap, Map<String, String> columnNameAndColKeyMap) {
        HashMap<Integer, String> columnIndexAndColKeyMap = new HashMap<Integer, String>(16);
        for (Map.Entry<Integer, String> next : colIndexAndColumnNameMap.entrySet()) {
            Integer colIndex = next.getKey();
            String columnName = colIndexAndColumnNameMap.get(colIndex);
            if (columnName.contains("* ")) {
                columnName = columnName.replace("* ", "");
            }
            String columnKey = columnNameAndColKeyMap.get(columnName);
            columnIndexAndColKeyMap.put(colIndex, columnKey);
        }
        return columnIndexAndColKeyMap;
    }

    private static String dataImportOneBatch(CostCfgImportConfig conf, List<ImportRowEntity> costCfgBatchList) {
        logger.info("CostCfgImportService dataImportOneBatch begin 1-1");
        try {
            Map<Integer, List<String>> logCache = conf.getLogCache();
            CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
            CostCfgImportService.validateImportData(costCfgBatchList, logCache, costCfgImportParamEntity);
            logger.info("CostCfgImportService validateImportData end 1-2");
            List<ImportRowEntity> costCfgDealResultList = CostCfgImportService.filterRightRows(costCfgBatchList, logCache);
            Map<String, Map<String, String>> columnKeyAndQueryMap = costCfgImportParamEntity.getColumnKeyAndQueryMap();
            Map<String, String> colKeyAndColNameMap = costCfgImportParamEntity.getColumnKeyAndColumnNameMap();
            String billFormId = costCfgImportParamEntity.getBillFormId();
            CostCfgImportDataOperate costCfgImportDataOperate = new CostCfgImportDataOperate();
            costCfgImportDataOperate.baseDataColumnConvertToDy(billFormId, costCfgDealResultList, colKeyAndColNameMap, columnKeyAndQueryMap, logCache);
            logger.info("CostCfgImportService baseDataColumnConvertToDy end 1-3");
            costCfgDealResultList = CostCfgImportService.filterRightRows(costCfgDealResultList, logCache);
            ArrayList<Long> sourceIdList = new ArrayList<Long>(10);
            ArrayList<Long> salaryFileIdList = new ArrayList<Long>(10);
            CostCfgImportService.initSourceIdList(billFormId, sourceIdList, salaryFileIdList, costCfgDealResultList);
            logger.info("CostCfgImportService initSourceIdList end 1-4");
            Long costAdaptionId = costCfgImportParamEntity.getCostAdaptionId();
            Map<String, DynamicObject> keyAndCostCfgDyMap = CostCfgImportHelper.queryCostCfgDy(billFormId, costAdaptionId, sourceIdList, salaryFileIdList);
            logger.info("CostCfgImportService initSourceIdList end 1-5");
            costCfgDealResultList = costCfgImportDataOperate.importEntityConvertToCostCfgDy(sourceIdList, costCfgDealResultList, keyAndCostCfgDyMap, conf);
            logger.info("CostCfgImportService importEntityConvertToCostCfgDy end 1-6");
            costCfgDealResultList = CostCfgImportService.filterRightRows(costCfgDealResultList, logCache);
            costCfgDealResultList = CostCfgImportService.validateSaveOp(conf, costCfgDealResultList, keyAndCostCfgDyMap);
            CostCfgImportService.batchDealImportUsableData(costCfgDealResultList, keyAndCostCfgDyMap, conf);
            logger.info("CostCfgImportService batchDealImportUsableData  end 1-9");
            return "";
        }
        catch (Exception e) {
            logger.error("CostCfgImportService dataImportOneBatch error...", (Throwable)e);
            return e.getMessage();
        }
    }

    private static List<ImportRowEntity> validateSaveOp(CostCfgImportConfig conf, List<ImportRowEntity> costCfgDealResultList, Map<String, DynamicObject> keyAndCostCfgDyMap) {
        List<ImportRowEntity> convertImportAddRowList = new ArrayList<ImportRowEntity>(10);
        List<ImportRowEntity> convertImportUpdateRowList = new ArrayList<ImportRowEntity>(10);
        for (ImportRowEntity importableRowInfo : costCfgDealResultList) {
            String rowKey = importableRowInfo.getRowKey();
            DynamicObject dbDynamicObj = keyAndCostCfgDyMap.get(rowKey);
            if (dbDynamicObj == null) {
                convertImportAddRowList.add(importableRowInfo);
                continue;
            }
            convertImportUpdateRowList.add(importableRowInfo);
        }
        CostCfgImportService.executeOp("save_validate", convertImportAddRowList, conf);
        CostCfgImportService.executeOp("save_validate", convertImportUpdateRowList, conf);
        logger.info("CostCfgImportService executeOp save_validate end 1-7");
        Map<Integer, List<String>> logCache = conf.getLogCache();
        convertImportAddRowList = CostCfgImportService.filterRightRows(convertImportAddRowList, logCache);
        convertImportUpdateRowList = CostCfgImportService.filterRightRows(convertImportUpdateRowList, logCache);
        ArrayList<ImportRowEntity> costCfgImportList = new ArrayList<ImportRowEntity>(10);
        costCfgImportList.addAll(convertImportAddRowList);
        costCfgImportList.addAll(convertImportUpdateRowList);
        logger.info("CostCfgImportService filterRightRows end 1-8");
        return costCfgImportList;
    }

    private static void batchDealImportUsableData(List<ImportRowEntity> costCfgDealResultList, Map<String, DynamicObject> keyAndCostCfgDyMap, CostCfgImportConfig conf) {
        logger.info("CostCfgImportService batchDealImportUsableData  begin 1-1");
        if (CollectionUtils.isEmpty(costCfgDealResultList)) {
            return;
        }
        Set<String> ignoreKeysSet = CostCfgImportService.getIgnoreKeysSet();
        ArrayList<ImportRowEntity> needSaveAddList = new ArrayList<ImportRowEntity>(10);
        ArrayList<ImportRowEntity> needSaveUpdateList = new ArrayList<ImportRowEntity>(10);
        ArrayList<DynamicObject> newHisDys = new ArrayList<DynamicObject>(10);
        ArrayList<ImportRowEntity> newHisImportRowEntity = new ArrayList<ImportRowEntity>(10);
        CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
        Long costStruId = costCfgImportParamEntity.getCostStruId();
        String billFormId = costCfgImportParamEntity.getBillFormId();
        DynamicObjectCollection costSegTypeStoreDyList = new DynamicObjectCollection();
        SWCDataServiceHelper costSegStoreHelper = new SWCDataServiceHelper("pcs_costsegstore");
        Map<Long, String> costStruDimensionIdMap = CostCfgHelper.getCostStruDimensionIdStorageNumberMap(costStruId);
        String costSourceType = CostCfgHelper.getCostType(billFormId);
        for (ImportRowEntity importableRowInfo : costCfgDealResultList) {
            DynamicObject currEntityDyObj = importableRowInfo.getDyObj();
            String rowKey = importableRowInfo.getRowKey();
            DynamicObject dbDynamicObj = keyAndCostCfgDyMap.get(rowKey);
            if (dbDynamicObj == null) {
                needSaveAddList.add(importableRowInfo);
                continue;
            }
            String status = dbDynamicObj.getString("status");
            if ("A".equals(status) || "B".equals(status)) {
                needSaveUpdateList.add(importableRowInfo);
                continue;
            }
            if (!"C".equals(status)) continue;
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(dbDynamicObj.getDataEntityType().getName());
            DynamicObject hisDyn = serviceHelper.generateEmptyDynamicObject();
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)dbDynamicObj, (DynamicObject)hisDyn, null, null);
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)currEntityDyObj, (DynamicObject)hisDyn, ignoreKeysSet, null);
            hisDyn.set("status", (Object)"C");
            hisDyn.set("boid", dbDynamicObj.get("id"));
            Date firstBsed = currEntityDyObj.getDate("firstbsed");
            Date bsed = currEntityDyObj.getDate("bsed");
            if (firstBsed != null && bsed != null && SWCDateTimeUtils.dayBefore((Date)bsed, (Date)firstBsed)) {
                hisDyn.set("firstbsed", (Object)bsed);
            }
            CostCfgHelper.fillCostSegmentInfo("costCfg", "1", costSegStoreHelper, hisDyn, costStruDimensionIdMap, costSegTypeStoreDyList);
            if ("pcs_costitemcfg".equals(billFormId) || "pcs_costdeptcfg".equals(billFormId)) {
                CostCfgHelper.fillCostSegmentInfo("costCfgType", costSourceType, costSegStoreHelper, hisDyn, costStruDimensionIdMap, costSegTypeStoreDyList);
            }
            newHisDys.add(hisDyn);
            newHisImportRowEntity.add(importableRowInfo);
        }
        logger.info("CostCfgImportService batchDealImportUsableData executeOp begin 1-2");
        Map<Integer, List<String>> logCache = conf.getLogCache();
        CostCfgImportService.executeOp("save", needSaveAddList, conf);
        CostCfgImportService.executeOp("save", needSaveUpdateList, conf);
        logger.info("CostCfgImportService batchDealImportUsableData executeOp end 1-2");
        HisResponse response = BaseDataHisHelper.saveNoTimeVersion((DynamicObject[])newHisDys.toArray(new DynamicObject[newHisDys.size()]), (boolean)true);
        logger.info("CostCfgImportService batchDealImportUsableData saveNoTimeVersion end 1-3");
        costSegStoreHelper.save(costSegTypeStoreDyList);
        CostCfgImportService.setLogInfoByResponse((HisResponse<VersionChangeRespData>)response, newHisImportRowEntity, conf.getLogCache());
        logger.info("CostCfgImportService batchDealImportUsableData setLogInfoByResponse end 1-4");
    }

    private static void setLogInfoByResponse(HisResponse<VersionChangeRespData> response, List<ImportRowEntity> newHisImportRowEntity, Map<Integer, List<String>> logCache) {
        if (response != null && SWCStringUtils.isNotEmpty((String)response.getErrorMessage())) {
            String errorMessage = response.getErrorMessage();
            for (ImportRowEntity importRowEntity : newHisImportRowEntity) {
                CostCfgImportLoggerHelper.putRowErrors(errorMessage, importRowEntity, logCache);
            }
        }
    }

    private static Set<String> getIgnoreKeysSet() {
        return Sets.newHashSetWithExpectedSize((int)6);
    }

    private static void initSourceIdList(String billFormId, List<Long> sourceIdList, List<Long> salaryFileIdList, List<ImportRowEntity> costCfgDealResultList) {
        for (ImportRowEntity importRowEntity : costCfgDealResultList) {
            DynamicObject costCfgDy = (DynamicObject)importRowEntity.getJsonObjectData().get((Object)"costCfgNumber");
            long sourceId = costCfgDy.getLong("id");
            sourceIdList.add(sourceId);
            if (!"pcs_costsalaryitemcfg".equals(billFormId)) continue;
            DynamicObject costSalaryFileItemDy = (DynamicObject)importRowEntity.getJsonObjectData().get((Object)"salaryFileNumber");
            long salaryFileId = costSalaryFileItemDy.getLong("id");
            salaryFileIdList.add(salaryFileId);
        }
    }

    private static List<ImportRowEntity> filterRightRows(List<ImportRowEntity> costCfgDealResultList, Map<Integer, List<String>> logCache) {
        return costCfgDealResultList.stream().filter(o1 -> !logCache.containsKey(o1.getRowIndex())).collect(Collectors.toList());
    }

    public static void executeOp(String opName, List<ImportRowEntity> costCfgDealResultList, CostCfgImportConfig conf) {
        if (CollectionUtils.isEmpty(costCfgDealResultList)) {
            return;
        }
        List<Object> waitDys = new ArrayList<DynamicObject>(10);
        HashMap<Long, ImportRowEntity> costCfgDataMap = new HashMap<Long, ImportRowEntity>(16);
        for (int i = 0; i < costCfgDealResultList.size(); ++i) {
            ImportRowEntity rowEntity = costCfgDealResultList.get(i);
            DynamicObject dy = rowEntity.getDyObj();
            waitDys.add(dy);
            costCfgDataMap.put(dy.getLong("id"), rowEntity);
        }
        if ("save".equals(opName)) {
            CostCfgImportExtService extService = new CostCfgImportExtService();
            CostCfgEvent event = new CostCfgEvent(waitDys);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostCfgImportExtService.class, (String)"kd.sdk.swc.pcs.business.extpoint.costcfg.ICostCfgImportExtService#setCostCfgImportValue", null);
            hrPluginProxy.callReplaceIfPresent(proxy -> {
                proxy.setCostCfgImportValue(event);
                return null;
            });
            List costCfgColl = event.getCostCfgColl();
            if (!CollectionUtils.isEmpty((Collection)costCfgColl)) {
                waitDys = costCfgColl;
            }
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isimport", "1");
        operateOption.setVariableValue("hasRight", "true");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult operationResult = opImpl.localInvokeOperation(opName, waitDys.toArray(new DynamicObject[0]), operateOption);
        CostCfgImportService.dealOperationResult(costCfgDataMap, operationResult, conf, opName);
    }

    private static void dealOperationResult(Map<Long, ImportRowEntity> costCfgDataMap, OperationResult operationResult, CostCfgImportConfig conf, String opName) {
        Map<Integer, List<String>> logCache = conf.getLogCache();
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                ImportRowEntity importRowEntity = costCfgDataMap.get(Long.parseLong(String.valueOf(operateInfo.getPkValue())));
                CostCfgImportLoggerHelper.putRowErrors(operateInfo.getMessage(), importRowEntity, logCache);
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && SWCStringUtils.isNotEmpty((String)msg)) {
                for (ImportRowEntity importRowEntity : costCfgDataMap.values()) {
                    CostCfgImportLoggerHelper.putRowErrors(msg, importRowEntity, logCache);
                }
            }
        } else if ("save".equals(opName)) {
            int excelNum = 0;
            List successPkIds = operationResult.getSuccessPkIds();
            for (Object idObj : successPkIds) {
                ImportRowEntity importRowEntity = costCfgDataMap.get(Long.parseLong(String.valueOf(idObj)));
                List<JSONObject> jsonObjectDataList = importRowEntity.getJsonObjectDataList();
                int i = jsonObjectDataList == null ? 0 : jsonObjectDataList.size();
                excelNum += i;
            }
            conf.setSaveExcelRows(conf.getSaveExcelRows() + excelNum);
        }
    }

    public String validatorImportData(Map<String, String> costCfgHeaders, Sheet sheetAt) {
        List<String> excelHeader = CostCfgImportSheetHandler.getExcelHeader(sheetAt);
        if (excelHeader.isEmpty()) {
            return ResManager.loadKDString((String)"\u89e3\u6790Excel\u5931\u8d25\uff0c\u5728\u7b2c\u4e00\u884c\u6ca1\u6709\u8bfb\u53d6\u5230\u4efb\u4f55\u6570\u636e\u3002", (String)"CostCfgImportService_22", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        }
        if (excelHeader.size() != costCfgHeaders.size()) {
            return ResManager.loadKDString((String)"\u8868\u5934\u5b57\u6bb5\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"CostCfgImportService_23", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        }
        Collection<String> valueCollection = costCfgHeaders.values();
        ArrayList<String> valueList = new ArrayList<String>(valueCollection);
        for (int i = 0; i < excelHeader.size(); ++i) {
            String excelColumn;
            String column = (String)valueList.get(i);
            if (SWCStringUtils.equals((String)column, (String)(excelColumn = excelHeader.get(i))) || SWCStringUtils.equals((String)("* " + column), (String)excelColumn)) continue;
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8868\u5934\u5b57\u6bb5\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"CostCfgImportService_23", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]), excelColumn);
        }
        int lastRowNum = sheetAt.getLastRowNum();
        if (lastRowNum <= 1) {
            return ResManager.loadKDString((String)"\u89e3\u6790Excel\u5931\u8d25\uff0c\u9664\u4e86\u8868\u5934\u6ca1\u6709\u8bfb\u53d6\u5230\u4efb\u4f55\u6570\u636e\u3002", (String)"CostCfgImportService_35", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        }
        return "";
    }

    private static void validateImportData(List<ImportRowEntity> costCfgBatchList, Map<Integer, List<String>> logCache, CostCfgImportParamEntity costCfgImportParamEntity) {
        try {
            logger.info("CostCfgImportValidator validateMustInputAndRight begin 1");
            String billFormId = costCfgImportParamEntity.getBillFormId();
            List<String> mustInputColumn = costCfgImportParamEntity.getMustInputColumn();
            Map<String, String> colKeyAndColNameMap = costCfgImportParamEntity.getColumnKeyAndColumnNameMap();
            Map<String, DynamicObject> columnKeyAndDimensionDyMap = costCfgImportParamEntity.getColumnKeyAndDimensionDyMap();
            CostCfgImportService.validateMustInputAndRight(billFormId, costCfgBatchList, mustInputColumn, colKeyAndColNameMap, columnKeyAndDimensionDyMap, logCache);
            logger.info("CostCfgImportValidator validateMustInputAndRight end 2");
        }
        catch (Exception e) {
            logger.error("CostCfgImportValidator validateImportData error: ", (Throwable)e);
        }
    }

    private static void validateMustInputAndRight(String billFormId, List<ImportRowEntity> costCfgDealResultList, List<String> mustInputColumn, Map<String, String> colKeyAndColNameMap, Map<String, DynamicObject> columnKeyAndDimensionDy, Map<Integer, List<String>> logCache) {
        List<String> costTypeNameList = CostExportCommonHelper.getCostTypeNameList();
        Map<String, String> costTypeNameByFormIdMap = CostExportCommonHelper.getCostTypeNameMapByFormId(billFormId);
        for (ImportRowEntity importRowEntity : costCfgDealResultList) {
            List<JSONObject> jsonObjectDataList = importRowEntity.getJsonObjectDataList();
            if (CollectionUtils.isEmpty(jsonObjectDataList)) {
                String errorMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgImportDataOperate_7", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
                int rowIndex = importRowEntity.getRowIndex();
                CostCfgImportLoggerHelper.putRowError(rowIndex, errorMessage, logCache);
                continue;
            }
            for (JSONObject jsonData : jsonObjectDataList) {
                String mustInputError = CostCfgImportService.validatorMustInputColumn(jsonData, mustInputColumn, colKeyAndColNameMap, columnKeyAndDimensionDy);
                String typeError = CostCfgImportService.validatorCostCfgEntryType(billFormId, jsonData, costTypeNameList, costTypeNameByFormIdMap);
                String dateError = CostCfgImportService.validatorDate(jsonData);
                String percentError = CostCfgImportService.validatorProportion(jsonData);
                String allErrorMessage = mustInputError + typeError + dateError + percentError;
                if (!SWCStringUtils.isNotEmpty((String)allErrorMessage)) continue;
                int rowIndex = importRowEntity.getRowIndex();
                int rowEntryIndex = jsonData.getInteger("rowIndex");
                CostCfgImportLoggerHelper.putRowEntryError(rowIndex, rowEntryIndex, allErrorMessage, logCache);
            }
        }
    }

    private static String validatorMustInputColumn(JSONObject jsonData, List<String> mustInputColumn, Map<String, String> colKeyAndColNameMap, Map<String, DynamicObject> columnKeyAndDimensionDy) {
        StringBuilder sb = new StringBuilder();
        for (String columnKey : mustInputColumn) {
            String columnValue;
            boolean flag = jsonData.containsKey((Object)columnKey);
            if (!flag || !SWCStringUtils.isEmpty((String)(columnValue = jsonData.getString(columnKey)))) continue;
            String columnName = colKeyAndColNameMap.get(columnKey);
            String errorMessage = ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCfgImportService_25", (String)SWC_PCS_BUSINESS, (Object[])new Object[]{columnName});
            sb.append(errorMessage);
        }
        String costCfgType = jsonData.getString("costCfgType");
        if (CostExportCommonHelper.getPriorityTypeName().equals(costCfgType) || CostExportCommonHelper.getRevealTypeName().equals(costCfgType)) {
            for (Map.Entry<String, DynamicObject> next : columnKeyAndDimensionDy.entrySet()) {
                String value;
                DynamicObject dimensionDy = next.getValue();
                boolean isRequired = dimensionDy.getBoolean("isrequired");
                int storageSetNumber = dimensionDy.getInt("storageset.number");
                if (!isRequired || !SWCStringUtils.isEmpty((String)(value = jsonData.getString("segment" + storageSetNumber)))) continue;
                String costDimensionName = dimensionDy.getString("costdimension.name");
                String errorMessage = ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCfgImportService_25", (String)SWC_PCS_BUSINESS, (Object[])new Object[]{costDimensionName});
                sb.append(errorMessage);
            }
        }
        return sb.toString();
    }

    private static String validatorDate(JSONObject jsonData) {
        Object bsedObj = jsonData.get((Object)"bsed");
        String error = "";
        if (bsedObj == null) {
            return error;
        }
        if (String.valueOf(bsedObj).length() != 10) {
            error = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u9700\u6309\u201cyyyy-mm-dd\u201d\u683c\u5f0f\u586b\u5199\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CostCfgImportService_26", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]), bsedObj);
        } else {
            try {
                SWCDateTimeUtils.parseDate((String)String.valueOf(bsedObj), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                error = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u9700\u6309\u201cyyyy-mm-dd\u201d\u683c\u5f0f\u586b\u5199\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CostCfgImportService_26", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]), bsedObj);
            }
        }
        return error;
    }

    private static String validatorProportion(JSONObject jsonData) {
        Object proportionObj = jsonData.get((Object)"proportion");
        String error = "";
        if (proportionObj == null) {
            return error;
        }
        try {
            BigDecimal proportion;
            String proportionStr = String.valueOf(proportionObj);
            String result = CostCommonHelper.numberRemoveZero(proportionStr);
            if (result.contains(".")) {
                int length = result.length();
                String substring = result.substring(result.indexOf(46) + 1, length);
                if (substring.length() > 2) {
                    return ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u4ec5\u652f\u6301\u8f93\u51652\u4f4d\u5c0f\u6570;", (String)"CostCfgImportService_38", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
                }
            }
            if ((proportion = new BigDecimal(proportionStr)).compareTo(BigDecimal.ZERO) <= 0 || proportion.compareTo(new BigDecimal(100)) > 0) {
                error = ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u8d85\u51fa\u6570\u503c\u8303\u56f4(0,100];", (String)"CostCfgImportService_37", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
            } else {
                jsonData.put("proportion", (Object)proportion);
            }
        }
        catch (Exception e) {
            error = ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u53ea\u80fd\u8f93\u51652\u4f4d\u5c0f\u6570\u7684\u6570\u503c;", (String)"CostCfgImportService_39", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        }
        return error;
    }

    public static boolean isAllZero(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if ("0".equals(str.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    private static String validatorCostCfgEntryType(String billFormId, JSONObject jsonData, List<String> costTypeNameList, Map<String, String> costTypeNameByFormIdMap) {
        String errorMessage = "";
        String costTypeName = jsonData.getString("costCfgType");
        if (SWCStringUtils.isEmpty((String)costTypeName)) {
            return errorMessage;
        }
        if (costTypeNameList.contains(costTypeName)) {
            String costTypeNameValue = costTypeNameByFormIdMap.get(costTypeName);
            if ("pcs_costitemcfg".equals(billFormId) && SWCStringUtils.isEmpty((String)costTypeNameValue)) {
                errorMessage = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u6210\u672c\u8bbe\u7f6e\u4e2d\u53ea\u6709\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u548c\u201c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u201d\u4e24\u79cd\u7c7b\u578b\u3002", (String)"CostCfgImportService_29", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
            } else if ("pcs_costdeptcfg".equals(billFormId) && SWCStringUtils.isEmpty((String)costTypeNameValue)) {
                errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u85aa\u916c\u6210\u672c\u8bbe\u7f6e\u4e2d\uff0c\u53ea\u6709\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u548c\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d\u4e24\u79cd\u7c7b\u578b\u3002", (String)"CostCfgImportService_30", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
            }
        } else {
            errorMessage = ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"CostCfgImportService_31", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        }
        return errorMessage;
    }
}

