/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostItemCfgQualityHelper;

public class CostItemQualityService {
    private IFormView view;

    public CostItemQualityService(IFormView view) {
        this.view = view;
    }

    public int fillCostCfgQualityInfo() {
        DynamicObject costItemCfgDy = this.view.getModel().getDataEntity();
        Long qualityDimId = costItemCfgDy.getLong("qualitydim.id");
        if (qualityDimId == 0L) {
            SWCPageCache swcPageCache = new SWCPageCache(this.view);
            qualityDimId = (Long)swcPageCache.get("qualityDimId", Long.class);
        }
        this.view.getModel().setValue("qualitydim", (Object)qualityDimId);
        int qualityDimIndex = costItemCfgDy.getInt("qualitydim.index");
        if (qualityDimIndex == 0) {
            return qualityDimIndex;
        }
        if (6 == qualityDimIndex) {
            String groupValue = costItemCfgDy.getString("groupvalue");
            this.view.getModel().setValue("basedataid" + qualityDimIndex, (Object)groupValue);
        } else {
            String groupValue = costItemCfgDy.getString("groupvalue");
            if (SWCStringUtils.isNotEmpty((String)groupValue)) {
                List<String> strings = Arrays.asList(groupValue.split(","));
                List collect = strings.stream().map(str -> Long.parseLong(str.trim())).collect(Collectors.toList());
                Object[] objects = collect.toArray();
                this.view.getModel().setValue("basedataid" + qualityDimIndex, (Object)objects);
            }
        }
        return qualityDimIndex;
    }

    public void setQualityBaseDataVisible(int qualityDimIndex) {
        if (qualityDimIndex == 0) {
            qualityDimIndex = 1;
        }
        for (int i = 1; i <= 11; ++i) {
            String baseData = "basedataid" + String.valueOf(i);
            if (i == qualityDimIndex) {
                this.view.setVisible(Boolean.TRUE, new String[]{baseData});
                BasedataEdit basedataEdit = (BasedataEdit)this.view.getControl("basedataid" + i);
                basedataEdit.setMustInput(true);
                continue;
            }
            this.view.setVisible(Boolean.FALSE, new String[]{baseData});
            FieldEdit fieldEdit = (FieldEdit)this.view.getControl("basedataid" + i);
            fieldEdit.setMustInput(false);
        }
        BasedataEdit basedataEdit = (BasedataEdit)this.view.getControl("qualitydim");
        basedataEdit.setMustInput(true);
    }

    public void initQualityGroupInfo(DynamicObject[] costItemCfgDys) {
        ArrayList<Long> costQualityIds = new ArrayList<Long>(costItemCfgDys.length);
        for (int i = 0; i < costItemCfgDys.length; ++i) {
            long id = costItemCfgDys[i].getLong("qualitydim.id");
            costQualityIds.add(id);
        }
        if (!costQualityIds.isEmpty()) {
            SWCPageCache swcPageCache = new SWCPageCache(this.view);
            swcPageCache.put("qualityDimId", costQualityIds.get(0));
        }
    }

    public List<TreeNode> buildLeftTree(DynamicObject[] dynamicObjects, String parentId) {
        TreeView treeView = this.setLeftTreeInfo(parentId);
        List<TreeNode> nodes = this.addSaveNodeInfo(dynamicObjects);
        this.addNotSaveNodeInfo(nodes, parentId);
        treeView.addNodes(nodes);
        return nodes;
    }

    private TreeView setLeftTreeInfo(String parentId) {
        TreeView treeView = (TreeView)this.view.getControl("treeview");
        treeView.deleteAllNodes();
        treeView.addNode(this.getRootNode(Long.parseLong(parentId)));
        treeView.setMulti(false);
        treeView.setRootVisible(true);
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String keyRoot = (String)swcPageCache.get("keyRoot", String.class);
        treeView.expand(keyRoot);
        treeView.setDraggable(true);
        treeView.setDroppable(true);
        return treeView;
    }

    public void initParentId() {
        long pkId = this.view.getModel().getDataEntity().getLong("id");
        if (pkId == 0L) {
            return;
        }
        long parentId = CostItemCfgQualityHelper.getParentId(pkId);
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        if (parentId == 0L) {
            parentId = pkId;
        }
        String keyRoot = String.valueOf(parentId);
        swcPageCache.put("parentId", (Object)keyRoot);
        swcPageCache.put("selectNodeId", (Object)String.valueOf(pkId));
        swcPageCache.put("keyRoot", (Object)keyRoot);
    }

    public void setCostItemCfgInfo() {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String selectNodeId = (String)swcPageCache.get("selectNodeId", String.class);
        if ("addnotsave".equals(selectNodeId)) {
            this.setInfoFromCache(swcPageCache);
        }
        this.setInfoFromSalaryItem();
    }

    public void clickTreeNode(String nodeId, TreeNodeEvent evt) {
        String qualityName;
        if ("addnotsave".equals(nodeId)) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String parentId = (String)swcPageCache.get("parentId", String.class);
        if (SWCStringUtils.isEmpty((String)parentId)) {
            return;
        }
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            nodeId = parentId;
        }
        if (SWCStringUtils.isEmpty((String)(qualityName = (String)swcPageCache.get("qualityName", String.class)))) {
            this.loadById(nodeId);
        } else {
            swcPageCache.put("clickOtherTreeNode", (Object)nodeId);
            evt.setCancel(true);
            this.view.showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u4fe1\u606f\uff0c\u5207\u6362\u540e\u5c06\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostItemQualityService_1", (String)"swc-pcs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clicktreenodecallback"));
        }
    }

    public void loadById(String nodeId) {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        swcPageCache.put("selectNodeId", (Object)nodeId);
        BillModel model = (BillModel)this.view.getService(IDataModel.class);
        model.load((Object)Long.valueOf(nodeId));
        this.view.updateView();
    }

    public void focusRootTreeNode() {
        TreeView tree = (TreeView)this.view.getControl("treeview");
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String keyRoot = (String)swcPageCache.get("keyRoot", String.class);
        TreeNode root = new TreeNode("", keyRoot, "");
        tree.focusNode(root);
    }

    public void clickTreeRoot() {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String parentId = (String)swcPageCache.get("parentId", String.class);
        if (SWCStringUtils.isEmpty((String)parentId)) {
            return;
        }
        this.loadById(parentId);
    }

    public List<Long> getCostItemIdList(DynamicObject[] costItemCfgDys) {
        ArrayList<Long> costItemIdList = new ArrayList<Long>(costItemCfgDys.length);
        for (DynamicObject costItemCfgDy : costItemCfgDys) {
            int qualityDimIndex = costItemCfgDy.getInt("qualitydim.index");
            if (6 == qualityDimIndex) {
                return costItemIdList;
            }
            String groupValue = costItemCfgDy.getString("groupvalue");
            if (!SWCStringUtils.isNotEmpty((String)groupValue)) continue;
            List<String> strings = Arrays.asList(groupValue.split(","));
            List collect = strings.stream().map(str -> Long.parseLong(str.trim())).collect(Collectors.toList());
            costItemIdList.addAll(collect);
        }
        return costItemIdList;
    }

    private List<TreeNode> addSaveNodeInfo(DynamicObject[] dynamicObjects) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(dynamicObjects.length);
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String keyRoot = (String)swcPageCache.get("keyRoot", String.class);
        for (DynamicObject costItemDy : dynamicObjects) {
            String qualityName = costItemDy.getString("qualityname");
            if (SWCStringUtils.isEmpty((String)qualityName)) {
                qualityName = costItemDy.getString("name");
            }
            nodes.add(new TreeNode(keyRoot, costItemDy.getString("id"), qualityName));
        }
        return nodes;
    }

    private TreeNode getRootNode(long parentId) {
        String rootName = "";
        if (parentId != 0L) {
            rootName = CostItemCfgQualityHelper.getTootNodeName(parentId);
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String keyRoot = (String)swcPageCache.get("keyRoot", String.class);
        TreeNode root = new TreeNode("", keyRoot, rootName);
        root.setChildren(new ArrayList());
        return root;
    }

    private void addNotSaveNodeInfo(List<TreeNode> nodes, String parentId) {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String selectNodeId = (String)swcPageCache.get("selectNodeId", String.class);
        if (SWCStringUtils.isNotEmpty((String)parentId) && "addnotsave".equals(selectNodeId)) {
            this.view.getModel().setValue("parentId", (Object)parentId);
            String qualityName = (String)swcPageCache.get("qualityName", String.class);
            if (StringUtils.isNotBlank((CharSequence)qualityName)) {
                String keyRoot = (String)swcPageCache.get("keyRoot", String.class);
                nodes.add(new TreeNode(keyRoot, "addnotsave", qualityName));
            }
        }
    }

    private void setInfoFromCache(SWCPageCache swcPageCache) {
        String qualityNumber = (String)swcPageCache.get("qualityNumber", String.class);
        String qualityName = (String)swcPageCache.get("qualityName", String.class);
        Date qualityBsed = (Date)swcPageCache.get("qualityBsed", Date.class);
        Long costAdapterId = (Long)swcPageCache.get("costAdapter", Long.class);
        Long sourceTypeId = (Long)swcPageCache.get("sourceType", Long.class);
        Long sourceId = (Long)swcPageCache.get("source", Long.class);
        Long costStruId = (Long)swcPageCache.get("costStru", Long.class);
        Long orgId = (Long)swcPageCache.get("createOrg", Long.class);
        this.view.getModel().setValue("costadapter", (Object)costAdapterId);
        this.view.getModel().setValue("sourcetype", (Object)sourceTypeId);
        this.view.getModel().setValue("source", (Object)sourceId);
        this.view.getModel().setValue("bsed", (Object)qualityBsed);
        this.view.getModel().setValue("qualityname", (Object)qualityName);
        this.view.getModel().setValue("qualitynumber", (Object)qualityNumber);
        this.view.getModel().setValue("costStru", (Object)costStruId);
        this.view.getModel().setValue("createOrg", (Object)orgId);
        this.view.getModel().setValue("name", (Object)this.view.getModel().getDataEntity().getString("source.name"));
        this.view.getModel().setValue("number", (Object)this.view.getModel().getDataEntity().getString("source.number"));
    }

    private void setInfoFromSalaryItem() {
        DynamicObject salaryItemDy = this.view.getModel().getDataEntity().getDynamicObject("source");
        if (salaryItemDy == null) {
            return;
        }
        String qualityName = this.view.getModel().getDataEntity().getString("qualityname");
        if (SWCStringUtils.isEmpty((String)qualityName)) {
            String name = salaryItemDy.getString("name");
            String number = salaryItemDy.getString("number");
            this.view.getModel().setValue("name", (Object)name);
            this.view.getModel().setValue("number", (Object)number);
        }
    }

    public void initLeftCostCfgQualityInfo() {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String parentId = (String)swcPageCache.get("parentId", String.class);
        if (SWCStringUtils.isEmpty((String)parentId)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costitemcfg");
        boolean exists = helper.isExists((Object)parentId);
        if (!exists) {
            return;
        }
        DynamicObject[] costItemCfgDys = CostItemCfgQualityHelper.selectCostItemCfgList(Long.parseLong(parentId));
        this.initQualityGroupInfo(costItemCfgDys);
        List<TreeNode> treeNodeList = this.buildLeftTree(costItemCfgDys, parentId);
        CostItemCfgQualityHelper.updateCache(treeNodeList, this.view);
    }

    public void setQualityGroupEnable(int qualityDimIndex) {
        if (qualityDimIndex == 0) {
            this.view.setEnable(Boolean.TRUE, new String[]{"qualitydim"});
        } else {
            SWCPageCache swcPageCache = new SWCPageCache(this.view);
            String treeNodeStr = (String)swcPageCache.get("treeNode", String.class);
            List rootNodes = JSON.parseArray((String)treeNodeStr, TreeNode.class);
            if (SWCListUtils.isEmpty((List)rootNodes)) {
                long parentId = this.view.getModel().getDataEntity().getLong("parentid");
                DynamicObject[] costItemCfgDys = CostItemCfgQualityHelper.selectCostItemCfgList(parentId);
                if (costItemCfgDys.length > 1) {
                    this.view.setEnable(Boolean.FALSE, new String[]{"qualitydim"});
                } else {
                    this.view.setEnable(Boolean.TRUE, new String[]{"qualitydim"});
                }
            } else if (!CollectionUtils.isEmpty((Collection)rootNodes) && rootNodes.size() > 1) {
                this.view.setEnable(Boolean.FALSE, new String[]{"qualitydim"});
            } else {
                this.view.setEnable(Boolean.TRUE, new String[]{"qualitydim"});
            }
        }
    }

    public void clearCacheAndRebuildLeftTree() {
        this.cleanCache();
        this.initLeftCostCfgQualityInfo();
        this.focusTreeNode();
    }

    public void cleanCache() {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        swcPageCache.remove("qualityName");
        swcPageCache.remove("qualityNumber");
        swcPageCache.remove("qualityBsed");
    }

    public void focusTreeNode() {
        String selectNodeId;
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String parentId = (String)swcPageCache.get("parentId", String.class);
        if (StringUtils.equals((CharSequence)parentId, (CharSequence)(selectNodeId = (String)swcPageCache.get("selectNodeId", String.class)))) {
            this.focusRootTreeNode();
        } else {
            this.focusChildTreeNode(selectNodeId);
        }
    }

    private void focusChildTreeNode(String selectNodeId) {
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String treeNodeStr = (String)swcPageCache.get("treeNode", String.class);
        List rootNodes = JSON.parseArray((String)treeNodeStr, TreeNode.class);
        if (CollectionUtils.isEmpty((Collection)rootNodes)) {
            return;
        }
        for (TreeNode treeNode : rootNodes) {
            String id = treeNode.getId();
            if (!SWCStringUtils.equals((String)id, (String)selectNodeId)) continue;
            TreeView tree = (TreeView)this.view.getControl("treeview");
            tree.focusNode(treeNode);
            break;
        }
    }

    public void setLeftPanelVisible() {
        long id = this.view.getModel().getDataEntity().getLong("id");
        boolean hisPage = BaseDataHisHelper.isHisPage((IFormView)this.view);
        if (id == 0L) {
            if (hisPage) {
                this.view.setVisible(Boolean.FALSE, new String[]{"leftadd", "leftflexpanelap"});
            } else {
                String qualityName = this.view.getModel().getDataEntity().getString("qualityname");
                if (SWCStringUtils.isEmpty((String)qualityName)) {
                    this.view.setVisible(Boolean.FALSE, new String[]{"leftadd", "leftflexpanelap"});
                } else {
                    this.view.setVisible(Boolean.TRUE, new String[]{"leftflexpanelap"});
                    this.view.setVisible(Boolean.FALSE, new String[]{"leftadd"});
                }
            }
        } else if (hisPage) {
            this.view.setVisible(Boolean.FALSE, new String[]{"leftadd", "leftflexpanelap"});
        } else {
            this.view.setVisible(Boolean.TRUE, new String[]{"leftadd", "leftflexpanelap"});
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costitemcfg");
        SWCPageCache swcPageCache = new SWCPageCache(this.view);
        String parentId = (String)swcPageCache.get("parentId", String.class);
        boolean exists = helper.isExists((Object)parentId);
        if (!exists) {
            this.view.setVisible(Boolean.FALSE, new String[]{"leftadd", "leftflexpanelap"});
        }
        this.view.getModel().setDataChanged(false);
    }
}

