/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcommon;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;

public class CostCommonHelper {
    private static final String NUM_REGEX = "[0-9]*";
    private static Map<String, Long> costCfgTypeMap = new HashMap<String, Long>();

    public static Map<String, Long> getCostCfgTypeMap() {
        return costCfgTypeMap;
    }

    public static Long getCostCfgTypeIdByFormId(String billFormId) {
        return costCfgTypeMap.get(billFormId);
    }

    public static Map<String, String> getBaseDataPropMap(DynamicObjectCollection dimensionEntryColl) {
        HashMap<String, String> baseDataPropMap = new HashMap<String, String>(16);
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            String costDimensionId = dimensionDy.getString("costdimension.id");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String costDimensionIdKey = "1".equals(valueType) || "2".equals(valueType) ? "basedata" + costDimensionId : "text" + costDimensionId;
            String storageSetNumber = dimensionDy.getString("storageset.number");
            baseDataPropMap.put(costDimensionIdKey, storageSetNumber);
        }
        return baseDataPropMap;
    }

    public static Map<String, DynamicObject> getAllDimensionMap(DynamicObjectCollection dimensionEntryColl) {
        HashMap<String, DynamicObject> allDimensionMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            String costDimensionId = dimensionDy.getString("costdimension.id");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String costDimensionIdKey = "1".equals(valueType) || "2".equals(valueType) ? "basedata" + costDimensionId : "text" + costDimensionId;
            allDimensionMap.put(costDimensionIdKey, dimensionDy);
        }
        return allDimensionMap;
    }

    public static void getDynamicColumnMap(Map<String, String> dynamicColumnMap, DynamicObjectCollection entryEntity) {
        for (DynamicObject dimensionDy : entryEntity) {
            String costDimensionId = dimensionDy.getString("costdimension.id");
            String dimensionObjName = dimensionDy.getString("costdimension.name");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String costDimensionIdKey = "1".equals(valueType) || "2".equals(valueType) ? "basedata" + String.valueOf(costDimensionId) : "text" + String.valueOf(costDimensionId);
            dynamicColumnMap.put(costDimensionIdKey, dimensionObjName);
        }
    }

    public static void setDynamicColumnValue(Map<String, Object> valueMap, DynamicObject constResult, Map<String, DynamicObject> queryCostStruMap, Iterator<Map.Entry<String, String>> iterator, Map<String, HashMap<String, DynamicObject>> baseDataValueMap) {
        while (iterator.hasNext()) {
            Map baseDataResult;
            Map.Entry<String, String> next = iterator.next();
            String key = next.getKey();
            DynamicObject dimensionDy = queryCostStruMap.get(key);
            if (dimensionDy == null) continue;
            String storageSetNumber = dimensionDy.getString("storageset.number");
            String baseDataNumber = dimensionDy.getString("costdimension.valuesource.id");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String displayProperty = dimensionDy.getString("costdimension.displayproperty");
            if ("1".equals(valueType)) {
                baseDataResult = baseDataValueMap.get(baseDataNumber);
                CostCommonHelper.setExportValue(valueMap, constResult, key, storageSetNumber, displayProperty, baseDataResult);
                continue;
            }
            if ("2".equals(valueType)) {
                baseDataResult = baseDataValueMap.get("bos_assistantdata_detail");
                CostCommonHelper.setExportValue(valueMap, constResult, key, storageSetNumber, displayProperty, baseDataResult);
                continue;
            }
            if (!"3".equals(valueType)) continue;
            String baseDataStr = constResult.getString("segment" + storageSetNumber);
            valueMap.put(key, baseDataStr);
        }
    }

    private static void setExportValue(Map<String, Object> valueMap, DynamicObject constResult, String key, String storageSetNumber, String displayProperty, Map<String, DynamicObject> baseDataResult) {
        if (baseDataResult == null) {
            return;
        }
        String baseDataStr = constResult.getString("segment" + storageSetNumber);
        DynamicObject dynamicObject = baseDataResult.get(baseDataStr);
        if (dynamicObject == null) {
            return;
        }
        if ("1".equals(displayProperty)) {
            valueMap.put(key, dynamicObject.getString("number"));
        } else {
            valueMap.put(key, dynamicObject.getString("name"));
        }
    }

    public static DynamicObjectType getDynamicObjectType(List<DynamicObject> dimensionObjList) {
        DynamicObjectType dynamicObjectType;
        if (dimensionObjList.isEmpty()) {
            SWCDataServiceHelper costDimensionHelper = new SWCDataServiceHelper("lcs_costdimension");
            DynamicObject generateEmptyDynamicObject = costDimensionHelper.generateEmptyDynamicObject();
            dynamicObjectType = generateEmptyDynamicObject.getDynamicObjectType();
        } else {
            dynamicObjectType = dimensionObjList.get(0).getDynamicObjectType();
        }
        return dynamicObjectType;
    }

    public static Long queryCostAdapterIdByCalTaskId(Long calTaskId) {
        DynamicObject costAdaptionObj = CostCommonHelper.getCostAdapterDyObj(calTaskId);
        return costAdaptionObj == null ? null : Long.valueOf(costAdaptionObj.getLong("id"));
    }

    public static Map<Long, Long> queryCostAdapterIdByCalTaskIds(Set<Long> calTaskIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject[] calTaskObjArr = serviceHelper.query("payrollgroupv", new QFilter[]{new QFilter("id", "in", calTaskIds)});
        Map<Long, Long> calTaskGroupVidMap = Arrays.stream(calTaskObjArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("payrollgroupv.id"), (v1, v2) -> v1));
        serviceHelper.setEntityName("pcs_costadaptionmap");
        DynamicObject[] costAdaptionArr = serviceHelper.query("costadaption.id,source", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "in", calTaskGroupVidMap.values()), new QFilter("status", "=", (Object)"C")}, "modifytime desc");
        Map<Long, Long> groupVidAdaptionMap = Arrays.stream(costAdaptionArr).collect(Collectors.toMap(dy -> dy.getLong("source"), dy -> dy.getLong("costadaption.id"), (v1, v2) -> v1));
        HashMap<Long, Long> calTaskAdaptionIdMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Long> entry : calTaskGroupVidMap.entrySet()) {
            calTaskAdaptionIdMap.put(entry.getKey(), groupVidAdaptionMap.get(entry.getValue()));
        }
        return calTaskAdaptionIdMap;
    }

    public static Map<Long, DynamicObject> getCalPayrollTask(Set<Long> calTaskIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject[] calTaskObj = serviceHelper.query("id,name", new QFilter[]{new QFilter("id", "in", calTaskIds)});
        return Arrays.stream(calTaskObj).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
    }

    public static DynamicObject getCostAdapterDyObj(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("payrollgroupv", (Object)calTaskId);
        Long payrollGroupVid = calTaskObj.getLong("payrollgroupv.id");
        serviceHelper.setEntityName("pcs_costadaptionmap");
        DynamicObject dynamicObject = serviceHelper.queryOne("costadaption", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "=", (Object)payrollGroupVid), new QFilter("status", "=", (Object)"C")}, "modifytime desc");
        return dynamicObject == null ? null : dynamicObject.getDynamicObject("costadaption");
    }

    public static Map<Long, DynamicObject> getConstEntryIdMap(List<Long> defCostSetUpConstIds) {
        SWCDataServiceHelper constHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        DynamicObject[] constQueryResult = constHelper.query(defCostSetUpConstIds.toArray());
        HashMap<Long, DynamicObject> constEntryIdMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject constDy : constQueryResult) {
            long constId = constDy.getLong("id");
            constEntryIdMap.put(constId, constDy);
        }
        return constEntryIdMap;
    }

    public static Map<Long, DynamicObject> getCostSegStoreIdMap(List<Long> defCostSetUpConstIds) {
        SWCDataServiceHelper constHelper = new SWCDataServiceHelper("pcs_costsegstore");
        DynamicObject[] constQueryResult = constHelper.query(defCostSetUpConstIds.toArray());
        HashMap<Long, DynamicObject> constEntryIdMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject constDy : constQueryResult) {
            long constId = constDy.getLong("id");
            constEntryIdMap.put(constId, constDy);
        }
        return constEntryIdMap;
    }

    public static Map<String, String> queryCostStruMap(long costStruId) {
        DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById(costStruId);
        return CostCommonHelper.getBaseDataPropMap(dimensionEntryColl);
    }

    public static DynamicObjectCollection getCostStruDimById(long costStruId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "=", (Object)costStruId);
        DynamicObject queryResult = costStruHelper.queryOne("id,dimensionentry,costdimension,isrequired,storageset,costdimension.valuetype,costdimension.valuesource,costdimension.valuesource.number,costdimension.displayproperty,costdimension.importproperty,costdimension.valuesource,dimensionentry.seq,subentryentity.costbizobj", new QFilter[]{filter});
        if (queryResult != null) {
            return queryResult.getDynamicObjectCollection("dimensionentry");
        }
        return new DynamicObjectCollection();
    }

    public static Map<String, DynamicObject> queryCostStruSegmentMap(long costStruId, String billFormId) {
        DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById(costStruId);
        if (!"pcs_costitemcfg".equals(billFormId) && !"pcs_costdeptcfg".equals(billFormId)) {
            Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId(billFormId);
            dimensionEntryColl = CostCfgHelper.getNeedShowDimensionColl(costTypeId, "COST", dimensionEntryColl);
        }
        HashMap<String, DynamicObject> baseDataPropMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            String storageSetNumber = dimensionDy.getString("storageset.number");
            baseDataPropMap.put(storageSetNumber, dimensionDy);
        }
        return baseDataPropMap;
    }

    public static Map<String, String> queryCostStruSegmentAndDimNameMap(long costStruId, String billFormId) {
        DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById(costStruId);
        if (!"pcs_costitemcfg".equals(billFormId) && !"pcs_costdeptcfg".equals(billFormId)) {
            Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId(billFormId);
            dimensionEntryColl = CostCfgHelper.getNeedShowDimensionColl(costTypeId, "COST", dimensionEntryColl);
        }
        HashMap<String, String> baseDataPropMap = new HashMap<String, String>(16);
        String numberSuf = ResManager.loadKDString((String)"\u7f16\u7801", (String)"CostCommonHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]);
        String nameSuf = ResManager.loadKDString((String)"\u540d\u79f0", (String)"CostCommonHelper_4", (String)"swc-pcs-business", (Object[])new Object[0]);
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            String costDimensionName = dimensionDy.getString("costdimension.name");
            String storageSetNumber = dimensionDy.getString("storageset.number");
            String importProperty = dimensionDy.getString("costdimension.importproperty");
            costDimensionName = "1".equals(importProperty) ? costDimensionName + '.' + numberSuf : costDimensionName + '.' + nameSuf;
            baseDataPropMap.put(storageSetNumber, costDimensionName);
        }
        return baseDataPropMap;
    }

    public static Map<String, HashMap<String, DynamicObject>> getBaseDataValueMap(Map<String, List<Long>> constQueryResultMap) {
        Iterator<Map.Entry<String, List<Long>>> iterator = constQueryResultMap.entrySet().iterator();
        HashMap<String, HashMap<String, DynamicObject>> baseDataValueMap = new HashMap<String, HashMap<String, DynamicObject>>(16);
        while (iterator.hasNext()) {
            Map.Entry<String, List<Long>> next = iterator.next();
            String key = next.getKey();
            List<Long> value = next.getValue();
            if (SWCListUtils.isEmpty(value)) continue;
            SWCDataServiceHelper helper = new SWCDataServiceHelper(key);
            QFilter qFilter = new QFilter("id", "in", value);
            DynamicObject[] queryResults = helper.query("name,number", new QFilter[]{qFilter});
            HashMap<String, DynamicObject> queryResultMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject queryResultDy : queryResults) {
                String id = queryResultDy.getString("id");
                queryResultMap.put(id, queryResultDy);
            }
            baseDataValueMap.put(key, queryResultMap);
        }
        return baseDataValueMap;
    }

    public static Map<String, List<Long>> getConstNeedQueryDbMap(Map<Long, DynamicObject> constEntryIdMap, DynamicObjectCollection dimensionEntryColl) {
        Iterator<Map.Entry<Long, DynamicObject>> iterator = constEntryIdMap.entrySet().iterator();
        HashMap<String, List<Long>> constNeedQueryDbMap = new HashMap<String, List<Long>>(16);
        while (iterator.hasNext()) {
            Map.Entry<Long, DynamicObject> next = iterator.next();
            DynamicObject constEntryDy = next.getValue();
            for (DynamicObject dimensionDy : dimensionEntryColl) {
                String segValue;
                ArrayList<Long> filterList;
                String valueType = dimensionDy.getString("costdimension.valuetype");
                String baseDataNumber = dimensionDy.getString("costdimension.valuesource.id");
                String storageSetNumber = dimensionDy.getString("storageset.number");
                if ("2".equals(valueType)) {
                    baseDataNumber = "bos_assistantdata_detail";
                }
                if (SWCListUtils.isEmpty((List)(filterList = (ArrayList<Long>)constNeedQueryDbMap.get(baseDataNumber)))) {
                    filterList = new ArrayList<Long>();
                }
                if (("1".equals(valueType) || "2".equals(valueType)) && SWCStringUtils.isNotEmpty((String)(segValue = constEntryDy.getString("segment" + storageSetNumber)))) {
                    if (segValue.contains("||")) {
                        segValue = segValue.substring(0, segValue.indexOf("||"));
                    }
                    if (CostCommonHelper.isNumber(segValue)) {
                        filterList.add(Long.valueOf(segValue));
                    }
                }
                if ("1".equals(valueType)) {
                    if (SWCStringUtils.isEmpty((String)baseDataNumber)) continue;
                    constNeedQueryDbMap.put(baseDataNumber, filterList);
                    continue;
                }
                if (!"2".equals(valueType)) continue;
                constNeedQueryDbMap.put("bos_assistantdata_detail", filterList);
            }
        }
        return constNeedQueryDbMap;
    }

    public static boolean isNumber(Object value) {
        Pattern pattern = Pattern.compile(NUM_REGEX);
        boolean isNumber = true;
        if (value != null) {
            isNumber = pattern.matcher(value.toString()).matches();
        }
        return isNumber;
    }

    public static String numberRemoveZero(String coverValue) {
        BigDecimal value = new BigDecimal(coverValue);
        String newValue = value.compareTo(BigDecimal.ZERO) == 0 ? "0" : value.stripTrailingZeros().toPlainString();
        return newValue;
    }

    static {
        costCfgTypeMap.put("pcs_costdeptcfg", SWCCostConstants.COST_TYPE_DEPT);
        costCfgTypeMap.put("pcs_costpostcfg", SWCCostConstants.COST_TYPE_POST);
        costCfgTypeMap.put("pcs_costempcfg", SWCCostConstants.COST_TYPE_EMP);
        costCfgTypeMap.put("pcs_costitemcfg", SWCCostConstants.COST_TYPE_ITEM);
        costCfgTypeMap.put("pcs_costsalaryfilecfg", SWCCostConstants.COST_TYPE_SALARYFILE);
        costCfgTypeMap.put("pcs_costsalaryitemcfg", SWCCostConstants.COST_TYPE_SALARYFILEITEM);
        costCfgTypeMap.put("pcs_costgroupcfg", SWCCostConstants.COST_TYPE_PAYROLLGRP);
        costCfgTypeMap.put("pcs_costjobcfg", SWCCostConstants.COST_TYPE_JOB);
    }
}

