/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcommon;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.list.IListView;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CostProgressCommonHelper {
    public static void updateTerminationContent(IFormView view) {
        String content = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"CostProgressCommonHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]);
        Label contentLabel = (Label)view.getControl("contentlabel");
        contentLabel.setText(content);
        view.updateView("contentlabel");
    }

    public static void updateTerminationImage(IFormView view) {
        Image img = (Image)view.getControl("stateimage");
        img.setUrl("/images/pc/emotion/fkjg_sczd_168_96.png");
        view.updateView("stateimage");
    }

    public static void updateSuccessImage(IFormView view) {
        Image img = (Image)view.getControl("stateimage");
        img.setUrl("/images/pc/emotion/rcgyy_succes_168_96.png");
        view.updateView("stateimage");
    }

    public static void updateImportFailImage(IFormView view) {
        Image img = (Image)view.getControl("stateimage");
        img.setUrl("/images/pc/emotion/pt_tyyj_168_96.png");
        view.updateView("stateimage");
    }

    public static void setProgressAndContent(ProgressEvent progressEvent, CostAllocationProgressInfo progress, IFormView view) {
        int total = progress.getTotal();
        int finishCount = progress.getFinish();
        int failCount = progress.getFail();
        int percentage = CostProgressCommonHelper.getPercent(total, finishCount, failCount);
        progressEvent.setProgress(percentage);
        String termination = view.getPageCache().get("btn_termination");
        String content = CostProgressCommonHelper.getContent(percentage, termination);
        Label contentLabel = (Label)view.getControl("contentlabel");
        contentLabel.setText(content);
    }

    public static void refreshParentView(IFormView view) {
        IFormView parentView;
        String parentPageId = (String)view.getFormShowParameter().getCustomParam("parentPageId");
        if (SWCStringUtils.isEmpty((String)parentPageId) && (parentView = view.getParentView()) != null) {
            parentPageId = parentView.getPageId();
        }
        if ((parentView = view.getView(parentPageId)) != null) {
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
        }
    }

    public static void openGenerateResult(String content, CostAllocationProgressInfo progress, IFormView view) {
        List failList = progress.getFailList();
        if (SWCListUtils.isEmpty((List)failList)) {
            CostProgressCommonHelper.setButtonVisible(view);
        } else {
            int total = progress.getTotal();
            String message = ResManager.loadKDString((String)"\u5171{0}\u4e2a\u85aa\u8d44\u6863\u6848\uff0c{1}\u4e2a\u751f\u6210\u6210\u529f\uff0c{2}\u4e2a\u751f\u6210\u5931\u8d25\u3002", (String)"CostProgressCommonHelper_2", (String)"swc-pcs-business", (Object[])new Object[]{total, progress.getSuccess(), progress.getFail()});
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)content, (String)message, (List)failList);
            view.showForm(parameters);
            view.sendFormAction(view.getParentView());
        }
    }

    public static void setShowProgressInfo(String cacheKey, String progressBarKey, IFormView view) {
        CostAllocationProgressInfo progressInfo = CostProgressCommonHelper.getProgress(cacheKey, view);
        if (progressInfo == null) {
            return;
        }
        int status = progressInfo.getStatus();
        if (status == 2) {
            CostProgressCommonHelper.setButtonVisible(view);
            ProgressBar progressBar = (ProgressBar)view.getControl(progressBarKey);
            progressBar.setPercent(100);
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"btn_min", "btn_termination"});
            view.setVisible(Boolean.FALSE, new String[]{"btn_viewrecord", "btn_viewresult", "btn_close"});
        }
        int total = progressInfo.getTotal();
        int finishCount = progressInfo.getFinish();
        int failCount = progressInfo.getFail();
        int percentage = CostProgressCommonHelper.getPercent(total, finishCount, failCount);
        if (percentage == 100) {
            CostProgressCommonHelper.updateSuccessImage(view);
        }
        String termination = view.getPageCache().get("btn_termination");
        String content = CostProgressCommonHelper.getContent(percentage, termination);
        Label contentLabel = (Label)view.getControl("contentlabel");
        contentLabel.setText(content);
    }

    public static void setButtonVisible(IFormView view) {
        String termination;
        Set recordIds;
        boolean multiCalTask = false;
        String recordIdsStr = (String)view.getFormShowParameter().getCustomParam("costallocationrecordids");
        if (SWCStringUtils.isNotEmpty((String)recordIdsStr) && (recordIds = (Set)JSON.parseObject((String)recordIdsStr, Set.class)).size() > 1) {
            multiCalTask = true;
        }
        if ("1".equals(termination = view.getPageCache().get("btn_termination"))) {
            view.setVisible(Boolean.TRUE, new String[]{"btn_close"});
            view.setVisible(Boolean.FALSE, new String[]{"btn_min", "btn_termination", "btn_viewresult", "btn_viewrecord"});
        } else {
            IListView listView = (IListView)view.getParentView();
            String billFormId = listView.getBillFormId();
            if ("pcs_costallocation".equals(billFormId) || "pcs_allottask".equals(billFormId)) {
                view.setVisible(Boolean.FALSE, new String[]{"btn_min", "btn_termination"});
                view.setVisible(Boolean.TRUE, new String[]{"btn_viewresult", "btn_viewrecord"});
                if (multiCalTask && "pcs_costallocation".equals(billFormId)) {
                    view.setVisible(Boolean.FALSE, new String[]{"btn_viewresult"});
                }
            } else if ("pcs_costsetuprst".equals(billFormId) || "pcs_allotdetail".equals(billFormId)) {
                view.setVisible(Boolean.FALSE, new String[]{"btn_min", "btn_termination", "btn_viewresult"});
                view.setVisible(Boolean.TRUE, new String[]{"btn_viewrecord"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"btn_close"});
        }
    }

    public static void setCostProgressDetail(String cacheKey, String message, ProgressEvent progressEvent, IFormView view) {
        CostAllocationProgressInfo progress = CostProgressCommonHelper.getProgress(cacheKey, view);
        if (progress == null) {
            CostProgressCommonHelper.stopProgress(progressEvent);
            return;
        }
        CostProgressCommonHelper.setProgressAndContent(progressEvent, progress, view);
        int status = progress.getStatus();
        if (status == 2) {
            CostProgressCommonHelper.stopProgress(progressEvent);
            CostProgressCommonHelper.openGenerateResult(message, progress, view);
            CostProgressCommonHelper.updateSuccessImage(view);
        }
    }

    public static CostAllocationProgressInfo getProgress(String cacheKey, IFormView view) {
        String calTaskIdStr = (String)view.getFormShowParameter().getCustomParam("caltaskids");
        Set caltaskids = (Set)JSON.parseObject((String)calTaskIdStr, Set.class);
        return CostProgressCommonHelper.getProgressByCalTaskIds(cacheKey, caltaskids);
    }

    public static CostAllocationProgressInfo getProgressByCalTaskIds(String cacheKey, Set<Long> caltaskids) {
        CostAllocationProgressInfo info = new CostAllocationProgressInfo();
        info.setFailList(new ArrayList(10));
        int stopSize = 0;
        for (Long calTaskId : caltaskids) {
            int tempStatus;
            CostAllocationProgressInfo tempInfo = (CostAllocationProgressInfo)SWCAppCache.get((String)"pcs").get(String.format(Locale.ROOT, cacheKey, calTaskId), CostAllocationProgressInfo.class);
            if (tempInfo == null) continue;
            info.setTotal(info.getTotal() + tempInfo.getTotal());
            info.setFinish(info.getFinish() + tempInfo.getFinish());
            info.setFail(info.getFail() + tempInfo.getFail());
            if (tempInfo.getFailList() != null) {
                info.getFailList().addAll(tempInfo.getFailList());
            }
            if (2 != (tempStatus = tempInfo.getStatus())) continue;
            ++stopSize;
        }
        if (stopSize == caltaskids.size()) {
            info.setStatus(2);
        } else {
            info.setStatus(1);
        }
        if (info.getTotal() == 0) {
            return null;
        }
        return info;
    }

    public static String getContent(int percentage, String termination) {
        String content = percentage == 100 ? ResManager.loadKDString((String)"\u5df2\u5b8c\u6210({0}%)", (String)"CostProgressCommonHelper_3", (String)"swc-pcs-business", (Object[])new Object[]{percentage}) : ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210({0}%)", (String)"CostProgressCommonHelper_4", (String)"swc-pcs-business", (Object[])new Object[]{percentage});
        if ("1".equals(termination)) {
            content = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"CostProgressCommonHelper_1", (String)"swc-pcs-business", (Object[])new Object[]{percentage});
        }
        return content;
    }

    public static int getPercent(int total, int finishCount, int failCount) {
        int finishTotal;
        int percentage = 0;
        if (total > 0) {
            percentage = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
        }
        if ((finishTotal = finishCount + failCount) == total) {
            percentage = 100;
        }
        return percentage;
    }

    public static void stopProgress(ProgressEvent progressEvent) {
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
    }
}

