/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcustomize.service;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.url.SWCURLHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.pcs.business.costcfg.CostSetUpExportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costcommon.CostExportCommonHelper;
import kd.swc.pcs.business.costthread.CostSetUpExportThread;
import kd.swc.pcs.common.constants.CostExportConstants;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CostSetUpExportService {
    protected static final Log logger = LogFactory.getLog(CostSetUpExportService.class);
    public static final String SWC_PCS_BUSINESS = "swc-pcs-business";

    public void doExport(IFormView view) {
        IListView listView = (IListView)view;
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.doExportAll(view);
        } else {
            ArrayList<Long> selectIdList = new ArrayList<Long>(10);
            for (ListSelectedRow row : selectedRows) {
                Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
                if (selectIdList.contains(primaryKeyValue)) continue;
                selectIdList.add(primaryKeyValue);
            }
            this.doExportSelected(selectIdList, view);
        }
    }

    private void doExportSelected(List<Long> selectIdList, IFormView view) {
        logger.info("CostSetUpExportService doExportSelected 4-1");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long calTaskId = (Long)formShowParameter.getCustomParam("calTaskId");
        DynamicObject costAdapterDyObj = CostCommonHelper.getCostAdapterDyObj(calTaskId);
        long costStruId = costAdapterDyObj.getLong("coststru.id");
        int totalPages = (int)Math.ceil((double)selectIdList.size() * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.updateProgressAndOpenExportProgressBar(totalPages, countDownLatch, view);
        logger.info("CostSetUpExportService doExportSelected 4-2");
        List<FutureTask<List<Map<String, Object>>>> taskList = this.getSelectExportData(selectIdList, calTaskId, costStruId, totalPages, view);
        logger.info("CostSetUpExportService doExportSelected 4-3");
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_SELECT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            List<Map<String, Object>> allData = this.getExportData(taskList);
            this.manageSelected(view, allData, costStruId);
        });
    }

    private void doExportAll(IFormView view) {
        logger.info("CostSetUpExportService doExportAll 4-1");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long calTaskId = (Long)formShowParameter.getCustomParam("calTaskId");
        DynamicObject costAdapterDyObj = CostCommonHelper.getCostAdapterDyObj(calTaskId);
        if (costAdapterDyObj == null) {
            return;
        }
        long costStruId = costAdapterDyObj.getLong("coststru.id");
        logger.info("CostSetUpExportService doExportAll 4-2");
        List<QFilter> allFilterList = this.getAllFilterList(view, "pcs_costsetuprst");
        int totalSize = CostSetUpExportHelper.queryAllCostSetUpListByCalTaskId(calTaskId, allFilterList);
        if (totalSize == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5bfc\u51fa\u6570\u636e\u3002", (String)"CostSetUpExportService_26", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            return;
        }
        int totalPages = (int)Math.ceil((double)totalSize * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.updateProgressAndOpenExportProgressBar(0, countDownLatch, view);
        List<FutureTask<List<Map<String, Object>>>> taskList = this.getAllExportData(calTaskId, totalSize, costStruId, view, allFilterList);
        logger.info("CostSetUpExportService doExportAll 4-3");
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_ALL_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            logger.info("CostSetUpExportService getExportData begin");
            List<Map<String, Object>> allData = this.getExportData(taskList);
            logger.info("CostSetUpExportService getExportData end");
            this.manageSelected(view, allData, costStruId);
        });
    }

    private List<QFilter> getAllFilterList(IFormView view, String billFormId) {
        BillList billList;
        List filters;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"1ANC8T4UC434", (String)billFormId, (String)"47150e89000000ac");
        if (CollectionUtils.isNotEmpty((Collection)authorizedDataRuleQFilter)) {
            filterList.addAll(authorizedDataRuleQFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)(filters = (billList = (BillList)((IListView)view).getControl("billlistap")).generalFilterParameter().getQFilters()))) {
            filterList.addAll(filters);
        }
        return filterList;
    }

    private void updateProgressAndOpenExportProgressBar(int totalPages, CountDownLatch countDownLatch, IFormView view) {
        this.updateProgressChanges(totalPages, countDownLatch, view);
        this.openExportProgressForm(view);
    }

    private void updateProgressChanges(int totalPages, CountDownLatch countDownLatch, IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        if (totalPages <= 0) {
            pageCache.put("progress", (Object)CostExportConstants.DOUBLE_ZERO);
        } else {
            pageCache.put("progress", (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
        }
        pageCache.saveChanges();
    }

    private void openExportProgressForm(IFormView view) {
        String pageId = view.getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("pcs_costcommonprogress");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u7ed3\u6784\u5bfc\u51fa\u8fdb\u5ea6", (String)"CostSetUpExportService_29", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        para.setCloseCallBack(new CloseCallBack("kd.swc.pcs.formplugin.web.costsetup.CostSetUpList", "openCostSetUpExportProgressBar"));
        view.showForm(para);
    }

    private List<FutureTask<List<Map<String, Object>>>> getSelectExportData(List<Long> selectIdList, Long calTaskId, long costStruId, int totalPages, IFormView view) {
        RequestContext cxt = RequestContext.get();
        ArrayList<FutureTask<List<Map<String, Object>>>> taskList = new ArrayList<FutureTask<List<Map<String, Object>>>>(10);
        Map<String, String> dynamicColumnMap = CostSetUpExportHelper.getDynamicColumnMap(costStruId);
        List<QFilter> allFilterList = this.getAllFilterList(view, "pcs_costsetuprst");
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            int fromIndex = Math.min(pageIndex * CostExportConstants.PAGE_SIZE, selectIdList.size());
            int toIndex = Math.min(fromIndex + CostExportConstants.PAGE_SIZE, selectIdList.size());
            ImmutableList batchList = ImmutableList.copyOf(selectIdList.subList(fromIndex, toIndex));
            CostSetUpExportThread task = new CostSetUpExportThread(pageIndex, cxt, (List<Long>)batchList, calTaskId, CostExportConstants.PAGE_SIZE, costStruId, dynamicColumnMap, allFilterList);
            FutureTask<List<Map<String, Object>>> futureTask = new FutureTask<List<Map<String, Object>>>(task);
            CostExportConstants.QUERY_COST_SET_UP_POOL.submit(futureTask);
            taskList.add(futureTask);
        }
        return taskList;
    }

    private List<FutureTask<List<Map<String, Object>>>> getAllExportData(Long calTaskId, int totalSize, Long costStruId, IFormView view, List<QFilter> allFilterList) {
        int totalPages = (int)Math.ceil((double)totalSize * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        RequestContext cxt = RequestContext.get();
        ArrayList<FutureTask<List<Map<String, Object>>>> taskList = new ArrayList<FutureTask<List<Map<String, Object>>>>(10);
        Map<String, String> dynamicColumnMap = CostSetUpExportHelper.getDynamicColumnMap(costStruId);
        logger.info("CostSetUpExportService getAllExportData totalPages :{} ", (Object)totalPages);
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            CostSetUpExportThread task = new CostSetUpExportThread(pageIndex, cxt, Collections.emptyList(), calTaskId, CostExportConstants.PAGE_SIZE, costStruId, dynamicColumnMap, allFilterList);
            FutureTask<List<Map<String, Object>>> futureTask = new FutureTask<List<Map<String, Object>>>(task);
            CostExportConstants.QUERY_COST_SET_UP_POOL.submit(futureTask);
            taskList.add(futureTask);
        }
        return taskList;
    }

    private List<Map<String, Object>> getExportData(List<FutureTask<List<Map<String, Object>>>> taskList) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (FutureTask<List<Map<String, Object>>> task : taskList) {
            try {
                List<Map<String, Object>> resultList = task.get();
                exportData.addAll(resultList);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("getExportData error", (Throwable)e);
            }
        }
        return exportData;
    }

    private void manageSelected(IFormView view, List<Map<String, Object>> allData, Long costStruId) {
        logger.info("CostSetUpExportService manageSelected 4-4");
        Map<String, String> headers = this.getExportHeaders(costStruId);
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long calTaskId = (Long)formShowParameter.getCustomParam("calTaskId");
        int totalPages = (int)Math.ceil((double)allData.size() * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        logger.info("CostSetUpExportService manageSelected 4-5");
        RequestContext ctx = RequestContext.get();
        try (SXSSFWorkbook wb = new SXSSFWorkbook(CostExportConstants.ROW_ACCESS_WINDOWS_SIZE);){
            SXSSFSheet sheet = wb.createSheet();
            int RANDOM_SEEK = -1;
            sheet.setRandomAccessWindowSize(-1);
            String fileName = ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u7ed3\u6784", (String)"CostSetUpExportService_24", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
            wb.setSheetName(0, fileName);
            RequestContext.copyAndSet((RequestContext)ctx);
            logger.info("CostSetUpExportService manageSelected 4-6");
            CostExportCommonHelper.write2ExportHead(sheet, headers);
            logger.info("CostSetUpExportService manageSelected 4-7");
            this.batchWriteExport(view, headers, ctx, allData, totalPages, countDownLatch, sheet);
            logger.info("CostSetUpExportService manageSelected 4-8");
            if (countDownLatch.await(10L, TimeUnit.MINUTES)) {
                logger.info("CostSetUpExportService manageSelected 4-9");
                this.flushAll(sheet, fileName, totalPages, countDownLatch, view);
                logger.info("CostSetUpExportService manageSelected 4-10");
            }
            logger.info("CostSetUpExportService manageSelected 4-11");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            view.showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"CostSetUpExportService_23", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void flushAll(SXSSFSheet sheet, String fileName, int totalPages, CountDownLatch countDownLatch, IFormView view) throws IOException {
        logger.info("export data 8-1");
        logger.info("export data 8-2");
        String url = CostExportCommonHelper.writeFile(sheet.getWorkbook(), fileName);
        String safeUrl = SWCURLHelper.getSafeUrl((String)"pcs", (String)"pcs_costsetuprst", (String)url);
        SWCPageCache pageCache = new SWCPageCache(view);
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        pageCache.put("progress", (Object)percent);
        pageCache.put("url", (Object)safeUrl);
        pageCache.saveChanges();
        logger.info("export data 8-3");
    }

    private void batchWriteExport(IFormView view, Map<String, String> headers, RequestContext ctx, List<Map<String, Object>> exportData, int totalPages, CountDownLatch countDownLatch, SXSSFSheet sheet) {
        ReentrantLock lock = new ReentrantLock();
        int pageIndex = 0;
        while (pageIndex < totalPages) {
            int currentPage = pageIndex++;
            logger.info("CostSetUpExportService batchWriteExport export data 0");
            CostExportConstants.WRITE_COST_CET_UP_EXCEL_POOL.submit(() -> {
                try {
                    logger.info("CostSetUpExportService batchWriteExport export data 1");
                    RequestContext.copyAndSet((RequestContext)ctx);
                    int fromIndex = Math.min(currentPage * CostExportConstants.PAGE_SIZE, exportData.size());
                    int toIndex = Math.min(fromIndex + CostExportConstants.PAGE_SIZE, exportData.size());
                    ImmutableList batchList = ImmutableList.copyOf(exportData.subList(fromIndex, toIndex));
                    lock.lock();
                    logger.info("CostSetUpExportService batchWriteExport export data 2");
                    CostExportCommonHelper.write2ExportContent(sheet, currentPage * CostExportConstants.PAGE_SIZE + 1, (List<Map<String, Object>>)batchList, headers);
                    logger.info("CostSetUpExportService batchWriteExport export data 3");
                }
                catch (Exception e) {
                    logger.error("CostSetUpExportService.doExportAll.error. ", (Throwable)e);
                }
                finally {
                    this.updateProgressAndUnlock(view, totalPages, countDownLatch, lock);
                }
            });
        }
    }

    private void updateProgressAndUnlock(IFormView view, int totalPages, CountDownLatch countDownLatch, Lock lock) {
        lock.unlock();
        logger.info("CostSetUpExportService batchWriteExport export data 6");
        countDownLatch.countDown();
        SWCPageCache pageCache = new SWCPageCache(view);
        double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
        if (percent < 100.0) {
            pageCache.put("progress", (Object)BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue());
            pageCache.saveChanges();
        }
        logger.info("CostSetUpExportService batchWriteExport export data 7");
    }

    private Map<String, String> getExportHeaders(Long costStruId) {
        return this.getExportColumnMap(costStruId);
    }

    private Map<String, String> getExportColumnMap(Long costStruId) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
        map.put("rowSeq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"CostSetUpExportService_1", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("id", "");
        map.put("personName", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CostSetUpExportService_5", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("personNum", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CostSetUpExportService_4", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("salaryFileNum", ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7", (String)"CostSetUpExportService_3", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("adapterCountryName", ResManager.loadKDString((String)"\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730", (String)"CostSetUpExportService_8", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("enable", ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c", (String)"CostSetUpExportService_11", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("salaryItemName", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"CostSetUpExportService_12", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("costitemName", ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee", (String)"CostSetUpExportService_25", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        map.put("percentage", ResManager.loadKDString((String)"\u627f\u62c5\u6bd4\u4f8b\uff08%\uff09", (String)"CostSetUpExportService_13", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        Map<String, String> dynamicColumnMap = CostSetUpExportHelper.getDynamicColumnMap(costStruId);
        if (!dynamicColumnMap.isEmpty()) {
            map.putAll(dynamicColumnMap);
        }
        map.put("isRevealDetail", ResManager.loadKDString((String)"\u662f\u5426\u515c\u5e95", (String)"CostSetUpExportService_15", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        return map;
    }
}

