/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costmap.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.pcs.business.costmap.CostItemMapHelper;

public class CostItemMapService {
    private static final Log LOGGER = LogFactory.getLog(CostItemMapService.class);

    public long getCostMapObjId(String formId) {
        return CostItemMapHelper.getCostMapObjId(formId);
    }

    public DynamicObject[] queryExistDBSalaryItemByOrg(long hrOrgId, long payRollCalOrgId, long id, String billName) {
        return CostItemMapHelper.queryExistDBSalaryItemByOrg(hrOrgId, payRollCalOrgId, id, billName);
    }

    public DynamicObject[] queryExistDBSalaryItemByOrgAndGroup(long hrOrgId, long payRollCalOrgId, long payrollGroupId, long id, String billName) {
        return CostItemMapHelper.queryExistDBSalaryItemByOrgAndGroup(hrOrgId, payRollCalOrgId, payrollGroupId, id, billName);
    }

    public void orgChange(PropertyChangedArgs e, String key, IFormView view) {
        DynamicObject payrollCalDy = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (payrollCalDy == null) {
            view.getModel().setValue(key, null);
        } else {
            long oldId;
            long newId = payrollCalDy.getLong("id");
            DynamicObject oldDy = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (oldDy != null && newId != (oldId = oldDy.getLong("id"))) {
                view.getModel().setValue(key, null);
            }
        }
    }

    public void costMapCloseCallBack(ClosedCallBackEvent closedCallBackEvent, IFormView view, String name) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        Long primaryKeyValue = (Long)returnData.get(0).getPrimaryKeyValue();
        String actionId = closedCallBackEvent.getActionId();
        String baseDataIdKey = actionId + ".id";
        long oldValue = view.getModel().getDataEntity().getLong(baseDataIdKey);
        if (oldValue == 0L) {
            view.getModel().setValue(actionId, (Object)primaryKeyValue);
        } else {
            SWCPageCache swcPageCache = new SWCPageCache(view);
            swcPageCache.put("newValue", (Object)primaryKeyValue);
            this.showConfirm(actionId, view, name);
        }
    }

    private void showConfirm(String actionId, IFormView view, String name) {
        switch (actionId) {
            case "payrollcal": {
                IListView listView = (IListView)view.getParentView();
                String billFormId = listView.getBillFormId();
                if ("pcs_costpayrollcalmap".equals(billFormId)) {
                    view.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u5c06\u6e05\u7a7a\u201c\u85aa\u916c\u9879\u76ee\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostItemMapService_1", (String)"swc-pcs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(actionId, name));
                    break;
                }
                view.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u5c06\u6e05\u7a7a\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u53ca\u201c\u85aa\u916c\u9879\u76ee\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostItemMapService_2", (String)"swc-pcs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(actionId, name));
                break;
            }
            case "source": {
                view.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u5c06\u6e05\u7a7a\u201c\u85aa\u916c\u9879\u76ee\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostItemMapService_3", (String)"swc-pcs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(actionId, name));
                break;
            }
            case "hrorg": {
                view.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u5c06\u6e05\u7a7a\u5bf9\u5e94\u201c\u6210\u672c\u9879\u76ee\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostItemMapService_5", (String)"swc-pcs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(actionId, name));
                break;
            }
        }
    }

    public void updateParentView(AfterDoOperationEventArgs args, IFormView view) {
        OperationResult operationResult;
        boolean success;
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && (success = (operationResult = args.getOperationResult()).isSuccess())) {
            IFormView parentView = view.getParentView();
            if (parentView == null) {
                return;
            }
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
        }
    }

    private Set<Long> addExistSalaryItemId(DynamicObject[] calExistSalaryItemDys) {
        HashSet<Long> existSalaryItemIdList = new HashSet<Long>(16);
        for (int i = 0; i < calExistSalaryItemDys.length; ++i) {
            DynamicObject calExistSalaryItemDy = calExistSalaryItemDys[i];
            long salaryItemId = calExistSalaryItemDy.getLong("salaryitem.id");
            existSalaryItemIdList.add(salaryItemId);
        }
        return existSalaryItemIdList;
    }

    public Set<Long> getCalDBExistSalaryItemIdList(long hrOrgId, long payRollCalOrgId, long id, String billName) {
        DynamicObject[] dynamicObjects = this.queryExistDBSalaryItemByOrg(hrOrgId, payRollCalOrgId, id, billName);
        return this.addExistSalaryItemId(dynamicObjects);
    }

    public Set<Long> getGroupDBExistSalaryItemIdList(long hrOrgId, long payRollCalOrgId, long payrollGroupId, long id, String billName) {
        DynamicObject[] dynamicObjects = this.queryExistDBSalaryItemByOrgAndGroup(hrOrgId, payRollCalOrgId, payrollGroupId, id, billName);
        return this.addExistSalaryItemId(dynamicObjects);
    }

    public void addOrgPermFilter(List<QFilter> filters, String billName, String propKey) {
        Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)billName, (String)"47150e89000000ac");
        if (payRollCalSet != null) {
            LOGGER.info("CostItemMapService addOrgPermFilter payRollCalSet:{}", (Object)payRollCalSet);
            QFilter permFilter = new QFilter(propKey, "in", (Object)payRollCalSet);
            filters.add(permFilter);
        }
    }

    public void addSalaryItemFilter(List<QFilter> filters, String billName) {
        this.addBaseDataFilter(filters, billName, "hsbs_salaryitem");
    }

    public void addSalaryItemCalFilter(List<QFilter> filters, String billName) {
        this.addBaseDataCalFilter(filters, billName, "hsbs_salaryitem");
    }

    public void addCostItemFilter(List<QFilter> filters, String billName) {
        this.addBaseDataFilter(filters, billName, "lcs_costitem");
    }

    public void addCostAdapterFilter(List<QFilter> filters, String parentBillFormId) {
        this.addBaseDataFilter(filters, parentBillFormId, "lcs_costadaption");
    }

    public void addCostStruFilter(List<QFilter> filters, String parentBillFormId) {
        this.addBaseDataFilter(filters, parentBillFormId, "lcs_coststru");
    }

    private void addBaseDataFilter(List<QFilter> filters, String parentBillFormId, String billName) {
        QFilter baseDataFilter;
        List hasPermOrgs;
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)parentBillFormId, (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)(hasPermOrgs = permOrgs.getHasPermOrgs())) && (baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)billName, (List)hasPermOrgs, (boolean)true)) != null) {
            filters.add(baseDataFilter);
            LOGGER.info("CostItemMapService addBaseDataFilter baseDataFilter:{}", (Object)baseDataFilter);
        }
    }

    private void addBaseDataCalFilter(List<QFilter> filters, String parentBillFormId, String billName) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter baseDataRuleFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)parentBillFormId, (String)"source", (String)"47150e89000000ac");
        Set payrollCalSetByPermItem = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costitemcfgperm", (String)"47150e89000000ac");
        QFilter salaryItemBaseDataBuFilter = null;
        if (!CollectionUtils.isEmpty((Collection)payrollCalSetByPermItem)) {
            ArrayList payrollCalListByPermItem = new ArrayList(payrollCalSetByPermItem);
            salaryItemBaseDataBuFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)billName, payrollCalListByPermItem, (boolean)true);
        }
        if (baseDataRuleFilter != null && salaryItemBaseDataBuFilter != null) {
            baseDataRuleFilter.or(salaryItemBaseDataBuFilter);
            filters.add(baseDataRuleFilter);
        } else {
            if (baseDataRuleFilter != null) {
                filters.add(baseDataRuleFilter);
            }
            if (salaryItemBaseDataBuFilter != null) {
                filters.add(salaryItemBaseDataBuFilter);
            }
        }
        LOGGER.info("CostItemMapService addBaseDataCalFilter filters:{}", filters);
    }
}

