/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costthread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.pcs.business.costallotbill.helper.CostAllotBillExportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostAllotBillExportThread
implements Callable<List<List<Map<String, Object>>>> {
    private int pageIndex;
    private RequestContext requestContext;
    private List<Long> batchList;
    private int pageSize;
    private Map<Long, Long> adapterAndStruMap;

    public CostAllotBillExportThread(int pageIndex, RequestContext requestContext, List<Long> batchList, int pageSize, Map<Long, Long> adapterAndStruMap) {
        this.pageIndex = pageIndex;
        this.requestContext = requestContext;
        this.batchList = batchList;
        this.pageSize = pageSize;
        this.adapterAndStruMap = adapterAndStruMap;
    }

    @Override
    public List<List<Map<String, Object>>> call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        return this.getExportData(this.batchList, this.pageIndex, this.pageSize, this.adapterAndStruMap);
    }

    private List<List<Map<String, Object>>> getExportData(List<Long> selectRows, int pageIndex, int pageSize, Map<Long, Long> adapterAndStruMap) {
        if (selectRows.size() > 0) {
            QFilter[] selectIdFilter = new QFilter[]{new QFilter("id", "in", selectRows)};
            return this.queryExportData(selectIdFilter, adapterAndStruMap);
        }
        return this.queryExportData(new QFilter[0], pageIndex, pageSize, adapterAndStruMap);
    }

    private List<List<Map<String, Object>>> queryExportData(QFilter[] filters, Map<Long, Long> adapterAndStruMap) {
        return this.queryExportData(filters, 0, Integer.MAX_VALUE, adapterAndStruMap);
    }

    private List<List<Map<String, Object>>> queryExportData(QFilter[] filters, int pageIndex, int pageSize, Map<Long, Long> adapterAndStruMap) {
        String selectField = this.getSelectField();
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"pcs_allotbill", (String)selectField, (QFilter[])filters, (String)"createtime desc", (int)pageIndex, (int)pageSize);
        List<Long> costSetUpConstIds = this.getCostSetUpConstIdList(coll);
        ArrayList<Long> costAdapterStruIds = new ArrayList<Long>(adapterAndStruMap.values());
        Map<Long, Map<String, String>> queryCostStruIdMap = CostAllotBillExportHelper.queryCostStruMap(costAdapterStruIds);
        Map<Long, DynamicObject> constEntryIdMap = CostCommonHelper.getConstEntryIdMap(costSetUpConstIds);
        int rowSeq = pageIndex * pageSize;
        ArrayList<List<Map<String, Object>>> dataList = new ArrayList<List<Map<String, Object>>>(10);
        this.setColumnValue(dataList, coll, constEntryIdMap, queryCostStruIdMap, adapterAndStruMap, rowSeq);
        return dataList;
    }

    private List<Long> getCostSetUpConstIdList(DynamicObject[] coll) {
        ArrayList<Long> costSetUpConstIds = new ArrayList<Long>(10);
        for (DynamicObject dy : coll) {
            DynamicObjectCollection allotBillEntryDys = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject allotBillEntryDy : allotBillEntryDys) {
                long defCostSetUpConstId = allotBillEntryDy.getLong("costsetupconst.id");
                costSetUpConstIds.add(defCostSetUpConstId);
            }
        }
        return costSetUpConstIds;
    }

    private String getSelectField() {
        return "billno,costadapter,calcurrency,personcount,creator,createtime,org,description,amountsum,costitem,costsetupconstval,costsetupconst,assuamount,calamount,oricurrency,startdate,enddate,paydate";
    }

    private void setColumnValue(List<List<Map<String, Object>>> dataList, DynamicObject[] coll, Map<Long, DynamicObject> constEntryIdMap, Map<Long, Map<String, String>> queryCostStruIdMap, Map<Long, Long> adapterAndStruMap, int rowSeq) {
        for (DynamicObject costAllotBillDy : coll) {
            int assuCurPrecision = costAllotBillDy.getInt("costadapter.currency.amtprecision");
            List<Map<String, Object>> allotBillInfoList = CostAllotBillExportHelper.setAllotBillInfo(costAllotBillDy, assuCurPrecision);
            Map<String, String> queryCostStruMap = this.getCostStruResultMap(queryCostStruIdMap, adapterAndStruMap, costAllotBillDy);
            Long costStruId = costAllotBillDy.getLong("costadapter.coststru.id");
            DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById(costStruId);
            Map<String, DynamicObject> allDimensionMap = CostCommonHelper.getAllDimensionMap(dimensionEntryColl);
            Map<String, List<Long>> constQueryResultMap = CostCommonHelper.getConstNeedQueryDbMap(constEntryIdMap, dimensionEntryColl);
            Map<String, HashMap<String, DynamicObject>> baseDataValueMap = CostCommonHelper.getBaseDataValueMap(constQueryResultMap);
            CostAllotBillExportHelper.setAllotBillEntryInfo(constEntryIdMap, allDimensionMap, rowSeq, costAllotBillDy, allotBillInfoList, baseDataValueMap, queryCostStruMap);
            dataList.add(allotBillInfoList);
        }
    }

    private Map<String, String> getCostStruResultMap(Map<Long, Map<String, String>> queryCostStruMap, Map<Long, Long> adapterAndStruMap, DynamicObject costAllotBillDy) {
        long costAdapterId = costAllotBillDy.getLong("costadapter.id");
        Long costStruId = adapterAndStruMap.get(costAdapterId);
        return queryCostStruMap.get(costStruId);
    }
}

