/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costthread;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class CostCfgExportThread
implements Callable<Map<Long, List<DynamicObject>>> {
    private int pageIndex;
    private RequestContext requestContext;
    private List<Long> batchList;
    private int pageSize;
    private String billFormId;
    private List<QFilter> filters;
    protected static final Log logger = LogFactory.getLog(CostCfgExportThread.class);

    public CostCfgExportThread(int pageIndex, RequestContext requestContext, List<Long> batchList, int pageSize, String billFormId, List<QFilter> filters) {
        this.pageIndex = pageIndex;
        this.requestContext = requestContext;
        this.batchList = batchList;
        this.pageSize = pageSize;
        this.billFormId = billFormId;
        this.filters = filters;
    }

    @Override
    public Map<Long, List<DynamicObject>> call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        return this.getExportData(this.batchList, this.pageIndex, this.pageSize, this.billFormId, this.filters);
    }

    public Map<Long, List<DynamicObject>> getExportData(List<Long> selectRows, int pageIndex, int pageSize, String billFormId, List<QFilter> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            filters = new ArrayList<QFilter>();
        }
        if (selectRows.size() > 0) {
            filters.add(new QFilter("id", "in", selectRows));
            QFilter[] selectIdFilter = this.convertFilter(filters);
            return this.queryExportData(selectIdFilter, billFormId);
        }
        QFilter[] calTaskIdFilter = this.convertFilter(filters);
        return this.queryExportData(calTaskIdFilter, pageIndex, pageSize, billFormId);
    }

    private QFilter[] convertFilter(List<QFilter> filters) {
        filters.removeAll(Collections.singleton(null));
        QFilter[] qFilterArray = new QFilter[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            QFilter qFilter = filters.get(i);
            String property = qFilter.getProperty();
            if ("bsed".equals(property)) {
                this.dealDataFilter(qFilterArray, i, qFilter);
                continue;
            }
            qFilterArray[i] = filters.get(i);
        }
        return qFilterArray;
    }

    private void dealDataFilter(QFilter[] qFilterArray, int i, QFilter qFilter) {
        Object leftDateObj = qFilter.getValue();
        try {
            Date date = SWCDateTimeUtils.parseDate((String)String.valueOf(leftDateObj));
            QFilter qFilterDate = new QFilter("bsed", "<=", (Object)date);
            qFilterArray[i] = qFilterDate.and(new QFilter("bsled", ">=", (Object)date));
        }
        catch (ParseException e) {
            logger.error("dealDataFilter error", (Object)e.getMessage());
        }
    }

    private Map<Long, List<DynamicObject>> queryExportData(QFilter[] filters, String billFormId) {
        return this.queryExportData(filters, 0, Integer.MAX_VALUE, billFormId);
    }

    private Map<Long, List<DynamicObject>> queryExportData(QFilter[] filters, int pageIndex, int pageSize, String billFormId) {
        DynamicObject[] coll;
        String selectField = SWCHisBaseDataHelper.getSelectProperties((String)billFormId);
        HashMap<Long, List<DynamicObject>> dataMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)billFormId, (String)selectField, (QFilter[])filters, (String)"number asc", (int)pageIndex, (int)pageSize)) {
            long costAdapterId = dy.getLong("costadapter.id");
            ArrayList<DynamicObject> dynamicObjects = (ArrayList<DynamicObject>)dataMap.get(costAdapterId);
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                dynamicObjects = new ArrayList<DynamicObject>();
            }
            dynamicObjects.add(dy);
            dataMap.put(costAdapterId, dynamicObjects);
        }
        return dataMap;
    }

    private String getSelectField() {
        return "number,source,qualityname,qualitynumber,createorg,creatorobj,person,costadapter,bsed,status,enable,costcfgentryentity,calcostproportion,coststrucfgvalue,costsegstore,costcfgtypeentryentity,costcfgtypeproportion,coststrutypecfgvalue,costtypesegstore";
    }
}

