/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costthread;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportConfig;

public class CostCfgResolveThread
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(CostCfgResolveThread.class);
    private final RequestContext ctx;
    private final CostCfgImportConfig conf;

    public CostCfgResolveThread(RequestContext ctx, CostCfgImportConfig conf) {
        this.ctx = ctx;
        this.conf = conf;
    }

    @Override
    public Object call() {
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            this.resolve();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        String url = this.conf.getCostCfgImportParamEntity().getUrl();
        final int headHeight = this.conf.getFixHeadHeight();
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in2 = null;
        try {
            this.conf.setResolveBegin(true);
            in2 = service.getInputStream(url);
            new ExcelReader().read(in2, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    int rowNum = row.getRowNum();
                    if (rowNum < headHeight - 1) {
                        return;
                    }
                    if (rowNum <= 1) {
                        CostCfgResolveThread.this.conf.getDataHead().add(row.getData());
                    } else {
                        CostCfgResolveThread.this.conf.getDataQueues().add(row.getData());
                    }
                    if (CostCfgResolveThread.this.conf.getDataQueues().size() >= 9000) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e);
                        }
                    }
                }

                public void setRowCount(int rowCount) {
                    super.setRowCount(rowCount);
                }
            });
            this.conf.setResolveEnd(true);
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", (String)"CostCfgResolveThread_1", (String)"swc-pcs-business", (Object[])new Object[0]));
            log.error((Throwable)e);
        }
        finally {
            try {
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }
}

