/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.log.impl;

import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.log.AbstractLogRecord;
import kd.sys.ricc.common.log.ConfigLog;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;

public class ConfigLogImpl
extends ConfigLog {
    private DynamicObject log;

    @Override
    public void preWriteLog(String opType, String taskId, long packetId, long targetDataCenterId, String userPhone, Object fastTransferLogId) {
        if (!Objects.isNull(fastTransferLogId)) {
            this.log = this.queryFastTransferLog(fastTransferLogId);
        } else {
            this.log = this.buildCommonLog(packetId, taskId);
            this.log.set("optype", (Object)opType);
            this.log.set("state", (Object)"4");
        }
        this.log.set("targetdatacenter", (Object)targetDataCenterId);
        this.log.set("targetdatacenteruser", (Object)userPhone);
        this.log.set("traceid", (Object)RequestContext.get().getTraceId());
        this.writeLog("ricc_log", this.log);
        this.setLogId(this.log.getPkValue());
    }

    @Override
    public DynamicObject buildLog(long packetId, int total, int successCount, String opType, String taskId, AbstractLogRecord logRecord) {
        String state = "2";
        if (total > 0 && total == successCount) {
            state = "1";
        } else if (successCount > 0 && successCount < total) {
            state = "3";
        }
        DynamicObject oneLog = this.buildCommonLog(packetId, taskId);
        oneLog.set("optype", (Object)opType);
        oneLog.set("state", (Object)state);
        oneLog.set("state", (Object)state);
        oneLog.set("successcount", (Object)successCount);
        oneLog.set("failedcount", (Object)(total - successCount));
        this.setDetailLogMessage(logRecord, oneLog);
        return oneLog;
    }

    @Override
    public void afterWriteLog(int total, int successCount, AbstractLogRecord logRecord) {
        String state = "2";
        if (total > 0 && total == successCount) {
            state = "1";
        } else if (successCount > 0 && successCount < total) {
            state = "3";
        }
        this.log.set("state", (Object)state);
        this.log.set("successcount", (Object)successCount);
        this.log.set("failedcount", (Object)(total - successCount));
        this.setDetailLogMessage(logRecord, this.log);
        this.writeLog("ricc_log", this.log);
    }

    public void afterWriteEntryLog(int total, int successCount, AbstractLogRecord logRecord) {
        DynamicObjectCollection entryLog = this.getLog().getDynamicObjectCollection("synlogentry");
        if (entryLog.size() > 0) {
            this.log.set("synlogentry", (Object)entryLog);
            total = entryLog.size();
            successCount = this.getSuccessCountByLogEntry(entryLog);
        }
        this.afterWriteLog(total, successCount, logRecord);
    }

    private void setDetailLogMessage(AbstractLogRecord logRecord, DynamicObject log) {
        if (logRecord != null) {
            String devLogs;
            log.set("usetime", (Object)logRecord.getUseTime());
            log.set("opendtime", (Object)logRecord.getEndTime());
            log.set("message", (Object)(logRecord.getMessageStr().length() > 25 ? logRecord.getMessageStr().substring(0, 25) + "..." : logRecord.getMessageStr()));
            log.set("message_tag", (Object)logRecord.getMessageStr());
            String devLog = log.getString("devmessage");
            String devLogTag = log.getString("devmessage_tag");
            if (StringUtils.isEmpty(devLog)) {
                log.set("devmessage", (Object)(logRecord.getDevMessageStr().length() > 25 ? logRecord.getDevMessageStr().substring(0, 25) + "..." : logRecord.getDevMessageStr()));
            }
            if ((devLogs = devLogTag + logRecord.getDevMessageStr()).length() > 10000) {
                String tpl = ResManager.loadKDString((String)"\u5f53\u524d\u5806\u6808\u9519\u8bef\u63d0\u793a\u4fe1\u606f\u8d85\u957f\uff0c\u5df2\u505a\u622a\u65ad\u5904\u7406\uff0c\u5982\u9700\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9\u67e5\u770bmonitor", (String)"ConfigLogImpl_0", (String)"sys-ricc-common", (Object[])new Object[0]);
                log.set("devmessage_tag", (Object)(devLogs.substring(0, 10000) + tpl));
            } else {
                log.set("devmessage_tag", (Object)devLogs);
            }
        }
    }

    @Override
    public DynamicObject buildCommonLog(long packetId, String taskId) {
        DynamicObject logRecord = BusinessDataServiceHelper.newDynamicObject((String)"ricc_log");
        logRecord.set("packet", (Object)packetId);
        logRecord.set("opuser", (Object)UserServiceHelper.getCurrentUserId());
        logRecord.set("taskid", (Object)taskId);
        logRecord.set("optime", (Object)System.currentTimeMillis());
        return logRecord;
    }

    @Override
    public void preWriteBatchPackLog(String opType, String taskId, long packetId, Object batchPackSchemeId) {
        this.log = this.buildCommonLog(packetId, taskId);
        this.log.set("optype", (Object)opType);
        this.log.set("state", (Object)"4");
        if (batchPackSchemeId != null) {
            this.log.set("batchpackscheme", batchPackSchemeId);
        }
        this.log.set("traceid", (Object)RequestContext.get().getTraceId());
        this.writeLog("ricc_log", this.log);
        this.setLogId(this.log.getPkValue());
    }

    public DynamicObject queryFastTransferLog(Object logId) {
        return BusinessDataServiceHelper.loadSingle((Object)logId, (String)"ricc_log");
    }

    private int getSuccessCountByLogEntry(DynamicObjectCollection entryLog) {
        int result = 0;
        for (DynamicObject oneEntryLog : entryLog) {
            if (!StringUtils.equals("1", oneEntryLog.getString("entrysynstatus"))) continue;
            ++result;
        }
        return result;
    }

    public void buildEntrySyncLogWithException(String entrySynStatus, String exceptionMsg, Throwable e, int seq, int entrySuccessCount, int entryFailedCount) {
        String exceptionStackTrace = CommonUtil.getExceptionDetailInfo(e);
        this.buildEntrySyncLogWithException(entrySynStatus, exceptionMsg, exceptionStackTrace, seq, entrySuccessCount, entryFailedCount);
    }

    public void buildEntrySyncLogWithException(String entrySynStatus, String exceptionMsg, String exceptionStackTrace, int seq, int entrySuccessCount, int entryFailedCount) {
        this.buildEntrySyncLogWithMsg(entrySynStatus, exceptionMsg, seq, entrySuccessCount, entryFailedCount);
        if (StringUtils.isNotEmpty(exceptionStackTrace)) {
            String devLog = this.getLog().getString("devmessage_tag");
            if (devLog.length() > 10000) {
                return;
            }
            String logTpl = ResManager.loadKDString((String)"%1$s%n\u7b2c%2$d\u884c\uff1a%n%3$s", (String)"ConfigLogImpl_1", (String)"sys-ricc-common", (Object[])new Object[0]);
            String newDevlog = String.format(logTpl, devLog, seq, exceptionStackTrace);
            this.getLog().set("devmessage_tag", (Object)newDevlog);
        }
    }

    public void buildEntrySyncLogWithMsg(String entrySynStatus, String entryMsg, int seq, int entrySuccessCount, int entryFailedCount) {
        DynamicObject synLogEntry = this.getLog().getDynamicObjectCollection("synlogentry").addNew();
        synLogEntry.set("seq", (Object)seq);
        synLogEntry.set("entrysuccesscount", (Object)entrySuccessCount);
        synLogEntry.set("entryfailedcount", (Object)entryFailedCount);
        synLogEntry.set("entrysynstatus", (Object)entrySynStatus);
        if (StringUtils.isNotEmpty(entryMsg)) {
            String logNoBlank = StringUtils.replaceBlank(entryMsg);
            synLogEntry.set("synlog", (Object)(logNoBlank.length() > 165 ? logNoBlank.substring(0, 165) + "..." : logNoBlank));
            synLogEntry.set("synlog_tag", (Object)entryMsg);
        }
    }

    public DynamicObject getLog() {
        return this.log;
    }
}

